/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.navigator.core;

import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.TreeSet;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;
import oracle.dbtools.raptor.navigator.model.NavigatorTree;
import oracle.dbtools.raptor.navigator.model.NavigatorTreeNode;
import oracle.dbtools.raptor.navigator.ui.CustomTree;
import oracle.ide.Context;
import oracle.ide.model.DataContainer;
import oracle.ide.model.Element;
import oracle.javatools.util.ModelUtil;

public final class NavigatorContext {
    private static final String TREE_NODE_KEY = "NavigatorContext.NavigatorNodes";
    private static final String TREE_KEY = "NavigatorContext.NavigatorTree";

    static void initializeContext(Context context, NavigatorTree navigatorTree, NavigatorTreeNode[] navigatorTreeNodeArray) {
        context.setProperty(TREE_NODE_KEY, (Object)navigatorTreeNodeArray);
        context.setProperty(TREE_KEY, (Object)navigatorTree);
    }

    public static NavigatorTreeNode[] getNavigatorNodesFromContext(Context context) {
        return (NavigatorTreeNode[])context.getProperty(TREE_NODE_KEY);
    }

    public static NavigatorTreeNode getSingleNavigatorTreeNodeFromContext(Context context) {
        NavigatorTreeNode[] navigatorTreeNodeArray = NavigatorContext.getNavigatorNodesFromContext(context);
        return navigatorTreeNodeArray != null && navigatorTreeNodeArray.length == 1 ? navigatorTreeNodeArray[0] : null;
    }

    public static NavigatorTreeNode getFirstNavigatorTreeNodeFromContext(Context context) {
        NavigatorTreeNode[] navigatorTreeNodeArray = NavigatorContext.getNavigatorNodesFromContext(context);
        return navigatorTreeNodeArray != null && navigatorTreeNodeArray.length > 0 ? navigatorTreeNodeArray[0] : null;
    }

    public static NavigatorTree getNavigatorTreeFromContext(Context context) {
        return (NavigatorTree)context.getProperty(TREE_KEY);
    }

    public static List<TreePath> storeSelectionState(NavigatorTree navigatorTree) {
        CustomTree customTree = navigatorTree.getTree();
        TreePath[] treePathArray = ((JTree)((Object)customTree)).getSelectionPaths();
        return null == treePathArray ? new ArrayList<TreePath>() : new ArrayList<TreePath>(Arrays.asList(treePathArray));
    }

    public static void restoreSelectionState(NavigatorTree navigatorTree, List<TreePath> list) {
        if (list == null) {
            throw new IllegalArgumentException("null selection data to restoreSelectionState");
        }
        CustomTree customTree = navigatorTree.getTree();
        int n = list.size();
        if (n == 1 && ModelUtil.areEqual((Object)list.get(0), (Object)((JTree)((Object)customTree)).getSelectionPath())) {
            return;
        }
        ((JTree)((Object)customTree)).clearSelection();
        NavigatorTreeNode navigatorTreeNode = navigatorTree.getRoot();
        for (TreePath treePath : list) {
            TreePath treePath2 = NavigatorContext.findNewPath(navigatorTreeNode, treePath, false);
            if (treePath2 == null) continue;
            ((JTree)((Object)customTree)).addSelectionPath(treePath2);
            ((JTree)((Object)customTree)).scrollPathToVisible(treePath2);
        }
    }

    private static TreePath findNewPath(NavigatorTreeNode navigatorTreeNode, TreePath treePath, boolean bl) {
        if (navigatorTreeNode == null || treePath == null) {
            return null;
        }
        Object[] objectArray = treePath.getPath();
        if (objectArray == null || objectArray.length == 0) {
            return null;
        }
        Object[] objectArray2 = new Object[objectArray.length];
        NavigatorTreeNode navigatorTreeNode2 = navigatorTreeNode;
        objectArray2[0] = navigatorTreeNode;
        for (int i = 1; i < objectArray.length; ++i) {
            NavigatorTreeNode navigatorTreeNode3 = (NavigatorTreeNode)objectArray[i];
            String string = navigatorTreeNode3.getLongLabel();
            NavigatorTreeNode navigatorTreeNode4 = NavigatorContext.findChildWithLongLabel(navigatorTreeNode2, string);
            if (navigatorTreeNode4 == null) {
                if (bl) {
                    return null;
                }
                Object[] objectArray3 = new Object[i];
                System.arraycopy(objectArray2, 0, objectArray3, 0, i);
                return new TreePath(objectArray3);
            }
            objectArray2[i] = navigatorTreeNode4;
            navigatorTreeNode2 = navigatorTreeNode4;
        }
        return new TreePath(objectArray2);
    }

    private static NavigatorTreeNode findChildWithLongLabel(NavigatorTreeNode navigatorTreeNode, String string) {
        Iterator<NavigatorTreeNode> iterator = navigatorTreeNode.getChildNodes();
        while (iterator.hasNext()) {
            NavigatorTreeNode navigatorTreeNode2 = iterator.next();
            if (navigatorTreeNode2 == null || !ModelUtil.areEqual((Object)navigatorTreeNode2.getLongLabel(), (Object)string)) continue;
            return navigatorTreeNode2;
        }
        return null;
    }

    public static List<ExpandInfo> storeExpansionState(NavigatorTree navigatorTree, NavigatorTreeNode navigatorTreeNode) {
        Object object;
        CustomTree customTree = navigatorTree.getTree();
        Enumeration<TreePath> enumeration = ((JTree)((Object)customTree)).getExpandedDescendants(new TreePath(navigatorTreeNode.getPath()));
        TreeSet<Object> treeSet = new TreeSet<Object>(new TreePathComparator());
        if (enumeration != null) {
            while (enumeration.hasMoreElements()) {
                object = enumeration.nextElement();
                treeSet.add(object);
            }
        }
        object = treeSet.iterator();
        ArrayList<ExpandInfo> arrayList = new ArrayList<ExpandInfo>();
        while (object.hasNext()) {
            TreePath treePath = (TreePath)object.next();
            String string = NavigatorContext.convertTreePathToString(treePath);
            ExpandInfo expandInfo = new ExpandInfo(string);
            arrayList.add(expandInfo);
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treePath.getLastPathComponent();
            Object object2 = ((Element)defaultMutableTreeNode.getUserObject()).getData();
            if (!(object2 instanceof DataContainer)) continue;
            DataContainer dataContainer = (DataContainer)object2;
            expandInfo._url = dataContainer.getURL();
        }
        return arrayList;
    }

    public static void restoreExpansionState(NavigatorTree navigatorTree, NavigatorTreeNode navigatorTreeNode, List<TreePath> list) {
    }

    private static String convertTreePathToString(TreePath treePath) {
        Object object = "";
        Object[] objectArray = treePath.getPath();
        for (int i = 0; i < objectArray.length; ++i) {
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)objectArray[i];
            object = (String)object + ((Element)defaultMutableTreeNode.getUserObject()).getLongLabel() + ",";
        }
        return object;
    }

    public static void checkExpansionState(NavigatorTreeNode navigatorTreeNode, List<ExpandInfo> list, int n, List<TreePath> list2) {
        TreePath treePath = new TreePath(navigatorTreeNode.getPath());
        String string = NavigatorContext.convertTreePathToString(treePath);
        if (!NavigatorContext.wasExpanded(string, list, n)) {
            return;
        }
        Iterator<NavigatorTreeNode> iterator = navigatorTreeNode.getChildNodes();
        list2.add(treePath);
        ++n;
        while (iterator.hasNext()) {
            navigatorTreeNode = iterator.next();
            if (n >= list.size()) continue;
            NavigatorContext.checkExpansionState(navigatorTreeNode, list, n, list2);
        }
    }

    private static boolean wasExpanded(String string, List<ExpandInfo> list, int n) {
        for (int i = n; i < list.size(); ++i) {
            ExpandInfo expandInfo = list.get(i);
            if (!string.equals(expandInfo._nodePath)) continue;
            return true;
        }
        return false;
    }

    public static class ExpandInfo {
        private URL _url;
        private String _nodePath;

        public ExpandInfo() {
        }

        public ExpandInfo(String string) {
            this(string, null);
        }

        public ExpandInfo(String string, URL uRL) {
            this._url = uRL;
            this._nodePath = string;
        }
    }

    static class TreePathComparator
    implements Comparator {
        TreePathComparator() {
        }

        public int compare(Object object, Object object2) {
            int n;
            if (object == object2) {
                return 0;
            }
            int n2 = ((TreePath)object).getPathCount();
            if (n2 < (n = ((TreePath)object2).getPathCount())) {
                return -1;
            }
            return 1;
        }
    }
}

