/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.navigator.db;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import javax.ide.util.MetaClass;
import oracle.dbtools.common.utils.ModelUtil;
import oracle.dbtools.raptor.navigator.DatabaseNavigatorResources;
import oracle.dbtools.raptor.navigator.db.BaseConnectionNode;
import oracle.dbtools.raptor.navigator.db.DBNavigatorWindow;
import oracle.dbtools.raptor.navigator.db.DBViewControllerImpl;
import oracle.dbtools.raptor.navigator.db.DatabaseTypeRoot;
import oracle.dbtools.raptor.navigator.db.xml.NavigatorHook;
import oracle.dbtools.raptor.navigator.impl.ViewableElement;
import oracle.dbtools.util.Logger;
import oracle.dbtools.util.Pair;
import oracle.ide.ExtensionRegistry;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.extension.HashStructureHook;
import oracle.ide.extension.HashStructureHookEvent;
import oracle.ide.extension.HashStructureHookListener;
import oracle.ide.extension.LazyClassAdapter;
import oracle.ide.view.View;
import oracle.javatools.data.HashStructure;

public abstract class DatabaseTypeSupport {
    private static final String ELEMENT_KEY = "db-connection-type-provider";
    private static final String ATTRIBUTE_ID = "id";
    private static final String ATTRIBUTE_CLASS = "class";
    private static Set<Pair<String, DatabaseTypeSupport>> sTypes = new TreeSet<Pair<String, DatabaseTypeSupport>>(new Comparator<Pair<String, DatabaseTypeSupport>>(){

        @Override
        public int compare(Pair<String, DatabaseTypeSupport> pair, Pair<String, DatabaseTypeSupport> pair2) {
            int n;
            int n2 = ((DatabaseTypeSupport)pair.second()).getWeight();
            if (n2 == (n = ((DatabaseTypeSupport)pair2.second()).getWeight())) {
                return ((String)pair.first()).compareTo((String)pair2.first());
            }
            return n2 - n;
        }
    });
    private static Listener sListener;

    private static DatabaseTypeSupport findType(String string) {
        DatabaseTypeSupport databaseTypeSupport = null;
        for (Pair<String, DatabaseTypeSupport> pair : sTypes) {
            if (!((String)pair.first()).equals(string)) continue;
            databaseTypeSupport = (DatabaseTypeSupport)pair.second();
            break;
        }
        return databaseTypeSupport;
    }

    private static void registerType(String string, DatabaseTypeSupport databaseTypeSupport) {
        sTypes.add((Pair<String, DatabaseTypeSupport>)new Pair((Object)string, (Object)databaseTypeSupport));
    }

    public static List<String> getSupportedDatabaseTypes() {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (Pair<String, DatabaseTypeSupport> pair : sTypes) {
            arrayList.add((String)pair.first());
        }
        return arrayList;
    }

    public static IdeAction getLocalNewAction(String string, View view, boolean bl) {
        DatabaseTypeSupport databaseTypeSupport = DatabaseTypeSupport.findType(string);
        IdeAction ideAction = IdeAction.newLocalAction((int)databaseTypeSupport.getNewCommandID(), (View)view);
        if (ideAction != null && bl) {
            ideAction.putValueDirectly("Name", (Object)databaseTypeSupport.getNewLabelForSubmenu());
        }
        return ideAction;
    }

    public static Controller createController(String string, DBNavigatorWindow dBNavigatorWindow) {
        DatabaseTypeSupport databaseTypeSupport = DatabaseTypeSupport.findType(string);
        return databaseTypeSupport != null ? databaseTypeSupport.createController(dBNavigatorWindow) : null;
    }

    public static DatabaseTypeRoot getRootContainer(String string) {
        DatabaseTypeSupport databaseTypeSupport = DatabaseTypeSupport.findType(string);
        return databaseTypeSupport != null ? databaseTypeSupport.getRoot() : null;
    }

    public static void registerViewers(String string, ViewableElement viewableElement) {
        DatabaseTypeSupport databaseTypeSupport = DatabaseTypeSupport.findType(string);
        if (databaseTypeSupport != null) {
            databaseTypeSupport.registerViewers(viewableElement);
        }
    }

    protected abstract String getID();

    protected abstract int getNewCommandID();

    protected abstract String getNewLabelForSubmenu();

    protected abstract int getWeight();

    protected abstract Controller createController(DBNavigatorWindow var1);

    protected abstract DatabaseTypeRoot getRoot();

    protected abstract <T> BaseConnectionNode<T> getConnectionNode(String var1, boolean var2);

    protected void registerViewers(ViewableElement viewableElement) {
    }

    static {
        DatabaseTypeSupport.registerType("sqldev.nav", new JDBCSupport());
        HashStructureHook hashStructureHook = (HashStructureHook)ExtensionRegistry.getExtensionRegistry().getHook(NavigatorHook.ELEMENT_NAME);
        if (hashStructureHook != null) {
            sListener = new Listener();
            hashStructureHook.addHashStructureHookListener((HashStructureHookListener)sListener);
        }
    }

    private static class JDBCSupport
    extends DatabaseTypeSupport {
        private JDBCSupport() {
        }

        @Override
        protected String getID() {
            return "sqldev.nav";
        }

        @Override
        protected int getNewCommandID() {
            return DBViewControllerImpl.NEW_CONN_CHILD_CMD_ID;
        }

        @Override
        protected String getNewLabelForSubmenu() {
            return DatabaseNavigatorResources.getString("NEW_DATABASE_SUBMENU_LABEL");
        }

        @Override
        protected Controller createController(DBNavigatorWindow dBNavigatorWindow) {
            return new DBViewControllerImpl(dBNavigatorWindow);
        }

        @Override
        protected DatabaseTypeRoot getRoot() {
            return null;
        }

        @Override
        protected <T> BaseConnectionNode<T> getConnectionNode(String string, boolean bl) {
            return null;
        }

        @Override
        protected int getWeight() {
            return 0;
        }
    }

    private static class Listener
    implements HashStructureHookListener {
        private Listener() {
        }

        public void elementVisited(HashStructureHookEvent hashStructureHookEvent) {
            this.processDescriptors(hashStructureHookEvent.getNewElementHashStructure());
        }

        public void listenerAttached(HashStructureHookEvent hashStructureHookEvent) {
            this.processDescriptors(hashStructureHookEvent.getCombinedHashStructure());
        }

        private void processDescriptors(HashStructure hashStructure) {
            List list = hashStructure.getAsList(DatabaseTypeSupport.ELEMENT_KEY);
            if (list != null) {
                for (HashStructure hashStructure2 : list) {
                    String string = hashStructure2.getString(DatabaseTypeSupport.ATTRIBUTE_ID);
                    if (!ModelUtil.hasLength((String)string)) {
                        Logger.severe(DatabaseTypeSupport.class, (String)"Invalid DatabaseTypeSupport - missing id");
                        continue;
                    }
                    LazyClassAdapter lazyClassAdapter = LazyClassAdapter.getInstance((HashStructure)hashStructure2);
                    MetaClass metaClass = lazyClassAdapter.getMetaClass(DatabaseTypeSupport.ATTRIBUTE_CLASS);
                    if (metaClass == null) {
                        Logger.severe(DatabaseTypeSupport.class, (String)("Invalid DatabaseTypeSupport - missing class : " + string));
                        continue;
                    }
                    try {
                        DatabaseTypeSupport databaseTypeSupport = (DatabaseTypeSupport)metaClass.newInstance();
                        DatabaseTypeSupport.registerType(string, databaseTypeSupport);
                    }
                    catch (ClassNotFoundException | IllegalAccessException | InstantiationException reflectiveOperationException) {
                        Logger.severe(DatabaseTypeSupport.class, (String)("Invalid DatabaseTypeSupport : " + string), (Throwable)reflectiveOperationException);
                    }
                }
            }
        }
    }
}

