/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.navigator.db;

import javax.swing.Icon;
import oracle.dbtools.raptor.navigator.ConnectionOwner;
import oracle.dbtools.raptor.navigator.DatabaseNavigatorResources;
import oracle.dbtools.raptor.navigator.db.ConnectionFolderOwner;
import oracle.dbtools.raptor.navigator.db.DatabaseConnection;
import oracle.dbtools.raptor.navigator.db.Uncollapsable;
import oracle.dbtools.raptor.navigator.db.xml.ConnectionType;
import oracle.dbtools.raptor.navigator.db.xml.ConnectionTypeDetails;
import oracle.dbtools.raptor.navigator.db.xml.NavigatorHook;
import oracle.ide.model.DefaultFolder;
import oracle.ide.model.IdeSubject;
import oracle.ide.model.Observer;
import oracle.ide.model.Subject;
import oracle.ide.model.UpdateMessage;

public final class TypedConnections
extends DefaultFolder
implements ConnectionFolderOwner,
ConnectionOwner,
Subject,
Uncollapsable {
    private String mType;
    private Icon mIcon;
    private String mLabel;
    private IdeSubject mSubject = new IdeSubject();

    public static TypedConnections create(String string) {
        return new TypedConnections(string);
    }

    private TypedConnections(String string) {
        this.mType = string;
    }

    public String getType() {
        return this.mType;
    }

    public Icon getIcon() {
        if (this.mIcon == null) {
            this.mIcon = DatabaseConnection.loadIconForType(this.mType);
        }
        return this.mIcon;
    }

    public String getShortLabel() {
        if (this.mLabel == null) {
            ConnectionTypeDetails connectionTypeDetails;
            String string = null;
            ConnectionType connectionType = NavigatorHook.getHookInstance("sqldev.nav").getConnectionType(this.mType);
            if (connectionType != null && (connectionTypeDetails = connectionType.getImpl()) != null) {
                string = connectionTypeDetails.getConnectionPanelLabel();
            }
            if (string == null) {
                string = DatabaseNavigatorResources.getString("GENERIC_DATABASE_CONNECTION_TYPE");
            }
            this.mLabel = DatabaseNavigatorResources.format("DATABASE_CONNECTION_TYPE_LABEL", string);
        }
        return this.mLabel;
    }

    @Override
    public final int compareTo(ConnectionOwner connectionOwner) {
        if (connectionOwner == this) {
            return 0;
        }
        int n = connectionOwner.getWeight() - this.getWeight();
        if (n == 0) {
            n = this.getKey().compareTo(connectionOwner.getKey());
        }
        return n;
    }

    @Override
    public String getKey() {
        return this.mType;
    }

    @Override
    public int getWeight() {
        return "Oracle".equals(this.mType) ? 100 : 50;
    }

    public void attach(Observer observer) {
        this.mSubject.attach(observer);
    }

    public void detach(Observer observer) {
        this.mSubject.detach(observer);
    }

    public void notifyObservers(Object object, UpdateMessage updateMessage) {
        this.mSubject.notifyObservers(object, updateMessage);
    }
}

