/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.navigator.db.dbapi;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import oracle.dbtools.raptor.navigator.ConnectionInfo;
import oracle.dbtools.raptor.navigator.ObjectFactory;
import oracle.dbtools.raptor.navigator.db.dbapi.MetadataConnectionType;
import oracle.dbtools.raptor.navigator.db.dbapi.MetadataFolder;
import oracle.dbtools.raptor.navigator.db.dbapi.MetadataFolderInstance;
import oracle.dbtools.raptor.navigator.db.dbapi.MetadataObject;
import oracle.dbtools.raptor.navigator.db.dbapi.MetadataObjectInstance;
import oracle.dbtools.raptor.navigator.db.dbapi.MetadataObjectType;
import oracle.dbtools.raptor.navigator.db.dbapi.MetadataSchema;
import oracle.dbtools.raptor.navigator.db.dbapi.MetadataSchemaInstance;
import oracle.dbtools.raptor.navigator.db.dbapi.MetadataSchemas;
import oracle.dbtools.raptor.navigator.db.dbapi.MetadataSchemasInstance;
import oracle.dbtools.raptor.navigator.db.model.DBCatalogInstance;
import oracle.dbtools.raptor.navigator.db.model.DBCatalogsInstance;
import oracle.dbtools.raptor.navigator.db.model.DBChildInstance;
import oracle.dbtools.raptor.navigator.db.model.DBFolderInstance;
import oracle.dbtools.raptor.navigator.db.model.DBItemInstance;
import oracle.dbtools.raptor.navigator.db.model.DBObjectInstance;
import oracle.dbtools.raptor.navigator.db.model.DBSchema;
import oracle.dbtools.raptor.navigator.db.model.DBSchemaInstance;
import oracle.dbtools.raptor.navigator.db.model.DBSchemas;
import oracle.dbtools.raptor.navigator.db.model.DBSchemasInstance;
import oracle.dbtools.raptor.navigator.db.model.DatabaseFolder;
import oracle.dbtools.raptor.navigator.db.model.DatabaseObject;
import oracle.dbtools.raptor.navigator.db.model.ObjectType;
import oracle.dbtools.raptor.utils.Connections;
import oracle.javatools.db.DBException;
import oracle.javatools.db.Database;
import oracle.javatools.db.Schema;

public class MetadataObjectFactory
extends ObjectFactory {
    private static DBSchemas s_schemasDesc = new MetadataSchemas();
    private static DBSchema s_schemaDesc = new MetadataSchema();
    private Database m_db;
    private Map<String, ObjectType> m_types = new HashMap<String, ObjectType>();
    private DBSchemasInstance m_schemas;

    public MetadataObjectFactory(ConnectionInfo connectionInfo) throws DBException {
        super(connectionInfo, new MetadataConnectionType(connectionInfo));
        this.m_db = Connections.getInstance().getDatabase(connectionInfo.getConnectionName());
        for (String string : this.m_db.listObjectTypes()) {
            MetadataObjectType metadataObjectType = new MetadataObjectType(this.m_db, string);
            this.m_types.put(string, metadataObjectType);
        }
    }

    @Override
    protected ObjectType[] listTypesImpl(String string) {
        return this.m_types.values().toArray(new ObjectType[0]);
    }

    @Override
    public ObjectType[] listTypes() {
        return this.listTypesImpl(null);
    }

    @Override
    public DBSchemasInstance getSchemasInstance(DBCatalogInstance dBCatalogInstance) {
        if (this.m_schemas == null) {
            this.m_schemas = new MetadataSchemasInstance(this, s_schemasDesc);
            this.m_schemas.setProperty("ConnectionType", this.getConnectionType());
        }
        this.m_schemas.setProperty("ConnectionType", this.getConnectionType());
        return this.m_schemas;
    }

    @Override
    public DatabaseObject getObjectDescriptor(String string) {
        DatabaseObject databaseObject = null;
        ObjectType objectType = this.m_types.get(string);
        if (objectType != null) {
            databaseObject = objectType.getNode();
        }
        return databaseObject;
    }

    @Override
    public DBCatalogsInstance getCatalogsInstance() {
        return null;
    }

    @Override
    public DBSchemaInstance createSchemaInstance(String string) {
        Schema schema = null;
        try {
            schema = this.m_db.getSchema(string);
        }
        catch (DBException dBException) {
            // empty catch block
        }
        return schema != null ? this.createSchemaInstance(schema) : new MetadataSchemaInstance(this, s_schemaDesc, string);
    }

    DBSchemaInstance createSchemaInstance(Schema schema) {
        MetadataSchemaInstance metadataSchemaInstance = new MetadataSchemaInstance(this, s_schemaDesc, schema.getName());
        metadataSchemaInstance.setProperty("dbapi.schema", schema);
        Map map = schema.getProperties();
        if (map != null) {
            Iterator iterator = map.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry;
                Map.Entry entry2 = entry = iterator.next();
                metadataSchemaInstance.setProperty((String)entry2.getKey(), entry2.getValue());
            }
        }
        return metadataSchemaInstance;
    }

    @Override
    public DBObjectInstance createNodeInstance(String string) {
        DBItemInstance dBItemInstance = null;
        DatabaseObject databaseObject = this.getObjectDescriptor(string);
        if (databaseObject != null) {
            dBItemInstance = new MetadataObjectInstance(this, (MetadataObject)databaseObject);
        }
        dBItemInstance.setProperty("ConnectionType", this.getConnectionType());
        dBItemInstance.setProperty("TYPE", string);
        return dBItemInstance;
    }

    @Override
    public DBFolderInstance createFolderInstance(String string, DatabaseFolder databaseFolder) {
        MetadataFolderInstance metadataFolderInstance = new MetadataFolderInstance(this, (MetadataFolder)databaseFolder);
        metadataFolderInstance.setProperty("TYPE", string);
        metadataFolderInstance.setProperty("ConnectionType", this.getConnectionType());
        return metadataFolderInstance;
    }

    @Override
    public DBChildInstance createChildInstance(String string, String string2) {
        return null;
    }

    @Override
    public DBCatalogInstance createCatalogInstance(String string) {
        return null;
    }

    @Override
    public boolean isShowAllSchemasAtTopLevel() {
        return true;
    }

    @Override
    public boolean isSupportsCatalog() {
        return false;
    }

    Database getDatabase() {
        return this.m_db;
    }

    @Override
    public String getConnectionType() {
        return "JDBC";
    }
}

