/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.navigator.db.xml;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import oracle.dbtools.raptor.navigator.db.model.DatabaseFolder;
import oracle.dbtools.raptor.navigator.db.xml.NavigatorDescriptor;
import oracle.dbtools.raptor.navigator.db.xml.XmlBaseElement;
import oracle.dbtools.raptor.navigator.db.xml.XmlFolderImpl;
import oracle.dbtools.xml.navigator.FolderElement;
import oracle.dbtools.xml.navigator.FolderOwner;
import oracle.dbtools.xml.navigator.NavigatorXmlElements;

abstract class XmlFolderOwner
extends XmlBaseElement
implements NavigatorXmlElements {
    protected double m_weight = 100.0;
    protected boolean m_includesSyns;
    private boolean m_treeOnly;
    private boolean m_requiresParent;
    protected NavigatorDescriptor m_desc;
    private List<XmlFolderImpl> m_folders;
    private final Set<String> m_reqLicenses;

    abstract boolean isIncludesSynonyms();

    public abstract String getType();

    protected XmlFolderOwner(String string, NavigatorDescriptor navigatorDescriptor, FolderOwner folderOwner) {
        super(string);
        this.m_desc = navigatorDescriptor;
        this.m_treeOnly = folderOwner.isTreeOnly();
        this.m_requiresParent = folderOwner.isRequiresParent();
        this.m_includesSyns = folderOwner.isIncludeSynonyms();
        this.m_reqLicenses = new HashSet<String>(folderOwner.getRequiredLicences());
        double d = folderOwner.getWeight();
        if (d != Double.NEGATIVE_INFINITY) {
            this.m_weight = d;
        }
        this.initFolders(folderOwner);
    }

    public double getWeight() {
        return this.m_weight;
    }

    protected DatabaseFolder[] getFoldersImpl() {
        return this.m_folders.toArray(new XmlFolderImpl[0]);
    }

    protected NavigatorDescriptor getNavigatorDescriptor() {
        return this.m_desc;
    }

    private void initFolders(FolderOwner folderOwner) {
        if (this.m_folders == null) {
            this.m_folders = new ArrayList<XmlFolderImpl>();
            for (FolderElement folderElement : folderOwner.getFolders()) {
                this.m_folders.add(new XmlFolderImpl(this, this.m_desc, folderElement));
            }
        }
    }

    public boolean isTreeOnly() {
        return this.m_treeOnly;
    }

    public boolean requiresParentObject() {
        return this.m_requiresParent;
    }

    protected Set<String> getRequiredLicenses() {
        return Collections.unmodifiableSet(this.m_reqLicenses);
    }
}

