/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.navigator.net.editor;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import java.util.WeakHashMap;
import java.util.logging.Logger;
import oracle.dbtools.raptor.Messages;
import oracle.dbtools.raptor.extendedtype.XMLExtendeType;
import oracle.dbtools.raptor.navigator.net.editor.BreakoutEditorListener;
import oracle.dbtools.raptor.navigator.net.editor.XMLTypeBreakoutEditorAction;
import oracle.dbtools.raptor.navigator.net.editor.XMLTypeNodeFactory;
import oracle.dbtools.raptor.navigator.net.editor.XMLTypeURLStreamHandlerFactory;
import oracle.dbtools.raptor.navigator.net.editor.XMLTypeURLTemporaryCollector;
import oracle.dbtools.util.Resource;
import oracle.ide.model.Node;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLFileSystemHelper;

public class XMLTypeURLFileSystemHelper
extends URLFileSystemHelper {
    static final Logger LOGGER = Logger.getLogger(XMLTypeURLFileSystemHelper.class.getName());
    public static final String PROTOCOL = "sqldev.xml";
    private static Map<URL, URL> s_backers = new HashMap<URL, URL>();
    private static List<URL> s_tempURLs = new Vector<URL>();
    private static Map<XMLExtendeType, XMLTypeURLTemporaryCollector> s_collectorMap = new WeakHashMap<XMLExtendeType, XMLTypeURLTemporaryCollector>();

    static URL createXMLTypeURL() throws IOException {
        File file = XMLTypeURLFileSystemHelper.createTemporaryFile();
        return XMLTypeURLFileSystemHelper.createXMLTypeURL(URLFactory.newFileURL((File)file), true);
    }

    static URL createXMLTypeURL(URL uRL) throws IOException {
        if (uRL == null) {
            return XMLTypeURLFileSystemHelper.createXMLTypeURL();
        }
        return XMLTypeURLFileSystemHelper.createXMLTypeURL(uRL, false);
    }

    private static File createTemporaryFile() throws IOException {
        File file = File.createTempFile("XMLType", ".xml", Resource.RAPTOR_USER_TEMP);
        file.deleteOnExit();
        return file;
    }

    private static URL createXMLTypeURL(URL uRL, boolean bl) throws IOException {
        URL uRL2 = uRL;
        if (!XMLTypeURLStreamHandlerFactory.isHandler(uRL2.getProtocol())) {
            URL uRL3 = URLFactory.newDirURL((String)PROTOCOL, (String)"");
            uRL2 = URLFactory.newURL((URL)uRL3, (String)uRL2.getPath());
            s_backers.put(uRL2, uRL);
        }
        if (bl) {
            s_tempURLs.add(uRL2);
        }
        return uRL2;
    }

    static URL releaseXMLTypeURL(URL uRL) {
        URL uRL2 = s_backers.get(uRL);
        if (XMLTypeURLFileSystemHelper.releaseTemporaryFileURL(uRL2)) {
            return s_backers.remove(uRL);
        }
        return null;
    }

    static boolean isTemporaryFileURL(URL uRL) {
        return uRL != null && s_tempURLs.contains(uRL);
    }

    private static boolean releaseTemporaryFileURL(URL uRL) {
        boolean bl = false;
        if (uRL != null && s_tempURLs.contains(uRL)) {
            try {
                File file = new File(uRL.toURI());
                bl = file.delete();
                if (bl) {
                    bl = s_tempURLs.remove(uRL);
                }
            }
            catch (Exception exception) {}
        } else {
            bl = true;
        }
        return bl;
    }

    static URL getBackingURL(URL uRL) {
        URL uRL2 = s_backers.get(uRL);
        return uRL2;
    }

    static void manageURLCleanup(XMLExtendeType xMLExtendeType, URL uRL) {
        if (XMLTypeURLFileSystemHelper.isTemporaryFileURL(uRL)) {
            XMLTypeURLTemporaryCollector xMLTypeURLTemporaryCollector = s_collectorMap.get(xMLExtendeType);
            if (xMLTypeURLTemporaryCollector == null) {
                xMLTypeURLTemporaryCollector = new XMLTypeURLTemporaryCollector();
                s_collectorMap.put(xMLExtendeType, xMLTypeURLTemporaryCollector);
            }
            xMLTypeURLTemporaryCollector.pushURL(uRL);
        }
    }

    public long lastModified(URL uRL) {
        URL uRL2 = XMLTypeURLFileSystemHelper.getBackingURL(uRL);
        return uRL2 != null ? URLFileSystem.lastModified((URL)uRL2) : 0L;
    }

    public InputStream openInputStream(URL uRL) throws IOException {
        URL uRL2 = XMLTypeURLFileSystemHelper.getBackingURL(uRL);
        if (uRL2 == null) {
            throw new FileNotFoundException(uRL.toString());
        }
        return URLFileSystem.openInputStream((URL)uRL2);
    }

    public OutputStream openOutputStream(URL uRL) throws IOException {
        BreakoutEditorListener breakoutEditorListener;
        Object object;
        Node node = XMLTypeNodeFactory.find(uRL);
        if (node != null && (object = XMLTypeNodeFactory.getAction(node)) != null && (breakoutEditorListener = ((XMLTypeBreakoutEditorAction)object).getBreakoutEditorListener()) != null && !breakoutEditorListener.savable()) {
            throw new FileNotFoundException(Messages.getString("XMLTypeEditor.1"));
        }
        object = XMLTypeURLFileSystemHelper.getBackingURL(uRL);
        if (object == null) {
            throw new FileNotFoundException(uRL.toString());
        }
        return URLFileSystem.openOutputStream((URL)object);
    }

    public boolean exists(URL uRL) {
        return s_backers.get(uRL.getPath()) != null;
    }

    public boolean isReadOnly(URL uRL) {
        return false;
    }

    public String toRelativeSpec(URL uRL, URL uRL2, boolean bl) {
        return bl ? null : uRL.getPath();
    }

    public String getPlatformPathName(URL uRL) {
        URL uRL2 = XMLTypeURLFileSystemHelper.getBackingURL(uRL);
        return uRL2 != null ? URLFileSystem.getPlatformPathName((URL)uRL2) : uRL.getPath();
    }

    public String getFileName(URL uRL) {
        URL uRL2 = XMLTypeURLFileSystemHelper.getBackingURL(uRL);
        return uRL2 != null ? URLFileSystem.getFileName((URL)uRL2) : uRL.getPath();
    }
}

