/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.navigator.plsql;

import java.util.List;
import javax.swing.Icon;
import oracle.dbtools.parser.LexerToken;
import oracle.dbtools.parser.plsql.ProcArg;
import oracle.dbtools.raptor.images.RaptorImagesArb;
import oracle.dbtools.raptor.navigator.plsql.PlSqlArguments;
import oracle.dbtools.raptor.navigator.plsql.PlsqlStructureParser;
import oracle.dbtools.util.Service;
import oracle.javatools.icons.OracleIcons;

public class Member {
    public String name;
    public String type;
    public int codeOffset;
    public int endOffset;
    private String payload;
    public boolean isPrivate = false;
    public Integer overload = null;
    public int from;
    public int to;

    public String getPayload() {
        return this.payload;
    }

    public String getTooltip() {
        int n = 200;
        return this.payload.length() <= n ? this.payload : this.payload.substring(0, n);
    }

    public Member(String string, String string2, int n, int n2, String string3) {
        this.name = string;
        this.type = string2 != null ? string2.toUpperCase() : string2;
        this.codeOffset = n;
        this.endOffset = n2;
        this.payload = string3;
    }

    public boolean isData() {
        return !"PROCEDURE".equals(this.type) && !"FUNCTION".equals(this.type);
    }

    public String toString() {
        return "<" + this.name + "," + this.type + ">";
    }

    public Icon getIcon() {
        return Member.getIcon(this.type, this.isPrivate);
    }

    public static Icon getIcon(String string, boolean bl) {
        if (string == null) {
            return null;
        }
        String string2 = string.toUpperCase();
        if (string2.startsWith("TYPE")) {
            return OracleIcons.getIcon((String)"domain.png");
        }
        if ("DATE".equals(string2) || "TIMESTAMP".equals(string2)) {
            return RaptorImagesArb.getIcon("DATE");
        }
        if ("STRING".equals(string2) || string2.contains("CHAR")) {
            return RaptorImagesArb.getIcon("STRING");
        }
        if ("BOOLEAN".equals(string2)) {
            return RaptorImagesArb.getIcon("BOOLEAN");
        }
        if ("EXCEPTION".equals(string2)) {
            return RaptorImagesArb.getIcon("EXC");
        }
        if ("CURSOR".equals(string2)) {
            return RaptorImagesArb.getIcon("CURSOR");
        }
        if ("TRIGGER".equals(string2)) {
            return OracleIcons.getIcon((String)"trigger.png");
        }
        if ("FUNCTION".equals(string2)) {
            if (bl) {
                return RaptorImagesArb.getIcon("PRIVATE_FUNCTION");
            }
            return RaptorImagesArb.getIcon("FUNCTION");
        }
        if ("PROCEDURE".equals(string2)) {
            if (bl) {
                return RaptorImagesArb.getIcon("PRIVATE_PROCEDURE");
            }
            return RaptorImagesArb.getIcon("PROCEDURE");
        }
        if ("PACKAGE".equals(string2) || "PACKAGE BODY".equals(string2)) {
            return OracleIcons.getIcon((String)"package.png");
        }
        if ("INTEGER".equalsIgnoreCase(string2) || "NUMBER".equalsIgnoreCase(string2)) {
            return OracleIcons.getIcon((String)"field.png");
        }
        return null;
    }

    public List<ProcArg> getSignature() {
        if (this.isData()) {
            throw new AssertionError((Object)"N/A");
        }
        List list = LexerToken.parse((String)this.payload);
        return ProcArg.collectViaParsing(list);
    }

    public static void main(String[] stringArray) throws Exception {
        String string = Service.readFile(ProcArg.class, (String)"test1.sql");
        List list = LexerToken.parse((String)string);
        PlsqlStructureParser plsqlStructureParser = new PlsqlStructureParser();
        plsqlStructureParser.parse(list, PlSqlArguments.getSort());
        for (Member member : plsqlStructureParser.children) {
            if (member.isData()) continue;
            for (ProcArg procArg : member.getSignature()) {
                System.out.println(procArg.procedure + " @" + procArg.argumentPos + ": " + procArg.argumentName + " " + procArg.type);
            }
        }
    }
}

