/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.plsql;

import java.beans.PropertyChangeEvent;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.TreeSet;
import java.util.logging.Logger;
import oracle.dbtools.parser.Grammar;
import oracle.dbtools.parser.Lexer;
import oracle.dbtools.parser.LexerToken;
import oracle.dbtools.parser.Matriceable;
import oracle.dbtools.parser.Matrix;
import oracle.dbtools.parser.ParseNode;
import oracle.dbtools.parser.Parser;
import oracle.dbtools.parser.plsql.Item;
import oracle.dbtools.parser.plsql.LazyNode;
import oracle.dbtools.parser.plsql.SqlEarley;
import oracle.dbtools.parser.plsql.StackParser;
import oracle.dbtools.raptor.config.DBConfig;
import oracle.dbtools.raptor.navigator.plsql.PlSqlNode;
import oracle.dbtools.raptor.newscriptrunner.commands.HiddenParameters;
import oracle.dbtools.raptor.phighlight.HighlightEditorPlugin;
import oracle.dbtools.raptor.plsql.ParserEventListener;
import oracle.dbtools.raptor.plsql.structure.OutlinePanel;
import oracle.dbtools.raptor.utils.NamedSwingWorker;
import oracle.javatools.buffer.TextBuffer;
import oracle.javatools.buffer.TextBufferListener;
import oracle.javatools.editor.BasicDocument;
import oracle.javatools.editor.BasicEditorPane;
import oracle.javatools.editor.language.NumberRange;
import oracle.javatools.editor.plugins.EditorPlugin;

public class BackgroundParser
implements TextBufferListener,
EditorPlugin {
    private static Logger logger = Logger.getLogger(BackgroundParser.class.getName());
    public LazyNode output = null;
    public List<LexerToken> src = null;
    public List<LexerToken> allSrc = null;
    public String text = null;
    public ArrayList<NumberRange> increments = new ArrayList();
    private TextBuffer buffer = null;
    public Matrix matrix = null;
    public ParseNode root = null;
    SqlEarley earley = SqlEarley.partialRecognizer();
    long lastUpdate = -1L;
    public BasicEditorPane editor;
    boolean quit = false;
    public boolean isInsertion = false;
    public boolean isSingleChar = false;
    static int cnt = 0;
    int instance;
    public boolean isParsing = false;
    private List<ParserEventListener> listeners = new ArrayList<ParserEventListener>();
    private static final String KEYWORD_FUNCTION = "FUNCTION";
    private static final String KEYWORD_PROCEDURE = "PROCEDURE";
    private static final String KEYWORD_PACKAGE = "PACKAGE";
    private static final String KEYWORD_BODY = "BODY";
    private static final String KEYWORD_TYPE = "TYPE";
    private static final String KEYWORD_TRIGGER = "TRIGGER";
    private static final String KEYWORD_OPERATOR = "OPERATOR";

    public void attributeUpdate(TextBuffer textBuffer, int n) {
    }

    public void insertUpdate(TextBuffer textBuffer, int n, int n2, char[] cArray) {
        this.buffer = textBuffer;
        this.increments.add(new NumberRange(n, n + n2));
        this.lastUpdate = System.currentTimeMillis();
    }

    public void removeUpdate(TextBuffer textBuffer, int n, int n2, char[] cArray) {
        this.buffer = textBuffer;
        this.increments.add(new NumberRange(n, n - n2));
        this.lastUpdate = System.currentTimeMillis();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean extractText() {
        block18: {
            boolean bl;
            if (!this.buffer.tryReadLock()) {
                return false;
            }
            try {
                if (this.buffer.getLength() > 5000000) {
                    this.quit = true;
                    Logger.getLogger(this.getClass().getName()).warning("Mem exceeded");
                    boolean bl2 = false;
                    return bl2;
                }
                this.text = this.buffer.getString(0, this.buffer.getLength());
                if (this.text != null) break block18;
                bl = false;
            }
            catch (Exception exception) {
                boolean bl3 = false;
                return bl3;
            }
            finally {
                try {
                    this.buffer.readUnlock();
                }
                catch (Throwable throwable) {}
            }
            return bl;
        }
        return true;
    }

    public void deinstall(BasicEditorPane basicEditorPane) {
        if ("true".equals(HiddenParameters.parameters.get("logBackgroundParser"))) {
            String string = "#" + this.instance + " BackgroundParser.deinstall()";
            System.out.println(string);
            logger.fine(string);
        }
        this.quit = true;
        if (this.buffer != null) {
            this.buffer.removeTextBufferListener((TextBufferListener)this);
        }
        basicEditorPane.deinstallPlugin((EditorPlugin)this);
    }

    private void cleanup() {
        this.listeners.clear();
        if ("true".equals(HiddenParameters.parameters.get("logBackgroundParser"))) {
            String string = "#" + this.instance + " BackgroundParser.cleanup()";
            System.out.println(string);
            logger.fine(string);
        }
    }

    public static void amendParserInstances(String string) {
        List list = Lexer.parse((String)string);
        if (list.size() == 0) {
            return;
        }
        ParseNode parseNode = Grammar.parseGrammarFile((List)list, (String)string);
        TreeSet treeSet = new TreeSet();
        Grammar.grammar((ParseNode)parseNode, (List)list, treeSet);
        SqlEarley.extendGrammar(treeSet);
    }

    public void install(BasicEditorPane basicEditorPane) {
        DBConfig dBConfig = DBConfig.getInstance();
        String string = dBConfig.getString("ADDITIONAL_RULES");
        if (string != null) {
            try {
                BackgroundParser.amendParserInstances(string);
            }
            catch (AssertionError assertionError) {
                logger.severe(((Throwable)((Object)assertionError)).getMessage());
            }
        }
        this.editor = basicEditorPane;
        BasicDocument basicDocument = (BasicDocument)basicEditorPane.getDocument();
        this.buffer = basicDocument.getTextBuffer();
        this.buffer.addTextBufferListener((TextBufferListener)this);
        if (this.text == null) {
            this.extractText();
        }
        this.init();
    }

    private void init() {
        this.src = null;
        if (this.extractText()) {
            try {
                this.parse();
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
        }
        try {
            this.instance = cnt++;
            NamedSwingWorker namedSwingWorker = new NamedSwingWorker("Background Parser#" + this.instance){

                @Override
                public Object construct() {
                    BackgroundParser.this.quit = false;
                    while (!BackgroundParser.this.quit) {
                        try {
                            Thread.sleep(100L);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                        if (BackgroundParser.this.src != null && System.currentTimeMillis() - BackgroundParser.this.lastUpdate < 250L || BackgroundParser.this.src != null && BackgroundParser.this.increments.size() == 0) continue;
                        BackgroundParser.this.isInsertion = BackgroundParser.this.isInsertion();
                        BackgroundParser.this.isSingleChar = BackgroundParser.this.isSingleChar();
                        if (!BackgroundParser.this.extractText()) continue;
                        try {
                            BackgroundParser.this.parse();
                        }
                        catch (Throwable throwable) {
                            throwable.printStackTrace();
                        }
                    }
                    BackgroundParser.this.cleanup();
                    return null;
                }
            };
            namedSwingWorker.start();
        }
        catch (IllegalThreadStateException illegalThreadStateException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void parse() {
        Object object;
        this.increments = new ArrayList();
        this.isParsing = true;
        long l = System.currentTimeMillis();
        if (this.text == null) {
            this.isParsing = false;
            return;
        }
        if (this.editor != null) {
            this.allSrc = LexerToken.parse((String)this.text, (boolean)true, (int)55);
            List list = LexerToken.parse((String)this.text);
            LazyNode lazyNode = StackParser.getInstance().parse(list);
            int n = BackgroundParser.parseThreshold();
            if (list.size() < n) {
                object = new Matrix((Parser)this.earley);
                this.earley.parse(list, (Matriceable)object);
                this.root = this.earley.forest(list, (Matrix)object);
                this.matrix = object;
            } else {
                this.root = null;
                this.matrix = null;
            }
            this.output = lazyNode;
            this.src = list;
        } else {
            this.src = LexerToken.parse((String)this.text);
            this.output = null;
            this.matrix = new Matrix((Parser)this.earley);
            this.earley.parse(this.src, (Matriceable)this.matrix);
            this.root = this.earley.forest(this.src, this.matrix);
        }
        this.isParsing = false;
        long l2 = System.currentTimeMillis();
        LinkedList<ParserEventListener> linkedList = new LinkedList<ParserEventListener>();
        object = this.listeners;
        synchronized (object) {
            for (ParserEventListener parserEventListener : this.listeners) {
                linkedList.add(parserEventListener);
            }
        }
        for (ParserEventListener parserEventListener : linkedList) {
            try {
                if (0 < this.increments.size()) {
                    return;
                }
                parserEventListener.stateChanged(this);
            }
            catch (Throwable throwable) {
                throwable.fillInStackTrace();
            }
        }
    }

    public static int parseThreshold() {
        int n = 15000;
        try {
            n = Integer.parseInt((String)HiddenParameters.parameters.get("parseThreshold"));
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            DBConfig dBConfig = DBConfig.getInstance();
            n = dBConfig.getInt("PARSER_THRESHOLD");
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return n;
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addParserEventListener(ParserEventListener parserEventListener) {
        List<ParserEventListener> list = this.listeners;
        synchronized (list) {
            this.listeners.add(parserEventListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeParserEventListener(ParserEventListener parserEventListener) {
        List<ParserEventListener> list = this.listeners;
        synchronized (list) {
            this.listeners.remove(parserEventListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void replaceOutlineListener(OutlinePanel outlinePanel) {
        LinkedList<ParserEventListener> linkedList = new LinkedList<ParserEventListener>();
        for (ParserEventListener parserEventListener : this.listeners) {
            if (!(parserEventListener instanceof OutlinePanel)) continue;
            linkedList.add(parserEventListener);
        }
        List<ParserEventListener> list = this.listeners;
        synchronized (list) {
            this.listeners.removeAll(linkedList);
            this.listeners.add(outlinePanel);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void replaceHighlighter(HighlightEditorPlugin highlightEditorPlugin) {
        LinkedList<ParserEventListener> linkedList = new LinkedList<ParserEventListener>();
        for (ParserEventListener parserEventListener : this.listeners) {
            if (!(parserEventListener instanceof HighlightEditorPlugin) || highlightEditorPlugin.getEditorPane() != ((HighlightEditorPlugin)parserEventListener).getEditorPane()) continue;
            linkedList.add(parserEventListener);
        }
        List<ParserEventListener> list = this.listeners;
        synchronized (list) {
            this.listeners.removeAll(linkedList);
            this.listeners.add(highlightEditorPlugin);
        }
    }

    public int recalculatePosition(int n) {
        int n2 = this.recalcPos(n);
        while (n2 != n) {
            n = n2;
            n2 = this.recalcPos(n2);
        }
        return n2;
    }

    private int recalcPos(int n) {
        for (NumberRange numberRange : this.increments) {
            if (numberRange.end != n) continue;
            return numberRange.start;
        }
        return n;
    }

    private boolean isInsertion() {
        boolean bl = false;
        for (NumberRange numberRange : this.increments) {
            if (numberRange.start < numberRange.end) {
                bl = true;
                continue;
            }
            if (numberRange.start <= numberRange.end) continue;
            bl = false;
            break;
        }
        return bl;
    }

    private boolean isSingleChar() {
        if (this.increments.size() != 1) {
            return false;
        }
        for (NumberRange numberRange : this.increments) {
            if (numberRange.start + 1 == numberRange.end) continue;
            return false;
        }
        return true;
    }

    public Item parseNameTypeOwner(PlSqlNode plSqlNode) {
        String string = null;
        String string2 = null;
        String string3 = null;
        if (this.src == null) {
            if (this.text == null) {
                this.text = plSqlNode.getSource();
            }
            this.allSrc = LexerToken.parse((String)this.text, (boolean)true, (int)55);
            this.src = LexerToken.parse((String)this.text);
        }
        Object object = null;
        for (int i = 0; i < this.src.size() && i < 10; ++i) {
            LexerToken lexerToken = this.src.get(i);
            if ("(".equalsIgnoreCase(lexerToken.content) || "RETURN".equalsIgnoreCase(lexerToken.content) || "IS".equalsIgnoreCase(lexerToken.content) || "AS".equalsIgnoreCase(lexerToken.content) || "BEFORE".equalsIgnoreCase(lexerToken.content) || "AFTER".equalsIgnoreCase(lexerToken.content)) break;
            if (object == null && KEYWORD_PACKAGE.equalsIgnoreCase(lexerToken.content)) {
                object = lexerToken.content.toUpperCase();
                continue;
            }
            if (object == null && KEYWORD_PROCEDURE.equalsIgnoreCase(lexerToken.content)) {
                object = lexerToken.content.toUpperCase();
                continue;
            }
            if (object == null && KEYWORD_FUNCTION.equalsIgnoreCase(lexerToken.content)) {
                object = lexerToken.content.toUpperCase();
                continue;
            }
            if (object == null && KEYWORD_TRIGGER.equalsIgnoreCase(lexerToken.content)) {
                object = lexerToken.content.toUpperCase();
                continue;
            }
            if (object == null && KEYWORD_TYPE.equalsIgnoreCase(lexerToken.content)) {
                object = lexerToken.content.toUpperCase();
                continue;
            }
            if (object == null && KEYWORD_OPERATOR.equalsIgnoreCase(lexerToken.content)) {
                object = lexerToken.content.toUpperCase();
                continue;
            }
            if (object != null && KEYWORD_BODY.equalsIgnoreCase(lexerToken.content)) {
                object = (String)object + " " + lexerToken.content.toUpperCase();
                continue;
            }
            if (object != null && !KEYWORD_BODY.equalsIgnoreCase(lexerToken.content) && string == null) {
                string = lexerToken.content;
                if (string == null) continue;
                if (string.startsWith("\"") && string.endsWith("\"")) {
                    string = string.substring(1, string.length() - 1);
                    continue;
                }
                string = string.toUpperCase();
                continue;
            }
            if (!".".equalsIgnoreCase(lexerToken.content)) continue;
            string3 = string;
            string = null;
        }
        if (string2 == null) {
            string2 = object;
        }
        return new Item(null, string, null, string2, string3, null, -1, -1);
    }
}

