/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.plsql.structure;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.SwingWorker;
import javax.swing.table.DefaultTableModel;
import oracle.dbtools.arbori.MaterializedPredicate;
import oracle.dbtools.arbori.Program;
import oracle.dbtools.arbori.SqlProgram;
import oracle.dbtools.arbori.Tuple;
import oracle.dbtools.parser.LexerToken;
import oracle.dbtools.parser.ParseNode;
import oracle.dbtools.parser.plsql.SyntaxError;
import oracle.dbtools.raptor.backgroundTask.internal.Messages;
import oracle.dbtools.raptor.plsql.structure.ArboriGrid;
import oracle.dbtools.raptor.plsql.structure.OutlinePanel;
import oracle.dbtools.raptor.plsql.structure.OutlineWindow;
import oracle.dbtools.raptor.plsql.structure.arbori.ArboriLanguageSupport;
import oracle.dbtools.raptor.plsql.structure.arbori.ArboriPanel;
import oracle.dbtools.raptor.utils.Connections;
import oracle.ide.controls.SmallSquareButton;
import oracle.ide.view.View;
import oracle.javatools.icons.OracleIcons;

public class ArboriToolbar
extends JToolBar {
    ArboriPanel context;
    JButton stop;
    SqlProgram current = null;
    static final String sugarcoatError = "<html><font color=red>";

    public ArboriToolbar(ArboriPanel arboriPanel) {
        this.context = arboriPanel;
        JButton jButton = new JButton(OracleIcons.getIcon((String)"run.png"));
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ArboriToolbar.this.run();
            }
        });
        this.add(jButton);
        this.stop = new SmallSquareButton(OracleIcons.getIcon((String)"error.png"), Messages.getString((String)"SimpleRaptorTaskUI.4"));
        this.stop.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                System.out.println("HIT:" + ArboriToolbar.this.current);
                if (ArboriToolbar.this.current != null) {
                    try {
                        ArboriToolbar.this.current.stop = true;
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
                ArboriToolbar.this.current = null;
                ArboriToolbar.this.stop.setEnabled(false);
            }
        });
        this.add(this.stop);
        this.stop.setEnabled(false);
    }

    protected void run() {
        this.context.tabbedPane.removeAll();
        this.stop.setEnabled(true);
        OutlinePanel outlinePanel = (OutlinePanel)OutlineWindow.getInstance().getGUI();
        outlinePanel.collapseMenu.switchAllItems(true);
        outlinePanel.hideMenu.switchAllItems(true);
        outlinePanel.mergeMenu.switchAllItems(true);
        outlinePanel.collapseExpand();
        outlinePanel.buildNewOutlineTree((View)outlinePanel.getEditor(), true);
        outlinePanel.tree.collapseRow(0);
        outlinePanel.tree.expandRow(0);
        if (outlinePanel.parser == null || outlinePanel.parser.text == null) {
            throw new AssertionError((Object)"No active Worksheet or PL/SQL editor? Please also open the Code Outline panel.");
        }
        new ExecWorker(outlinePanel).execute();
    }

    class ExecWorker
    extends SwingWorker<String, Object> {
        OutlinePanel ctx;
        Map<String, MaterializedPredicate> predicateVectors;
        LinkedList<String> orderedQueries;
        Throwable ex;

        public ExecWorker(OutlinePanel outlinePanel) {
            this.ctx = outlinePanel;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public String doInBackground() {
            try {
                Program.debug = false;
                String string = ArboriToolbar.this.context.code.getText();
                SyntaxError syntaxError = ((ArboriLanguageSupport)ArboriToolbar.this.context.code.getLanguageSupport()).parser.error;
                if (syntaxError != null) {
                    throw syntaxError;
                }
                ArboriToolbar.this.current = new SqlProgram(string);
                List list = LexerToken.parse((String)this.ctx.parser.text);
                HashMap<String, Object> hashMap = new HashMap<String, Object>();
                hashMap.put("outlinePanel", this.ctx);
                hashMap.put("arboriPanel", ArboriToolbar.this.context);
                hashMap.put("connections", Connections.getInstance());
                this.predicateVectors = ArboriToolbar.this.current.run(this.ctx.parser.text, list, new String[]{"program"}, hashMap);
                if (ArboriToolbar.this.current != null) {
                    this.orderedQueries = ArboriToolbar.this.current.querySequence();
                    return this.orderedQueries;
                }
            }
            catch (Throwable throwable) {
                this.ex = throwable;
                return this.ex;
            }
            finally {
                return "done";
            }
        }

        @Override
        protected void done() {
            if (this.ex != null) {
                if (this.ex instanceof SyntaxError) {
                    JPanel jPanel = new JPanel();
                    jPanel.add(new JLabel("<html><font color=red>Arbori syntax error:"));
                    jPanel.add(new JLabel(ArboriToolbar.sugarcoatError + this.ex.getMessage()));
                    ArboriToolbar.this.context.tabbedPane.add("Error", jPanel);
                } else if (this.ex instanceof AssertionError) {
                    JPanel jPanel = new JPanel();
                    jPanel.add(new JLabel("<html><font color=red>AssertionError"));
                    jPanel.add(new JLabel(ArboriToolbar.sugarcoatError + this.ex.getMessage()));
                    ArboriToolbar.this.context.tabbedPane.add("Error", jPanel);
                } else if (this.ex instanceof ThreadDeath) {
                    JPanel jPanel = new JPanel();
                    jPanel.add(new JLabel("<html><font color=red>Cancelled query"));
                    ArboriToolbar.this.context.tabbedPane.add("Error", jPanel);
                } else {
                    JPanel jPanel = new JPanel();
                    jPanel.add(new JLabel("<html><font color=red>Exception " + this.ex.getClass().getName()));
                    jPanel.add(new JLabel(ArboriToolbar.sugarcoatError + this.ex.getMessage()));
                    ArboriToolbar.this.context.tabbedPane.add("Error", jPanel);
                    this.ex.printStackTrace();
                }
                ArboriToolbar.this.stop.setEnabled(false);
                ArboriToolbar.this.current = null;
                return;
            }
            try {
                for (String string : this.orderedQueries) {
                    Object object2;
                    final MaterializedPredicate materializedPredicate = this.predicateVectors.get(string);
                    final ParseNode[][] parseNodeArray = new ParseNode[materializedPredicate.cardinality()][materializedPredicate.arity()];
                    int n = -1;
                    for (Object object2 : materializedPredicate.getTuples()) {
                        ++n;
                        for (int i = 0; i < materializedPredicate.arity(); ++i) {
                            ParseNode parseNode;
                            parseNodeArray[n][i] = parseNode = materializedPredicate.getAttribute((Tuple)object2, materializedPredicate.getAttribute(i));
                        }
                    }
                    ArboriGrid arboriGrid = ArboriGrid.initGrid(this.ctx);
                    arboriGrid.setModel(new DefaultTableModel(){

                        @Override
                        public int getRowCount() {
                            return materializedPredicate.cardinality();
                        }

                        @Override
                        public int getColumnCount() {
                            return materializedPredicate.arity();
                        }

                        @Override
                        public String getColumnName(int n) {
                            return materializedPredicate.getAttribute(n);
                        }

                        @Override
                        public Class<?> getColumnClass(int n) {
                            return ParseNode.class;
                        }

                        @Override
                        public boolean isCellEditable(int n, int n2) {
                            return false;
                        }

                        @Override
                        public Object getValueAt(int n, int n2) {
                            return parseNodeArray[n][n2];
                        }
                    });
                    object2 = new JScrollPane(arboriGrid);
                    ((JScrollPane)object2).setHorizontalScrollBarPolicy(30);
                    ((JScrollPane)object2).setVerticalScrollBarPolicy(20);
                    ArboriToolbar.this.context.tabbedPane.add(string, (Component)object2);
                }
                ArboriToolbar.this.stop.setEnabled(false);
                ArboriToolbar.this.current = null;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

