/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.plsql.structure;

import java.awt.Rectangle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;
import oracle.dbtools.parser.ParseNode;
import oracle.dbtools.parser.plsql.LazyNode;
import oracle.dbtools.raptor.navigator.plsql.Member;
import oracle.dbtools.raptor.plsql.BackgroundParser;
import oracle.dbtools.raptor.plsql.EquippedWithParser;
import oracle.dbtools.raptor.plsql.structure.LegacyToggleButton;
import oracle.dbtools.raptor.plsql.structure.OutlinePanel;
import oracle.dbtools.raptor.plsql.structure.OutlineWindow;
import oracle.ide.editor.Editor;
import oracle.ide.editor.EditorListener;
import oracle.ide.model.Node;
import oracle.javatools.editor.BasicEditorPane;
import oracle.javatools.editor.BasicEditorPaneContainer;

public class LocationListener
implements EditorListener {
    private CaretListener handler;
    private BasicEditorPane editorPane;
    private Editor editor;

    public void editorOpened(Editor editor) {
    }

    public void editorActivated(Editor editor) {
        if (!(editor instanceof BasicEditorPaneContainer)) {
            return;
        }
        if (!"CodeEditor".equals(editor.getDisplayName()) && !"Worksheet".equals(editor.getDisplayName())) {
            return;
        }
        this.editor = editor;
        this.addListeners();
    }

    private void addListeners() {
        if (null == this.editor) {
            return;
        }
        this.editorPane = ((BasicEditorPaneContainer)this.editor).getFocusedEditorPane();
        if (this.editorPane != null) {
            EquippedWithParser equippedWithParser = null;
            Node node = this.editor.getContext().getNode();
            if (node instanceof EquippedWithParser) {
                equippedWithParser = (EquippedWithParser)node;
            } else if (this.editor instanceof EquippedWithParser) {
                equippedWithParser = (EquippedWithParser)this.editor;
            }
            if (equippedWithParser == null) {
                return;
            }
            BackgroundParser backgroundParser = equippedWithParser.getParser();
            this.handler = new CaretListener(){

                @Override
                public void caretUpdate(CaretEvent caretEvent) {
                    int n = LocationListener.this.editorPane.getCaretPosition();
                    OutlinePanel outlinePanel = (OutlinePanel)OutlineWindow.getInstance().getGUI();
                    DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)outlinePanel.model.getRoot();
                    this.highlightCurrent(outlinePanel, defaultMutableTreeNode, n);
                }

                private void highlightCurrent(OutlinePanel outlinePanel, DefaultMutableTreeNode defaultMutableTreeNode, int n) {
                    if (defaultMutableTreeNode.getUserObject() instanceof Member) {
                        this.highlightCurrentMember(n, outlinePanel, defaultMutableTreeNode);
                        return;
                    }
                    if (!(defaultMutableTreeNode.getUserObject() instanceof ParseNode)) {
                        return;
                    }
                    ParseNode parseNode = (ParseNode)defaultMutableTreeNode.getUserObject();
                    if (parseNode.from + 1 == parseNode.to || parseNode instanceof LazyNode) {
                        this.highlightNode(outlinePanel, defaultMutableTreeNode, parseNode);
                        return;
                    }
                    int n2 = outlinePanel.model.getChildCount(defaultMutableTreeNode);
                    for (int i = 0; i < n2; ++i) {
                        DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)outlinePanel.model.getChild(defaultMutableTreeNode, i);
                        if (!(defaultMutableTreeNode2.getUserObject() instanceof ParseNode)) continue;
                        ParseNode parseNode2 = (ParseNode)defaultMutableTreeNode2.getUserObject();
                        if (parseNode2.parent() != null && parseNode2.parent().contains("subprg_body") && LegacyToggleButton.isOff()) {
                            parseNode2 = parseNode2.parent();
                        }
                        try {
                            int n3 = outlinePanel.parser.src.get((int)parseNode2.from).begin;
                            int n4 = outlinePanel.parser.src.get((int)(parseNode2.to - 1)).end;
                            if (n3 > n || n > n4) continue;
                            this.highlightCurrent(outlinePanel, defaultMutableTreeNode2, n);
                            return;
                        }
                        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                            Logger.getLogger(LocationListener.class.getName()).log(Level.SEVERE, "LocationListener.highlightCurrent()", indexOutOfBoundsException);
                        }
                    }
                }

                private void highlightNode(OutlinePanel outlinePanel, DefaultMutableTreeNode defaultMutableTreeNode, Object object) {
                    Rectangle rectangle;
                    outlinePanel.current = object;
                    Object[] objectArray = defaultMutableTreeNode.getPath();
                    TreePath treePath = new TreePath(objectArray);
                    int n = outlinePanel.tree.getRowForPath(treePath);
                    outlinePanel.tree.setSelectionRow(n);
                    if (treePath != null && (rectangle = outlinePanel.tree.getPathBounds(treePath)) != null) {
                        rectangle.height = outlinePanel.tree.getVisibleRect().height;
                        outlinePanel.tree.scrollRectToVisible(rectangle);
                    }
                    outlinePanel.repaint();
                }

                private void highlightCurrentMember(int n, OutlinePanel outlinePanel, DefaultMutableTreeNode defaultMutableTreeNode) {
                    int n2 = outlinePanel.model.getChildCount(defaultMutableTreeNode);
                    for (int i = 0; i < n2; ++i) {
                        DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)outlinePanel.model.getChild(defaultMutableTreeNode, i);
                        if (!(defaultMutableTreeNode2.getUserObject() instanceof Member)) continue;
                        Member member = (Member)defaultMutableTreeNode2.getUserObject();
                        if (member.codeOffset > n || n >= member.endOffset) continue;
                        this.highlightNode(outlinePanel, defaultMutableTreeNode2, member);
                        return;
                    }
                }
            };
            this.editorPane.addCaretListener(this.handler);
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    LocationListener.this.addListeners();
                }
            });
        }
    }

    public void editorDeactivated(Editor editor) {
        if (!"CodeEditor".equals(editor.getDisplayName()) && !"Worksheet".equals(editor.getDisplayName())) {
            return;
        }
        this.editor = null;
        if (this.editorPane != null) {
            this.editorPane.removeCaretListener(this.handler);
        }
    }

    public void editorClosed(Editor editor) {
    }
}

