/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.runner;

import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import oracle.dbtools.raptor.navigator.net.DBURLFormatHelper;

public class ArgusHelper {
    private static final String ARGUS_HEADER = "$Oracle";
    private static final Map<String, ArgusType> m_typeMap = new HashMap<String, ArgusType>();
    private static final Map<String, ArgusType> m_nameMap = new HashMap<String, ArgusType>();

    private ArgusHelper() {
    }

    private static void registerArgusType(ArgusType argusType) {
        m_typeMap.put(argusType.getType(), argusType);
        m_nameMap.put(argusType.getArgusName(), argusType);
    }

    public static String getArgusNameForType(String string) {
        ArgusType argusType = m_typeMap.get(string);
        return argusType != null ? argusType.getArgusName() : null;
    }

    private static ArgusType getTypeForName(String string) {
        return m_nameMap.get(string);
    }

    public static final URL argusStringToUrl(String string, String string2) {
        ArgusStringParser argusStringParser = ArgusStringParser.makeArgusStringParser(string);
        if (argusStringParser != null) {
            return argusStringParser.getURL(string2, argusStringParser.schema, argusStringParser.programUnitName);
        }
        return null;
    }

    static {
        ArgusHelper.registerArgusType(new ArgusType("Procedure", "PROCEDURE"));
        ArgusHelper.registerArgusType(new ArgusType("Function", "FUNCTION"));
        ArgusHelper.registerArgusType(new ArgusType("Trigger", "TRIGGER"));
        ArgusHelper.registerArgusType(new ArgusType("Block", "BLOCK"));
        ArgusType argusType = new ArgusType("Package", "PACKAGE");
        ArgusHelper.registerArgusType(argusType);
        ArgusHelper.registerArgusType(new ArgusType("PackageBody", "PACKAGE BODY", argusType));
        argusType = new ArgusType("Type", "TYPE");
        ArgusHelper.registerArgusType(argusType);
        ArgusHelper.registerArgusType(new ArgusType("TypeBody", "TYPE BODY", argusType));
    }

    private static class ArgusStringParser {
        private ArgusType type;
        private String programUnitName;
        private String schema;

        ArgusStringParser(ArgusType argusType, String string, String string2) {
            this.type = argusType;
            this.programUnitName = string;
            this.schema = string2;
        }

        static ArgusStringParser makeArgusStringParser(String string) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, ".");
            int n = Math.min(stringTokenizer.countTokens(), 4);
            String[] stringArray = new String[n];
            int n2 = 0;
            try {
                while (stringTokenizer.hasMoreTokens()) {
                    stringArray[n2++] = stringTokenizer.nextToken();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (stringArray[0].equals(ArgusHelper.ARGUS_HEADER)) {
                String string2;
                String string3;
                String string4 = stringArray[1];
                if (n2 > 3) {
                    string3 = stringArray[2];
                    string2 = stringArray[3];
                } else {
                    string3 = "";
                    string2 = stringArray[2];
                }
                ArgusType argusType = ArgusHelper.getTypeForName(string4);
                return argusType != null ? new ArgusStringParser(argusType, string2, string3) : null;
            }
            return null;
        }

        URL getURL(String string, String string2, String string3) {
            return this.type != null ? this.type.getURL(string, string2, string3) : null;
        }
    }

    private static class ArgusType {
        private final String m_name;
        private final String m_dbtype;
        private final ArgusType m_parentType;

        private ArgusType(String string, String string2) {
            this(string, string2, null);
        }

        private ArgusType(String string, String string2, ArgusType argusType) {
            this.m_name = string;
            this.m_dbtype = string2;
            this.m_parentType = argusType;
        }

        public String getArgusName() {
            return this.m_name;
        }

        public String getType() {
            return this.m_dbtype;
        }

        public URL getURL(String string, String string2, String string3) {
            URL uRL;
            if (this.m_parentType != null) {
                URL uRL2 = this.m_parentType.getURL(string, string2, string3);
                uRL = DBURLFormatHelper.getEnclosedTypeURL(uRL2, this.m_dbtype);
            } else {
                uRL = DBURLFormatHelper.getURL("sqldev.nav", string, null, string2, this.m_dbtype);
            }
            return DBURLFormatHelper.getURL(uRL, string3);
        }
    }
}

