/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.schemacopy.wizard;

import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.sql.Connection;
import javax.swing.ButtonGroup;
import javax.swing.JLabel;
import javax.swing.JRadioButton;
import oracle.bali.share.nls.StringUtils;
import oracle.dbtools.raptor.controls.OracleConnectionComboBox;
import oracle.dbtools.raptor.schemacopy.CopyPanelArb;
import oracle.dbtools.raptor.schemacopy.wizard.CopyWizArb;
import oracle.dbtools.raptor.utils.Connections;
import oracle.dbtools.raptor.utils.ExceptionHandler;
import oracle.ide.panels.DefaultTraversablePanel;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.javatools.db.DBException;
import oracle.javatools.util.ModelUtil;

public class CopyWizDBSelector
extends DefaultTraversablePanel {
    private static final long serialVersionUID = 1L;
    private JRadioButton jBCreate = new JRadioButton();
    private JRadioButton jBTruncate = new JRadioButton();
    private JRadioButton jBDrop = new JRadioButton();
    private OracleConnectionComboBox sourceConnSelector = new OracleConnectionComboBox();
    private OracleConnectionComboBox destConnSelector = new OracleConnectionComboBox();

    public CopyWizDBSelector() {
        this.sourceConnSelector.getJComboBox().addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                try {
                    Connections.getInstance().getConnection(CopyWizDBSelector.this.sourceConnSelector.getCurrentConnectionName());
                }
                catch (Exception exception) {
                    Throwable throwable;
                    Exception exception2;
                    CopyWizDBSelector.this.sourceConnSelector.getJComboBox().setSelectedIndex(-1);
                    while (exception2 instanceof DBException && (throwable = exception2.getCause()) instanceof Exception) {
                        exception2 = (Exception)throwable;
                    }
                    ExceptionHandler.handleException((Throwable)exception2);
                }
            }
        });
        this.sourceConnSelector.getJComboBox().setSelectedIndex(-1);
        this.destConnSelector.getJComboBox().addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                try {
                    Connections.getInstance().getConnection(CopyWizDBSelector.this.destConnSelector.getCurrentConnectionName());
                }
                catch (Exception exception) {
                    Throwable throwable;
                    Exception exception2;
                    CopyWizDBSelector.this.destConnSelector.getJComboBox().setSelectedIndex(-1);
                    while (exception2 instanceof DBException && (throwable = exception2.getCause()) instanceof Exception) {
                        exception2 = (Exception)throwable;
                    }
                    ExceptionHandler.handleException((Throwable)exception2);
                }
            }
        });
        this.destConnSelector.getJComboBox().setSelectedIndex(-1);
        this.jBCreate.setText(StringUtils.stripMnemonic((String)CopyPanelArb.getString("RADIO_CREATE")));
        this.jBCreate.setMnemonic(StringUtils.getMnemonicKeyCode((String)CopyPanelArb.getString("RADIO_CREATE")));
        this.jBCreate.setSelected(true);
        this.jBDrop.setText(StringUtils.stripMnemonic((String)CopyPanelArb.getString("RADIO_DROP")));
        this.jBDrop.setMnemonic(StringUtils.getMnemonicKeyCode((String)CopyPanelArb.getString("RADIO_DROP")));
        this.jBTruncate.setText(StringUtils.stripMnemonic((String)CopyPanelArb.getString("RADIO_TRUNC")));
        this.jBTruncate.setMnemonic(StringUtils.getMnemonicKeyCode((String)CopyPanelArb.getString("RADIO_TRUNC")));
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.jBCreate);
        buttonGroup.add(this.jBTruncate);
        buttonGroup.add(this.jBDrop);
        this.setLayout(new GridBagLayout());
        JLabel jLabel = new JLabel(StringUtils.stripMnemonic((String)CopyWizArb.getString("S_CON_LABEL")));
        jLabel.setDisplayedMnemonic(StringUtils.getMnemonicKeyCode((String)CopyWizArb.getString("S_CON_LABEL")));
        jLabel.setLabelFor(this.sourceConnSelector.getJComboBox());
        this.add(jLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.add(this.sourceConnSelector.getJComboBox(), new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(5, 0, 5, 0), 0, 0));
        JLabel jLabel2 = new JLabel(StringUtils.stripMnemonic((String)CopyWizArb.getString("D_CON_LABEL")));
        jLabel2.setDisplayedMnemonic(StringUtils.getMnemonicKeyCode((String)CopyWizArb.getString("D_CON_LABEL")));
        jLabel2.setLabelFor(this.destConnSelector.getJComboBox());
        this.add(jLabel2, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.add(this.destConnSelector.getJComboBox(), new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.add(this.jBCreate, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(30, 0, 0, 0), 0, 0));
        this.add(this.jBTruncate, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.add(this.jBDrop, new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
    }

    public String getAction() {
        if (this.jBTruncate.isSelected()) {
            return "TRUNC";
        }
        if (this.jBDrop.isSelected()) {
            return "DROP";
        }
        return "CREATE";
    }

    public void onEntry(TraversableContext traversableContext) {
        traversableContext.getWizardCallbacks().wizardEnableButtons(Boolean.valueOf(false), Boolean.valueOf(true), Boolean.valueOf(false));
        this.setSourceConnection((String)traversableContext.get("SOURCE_CONNECTION_NAME"));
        this.setTargetConnection((String)traversableContext.get("DEST_CONNECTION_NAME"));
    }

    public void onExit(TraversableContext traversableContext) throws TraversalException {
        String string = this.sourceConnSelector.getCurrentConnectionName();
        Connection connection = null;
        if (string != null) {
            try {
                connection = Connections.getInstance().getConnection(string);
            }
            catch (DBException dBException) {
                this.sourceConnSelector.getJComboBox().setSelectedIndex(-1);
            }
        }
        if (connection == null) {
            throw new TraversalException(CopyWizArb.getString("NO_SOURCE_CONNECTION"));
        }
        String string2 = this.destConnSelector.getCurrentConnectionName();
        Connection connection2 = null;
        if (string2 != null) {
            try {
                connection2 = Connections.getInstance().getConnection(string2);
            }
            catch (DBException dBException) {
                this.destConnSelector.getJComboBox().setSelectedIndex(-1);
            }
        }
        if (connection2 == null) {
            throw new TraversalException(CopyWizArb.getString("NO_DEST_CONNECTION"));
        }
        if (ModelUtil.areEqual((Object)string, (Object)string2)) {
            throw new TraversalException(CopyWizArb.getString("SAME_CONNECTION"));
        }
        traversableContext.put("SOURCE_CONNECTION", (Object)connection);
        traversableContext.put("SOURCE_CONNECTION_NAME", (Object)string);
        traversableContext.put("DEST_CONNECTION", (Object)connection2);
        traversableContext.put("DEST_CONNECTION_NAME", (Object)string2);
        traversableContext.put("COPY_ACTION", (Object)this.getAction());
    }

    public Object getExitTransition() {
        return "Fin";
    }

    private void setSourceConnection(String string) {
        if (this.sourceConnSelector != null) {
            this.sourceConnSelector.setCurrentConnection(string);
        }
    }

    private void setTargetConnection(String string) {
        if (this.destConnSelector != null) {
            this.destConnSelector.setCurrentConnection(string);
        }
    }
}

