/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.status;

import java.awt.Component;
import java.io.IOException;
import java.net.URL;
import oracle.dbtools.raptor.editors.DBEditorController;
import oracle.dbtools.raptor.editors.DbEditor;
import oracle.dbtools.raptor.status.StatusNode;
import oracle.dbtools.raptor.status.StatusPanel;
import oracle.dbtools.raptor.utils.DBObject;
import oracle.dbtools.util.Logger;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.controller.Controller;
import oracle.ide.controls.WaitCursor;
import oracle.ide.editor.Editor;
import oracle.ide.editor.EditorManager;
import oracle.ide.editor.OpenEditorOptions;
import oracle.ide.model.Node;
import oracle.ide.model.NodeFactory;
import oracle.ide.model.UpdateMessage;

public class StatusEditor
extends Editor
implements DbEditor {
    StatusPanel sp = new StatusPanel();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static StatusEditor openNewEditor(DBObject dBObject) {
        StatusEditor statusEditor = null;
        String string = dBObject.getConnectionName();
        WaitCursor waitCursor = new WaitCursor((Component)Ide.getMainWindow());
        waitCursor.show();
        try {
            URL uRL = StatusNode.createURL(string);
            StatusNode statusNode = (StatusNode)NodeFactory.findOrCreate(StatusNode.class, (URL)uRL);
            if (statusNode != null) {
                Context context = Context.newIdeContext((Node)statusNode);
                OpenEditorOptions openEditorOptions = new OpenEditorOptions(context);
                openEditorOptions.setFlags(1);
                statusEditor = (StatusEditor)EditorManager.getEditorManager().openEditor(openEditorOptions);
            }
        }
        catch (Exception exception) {
            Logger.warn(StatusEditor.class, (Throwable)exception);
        }
        finally {
            waitCursor.hide();
        }
        return statusEditor;
    }

    public void open() {
    }

    public synchronized void setContext(Context context) {
        Node node;
        Context context2 = this.getContext();
        Node node2 = context2 != null ? context2.getNode() : null;
        if (node2 != (node = context.getNode())) {
            if (node2 != null) {
                try {
                    node2.close();
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
            this.sp.setNode(node instanceof StatusNode ? (StatusNode)node : null);
        }
        super.setContext(context);
    }

    public Component getGUI() {
        return this.sp.getPanel();
    }

    public void update(Object object, UpdateMessage updateMessage) {
    }

    @Override
    public String getConnectionName() {
        StatusNode statusNode = this.getStatusNode();
        return statusNode != null ? statusNode.getConnName() : null;
    }

    public Controller getController() {
        return DBEditorController.getInstance();
    }

    StatusNode getStatusNode() {
        Node node;
        StatusNode statusNode = null;
        Context context = this.getContext();
        if (context != null && (node = context.getNode()) instanceof StatusNode) {
            statusNode = (StatusNode)node;
        }
        return statusNode;
    }
}

