/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.ui.panels;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import oracle.dbtools.common.ddl.DDLTypes;
import oracle.dbtools.raptor.controls.URLListRenderer;
import oracle.dbtools.raptor.controls.search.SearchPanel;
import oracle.dbtools.raptor.images.BaseRaptorImages;
import oracle.dbtools.raptor.navigator.net.DBURLFormatHelper;
import oracle.dbtools.raptor.ui.UiResources;
import oracle.dbtools.raptor.ui.panels.ByTypeSearchPanel;

public class SearchObjectsShuttlePanel
extends JPanel
implements ActionListener {
    private static final long serialVersionUID = 1L;
    private JScrollPane jScrollPane1 = new JScrollPane();
    private SearchPanel _searchPanel;
    private JButton addOne = new JButton();
    private JButton remOne = new JButton();
    private JButton addAll = new JButton();
    private JButton remAll = new JButton();
    private JList _tableList;
    private DefaultListModel _model;
    private JComboBox typeSelect = new JComboBox();
    List<URL> _oList = null;
    private boolean _initSearchPanel = false;
    private String _conn;
    private DDLTypes _ddlTypes = null;
    private boolean isTablespaceEnabled = false;
    private boolean isSchemasEnabled = false;

    public List<URL> getUrlList() {
        return this._oList;
    }

    public SearchObjectsShuttlePanel() {
        this(new ByTypeSearchPanel());
    }

    public SearchObjectsShuttlePanel(SearchPanel searchPanel) {
        this._searchPanel = searchPanel;
    }

    public void setDDLTypes(DDLTypes dDLTypes) {
        String[] stringArray2;
        this._ddlTypes = dDLTypes;
        Vector<String[]> vector = new Vector<String[]>();
        for (String[] stringArray2 : this._ddlTypes.getTypeList()) {
            vector.add(stringArray2);
        }
        String[] stringArray3 = new String[vector.size() + 1];
        stringArray2 = new String[vector.size()];
        int n = 0;
        stringArray3[0] = UiResources.getString("SEARCH_ALL_OBJECTS");
        Iterator iterator = vector.iterator();
        while (iterator.hasNext()) {
            String string;
            stringArray3[n + 1] = string = (String)iterator.next();
            stringArray2[n++] = string;
        }
        this._searchPanel.setTypesForDisplay(stringArray3);
        this._searchPanel.setTypesForSearch(stringArray2);
        this.setTypeList();
    }

    public void setConName(String string) {
        this._conn = string;
        this._searchPanel.setConnectionName(this._conn);
    }

    public void setList(List<URL> list) {
        this._oList = list != null ? list : new ArrayList<URL>();
        this.loadFilterList(this._oList);
    }

    public void updatePanel() {
        if (!this._initSearchPanel) {
            this._searchPanel.init();
            this.addSearchResultsListener();
            this._initSearchPanel = true;
        }
    }

    public void updatePanel(boolean bl) {
        this._searchPanel.init(bl);
        this.addSearchResultsListener();
    }

    public List<URL> getAdvListType(String string) {
        ArrayList<URL> arrayList = new ArrayList<URL>();
        for (URL uRL : this._oList) {
            if (uRL == null || !DBURLFormatHelper.getBaseType(uRL).equals(string)) continue;
            arrayList.add(uRL);
        }
        return arrayList;
    }

    public void addToList(List<URL> list) {
        for (URL uRL : list) {
            if (this._oList.contains(uRL)) continue;
            this._oList.add(uRL);
        }
    }

    public void remFromList(URL uRL) {
        if (this._oList.contains(uRL)) {
            this._oList.remove(uRL);
        }
    }

    public void resetList() {
        this._oList = new ArrayList<URL>();
    }

    private void loadFilterList(List<URL> list) {
        ((DefaultListModel)this._tableList.getModel()).clear();
        for (URL uRL : list) {
            if (((DefaultListModel)this._tableList.getModel()).indexOf(uRL) != -1) continue;
            ((DefaultListModel)this._tableList.getModel()).addElement(uRL);
        }
    }

    public void setTypeList() {
        try {
            this.typeSelect.removeAllItems();
        }
        finally {
            this.typeSelect.addItem(UiResources.getString("SEARCH_ALL"));
            for (String string : this._ddlTypes.getTypeList()) {
                this.typeSelect.addItem(string);
            }
        }
    }

    public List<URL> getList() {
        ArrayList<URL> arrayList = new ArrayList<URL>();
        DefaultListModel defaultListModel = (DefaultListModel)this._tableList.getModel();
        if (defaultListModel != null) {
            for (int i = 0; i < defaultListModel.size(); ++i) {
                URL uRL = (URL)defaultListModel.get(i);
                arrayList.add(uRL);
            }
        }
        return arrayList;
    }

    public JPanel getPanel() {
        this._model = new DefaultListModel();
        this._tableList = new JList(this._model);
        this._tableList.setCellRenderer(new URLListRenderer());
        this._tableList.setDragEnabled(false);
        this._tableList.getAccessibleContext().setAccessibleName(UiResources.getString("LIST_ACCESS"));
        this._tableList.addMouseListener(new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                int n = mouseEvent.getClickCount();
                if (n == 2) {
                    Object[] objectArray = SearchObjectsShuttlePanel.this._tableList.getSelectedValues();
                    for (int i = 0; i < objectArray.length; ++i) {
                        URL uRL = (URL)objectArray[i];
                        ((DefaultListModel)SearchObjectsShuttlePanel.this._tableList.getModel()).removeElement(uRL);
                        SearchObjectsShuttlePanel.this._oList.remove(uRL);
                    }
                }
            }

            @Override
            public void mouseEntered(MouseEvent mouseEvent) {
            }

            @Override
            public void mouseExited(MouseEvent mouseEvent) {
            }

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
            }

            @Override
            public void mouseReleased(MouseEvent mouseEvent) {
            }
        });
        this.typeSelect.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (actionEvent.getActionCommand().equals("comboBoxChanged")) {
                    String string = (String)SearchObjectsShuttlePanel.this.typeSelect.getSelectedItem();
                    if (string != null && !string.equals(UiResources.getString("SEARCH_ALL"))) {
                        List<URL> list = SearchObjectsShuttlePanel.this.getAdvListType(string);
                        SearchObjectsShuttlePanel.this.loadFilterList(list);
                    } else if (SearchObjectsShuttlePanel.this._oList != null) {
                        SearchObjectsShuttlePanel.this.loadFilterList(SearchObjectsShuttlePanel.this._oList);
                    }
                }
            }
        });
        this.typeSelect.getAccessibleContext().setAccessibleName(UiResources.getString("FILTER_LIST_ACCESS"));
        this.typeSelect.setName(UiResources.getString("FILTER_LIST_ACCESS"));
        this.addAll.setActionCommand(">>");
        this.addAll.getAccessibleContext().setAccessibleName(UiResources.getString("ADD_ALL"));
        this.addAll.setName(UiResources.getString("ADD_ALL"));
        this.addAll.setIcon(BaseRaptorImages.getIcon((String)"LAST_ENA"));
        this.addAll.addActionListener(this);
        this.addOne.setActionCommand(">");
        this.addOne.getAccessibleContext().setAccessibleName(UiResources.getString("ADD_SELECTED"));
        this.addOne.setName(UiResources.getString("ADD_SELECTED"));
        this.addOne.setIcon(BaseRaptorImages.getIcon((String)"NEXT_ENA"));
        this.addOne.addActionListener(this);
        this.remAll.setActionCommand("<<");
        this.remAll.getAccessibleContext().setAccessibleName(UiResources.getString("REMOVE_ALL"));
        this.remAll.setName(UiResources.getString("REMOVE_ALL"));
        this.remAll.setIcon(BaseRaptorImages.getIcon((String)"FIRST_ENA"));
        this.remAll.addActionListener(this);
        this.remOne.setActionCommand("<");
        this.remOne.getAccessibleContext().setAccessibleName(UiResources.getString("REMOVE_SELECTED"));
        this.remOne.setName(UiResources.getString("REMOVE_SELECTED"));
        this.remOne.setIcon(BaseRaptorImages.getIcon((String)"PREV_ENA"));
        this.remOne.addActionListener(this);
        this.jScrollPane1.setViewportView(this._tableList);
        this.setLayout(new GridBagLayout());
        this.add((Component)this._searchPanel, new GridBagConstraints(0, 0, 2, 6, 1.0, 1.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.addOne, new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 0, 5), 0, 0));
        this.add((Component)this.addAll, new GridBagConstraints(2, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 5), 0, 0));
        this.add((Component)this.remOne, new GridBagConstraints(2, 3, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 5), 0, 0));
        this.add((Component)this.remAll, new GridBagConstraints(2, 4, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 5), 0, 0));
        this.add((Component)this.typeSelect, new GridBagConstraints(3, 0, 2, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.jScrollPane1, new GridBagConstraints(3, 1, 2, 5, 1.0, 1.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
        return this;
    }

    private void addSearchResultsListener() {
        this._searchPanel.getResultsList().addMouseListener(new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                int n = mouseEvent.getClickCount();
                if (n == 2) {
                    Object[] objectArray = SearchObjectsShuttlePanel.this._searchPanel.getResultsList().getSelectedValues();
                    for (int i = 0; i < objectArray.length; ++i) {
                        URL uRL = (URL)objectArray[i];
                        if (((DefaultListModel)SearchObjectsShuttlePanel.this._tableList.getModel()).indexOf(uRL) == -1) {
                            ((DefaultListModel)SearchObjectsShuttlePanel.this._tableList.getModel()).addElement(uRL);
                        }
                        SearchObjectsShuttlePanel.this._searchPanel.removeURL(uRL);
                    }
                    SearchObjectsShuttlePanel.this.addToList(SearchObjectsShuttlePanel.this.getList());
                }
            }

            @Override
            public void mouseEntered(MouseEvent mouseEvent) {
            }

            @Override
            public void mouseExited(MouseEvent mouseEvent) {
            }

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
            }

            @Override
            public void mouseReleased(MouseEvent mouseEvent) {
            }
        });
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        block6: {
            block8: {
                block7: {
                    block5: {
                        if (!actionEvent.getActionCommand().equals(">")) break block5;
                        Object[] objectArray = this._searchPanel.getResultsList().getSelectedValues();
                        for (int i = 0; i < objectArray.length; ++i) {
                            URL uRL = (URL)objectArray[i];
                            if (((DefaultListModel)this._tableList.getModel()).indexOf(uRL) == -1) {
                                ((DefaultListModel)this._tableList.getModel()).addElement(uRL);
                            }
                            this._searchPanel.removeURL(uRL);
                        }
                        this.addToList(this.getList());
                        break block6;
                    }
                    if (!actionEvent.getActionCommand().equals("<")) break block7;
                    Object[] objectArray = this._tableList.getSelectedValues();
                    for (int i = 0; i < objectArray.length; ++i) {
                        URL uRL = (URL)objectArray[i];
                        ((DefaultListModel)this._tableList.getModel()).removeElement(uRL);
                        this.remFromList(uRL);
                        this._searchPanel.addURL(uRL);
                    }
                    break block6;
                }
                if (!actionEvent.getActionCommand().equals(">>")) break block8;
                DefaultListModel defaultListModel = (DefaultListModel)this._searchPanel.getResultsList().getModel();
                Object[] objectArray = new Object[defaultListModel.size() + 1];
                defaultListModel.copyInto(objectArray);
                for (int i = 0; i < objectArray.length; ++i) {
                    URL uRL = (URL)objectArray[i];
                    if (uRL == null || ((DefaultListModel)this._tableList.getModel()).indexOf(uRL) != -1) continue;
                    ((DefaultListModel)this._tableList.getModel()).addElement(uRL);
                }
                this.addToList(this.getList());
                this._searchPanel.removeAllURL();
                break block6;
            }
            if (!actionEvent.getActionCommand().equals("<<")) break block6;
            Object[] objectArray = ((DefaultListModel)this._tableList.getModel()).toArray();
            for (int i = 0; i < objectArray.length; ++i) {
                URL uRL = (URL)objectArray[i];
                ((DefaultListModel)this._tableList.getModel()).removeElement(uRL);
                this.remFromList(uRL);
                this._searchPanel.addURL(uRL);
            }
        }
    }

    public void setMultipleSchemaNames(String[] stringArray) {
        if (this.isAddMultipleSchemas()) {
            this._searchPanel.setAddMultipleSchemas(true);
            this._searchPanel.setMultipleSchemas(stringArray);
            this._initSearchPanel = false;
        }
    }

    public void setTablespaceNames(String[] stringArray) {
        if (this.isAddTableSpace()) {
            this._searchPanel.setAddTableSpace(true);
            this._searchPanel.setTableSpaceNames(stringArray);
            this._initSearchPanel = false;
        }
    }

    public void setAddTableSpace(boolean bl) {
        this.isTablespaceEnabled = bl;
    }

    public boolean isAddTableSpace() {
        return this.isTablespaceEnabled;
    }

    public void setAddMultipleSchemas(boolean bl) {
        this.isSchemasEnabled = bl;
    }

    public boolean isAddMultipleSchemas() {
        return this.isSchemasEnabled;
    }
}

