/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.utils;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import oracle.dbtools.raptor.connections.AbstractConnectionListener;
import oracle.dbtools.raptor.connections.ConnectionEvent;
import oracle.dbtools.raptor.utils.Connections;
import oracle.dbtools.util.Logger;
import oracle.ide.ExtensionRegistry;
import oracle.ide.Ide;
import oracle.ide.model.Element;
import oracle.ide.model.Node;
import oracle.ide.model.NodeEvent;
import oracle.ide.model.NodeFactory;
import oracle.ide.model.NodeListener;
import oracle.ide.model.Project;
import oracle.ide.model.Subject;
import oracle.ide.model.UpdateMessage;
import oracle.ide.model.Workspace;
import oracle.ide.model.Workspaces;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ideri.util.Product;
import oracle.javatools.util.ModelUtil;

public class ProjectTracker {
    static final String PROJECTS_DIRECTORY = "projects";
    private static final String WORKSPACE_NAME = "Databases";
    private static NodeListener s_listener = new NodeListener(){

        public void nodeDirtyStateChanged(NodeEvent nodeEvent, boolean bl) {
            Node node = nodeEvent.getNode();
            if (bl) {
                ProjectTracker.addNode(node);
            } else {
                ProjectTracker.removeNode(node);
            }
        }
    };
    private static ExecutorService s_service = null;
    private static Collection<Node> s_saveList = new ArrayList<Node>();
    private static URL s_projDir;
    private static Workspace s_wks;
    private static Map<String, Project> s_projects;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void addNode(Node node) {
        Object object = s_saveList;
        synchronized (object) {
            s_saveList.add(node);
        }
        object = ProjectTracker.class;
        synchronized (ProjectTracker.class) {
            if (s_service == null) {
                ScheduledExecutorService scheduledExecutorService = Executors.newScheduledThreadPool(1);
                scheduledExecutorService.scheduleAtFixedRate(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        Collection<Node> collection = s_saveList;
                        synchronized (collection) {
                            Iterator<Node> iterator = s_saveList.iterator();
                            while (iterator.hasNext()) {
                                Node node = iterator.next();
                                iterator.remove();
                                try {
                                    node.save();
                                }
                                catch (IOException iOException) {
                                    Logger.severe(ProjectTracker.class, (String)iOException.getLocalizedMessage());
                                }
                            }
                        }
                    }
                }, 5L, 5L, TimeUnit.SECONDS);
                s_service = scheduledExecutorService;
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void removeNode(Node node) {
        Collection<Node> collection = s_saveList;
        synchronized (collection) {
            s_saveList.remove(node);
        }
    }

    private static synchronized URL getProjectDirectory() {
        if (s_projDir == null) {
            URL uRL = ExtensionRegistry.getExtensionRegistry().getSystemDirectory(Product.getProductID());
            assert (uRL != null);
            s_projDir = URLFactory.newDirURL((URL)uRL, (String)PROJECTS_DIRECTORY);
            URLFileSystem.mkdir((URL)s_projDir);
        }
        return s_projDir;
    }

    public static synchronized Workspace getGlobalWorkspace() {
        if (s_wks == null) {
            URL uRL = ProjectTracker.getProjectDirectory();
            URL uRL2 = URLFactory.newURL((URL)uRL, (String)"Databases.jws");
            try {
                s_wks = (Workspace)NodeFactory.findOrCreate(Workspace.class, (URL)uRL2);
                s_wks.addNodeListener(s_listener);
                Workspaces workspaces = Ide.getWorkspaces();
                workspaces.add((Element)s_wks);
            }
            catch (IllegalAccessException illegalAccessException) {
                Logger.severe(ProjectTracker.class, (Throwable)illegalAccessException);
            }
            catch (InstantiationException instantiationException) {
                Logger.severe(ProjectTracker.class, (Throwable)instantiationException);
            }
        }
        return s_wks;
    }

    public static synchronized Project getProject(String string) {
        Project project = s_projects.get(string);
        if (project == null) {
            URL uRL = ProjectTracker.getProjectDirectory();
            URL uRL2 = URLFactory.newURL((URL)uRL, (String)(string + ".jpr"));
            try {
                project = (Project)NodeFactory.findOrCreate(Project.class, (URL)uRL2);
                project.addNodeListener(s_listener);
                s_projects.put(string, project);
                Workspace workspace = ProjectTracker.getGlobalWorkspace();
                if (workspace != null) {
                    workspace.add((Element)project);
                }
            }
            catch (IllegalAccessException illegalAccessException) {
                Logger.severe(ProjectTracker.class, (Throwable)illegalAccessException);
            }
            catch (InstantiationException instantiationException) {
                Logger.severe(ProjectTracker.class, (Throwable)instantiationException);
            }
        }
        return project;
    }

    static {
        s_projects = new HashMap<String, Project>();
        Connections.getInstance().addConnectionListener(new AbstractConnectionListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void connectionRenamed(ConnectionEvent connectionEvent) {
                Class<ProjectTracker> clazz = ProjectTracker.class;
                synchronized (ProjectTracker.class) {
                    this.handleRename(connectionEvent.getOldName(), connectionEvent.getConnectionName());
                    // ** MonitorExit[var2_2] (shouldn't be in output)
                    return;
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void connectionModified(ConnectionEvent connectionEvent) {
                Class<ProjectTracker> clazz = ProjectTracker.class;
                synchronized (ProjectTracker.class) {
                    this.handleRename(connectionEvent.getOldName(), connectionEvent.getConnectionName());
                    // ** MonitorExit[var2_2] (shouldn't be in output)
                    return;
                }
            }

            private void handleRename(String string, String string2) {
                Project project;
                if (ModelUtil.areDifferent((Object)string, (Object)string2) && (project = s_projects.remove(string)) != null) {
                    s_projects.put(string2, project);
                    URL uRL = project.getURL();
                    URL uRL2 = URLFactory.newURL((URL)URLFileSystem.getParent((URL)uRL), (String)(string2 + ".jpr"));
                    project.setURL(uRL2);
                    UpdateMessage.fireObjectRenamed((Subject)project);
                }
            }

            @Override
            public void connectionRemoved(ConnectionEvent connectionEvent) {
                String string = connectionEvent.getConnectionName();
                Project project = s_projects.remove(string);
                if (project != null) {
                    Workspace workspace = ProjectTracker.getGlobalWorkspace();
                    if (workspace != null) {
                        workspace.remove((Element)s_wks);
                    }
                    URL uRL = project.getURL();
                    NodeFactory.uncache((URL)uRL);
                    URLFileSystem.delete((URL)uRL);
                }
            }
        });
    }
}

