/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.worksheet.commands.autotrace;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLRecoverableException;
import java.sql.SQLSyntaxErrorException;
import java.sql.Statement;
import java.text.MessageFormat;
import java.util.Collections;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JTextField;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.parser.plsql.SyntaxError;
import oracle.dbtools.raptor.RaptorExtensionConstants;
import oracle.dbtools.raptor.backgroundTask.TaskException;
import oracle.dbtools.raptor.config.DBConfig;
import oracle.dbtools.raptor.controls.ITabCloseListner;
import oracle.dbtools.raptor.nls.NLSProvider;
import oracle.dbtools.raptor.nls.OracleNLSProvider;
import oracle.dbtools.raptor.utils.Connections;
import oracle.dbtools.util.SqlId;
import oracle.dbtools.util.SqlLocator;
import oracle.dbtools.worksheet.Messages;
import oracle.dbtools.worksheet.WorksheetContext;
import oracle.dbtools.worksheet.commands.autotrace.AnalyzeAction;
import oracle.dbtools.worksheet.commands.autotrace.AutotracePanel;
import oracle.dbtools.worksheet.commands.autotrace.SerializedData;
import oracle.dbtools.worksheet.editor.WorksheetTabbedPane;
import oracle.ide.Ide;
import oracle.javatools.dialogs.MessageDialog;

public class ExplainPlanAction
extends AnalyzeAction {
    int childNo = -1;
    private Logger logger = Logger.getLogger(AutotracePanel.class.getName());

    public ExplainPlanAction(String string, WorksheetContext worksheetContext) {
        super(Messages.getString("WorksheetTaskUI.9"), string, worksheetContext);
        if (string.startsWith("Worksheet.VSQL_Child")) {
            this.childNo = Integer.parseInt(string.substring("Worksheet.VSQL_Child".length()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Void doWork() throws TaskException {
        if (this.init()) {
            try {
                String string;
                String string2 = this.extractSql(null);
                boolean bl = true;
                if (0 <= this.childNo && this.childNo < 3) {
                    try {
                        OracleNLSProvider oracleNLSProvider = (OracleNLSProvider)NLSProvider.getProvider((Connection)this.conn);
                        String string3 = oracleNLSProvider.getDBCharset();
                        string = SqlId.stmt2sqlid((String)string2, (String)string3);
                        this.autoTracePanel.setTabLabel("V$SQL_PLAN.SQL_ID=" + string);
                        bl = this.childExists(string, this.childNo);
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                }
                if (!bl) {
                    string = MessageFormat.format(Messages.getString("ExplainPlanAction.5"), this.childNo);
                    MessageDialog.information((Component)Ide.getMainWindow(), (Object)string, (String)this.autoTracePanel.getTabLabel(), null);
                    this.requestCancel();
                    this.checkCanProceed();
                }
                this.showResultPanel();
                this.explainPlan(string2, this.conn);
                this.autoTracePanel.tbl.revalidate();
                SerializedData.initColumnWidths(this.autoTracePanel.tbl);
            }
            catch (ExecutionException executionException) {
                Throwable throwable = executionException.getCause();
                if (throwable instanceof CancellationException) {
                } else {
                    this.logger.log(Level.SEVERE, Messages.getString("ExplainPlanAction.2") + " " + throwable.getMessage());
                }
            }
            catch (Exception exception) {
                this.logger.log(Level.SEVERE, Messages.getString("ExplainPlanAction.2") + " " + exception.getMessage());
            }
            finally {
                this.resetCursor();
            }
        }
        return null;
    }

    private final String explainPlan(String string, Connection connection) {
        boolean bl = DBConfig.getInstance().getBoolean("COMMIT_PRIOR_TRANSACTION");
        if (bl && !Connections.getInstance().isTimesTen(connection) && RaptorExtensionConstants.isStandAlone() && DBUtil.hasTransaction((Connection)connection)) {
            if (!MessageDialog.confirm((Component)Ide.getMainWindow(), (Object)Messages.getString("Confirm_Commit"), (String)Messages.getString("Uncommitted_transaction"), null)) {
                return null;
            }
            try {
                connection.commit();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        String string2 = "" + System.currentTimeMillis();
        if (0 <= this.childNo && this.childNo < 3) {
            string2 = "" + this.childNo;
        }
        this.autoTracePanel.explainPlan(string, string2, connection);
        this.autoTracePanel.fetchPlan(string, string2, connection);
        if (bl && !Connections.getInstance().isTimesTen(connection)) {
            try {
                connection.rollback();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        return string2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean childExists(String string, int n) {
        Statement statement = null;
        ResultSet resultSet = null;
        boolean bl = false;
        try {
            if (!Connections.getInstance().tryLock(this.conn, 500L)) {
                boolean bl2 = false;
                return bl2;
            }
            try {
                if (string != null) {
                    statement = this.conn.prepareStatement("select child_number from v$sql \n where sql_id = ?  \n   and child_number = ?");
                    statement.setString(1, string);
                    statement.setInt(2, n);
                } else {
                    statement = this.conn.prepareStatement("select sql_id, child_number from v$sql \n where sql_text like ?  \n   and child_number = ?");
                    String string2 = this.getValidSqlStatementAtCursor(this.ctx);
                    StringBuilder stringBuilder = new StringBuilder();
                    for (int i = 0; i < string2.length() && i < 5000; ++i) {
                        char c = string2.charAt(i);
                        if ('\u07d0' < c) {
                            c = '%';
                        }
                        stringBuilder.append(c);
                    }
                    statement.setString(1, stringBuilder.toString() + "%");
                }
                resultSet = statement.executeQuery();
                if (resultSet.next()) {
                    bl = true;
                    if (string == null) {
                        string = resultSet.getString("sql_id");
                    }
                }
            }
            finally {
                Connections.getInstance().unlock(this.conn);
            }
        }
        catch (SQLRecoverableException sQLRecoverableException) {
        }
        catch (SQLSyntaxErrorException sQLSyntaxErrorException) {
            if (sQLSyntaxErrorException.getErrorCode() != 942) {
                sQLSyntaxErrorException.printStackTrace();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        finally {
            if (resultSet != null) {
                try {
                    resultSet.close();
                }
                catch (Exception exception) {}
            }
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (Exception exception) {}
            }
        }
        return bl;
    }

    private String getValidSqlStatementAtCursor(WorksheetContext worksheetContext) {
        String string = null;
        String string2 = worksheetContext.getConnectionName();
        if (string2 != null && Connections.getInstance().isOracle(string2)) {
            SyntaxError syntaxError;
            String string3 = worksheetContext.getParser().text;
            int n = worksheetContext.getEditor().getCaretPosition();
            string = SqlLocator.extractStmt((int)n, (String)string3, null);
            if (string != null && (syntaxError = SyntaxError.checkSQLQuerySyntax((String)string)) != null) {
                string = null;
            }
        }
        return string;
    }

    public static void main(String[] stringArray) throws Exception {
        JFrame jFrame = new JFrame("Result set Panels");
        jFrame.setDefaultCloseOperation(3);
        WorksheetContext worksheetContext = new WorksheetContext();
        ExplainPlanAction explainPlanAction = new ExplainPlanAction("1", worksheetContext);
        explainPlanAction.setConnection(DriverManager.getConnection("jdbc:oracle:thin:@adc2180670:1521:x112", "scott", "tiger"));
        explainPlanAction.setAutoTracePanel(new AutotracePanel("1", true, "oracle.jdbc.OracleDriver"));
        explainPlanAction.getAutoTracePanel().setTabLabel("Explain plan 1");
        explainPlanAction.getAutoTracePanel().setContext(worksheetContext);
        explainPlanAction.explainPlan("select --+leading(e) use_nl(d) \n* from emp e, dept d where e.deptno = d.deptno ", explainPlanAction.conn);
        ExplainPlanAction explainPlanAction2 = new ExplainPlanAction("2", worksheetContext);
        explainPlanAction2.setConnection(DriverManager.getConnection("jdbc:oracle:thin:@adc2180670:1521:x112", "scott", "tiger"));
        explainPlanAction2.setAutoTracePanel(new AutotracePanel("2", true, "oracle.jdbc.OracleDriver"));
        explainPlanAction2.getAutoTracePanel().setTabLabel("Explain plan 2");
        explainPlanAction2.getAutoTracePanel().setContext(worksheetContext);
        explainPlanAction2.explainPlan("select * from emp e, dept d where e.deptno = d.deptno", explainPlanAction2.conn);
        WorksheetTabbedPane worksheetTabbedPane = new WorksheetTabbedPane();
        ITabCloseListner iTabCloseListner = new ITabCloseListner(){

            public void tabClosed() {
            }
        };
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.setBackground(Color.BLUE);
        jPanel.add((Component)new JTextField("tab1"), "Center");
        worksheetTabbedPane.addTab(null, "Tab 1", jPanel, Collections.singletonList(iTabCloseListner));
        worksheetTabbedPane.addTab(null, "Explain plan 1", explainPlanAction.getAutoTracePanel(), Collections.singletonList(iTabCloseListner));
        worksheetTabbedPane.addTab(null, "Explain plan 2", explainPlanAction2.getAutoTracePanel(), Collections.singletonList(iTabCloseListner));
        jFrame.add((Component)((Object)worksheetTabbedPane));
        jFrame.pack();
        jFrame.setVisible(true);
    }
}

