/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.worksheet.commands.dbmsoutput;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.io.BufferedOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.URL;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Hashtable;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Action;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.text.BadLocationException;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.dbtools.raptor.CommonArb;
import oracle.dbtools.raptor.backgroundTask.IRaptorTaskRunMode;
import oracle.dbtools.raptor.backgroundTask.RaptorTask;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskManager;
import oracle.dbtools.raptor.config.DBConfig;
import oracle.dbtools.raptor.connections.ConnectionEvent;
import oracle.dbtools.raptor.connections.ConnectionListener;
import oracle.dbtools.raptor.controls.ConnectionSelectorUI;
import oracle.dbtools.raptor.controls.ControlsArb;
import oracle.dbtools.raptor.controls.DBConnectionComboBox;
import oracle.dbtools.raptor.controls.PropertyPanel;
import oracle.dbtools.raptor.dialogs.SQLErrorDialog;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.ui.URLFileChooser;
import oracle.dbtools.raptor.utils.Connections;
import oracle.dbtools.util.Utility;
import oracle.dbtools.worksheet.Messages;
import oracle.dbtools.worksheet.commands.dbmsoutput.DbmsOutputController;
import oracle.dbtools.worksheet.commands.dbmsoutput.DbmsOwaOutputTabWindow;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.controller.ToolbarManager;
import oracle.ide.controls.ToggleAction;
import oracle.ide.controls.Toolbar;
import oracle.ide.dialogs.OnePageWizardDialogFactory;
import oracle.ide.keyboard.KeyStrokeContext;
import oracle.ide.keyboard.KeyStrokeContextRegistry;
import oracle.ide.keyboard.KeyStrokeMap;
import oracle.ide.keyboard.KeyStrokeOptions;
import oracle.ide.keyboard.KeyStrokes;
import oracle.ide.keyboard.MultiInputMap;
import oracle.ide.keyboard.MultiMapAdapter;
import oracle.ide.util.IdeUtil;
import oracle.ide.view.View;
import oracle.javatools.db.DBException;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.editor.BasicEditorPane;
import oracle.javatools.util.StringUtil;
import oracle.javatools.util.SwingUtils;

public abstract class AbstractOutputPane
extends JPanel
implements ConnectionListener {
    protected static Connection connLocal = null;
    protected static Hashtable<String, Boolean> m_connEnableHash = new Hashtable();
    private URL m_lastUrl;
    private boolean _init;
    protected DbmsOwaOutputTabWindow m_tabPane = null;
    protected View dockableParent;
    protected Toolbar _toolbar = new Toolbar();
    public static final String ACCEL_FILE = "oracle/dbtools/worksheet/commands/dbmsoutput/accelerators.xml";
    private boolean updatingKeyMap;
    private ChangeListener myKeystrokeChangeListener;
    private IdeAction m_newAction = null;
    private static final int NEW_CMD_ID;
    private IdeAction m_clearAction = null;
    private static final int CLEAR_CMD_ID;
    private IdeAction m_saveAction = null;
    private static final int SAVE_CMD_ID;
    private IdeAction m_printAction = null;
    private static final int PRINT_CMD_ID;

    public AbstractOutputPane() {
    }

    public AbstractOutputPane(View view) {
        this.dockableParent = view;
        Connections.getInstance().addConnectionListener((ConnectionListener)this);
    }

    protected String ConnectionNameOrToString(Connection connection) {
        if (connection == null) {
            return null;
        }
        String string = Connections.getInstance().getConnectionName(connection);
        if (string == null) {
            string = connection.toString();
        }
        return string;
    }

    protected void initGUI() {
        ToolbarManager toolbarManager = ToolbarManager.getToolbarManager();
        toolbarManager.registerOnDemandToolbar("Output.Toolbar", this._toolbar, this.dockableParent);
        this._toolbar.removeAll();
        this._toolbar.add((ToggleAction)this.getNewAction());
        this._toolbar.add((ToggleAction)this.getClearAction());
        this._toolbar.add((ToggleAction)this.getSaveAction());
        this._toolbar.add((ToggleAction)this.getPrintAction());
        this.setLayout(new BorderLayout());
        this.add((Component)this._toolbar, "First");
        this.m_tabPane = new DbmsOwaOutputTabWindow(this);
        this.add((Component)this.m_tabPane, "Center");
    }

    public abstract boolean enableOutput(Connection var1, boolean var2);

    public abstract boolean disableOutput(Connection var1);

    public void init() {
        if (!this._init) {
            this._init = true;
            final KeyStrokeOptions keyStrokeOptions = Ide.getSettings().getKeyStrokeOptions();
            this.myKeystrokeChangeListener = new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent changeEvent) {
                    if (changeEvent.getSource() == keyStrokeOptions) {
                        AbstractOutputPane.this.updateKeyMap(keyStrokeOptions);
                    }
                }
            };
            keyStrokeOptions.addChangeListener(this.myKeystrokeChangeListener);
            this.updateKeyMap(keyStrokeOptions);
            this.initGUI();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean saveFile(URL uRL) {
        String string = this.getEncoding();
        OutputStreamWriter outputStreamWriter = null;
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(uRL.getPath());
            BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(fileOutputStream);
            outputStreamWriter = new OutputStreamWriter((OutputStream)bufferedOutputStream, string);
            outputStreamWriter.write(this.getOutputText());
            outputStreamWriter.close();
            boolean bl = true;
            return bl;
        }
        catch (IOException iOException) {
            MessageDialog.information((Component)Ide.getMainWindow(), (Object)Messages.getString("AbstractOutputPane.0"), (String)(uRL.getPath() + uRL.getFile()), null);
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, iOException.getStackTrace()[0].toString(), iOException);
        }
        finally {
            if (outputStreamWriter != null) {
                try {
                    outputStreamWriter.close();
                }
                catch (IOException iOException) {
                    Logger.getLogger(this.getClass().getName()).log(Level.WARNING, iOException.getStackTrace()[0].toString(), iOException);
                }
            }
        }
        return false;
    }

    public boolean printOutput() {
        return Utility.printText((String)this.getPaneName(), (String)this.getOutputText());
    }

    public abstract String getPaneName();

    public String getEncoding() {
        return IdeUtil.getIdeEncoding();
    }

    public URL getLastUrl() {
        this.setLastUrl();
        return this.m_lastUrl;
    }

    protected void setLastUrl() {
        this.m_lastUrl = DBConfig.getInstance().getScriptDirectory();
    }

    public boolean isEnabled(Connection connection) {
        boolean bl = false;
        if (m_connEnableHash != null && connection != null) {
            Boolean bl2 = m_connEnableHash.get(this.ConnectionNameOrToString(connection));
            bl = bl2 != null && bl2 != false;
        }
        return bl;
    }

    protected void launchConnectionChooseDialog() {
        PropertyPanel propertyPanel = new PropertyPanel();
        String string = Messages.getString("DbmsOutputPane.6");
        final DBConnectionComboBox dBConnectionComboBox = new DBConnectionComboBox();
        dBConnectionComboBox.getJComboBox().setSize(3, 1);
        propertyPanel.add((Component)dBConnectionComboBox.getJComboBox());
        final JEWTDialog jEWTDialog = OnePageWizardDialogFactory.createJEWTDialog((Component)propertyPanel, null, (String)string, (int)10);
        jEWTDialog.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                String string = dBConnectionComboBox.getCurrentConnectionName();
                if (string != null) {
                    Connection connection = null;
                    try {
                        connection = Connections.getInstance().getConnection(string);
                    }
                    catch (DBException dBException) {
                        Logger.getLogger(this.getClass().getName()).log(Level.WARNING, dBException.getStackTrace()[0].toString(), dBException);
                    }
                    if (connection != null) {
                        AbstractOutputPane.this.setConnection(connection);
                        jEWTDialog.dispose();
                        m_connEnableHash.put(Connections.getInstance().getConnectionName(connection), true);
                    } else {
                        MessageDialog.error((Component)Ide.getMainWindow(), (Object)Messages.getString("DbmsOutputPane.7"), (String)Messages.getString("DbmsOutputPane.8"), (String)"f1_connectionnamedup_html");
                    }
                }
            }
        });
        Dimension dimension = propertyPanel.getPreferredSize();
        int n = (int)dimension.getHeight() + 80;
        int n2 = (int)dimension.getWidth() + 100;
        jEWTDialog.setSize(n2, n);
        jEWTDialog.setPreferredSize(n2, n);
        IdeUtil.centerWindow((Container)Ide.getMainWindow(), (Component)jEWTDialog);
        jEWTDialog.setVisible(true);
    }

    public void setConnection(Connection connection) {
        connLocal = connection;
        if (connection == null) {
            return;
        }
        if (this.isEnabled(connection)) {
            RaptorTaskManager.getInstance().addTask((RaptorTask)new DbmsOutputController.EnableDbmsOutputTask(connection, this, "Enable DBMS_OUTPUT", IRaptorTaskRunMode.MODAL_OPTIONAL, false, false, true, false));
        } else {
            RaptorTaskManager.getInstance().addTask((RaptorTask)new DbmsOutputController.EnableDbmsOutputTask(connection, this, "Enable DBMS_OUTPUT", IRaptorTaskRunMode.MODAL_OPTIONAL, false, false, false, true));
        }
    }

    public Connection getCurrentConnection() {
        return connLocal;
    }

    public void connectionAdded(ConnectionEvent connectionEvent) {
    }

    public void connectionClosed(ConnectionEvent connectionEvent) {
        if (this.m_tabPane != null) {
            this.m_tabPane.remove(connectionEvent);
        }
    }

    public void connectionModified(ConnectionEvent connectionEvent) {
    }

    public void connectionOpened(ConnectionEvent connectionEvent) {
    }

    public void connectionRemoved(ConnectionEvent connectionEvent) {
        if (this.m_tabPane != null) {
            this.m_tabPane.remove(connectionEvent);
        }
    }

    public void connectionRenamed(ConnectionEvent connectionEvent) {
    }

    protected void newTab() {
        String string = "";
        string = ConnectionSelectorUI.getConnectionForDbms((String)ControlsArb.getString((String)"TITLE_CONNECTION"), (String)ControlsArb.getString((String)"MESSAGE_CONNECTION_PROMPT"), (String)string, (boolean)true);
        if (string == null) {
            return;
        }
        Connection connection = null;
        try {
            connection = Connections.getInstance().getConnection(string);
            if (connection == null) {
                return;
            }
            this.m_tabPane.getTabForConn(connection, string);
            m_connEnableHash.put(string, true);
        }
        catch (DBException dBException) {
            if (dBException.getCause() instanceof SQLException) {
                SQLErrorDialog.showErrorDialog((String)string, (Component)SwingUtils.getMainWindow(), (String)CommonArb.getString((String)"ERROR_CONNECTING"), (SQLException)((SQLException)dBException.getCause()));
            }
            MessageDialog.error((Component)SwingUtils.getMainWindow(), (Object)dBException.getStackTrace()[0].toString(), (String)CommonArb.getString((String)"ERROR_CONNECTING"), null);
        }
        this.setConnection(connection);
    }

    public void connect(String string) {
        Connection connection = null;
        try {
            connection = Connections.getInstance().getConnection(string);
            if (connection == null) {
                return;
            }
            this.m_tabPane.getTabForConn(connection, string);
            m_connEnableHash.put(string, true);
        }
        catch (DBException dBException) {
            if (dBException.getCause() instanceof SQLException) {
                SQLErrorDialog.showErrorDialog((String)string, (Component)SwingUtils.getMainWindow(), (String)CommonArb.getString((String)"ERROR_CONNECTING"), (SQLException)((SQLException)dBException.getCause()));
            }
            MessageDialog.error((Component)SwingUtils.getMainWindow(), (Object)dBException.getStackTrace()[0].toString(), (String)CommonArb.getString((String)"ERROR_CONNECTING"), null);
        }
        this.setConnection(connection);
    }

    public void disableOutput() {
        this.disableOutput(connLocal);
    }

    public boolean getState(Connection connection) {
        if (m_connEnableHash.get(this.ConnectionNameOrToString(connection)) == null) {
            return false;
        }
        return m_connEnableHash.get(this.ConnectionNameOrToString(connection));
    }

    public void enableOutput(ScriptRunnerContext scriptRunnerContext) {
        this.enableOutput(scriptRunnerContext.getCurrentConnection(), false);
    }

    protected BasicEditorPane getTextPanelArea() {
        if (connLocal == null) {
            return null;
        }
        if (this.m_tabPane.getTabInfo(connLocal) != null) {
            return (BasicEditorPane)this.m_tabPane.getTabInfo((Connection)AbstractOutputPane.connLocal)._data;
        }
        return null;
    }

    public void clear() {
        try {
            if (this.getTextPanelArea() == null) {
                return;
            }
            this.getTextPanelArea().getDocument().remove(0, this.getTextPanelArea().getDocument().getLength());
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
    }

    public void updateVisibleActions() {
        View.updateToolbarActions((Toolbar)this._toolbar);
    }

    public boolean isFocussed() {
        return this.getTextPanelArea().isFocusOwner();
    }

    public String getOutputText() {
        if (this.getTextPanelArea() == null) {
            return null;
        }
        return this.getTextPanelArea().getText();
    }

    public void setOutputResult(ScriptRunnerContext scriptRunnerContext, String string) {
        try {
            if (this.getTextPanelArea(scriptRunnerContext.getCurrentConnection()) != null) {
                this.getTextPanelArea(scriptRunnerContext.getCurrentConnection()).getDocument().insertString(this.getTextPanelArea(scriptRunnerContext.getCurrentConnection()).getDocument().getLength(), string, null);
                int n = this.m_tabPane.getIndexOfTab(scriptRunnerContext.getCurrentConnection());
                this.m_tabPane.highlightTab(n);
            }
        }
        catch (Exception exception) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
        }
    }

    private BasicEditorPane getTextPanelArea(Connection connection) {
        if (this.m_tabPane != null && this.m_tabPane.getTabInfo(connection) != null) {
            return (BasicEditorPane)this.m_tabPane.getTabInfo((Connection)connection)._data;
        }
        return null;
    }

    public void enableOutput() {
        this.enableOutput(connLocal, true);
    }

    private void setupAcceleratorToolTip(IdeAction ideAction) {
        KeyStrokeOptions keyStrokeOptions = Ide.getSettings().getKeyStrokeOptions();
        KeyStrokeMap keyStrokeMap = keyStrokeOptions.getLocalKeyMap(AbstractOutputPane.getKeyStrokeContext());
        List list = keyStrokeMap.getKeyStrokesFor(ideAction.getCommandId());
        if (list != null && list.size() > 0) {
            String string = StringUtil.textWithoutMnemonic((Action)ideAction);
            KeyStrokes keyStrokes = (KeyStrokes)list.get(0);
            StringBuffer stringBuffer = new StringBuffer(20);
            if (string.equals("")) {
                stringBuffer.append(this.getNewLabel());
            }
            stringBuffer.append(" (");
            for (int i = 0; i < keyStrokes.getLength(); ++i) {
                KeyStroke keyStroke = keyStrokes.getKeyStroke(i);
                if (keyStroke == null) continue;
                String string2 = KeyEvent.getKeyModifiersText(keyStroke.getModifiers());
                if (string2 != null && string2.length() > 0) {
                    stringBuffer.append(string2);
                    stringBuffer.append("+");
                }
                stringBuffer.append(KeyEvent.getKeyText(keyStroke.getKeyCode()));
                ideAction.putValueDirectly("AcceleratorKey", (Object)keyStroke);
            }
            stringBuffer.append(")");
            ideAction.putValueDirectly("last-tooltip-suffix", (Object)stringBuffer.toString());
            this.getActionMap().put(ideAction.getCommandId(), (Action)ideAction);
        }
    }

    private void updateKeyMap(KeyStrokeOptions keyStrokeOptions) {
        this.updateKeyMap(this, keyStrokeOptions);
    }

    private void updateKeyMap(JComponent jComponent, KeyStrokeOptions keyStrokeOptions) {
        if (!this.updatingKeyMap) {
            this.updatingKeyMap = true;
            MultiInputMap multiInputMap = MultiMapAdapter.getLocalMap((KeyStrokeOptions)keyStrokeOptions, (KeyStrokeContext)AbstractOutputPane.getKeyStrokeContext());
            jComponent.setInputMap(1, (InputMap)multiInputMap);
            this.updatingKeyMap = false;
        }
    }

    private static KeyStrokeContext getKeyStrokeContext() {
        KeyStrokeContextRegistry keyStrokeContextRegistry = Ide.getKeyStrokeContextRegistry();
        return keyStrokeContextRegistry.getContext(ACCEL_FILE);
    }

    private static void registerKeyStrokeContext(KeyStrokeOptions keyStrokeOptions) {
        KeyStrokeContext keyStrokeContext = AbstractOutputPane.getKeyStrokeContext();
        keyStrokeOptions.removeContext(keyStrokeContext);
        keyStrokeOptions.addContext(keyStrokeContext);
        keyStrokeOptions.solvePostponedMaps();
    }

    protected abstract String getNewLabel();

    private IdeAction getNewAction() {
        if (this.m_newAction == null) {
            this.m_newAction = IdeAction.get((int)NEW_CMD_ID).newLocalAction(this.dockableParent);
            this.m_newAction.putValueDirectly("Name", (Object)this.getNewLabel());
            this.setupAcceleratorToolTip(this.m_newAction);
            this.m_newAction.addController(new Controller(){

                public boolean handleEvent(IdeAction ideAction, Context context) {
                    int n = ideAction.getCommandId();
                    if (NEW_CMD_ID == n) {
                        AbstractOutputPane.this.newTab();
                        return true;
                    }
                    return false;
                }

                public boolean update(IdeAction ideAction, Context context) {
                    int n = ideAction.getCommandId();
                    return NEW_CMD_ID == n;
                }
            });
        }
        return this.m_newAction;
    }

    private IdeAction getClearAction() {
        if (this.m_clearAction == null) {
            this.m_clearAction = IdeAction.get((int)CLEAR_CMD_ID).newLocalAction(this.dockableParent);
            this.setupAcceleratorToolTip(this.m_clearAction);
            this.m_clearAction.addController(new Controller(){

                public boolean handleEvent(IdeAction ideAction, Context context) {
                    int n = ideAction.getCommandId();
                    if (CLEAR_CMD_ID == n) {
                        AbstractOutputPane.this.clear();
                        return true;
                    }
                    return false;
                }

                public boolean update(IdeAction ideAction, Context context) {
                    int n = ideAction.getCommandId();
                    return CLEAR_CMD_ID == n;
                }
            });
        }
        return this.m_clearAction;
    }

    private IdeAction getSaveAction() {
        if (this.m_saveAction == null) {
            this.m_saveAction = IdeAction.get((int)SAVE_CMD_ID).newLocalAction(this.dockableParent);
            this.setupAcceleratorToolTip(this.m_saveAction);
            this.m_saveAction.addController(new Controller(){

                public boolean handleEvent(IdeAction ideAction, Context context) {
                    int n = ideAction.getCommandId();
                    if (SAVE_CMD_ID == n) {
                        if (connLocal != null) {
                            int n2 = 0;
                            URLFileChooser uRLFileChooser = null;
                            URL uRL = AbstractOutputPane.this.getLastUrl();
                            uRLFileChooser = uRL != null ? new URLFileChooser(uRL) : new URLFileChooser();
                            n2 = uRLFileChooser.showSaveDialog(null);
                            if (n2 == 0) {
                                URL uRL2 = uRLFileChooser.getSelectedURL();
                                AbstractOutputPane.this.saveFile(uRL2);
                            }
                        }
                        return true;
                    }
                    return false;
                }

                public boolean update(IdeAction ideAction, Context context) {
                    int n = ideAction.getCommandId();
                    return SAVE_CMD_ID == n;
                }
            });
        }
        return this.m_saveAction;
    }

    private IdeAction getPrintAction() {
        if (this.m_printAction == null) {
            this.m_printAction = IdeAction.get((int)PRINT_CMD_ID).newLocalAction(this.dockableParent);
            this.setupAcceleratorToolTip(this.m_printAction);
            this.m_printAction.addController(new Controller(){

                public boolean handleEvent(IdeAction ideAction, Context context) {
                    int n = ideAction.getCommandId();
                    if (PRINT_CMD_ID == n) {
                        if (connLocal != null) {
                            AbstractOutputPane.this.printOutput();
                        }
                        return true;
                    }
                    return false;
                }

                public boolean update(IdeAction ideAction, Context context) {
                    int n = ideAction.getCommandId();
                    return PRINT_CMD_ID == n;
                }
            });
        }
        return this.m_printAction;
    }

    public abstract String getBufferSizeText();

    public Toolbar getToolbar() {
        return this._toolbar;
    }

    static {
        KeyStrokeOptions keyStrokeOptions = Ide.getSettings().getKeyStrokeOptions();
        AbstractOutputPane.registerKeyStrokeContext(keyStrokeOptions);
        NEW_CMD_ID = Ide.findOrCreateCmdID((String)"Output.New");
        CLEAR_CMD_ID = Ide.findOrCreateCmdID((String)"Output.Clear");
        SAVE_CMD_ID = Ide.findOrCreateCmdID((String)"Output.Save");
        PRINT_CMD_ID = Ide.findOrCreateCmdID((String)"Output.Print");
    }
}

