/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.worksheet.editor.bookmarks;

import java.net.URL;
import oracle.dbtools.worksheet.editor.Worksheet;
import oracle.dbtools.worksheet.editor.WorksheetGUI;
import oracle.ide.Context;
import oracle.ide.bookmarks.LineBookmark;
import oracle.ide.db.model.SqlNode;
import oracle.ide.editor.Editor;
import oracle.ide.editor.EditorManager;
import oracle.ide.editor.OpenEditorOptions;
import oracle.ide.model.Node;
import oracle.ide.model.NodeFactory;
import oracle.javatools.buffer.ExpiredTextBufferException;
import oracle.javatools.editor.BasicEditorPane;
import oracle.javatools.editor.BasicEditorPaneContainer;

final class WorksheetBookmark
extends LineBookmark {
    WorksheetBookmark(URL uRL, int n) {
        super(uRL, n);
    }

    public void gotoBookmark() {
        try {
            Node node = NodeFactory.findOrCreate((URL)this.getURL());
            if (!(node instanceof SqlNode)) {
                return;
            }
            SqlNode sqlNode = (SqlNode)node;
            Context context = Context.newIdeContext((Node)sqlNode);
            OpenEditorOptions openEditorOptions = new OpenEditorOptions(context, Worksheet.class);
            Editor editor = EditorManager.getEditorManager().openEditor(openEditorOptions);
            if (editor instanceof Worksheet) {
                BasicEditorPane basicEditorPane = ((BasicEditorPaneContainer)editor).getFocusedEditorPane();
                int n = this.getLine();
                int n2 = basicEditorPane.getLineStartOffset(n - 1);
                basicEditorPane.setCaretPositionCenter(n2);
            }
        }
        catch (ExpiredTextBufferException expiredTextBufferException) {
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public int getLineFromContext(Context context) {
        if (context.getView() instanceof Worksheet) {
            Worksheet worksheet = (Worksheet)context.getView();
            int n = ((WorksheetGUI)worksheet.getGUI()).getEditorPane().getCaretPosition();
            int n2 = ((WorksheetGUI)worksheet.getGUI()).getEditorPane().getLineFromOffset(n);
            return n2 + 1;
        }
        return -1;
    }
}

