/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.worksheet.sqlhistory.db;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.Writer;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.logging.Logger;
import oracle.dbtools.raptor.utils.FileUtils;
import oracle.dbtools.raptor.utils.XMLHelper;
import oracle.dbtools.worksheet.sqlhistory.SqlEditorHistory;
import org.w3c.dom.Node;

public class HistoryItem {
    private static final Logger LOG = Logger.getLogger(HistoryItem.class.getName());
    private String sql;
    private String conn;
    private long time;
    private String type;
    private int exeCount;
    private String fileName;
    private float execTime = -1.0f;

    public HistoryItem() {
    }

    public HistoryItem(Node node, String string) {
        this.load(node, string);
    }

    public void setExeCount(int n) {
        this.exeCount = n;
    }

    public int getExeCount() {
        return this.exeCount;
    }

    public void setTime(long l) {
        this.time = l;
    }

    public long getTime() {
        return this.time;
    }

    public void setConn(String string) {
        this.conn = string;
    }

    public String getConn() {
        return this.conn;
    }

    public void setSql(String string) {
        this.sql = string;
    }

    public String getSql() {
        return this.sql;
    }

    public void setType(String string) {
        this.type = string;
    }

    public String getType() {
        return this.type;
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String string) {
        this.fileName = string;
    }

    public float getExecTime() {
        return this.execTime;
    }

    public void setExecTime(float f) {
        this.execTime = f;
    }

    public void load(Node node, String string) {
        String string2 = XMLHelper.getNodeValue((Node)node, (String)"sql");
        String string3 = XMLHelper.getNodeValue((Node)node, (String)"connection");
        String string4 = XMLHelper.getNodeValue((Node)node, (String)"timestamp");
        String string5 = XMLHelper.getNodeValue((Node)node, (String)"type");
        String string6 = XMLHelper.getNodeValue((Node)node, (String)"execTime");
        float f = -1.0f;
        if (string6 != null) {
            try {
                f = Float.parseFloat(string6);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (string5 == null || string5.equals("")) {
            string5 = SqlEditorHistory.TYPE_SQL_HISTORY;
        }
        int n = 0;
        try {
            n = Integer.parseInt(XMLHelper.getNodeValue((Node)node, (String)"executed"));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        this.setConn(string3);
        this.setTime(this.getTime(string4));
        this.setSql(string2);
        this.setType(string5);
        this.setFileName(string);
        this.setExeCount(n);
        this.setExecTime(f);
    }

    private long getTime(String string) {
        Date date;
        DateFormat dateFormat;
        long l = 0L;
        try {
            l = Long.parseLong(string);
        }
        catch (NumberFormatException numberFormatException) {
            LOG.fine("Not a number:" + string);
        }
        if (l == 0L) {
            dateFormat = new SimpleDateFormat("M/d/yy HH:mm", Locale.getDefault());
            try {
                date = dateFormat.parse(string);
                l = date.getTime();
            }
            catch (ParseException parseException) {
                LOG.fine("Not a SimpleDate:" + string);
            }
        }
        if (l == 0L) {
            dateFormat = DateFormat.getDateTimeInstance(3, 3);
            try {
                date = dateFormat.parse(string);
                l = date.getTime();
            }
            catch (ParseException parseException) {
                LOG.fine("Not a SimpleDate:" + string);
            }
        }
        return l;
    }

    public void loadOldFormat(Node node, String string) {
        String string2 = XMLHelper.getNodeValue((Node)node, (String)"SQL");
        String string3 = XMLHelper.getNodeValue((Node)node, (String)"Connection");
        String string4 = XMLHelper.getNodeValue((Node)node, (String)"TimeStamp");
        String string5 = XMLHelper.getNodeValue((Node)node, (String)"Type");
        String string6 = XMLHelper.getNodeValue((Node)node, (String)"ExecTime");
        float f = -1.0f;
        if (string6 != null) {
            try {
                f = Float.parseFloat(string6);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (string5 == null || string5.equals("")) {
            string5 = SqlEditorHistory.TYPE_SQL_HISTORY;
        }
        int n = 0;
        try {
            n = Integer.parseInt(XMLHelper.getNodeValue((Node)node, (String)"Executed"));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        this.setConn(string3);
        this.setTime(this.getTime(string4));
        this.setSql(string2);
        this.setType(string5);
        this.setFileName(string);
        this.setExeCount(n);
        this.setExecTime(f);
    }

    public void save() throws FileNotFoundException, IOException {
        String string = FileUtils.getLineTerminator();
        Writer writer = FileUtils.getEncodedFileWriter((String)(SqlEditorHistory.NEW_HISTORY_DIR_PATH + File.separator + this.getFileName()), (String)"UTF-8");
        writer.write("<?xml version='1.0'  encoding='UTF-8' ?>" + string);
        writer.write("<history>" + string);
        writer.write("\t<historyItem>" + string);
        writer.write("\t\t<sql><![CDATA[" + this.getSql() + "]]></sql>" + string);
        writer.write("\t\t<connection><![CDATA[" + this.getConn() + "]]></connection>" + string);
        writer.write("\t\t<timestamp><![CDATA[" + this.getTime() + "]]></timestamp>" + string);
        writer.write("\t\t<type><![CDATA[" + this.getType() + "]]></type>" + string);
        writer.write("\t\t<executed><![CDATA[" + this.getExeCount() + "]]></executed>" + string);
        writer.write("\t\t<execTime><![CDATA[" + this.getExecTime() + "]]></execTime>" + string);
        writer.write("\t</historyItem>" + string);
        writer.write("</history>" + string);
        writer.flush();
        writer.close();
    }

    public boolean delete() {
        String string = this.getFileName();
        File file = new File(SqlEditorHistory.NEW_HISTORY_DIR_PATH + File.separator + string);
        if (!file.exists()) {
            return false;
        }
        return file.delete();
    }

    public String toString() {
        return this.conn + ":" + this.sql;
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + (this.conn == null ? 0 : this.conn.hashCode());
        n = 31 * n + (this.sql == null ? 0 : this.sql.hashCode());
        n = 31 * n + (this.type == null ? 0 : this.type.hashCode());
        return n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        HistoryItem historyItem = (HistoryItem)object;
        if (this.conn == null ? historyItem.conn != null : !this.conn.equals(historyItem.conn)) {
            return false;
        }
        if (this.sql == null ? historyItem.sql != null : !this.sql.equals(historyItem.sql)) {
            return false;
        }
        return !(this.type == null ? historyItem.type != null : !this.type.equals(historyItem.type));
    }
}

