/*
 * Decompiled with CFR 0.152.
 */
package oracle.maps.layer;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.util.List;
import java.util.Vector;
import oracle.maps.core.DataProducer;
import oracle.maps.core.DefaultSelectionManager;
import oracle.maps.core.Drawable;
import oracle.maps.core.EditChangeListener;
import oracle.maps.core.EditableLayer;
import oracle.maps.core.GeoDataProducer;
import oracle.maps.core.GeoObject;
import oracle.maps.core.HoverableLayer;
import oracle.maps.core.MapCanvas;
import oracle.maps.core.MapRegion;
import oracle.maps.core.MapRegionEvent;
import oracle.maps.core.SelectableLayer;
import oracle.maps.core.SelectionListener;
import oracle.maps.geoobject.GeometryFeature;
import oracle.maps.graphics.AnimatedStroke;
import oracle.maps.graphics.ShadowRenderer;
import oracle.maps.internal.LayerTransitionHelper;
import oracle.maps.layer.BasicLayer;
import oracle.maps.ui.IconMarker;
import oracle.maps.util.DynamicVertexSet;
import oracle.spatial.geometry.JGeometry;

public class GeometryLayer
extends BasicLayer
implements EditableLayer,
SelectableLayer,
HoverableLayer {
    private GeoDataProducer geoProducer;
    private GeoObject[] myData;
    private boolean loading = false;
    private IconMarker marker;
    private boolean antialiasing = true;
    private Stroke stroke = new BasicStroke(1.0f);
    private Color color = Color.black;
    private Color fillColor = Color.lightGray;
    private Stroke vertexBoxStroke = new BasicStroke(1.0f);
    private AnimatedStroke animeStrokeForSelected = null;
    private Stroke hoverStroke = new BasicStroke(2.0f);
    private Color hoverColor = Color.yellow;
    private Color hoverBorderColor = Color.darkGray;
    private BufferedImage img;
    private boolean imgUpToDate = false;
    private DynamicVertexSet vertexHandles = new DynamicVertexSet(4.0);
    private boolean doubleBuffering = false;
    private LayerTransitionHelper transitionHelper;
    private DefaultSelectionManager selectionManager = new DefaultSelectionManager(this);
    private DefaultSelectionManager hoverManager = new DefaultSelectionManager(this);

    public GeometryLayer(MapCanvas canvas) {
        super(canvas);
        this.properties.setDefaultProperty("oracle.maps.core.EditableLayer.editable", Boolean.toString(false));
        this.transitionHelper = new LayerTransitionHelper(canvas);
        this.animeStrokeForSelected = new AnimatedStroke(Color.magenta);
    }

    @Override
    public void setEditable(boolean editable) {
        this.setProperty("oracle.maps.core.EditableLayer.editable", Boolean.toString(editable));
    }

    @Override
    public boolean isEditable() {
        return Boolean.parseBoolean(this.getProperty("oracle.maps.core.EditableLayer.editable"));
    }

    @Override
    public boolean isModified() {
        return false;
    }

    @Override
    public boolean save() {
        return false;
    }

    @Override
    public void clearChanges() {
    }

    @Override
    public void addEditChangeListener(EditChangeListener l) {
        throw new UnsupportedOperationException("not implemented");
    }

    @Override
    public void removeEditChangeListener(EditChangeListener l) {
        throw new UnsupportedOperationException("not implemented");
    }

    @Override
    public void update(long elapsedTime) {
        this.animeStrokeForSelected.update(elapsedTime);
    }

    @Override
    public long render(Graphics2D g) {
        Drawable drawable;
        if (this.myData == null) {
            return 0L;
        }
        long t1 = System.currentTimeMillis();
        if (this.imgUpToDate && this.doubleBuffering) {
            if (this.transitionHelper.isWaitingOnServer() || this.transitionHelper.regionChanged()) {
                this.transitionHelper.drawTransitionImage(g, this.img);
            } else {
                g.drawImage((Image)this.img, 0, 0, null);
            }
        } else {
            this.doRealRendering(g);
            this.transitionHelper.setLastQueryWindow(this.canvas.getMapRegion().getDataWindow());
        }
        AffineTransform xfm = this.canvas.getViewportTransform();
        if (this.numSelected() > 0) {
            GeoObject selected = this.getSelection().get(0);
            drawable = selected.getDrawable(xfm);
            if (drawable.isShape()) {
                this.drawSelectedShape(drawable, g);
            } else {
                this.drawSelectedPoint(drawable, g);
            }
        }
        if (this.numHovered() > 0) {
            GeoObject hoverShape = this.getHover().get(0);
            drawable = hoverShape.getDrawable(xfm);
            if (drawable.isShape()) {
                Shape shp = drawable.getShape();
                this.renderHoverShape(shp, g, drawable.getType());
            } else {
                Point2D pt = drawable.getPoint();
                this.renderHoverPoint(pt, g);
            }
        }
        if (this.vertexHandles.size() > 0) {
            g.setColor(Color.blue);
            g.setStroke(this.vertexBoxStroke);
            Rectangle2D[] boxes = this.vertexHandles.getBoxes();
            for (int i = 0; i < boxes.length; ++i) {
                g.draw(boxes[i]);
            }
        }
        long t2 = System.currentTimeMillis();
        return t2 - t1;
    }

    private void drawSelectedShape(Drawable drawable, Graphics2D g) {
        if (this.animeStrokeForSelected != null) {
            g.setColor(this.animeStrokeForSelected.getColor());
            g.setStroke(this.animeStrokeForSelected.getStroke());
            Shape shp = drawable.getShape();
            g.draw(shp);
        }
    }

    private void drawSelectedPoint(Drawable drawable, Graphics2D g) {
        Point2D pt = drawable.getPoint();
        if (this.marker != null) {
            this.marker.draw((int)pt.getX(), (int)pt.getY(), g, 2);
        } else {
            Color oc = g.getColor();
            g.setColor(Color.red);
            g.fillOval((int)(pt.getX() - 6.0), (int)(pt.getY() - 6.0), 10, 10);
            g.setColor(oc);
        }
    }

    private void doRealRendering(Graphics2D canvasG) {
        if (this.img == null && this.doubleBuffering) {
            return;
        }
        long t1 = System.currentTimeMillis();
        Graphics2D g = null;
        if (this.doubleBuffering) {
            g = this.img.createGraphics();
            g.setBackground(new Color(0, 0, 0, 0));
            g.clearRect(0, 0, this.img.getWidth(), this.img.getHeight());
        } else {
            g = canvasG;
        }
        AffineTransform xfm = this.canvas.getViewportTransform();
        if (this.antialiasing) {
            g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        } else {
            g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        }
        g.setColor(this.color);
        g.setStroke(this.stroke);
        for (int i = 0; i < this.myData.length; ++i) {
            GeoObject o = this.myData[i];
            if (this.isSelected(o)) continue;
            Drawable dr = o.getDrawable(xfm);
            if (dr.isShape()) {
                Shape shp = dr.getShape();
                if (this.fillColor != null && dr.getType() == 1) {
                    g.setColor(this.fillColor);
                    g.fill(shp);
                }
                g.setColor(this.color);
                g.draw(shp);
                continue;
            }
            Point2D pt = dr.getPoint();
            if (this.marker == null) {
                g.fillOval((int)(pt.getX() - 6.5), (int)(pt.getY() - 6.5), 10, 10);
                continue;
            }
            this.marker.draw((int)pt.getX(), (int)pt.getY(), g, 0);
        }
        if (this.doubleBuffering) {
            g.dispose();
            this.imgUpToDate = true;
        }
        long t2 = System.currentTimeMillis();
    }

    private void renderHoverShape(Shape shape, Graphics2D dest, int shapeType) {
        Rectangle2D mbr = shape.getBounds2D();
        int x = (int)mbr.getMinX();
        int y = (int)mbr.getMinY();
        int w = (int)mbr.getWidth() + 1;
        int h = (int)mbr.getHeight() + 1;
        int imgW = Math.min((int)mbr.getWidth(), this.canvas.getWidth());
        int imgH = Math.min((int)mbr.getHeight(), this.canvas.getHeight());
        if (imgW == 0 || imgH == 0) {
            return;
        }
        BufferedImage image = new BufferedImage(imgW, imgH, 2);
        Graphics2D g = image.createGraphics();
        g.translate(-x, -y);
        g.setColor(this.hoverColor);
        if (shapeType == 1) {
            g.fill(shape);
        }
        g.setColor(this.hoverBorderColor);
        g.setStroke(this.hoverStroke);
        g.draw(shape);
        g.dispose();
        ShadowRenderer sr = new ShadowRenderer();
        BufferedImage shadow = sr.createShadow(image);
        dest.drawImage((Image)shadow, (int)mbr.getMinX(), (int)mbr.getMinY(), null);
        dest.drawImage((Image)image, (int)mbr.getMinX(), (int)mbr.getMinY(), null);
        shadow = null;
        image = null;
    }

    private void renderHoverPoint(Point2D pt, Graphics2D g) {
        if (this.marker != null) {
            this.marker.draw((int)pt.getX(), (int)pt.getY(), g, 1);
        } else {
            Color oc = g.getColor();
            g.setColor(this.hoverColor);
            g.fillOval((int)(pt.getX() - 6.5), (int)(pt.getY() - 6.5), 10, 10);
            g.setColor(oc);
        }
    }

    @Override
    public List<GeoObject> hitTest(int x, int y, int granularity) {
        Vector<GeoObject> result = new Vector<GeoObject>();
        if (this.myData == null || this.myData.length == 0) {
            return result;
        }
        AffineTransform xfm = this.canvas.getMapRegion().getViewportTransform();
        AffineTransform inv = null;
        try {
            inv = xfm.createInverse();
        }
        catch (Exception ex) {
            System.err.println("Cannot create inverse transformation.");
        }
        Point2D.Double pt = new Point2D.Double(0.0, 0.0);
        inv.transform(new Point2D.Double(x, y), pt);
        Rectangle2D.Double bbox = new Rectangle2D.Double();
        double _x = ((Point2D)pt).getX();
        double _y = ((Point2D)pt).getY();
        for (int i = 0; i < this.myData.length; ++i) {
            GeoObject obj = this.myData[i];
            GeometryFeature f = (GeometryFeature)obj;
            JGeometry geom = f.getSpatialAttribute();
            if (f.getSpatialAttribute().isPoint()) {
                if (!this.hitTestPointGeom(obj, xfm, x, y)) continue;
                result.add(obj);
                continue;
            }
            double[] mbr = geom.getMBR();
            ((Rectangle2D)bbox).setRect(mbr[0], mbr[1], mbr[2] - mbr[0], mbr[3] - mbr[1]);
            if (!bbox.contains(_x, _y)) continue;
            result.add(obj);
        }
        return result;
    }

    private boolean hitTestPointGeom(GeoObject obj, AffineTransform xfm, int x, int y) {
        Drawable dr = obj.getDrawable(xfm);
        Point2D point = dr.getPoint();
        Rectangle2D markerMbr = null;
        markerMbr = this.marker != null ? this.marker.getMBRForLocation((int)point.getX(), (int)point.getY()) : new Rectangle2D.Double(point.getX() - 6.5, point.getY() - 6.5, 13.0, 13.0);
        return markerMbr.contains(x, y);
    }

    @Override
    public List<GeoObject> hitTest(Rectangle2D box, int granularity) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void setCanvas(MapCanvas parent) {
        this.canvas = parent;
        this.transitionHelper.setCanvas(this.canvas);
    }

    @Override
    public MapCanvas getCanvas() {
        return this.canvas;
    }

    @Override
    public void mapRegionChanged(MapRegionEvent e) {
        MapRegion region;
        int w = this.canvas.getWidth();
        int h = this.canvas.getHeight();
        if (this.doubleBuffering && (this.img == null || this.img.getWidth() != w || this.img.getHeight() != h)) {
            this.img = new BufferedImage(w, h, 2);
        }
        if (this.geoProducer != null && (region = this.canvas.getMapRegion()) != null) {
            this.transitionHelper.setWaitingOnServer(true);
            this.geoProducer.loadData(region.getDataWindow(), region.getDataWindowSrid());
        }
    }

    @Override
    public GeoObject getObject(Object key) {
        return this.findObject(key);
    }

    @Override
    public GeoObject[] getObjects() {
        return this.myData;
    }

    @Override
    public GeoObject deleteObject(Object key) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public boolean insertObject(Object key, GeoObject obj) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public GeoObject updateObject(Object key, GeoObject changedObject) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public GeoObject newObject(Object spatialObject, Object[] params) throws Exception {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public boolean appendToObject(Object key, Object spatialObject) throws Exception {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void onDataException(DataProducer producer, Throwable exception) {
        this.transitionHelper.setWaitingOnServer(false);
        exception.printStackTrace(System.err);
    }

    public void onDataReady(DataProducer producer) {
        this.transitionHelper.setWaitingOnServer(false);
        this.myData = this.geoProducer.getData();
        this.imgUpToDate = false;
    }

    public GeoDataProducer getGeoDataProducer() {
        return this.geoProducer;
    }

    public void setGeoDataProducer(GeoDataProducer producer) {
        MapRegion region;
        this.geoProducer = producer;
        this.geoProducer.setLayer(this);
        if (this.myData != null && this.myData.length > 0 && this.geoProducer != null && (region = this.canvas.getMapRegion()) != null) {
            this.geoProducer.loadData(region.getDataWindow(), region.getDataWindowSrid());
        }
    }

    @Override
    public void repaint() {
        if (this.doubleBuffering) {
            this.doRealRendering(null);
        }
    }

    public DynamicVertexSet getActiveVertexHandles() {
        return this.vertexHandles;
    }

    public IconMarker getMarker() {
        return this.marker;
    }

    public void setMarker(IconMarker marker) {
        this.marker = marker;
        this.repaint();
    }

    public Color getColor() {
        return this.color;
    }

    public void setColor(Color color) {
        this.color = color;
        this.repaint();
    }

    public Color getHoverBorderColor() {
        return this.hoverBorderColor;
    }

    public void setHoverBorderColor(Color hoverBorderColor) {
        this.hoverBorderColor = hoverBorderColor;
        this.repaint();
    }

    public Color getHoverColor() {
        return this.hoverColor;
    }

    public void setHoverColor(Color hoverColor) {
        this.hoverColor = hoverColor;
        this.repaint();
    }

    public Stroke getHoverStroke() {
        return this.hoverStroke;
    }

    public void setHoverStroke(Stroke hoverStroke) {
        this.hoverStroke = hoverStroke;
        this.repaint();
    }

    public Stroke getStroke() {
        return this.stroke;
    }

    public void setStroke(Stroke stroke) {
        this.stroke = stroke;
        this.repaint();
    }

    public Color getFillColor() {
        return this.fillColor;
    }

    public void setFillColor(Color fillColor) {
        this.fillColor = fillColor;
        this.repaint();
    }

    private GeoObject findObject(Object key) {
        if (this.myData == null || this.myData.length == 0) {
            return null;
        }
        for (int i = 0; i < this.myData.length; ++i) {
            GeoObject o = this.myData[i];
            if (o.getKey() == null || key == null || !key.equals(o.getKey())) continue;
            return o;
        }
        return null;
    }

    public boolean isDoubleBuffering() {
        return this.doubleBuffering;
    }

    public void setDoubleBuffering(boolean doubleBuffering) {
        this.doubleBuffering = doubleBuffering;
        this.repaint();
    }

    @Override
    public Rectangle2D getDataMBR() {
        Rectangle2D.Double r = null;
        if (this.myData != null && this.myData.length > 0) {
            for (int i = 0; i < this.myData.length; ++i) {
                if (r == null) {
                    r = new Rectangle2D.Double();
                    ((Rectangle2D)r).setRect(this.myData[i].getMBR());
                    continue;
                }
                r.add(this.myData[i].getMBR());
            }
        }
        return r;
    }

    public boolean isAntialiasing() {
        return this.antialiasing;
    }

    public void setAntialiasing(boolean antialiasing) {
        this.antialiasing = antialiasing;
        this.repaint();
    }

    @Override
    public boolean isSelected(GeoObject feat) {
        return this.selectionManager.isSelected(feat);
    }

    @Override
    public boolean clearSelection() {
        return this.selectionManager.clear();
    }

    @Override
    public int numSelected() {
        return this.selectionManager.size();
    }

    @Override
    public List<GeoObject> getSelection() {
        return this.selectionManager.getSelection();
    }

    @Override
    public List<GeoObject> getSelection(GeoObject feat) {
        return this.selectionManager.getSelection(feat);
    }

    @Override
    public boolean setSelection(List<GeoObject> objs) {
        return this.selectionManager.setSelection(objs);
    }

    @Override
    public boolean select(List<GeoObject> objs) {
        return this.selectionManager.select(objs);
    }

    @Override
    public boolean unselect(List<GeoObject> objs) {
        return this.selectionManager.unselect(objs);
    }

    @Override
    public void addSelectionListener(SelectionListener l) {
        this.selectionManager.addSelectionListener(l);
    }

    @Override
    public void removeSelectionListener(SelectionListener l) {
        this.selectionManager.removeSelectionListener(l);
    }

    @Override
    public boolean setHover(List<GeoObject> objs) {
        return this.hoverManager.setSelection(objs);
    }

    @Override
    public boolean clearHover() {
        return this.hoverManager.clear();
    }

    @Override
    public List<GeoObject> getHover() {
        return this.hoverManager.getSelection();
    }

    @Override
    public boolean isHover(GeoObject obj) {
        return this.hoverManager.isSelected(obj);
    }

    @Override
    public int numHovered() {
        return this.hoverManager.size();
    }
}

