/*
 * Decompiled with CFR 0.152.
 */
package oracle.maps.layer.ui;

import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.util.EventObject;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import oracle.maps.core.MapCanvas;
import oracle.maps.core.MapRegionEvent;
import oracle.maps.layer.BasicLayer;
import oracle.mapviewer.share.ScaleBar;
import oracle.mdeditor.session.layer.ConfigurableLayer;
import oracle.mdeditor.ui.resources.MessagesBundle;
import oracle.sdovis.ScaleBarRenderer;

public class ScaleBarLayer
extends BasicLayer
implements ConfigurableLayer {
    protected ScaleBar scbar = null;
    protected ScaleBarRenderer scbarRender = null;
    protected BufferedImage img = null;
    protected boolean isReady = false;

    public ScaleBarLayer(MapCanvas parent) {
        super(parent);
        this.properties.setDefaultProperty("oracle.maps.core.Layer.name", "Scale Bar Layer");
        this.scbar = new ScaleBar();
        this.scbar.setMode("DUAL_MODES");
        this.scbar.setPosition("SOUTH_EAST");
        this.scbar.setLabelHaloSize(2.5f);
    }

    @Override
    public boolean handleEvent(EventObject evt) {
        return true;
    }

    @Override
    public long render(Graphics2D g) {
        if (!this.isReady) {
            return 0L;
        }
        long t1 = System.currentTimeMillis();
        g.drawImage((Image)this.img, 0, 0, null);
        long t2 = System.currentTimeMillis();
        return t2 - t1;
    }

    @Override
    public void setVisible(boolean v) {
        if (v && !this.isReady) {
            this.reload();
        }
        super.setVisible(v);
    }

    @Override
    public void mapRegionChanged(MapRegionEvent e) {
        this.reload();
    }

    private void reload() {
        this.isReady = false;
        this.img = null;
        if (this.canvas.getMapRegion() == null || this.canvas.getMapRegion().getSRS() == null || this.canvas.getMapRegion().getSRS().getSRID() == 0) {
            return;
        }
        int w = this.canvas.getWidth();
        int h = this.canvas.getHeight();
        this.scbarRender = new ScaleBarRenderer(this.scbar, this.canvas.getMapRegion().getSRS(), this.canvas.getMapRegion().getDataWindow(), (Rectangle2D)new Rectangle2D.Double(0.0, 0.0, this.canvas.getWidth(), this.canvas.getHeight()), null);
        this.img = new BufferedImage(w, h, 2);
        Graphics2D g = this.img.createGraphics();
        this.scbarRender.renderScaleBar(g);
        g.dispose();
        this.isReady = true;
    }

    @Override
    public JPanel getConfigurationPanel(Component parent) {
        JCheckBox showscbarCBox = new JCheckBox(MessagesBundle.getMessage("Show_scale_bar"), this.isVisible());
        showscbarCBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JCheckBox cb = (JCheckBox)e.getSource();
                ScaleBarLayer.this.setVisible(cb.isSelected());
            }
        });
        JPanel panel = new JPanel();
        panel.setLayout(new GridBagLayout());
        panel.add((Component)showscbarCBox, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        return panel;
    }
}

