/*
 * Decompiled with CFR 0.152.
 */
package oracle.maps.producer;

import java.awt.geom.Rectangle2D;
import java.net.URLEncoder;
import java.util.Random;
import oracle.maps.producer.SDOAbstractVectorProducer;

public class VectorQueryProducer
extends SDOAbstractVectorProducer {
    String query;
    String rewrittenQuery;
    Random rand;

    public VectorQueryProducer(String mapViewerUrl, String dataSrc, String query) {
        this.mapViewerDataSource = dataSrc;
        this.query = query;
        this.setMapViewerUrl(mapViewerUrl);
    }

    @Override
    protected String generateRequestUrl(Rectangle2D queryWindow) {
        if (this.themeName == null) {
            this.rand = new Random(System.currentTimeMillis());
            this.themeName = "t" + this.rand.nextInt(10000);
        }
        String requestUrl = this.mapViewerUrl + "/dataserver/" + this.mapViewerDataSource + "?" + "t=" + this.themeName;
        if (queryWindow != null && !Double.isInfinite(queryWindow.getWidth()) && !Double.isInfinite(queryWindow.getHeight())) {
            requestUrl = requestUrl + "&bbox=" + queryWindow.getMinX() + "," + queryWindow.getMinY() + "," + queryWindow.getMaxX() + "," + queryWindow.getMaxY();
        }
        if (this.query != null) {
            try {
                requestUrl = requestUrl + "&sql=" + URLEncoder.encode(this.query, "UTF-8");
            }
            catch (Exception ex) {
                System.err.println("Cannot encode query string.");
            }
        }
        return requestUrl;
    }
}

