/*
 * Decompiled with CFR 0.152.
 */
package oracle.maps.tools.configurable;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.EventObject;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JColorChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import oracle.maps.core.MapCanvas;
import oracle.maps.layer.BasicLayer;
import oracle.mapviewer.share.style.StyleUtils;
import oracle.mdeditor.session.layer.ConfigurableLayer;
import oracle.mdeditor.ui.ColorIcon;
import oracle.mdeditor.ui.resources.MessagesBundle;

public class VertexToolsConfigurable
extends BasicLayer
implements ConfigurableLayer {
    public static final String TAG_VERTEXTOOLS_CONFIG = "vertexToolsConfigLayer";
    public static final String PROPERTY_SHOW_VERTEXES = "oracle.maps.tools.configurable.VertexToolsConfigurable.showVertexes";
    public static final String PROPERTY_VERTEX_BOX_COLOR = "oracle.maps.tools.configurable.VertexToolsConfigurable.vertexBoxColor";
    public static final String PROPERTY_VERTEX_BOX_SIZE = "oracle.maps.tools.configurable.VertexToolsConfigurable.vertexBoxSize";

    public VertexToolsConfigurable(MapCanvas mapCanvas) {
        super(mapCanvas);
        this.properties.setDefaultProperty("oracle.maps.core.Layer.name", "Vertex Tools");
        this.properties.setDefaultProperty("oracle.maps.core.Layer.visible", Boolean.toString(true));
        this.properties.setDefaultProperty(PROPERTY_SHOW_VERTEXES, Boolean.toString(true));
        this.properties.setDefaultProperty(PROPERTY_VERTEX_BOX_COLOR, StyleUtils.getHexidecimalString((Color)Color.blue));
        this.properties.setDefaultProperty(PROPERTY_VERTEX_BOX_SIZE, "4");
    }

    @Override
    public JPanel getConfigurationPanel(Component parent) {
        VertexToolsPreferencesPanel p = new VertexToolsPreferencesPanel(parent);
        return p;
    }

    private Color getColorProperty(String property) {
        try {
            Integer i = Integer.decode(this.getProperty(property));
            return new Color(i);
        }
        catch (Exception ex) {
            return null;
        }
    }

    private void setColorProperty(String property, Color c) {
        this.setProperty(property, StyleUtils.getHexidecimalString((Color)c));
    }

    @Override
    public boolean handleEvent(EventObject evt) {
        return true;
    }

    private class VertexToolsPreferencesPanel
    extends JPanel {
        private Component parent = null;
        private Boolean showVertexes = null;
        private Color vertexBoxColor = null;
        private int vertexBoxSize = 4;
        JCheckBox showVertexesCheckbox = null;

        public VertexToolsPreferencesPanel(Component parent) {
            this.parent = parent;
            this.showVertexes = new Boolean(VertexToolsConfigurable.this.getProperty(VertexToolsConfigurable.PROPERTY_SHOW_VERTEXES));
            this.vertexBoxColor = VertexToolsConfigurable.this.getColorProperty(VertexToolsConfigurable.PROPERTY_VERTEX_BOX_COLOR);
            this.vertexBoxSize = Integer.parseInt(VertexToolsConfigurable.this.getProperty(VertexToolsConfigurable.PROPERTY_VERTEX_BOX_SIZE));
            try {
                this.jbInit();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        private void jbInit() throws Exception {
            this.setLayout(new GridBagLayout());
            this.setSize(new Dimension(305, 154));
            this.showVertexesCheckbox = new JCheckBox(MessagesBundle.getMessage("Checkbox_pref_show_vertexes"));
            this.showVertexesCheckbox.setSelected(this.showVertexes);
            this.showVertexesCheckbox.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    VertexToolsPreferencesPanel.this.showVertexes = new Boolean(VertexToolsPreferencesPanel.this.showVertexesCheckbox.isSelected());
                }
            });
            JLabel vertexBoxColorLabel = new JLabel(MessagesBundle.getMessage("Label_pref_vertex_box_color"));
            JButton vertexBoxColorButton = new JButton(new ColorIcon(32, 16, this.vertexBoxColor));
            vertexBoxColorButton.addActionListener(new ColorIconButtonActionListener(this.parent){

                @Override
                public void colorChanged(Color color) {
                    VertexToolsPreferencesPanel.this.vertexBoxColor = color;
                }
            });
            JLabel vertexBoxSizeLabel = new JLabel(MessagesBundle.getMessage("Label_pref_vertex_box_size"));
            JSpinner vertexBoxSizeSpinner = new JSpinner(new SpinnerNumberModel(this.vertexBoxSize, 1, 40, 1));
            vertexBoxSizeSpinner.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    JSpinner s = (JSpinner)e.getSource();
                    VertexToolsPreferencesPanel.this.vertexBoxSize = (Integer)s.getValue();
                }
            });
            JButton applyButton = new JButton(MessagesBundle.getMessage("Button_apply"));
            applyButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    VertexToolsConfigurable.this.setProperty(VertexToolsConfigurable.PROPERTY_SHOW_VERTEXES, "" + VertexToolsPreferencesPanel.this.showVertexes);
                    VertexToolsConfigurable.this.setColorProperty(VertexToolsConfigurable.PROPERTY_VERTEX_BOX_COLOR, VertexToolsPreferencesPanel.this.vertexBoxColor);
                    VertexToolsConfigurable.this.setProperty(VertexToolsConfigurable.PROPERTY_VERTEX_BOX_SIZE, "" + VertexToolsPreferencesPanel.this.vertexBoxSize);
                }
            });
            int y = 0;
            this.add((Component)this.showVertexesCheckbox, new GridBagConstraints(0, y, 1, 1, 1.0, 0.0, 13, 0, new Insets(10, 0, 0, 0), 0, 0));
            this.add((Component)vertexBoxColorLabel, new GridBagConstraints(0, ++y, 1, 1, 1.0, 0.0, 13, 0, new Insets(5, 0, 0, 0), 0, 0));
            this.add((Component)vertexBoxColorButton, new GridBagConstraints(1, y, 1, 1, 1.0, 0.0, 17, 0, new Insets(5, 0, 0, 0), 0, 0));
            this.add((Component)vertexBoxSizeLabel, new GridBagConstraints(0, ++y, 1, 1, 1.0, 0.0, 13, 0, new Insets(5, 0, 0, 0), 0, 0));
            this.add((Component)vertexBoxSizeSpinner, new GridBagConstraints(1, y, 1, 1, 1.0, 0.0, 17, 0, new Insets(5, 0, 0, 0), 0, 0));
            this.add((Component)applyButton, new GridBagConstraints(0, ++y, 1, 1, 1.0, 0.0, 13, 0, new Insets(15, 0, 0, 0), 0, 0));
        }
    }

    private abstract class ColorIconButtonActionListener
    implements ActionListener {
        Component parent = null;

        public ColorIconButtonActionListener(Component parent) {
            this.parent = parent;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JButton button = (JButton)e.getSource();
            ColorIcon ci = (ColorIcon)button.getIcon();
            Color c = JColorChooser.showDialog(this.parent, MessagesBundle.getMessage("Choose_color"), ci.getColor());
            if (c != null) {
                ci.setColor(c);
                this.colorChanged(c);
            }
        }

        public abstract void colorChanged(Color var1);
    }
}

