/*
 * Decompiled with CFR 0.152.
 */
package oracle.maps.util;

import java.util.ArrayList;
import java.util.Hashtable;
import oracle.maps.geoobject.AbstractFeature;
import oracle.maps.geoobject.GeometryFeature;
import oracle.mapviewer.share.Field;
import oracle.mapviewer.share.TopologyEdge;
import oracle.mapviewer.share.TopologyFace;
import oracle.mapviewer.share.TopologyNode;
import oracle.sdovis.text.AnnotationText;
import oracle.sdovis.text.AnnotationTextElement;
import oracle.sdovis.text.jaxb.FontStyle;
import oracle.sdovis.text.jaxb.TextAttributesType;
import oracle.sdovis.text.jaxb.TextDecoration;
import oracle.sdovis.text.jaxb.TextStyle;
import oracle.sdovis.text.jaxb.Textlayout;
import oracle.spatial.edit.model.annotationtext.AnnotationTextFeature;
import oracle.spatial.edit.model.topology.TopologyFeature;
import oracle.spatial.edit.model.topology.TopologyGeometry;
import oracle.spatial.geometry.JGeometry;
import org.codehaus.jackson.JsonFactory;
import org.codehaus.jackson.JsonParser;
import org.codehaus.jackson.JsonToken;

public class GeoJsonParser {
    private static int parseOrdinates(JsonParser jp, String type, int dim, ArrayList<Integer> elemInfo, ArrayList<Double> ordinates) throws Exception {
        if (jp == null || jp.isClosed() || !jp.hasCurrentToken()) {
            throw new Exception("The JsonParser is not ready");
        }
        if (jp.getCurrentToken() != JsonToken.START_ARRAY) {
            throw new Exception("Malformed JSON: Invalid start of coordinate data");
        }
        int gtype = -1;
        if (type.equals("Point")) {
            elemInfo.add(ordinates.size() + 1);
            elemInfo.add(1);
            elemInfo.add(1);
            while (jp.nextToken() != JsonToken.END_ARRAY) {
                ordinates.add(jp.getDoubleValue());
            }
            gtype = 1;
        } else if (type.equals("MultiPoint")) {
            elemInfo.add(ordinates.size() + 1);
            elemInfo.add(1);
            int i = 0;
            while (jp.nextToken() != JsonToken.END_ARRAY) {
                while (jp.nextToken() != JsonToken.END_ARRAY) {
                    ordinates.add(jp.getDoubleValue());
                }
                ++i;
            }
            elemInfo.add(i);
            gtype = 5;
        } else if (type.equals("OrientedPoint")) {
            elemInfo.add(ordinates.size() + 1);
            elemInfo.add(1);
            elemInfo.add(1);
            elemInfo.add(ordinates.size() + 1 + dim);
            elemInfo.add(1);
            elemInfo.add(0);
            while (jp.nextToken() != JsonToken.END_ARRAY) {
                ordinates.add(jp.getDoubleValue());
            }
            gtype = 1;
        } else if (type.equals("OrientedMultiPoint")) {
            while (jp.nextToken() != JsonToken.END_ARRAY) {
                elemInfo.add(ordinates.size() + 1);
                elemInfo.add(1);
                elemInfo.add(1);
                elemInfo.add(ordinates.size() + 1 + dim);
                elemInfo.add(1);
                elemInfo.add(0);
                while (jp.nextToken() != JsonToken.END_ARRAY) {
                    ordinates.add(jp.getDoubleValue());
                }
            }
            gtype = 5;
        } else if (type.equals("LineString")) {
            elemInfo.add(ordinates.size() + 1);
            elemInfo.add(2);
            elemInfo.add(1);
            while (jp.nextToken() != JsonToken.END_ARRAY) {
                ordinates.add(jp.getDoubleValue());
            }
            gtype = 2;
        } else if (type.equals("MultiLineString")) {
            while (jp.nextToken() != JsonToken.END_ARRAY) {
                elemInfo.add(ordinates.size() + 1);
                elemInfo.add(2);
                elemInfo.add(1);
                while (jp.nextToken() != JsonToken.END_ARRAY) {
                    ordinates.add(jp.getDoubleValue());
                }
            }
            gtype = 6;
        } else if (type.equals("Polygon")) {
            int i = 0;
            while (jp.nextToken() != JsonToken.END_ARRAY) {
                elemInfo.add(ordinates.size() + 1);
                elemInfo.add(i == 0 ? 1003 : 2003);
                elemInfo.add(1);
                while (jp.nextToken() != JsonToken.END_ARRAY) {
                    ordinates.add(jp.getDoubleValue());
                }
                ++i;
            }
            gtype = 3;
        } else if (type.equals("MultiPolygon")) {
            while (jp.nextToken() != JsonToken.END_ARRAY) {
                int i = 0;
                while (jp.nextToken() != JsonToken.END_ARRAY) {
                    elemInfo.add(ordinates.size() + 1);
                    elemInfo.add(i == 0 ? 1003 : 2003);
                    elemInfo.add(1);
                    while (jp.nextToken() != JsonToken.END_ARRAY) {
                        ordinates.add(jp.getDoubleValue());
                    }
                    ++i;
                }
            }
            gtype = 7;
        } else if (type.equals("Circle")) {
            ArrayList<Double> vals = new ArrayList<Double>();
            while (jp.nextToken() != JsonToken.END_ARRAY) {
                vals.add(jp.getDoubleValue());
            }
            double centerx = (Double)vals.get(0);
            double centery = (Double)vals.get(1);
            double radius = (Double)vals.get(2);
            elemInfo.add(ordinates.size() + 1);
            elemInfo.add(1003);
            elemInfo.add(4);
            ordinates.add(centerx);
            ordinates.add(centery - radius);
            ordinates.add(centerx + radius);
            ordinates.add(centery);
            ordinates.add(centerx);
            ordinates.add(centery + radius);
            gtype = 3;
        } else if (type.equals("Rectangle")) {
            elemInfo.add(ordinates.size() + 1);
            elemInfo.add(1003);
            elemInfo.add(3);
            while (jp.nextToken() != JsonToken.END_ARRAY) {
                ordinates.add(jp.getDoubleValue());
            }
            gtype = 3;
        } else {
            throw new Exception("Not of an expected type");
        }
        return gtype;
    }

    private static int parseJSONGeometry(JsonParser jp, ArrayList<Integer> elemInfo, ArrayList<Double> ordinates) throws Exception {
        if (jp == null || jp.isClosed() || !jp.hasCurrentToken()) {
            throw new Exception("The JsonParser is not ready");
        }
        if (jp.getCurrentToken() != JsonToken.START_OBJECT) {
            throw new Exception("Malformed JSON: Invalid start of geometry data");
        }
        String type = null;
        int dim = 2;
        int gtype = -1;
        boolean gtypeSet = false;
        while (jp.nextToken() != JsonToken.END_OBJECT) {
            String fieldName = jp.getCurrentName();
            jp.nextToken();
            if ("type".equalsIgnoreCase(fieldName)) {
                type = jp.getText();
                continue;
            }
            if ("dim".equalsIgnoreCase(fieldName)) {
                dim = jp.getIntValue();
                continue;
            }
            if ("coordinates".equalsIgnoreCase(fieldName)) {
                if (type == null) {
                    throw new Exception("Wrong order: Define 'type' before 'coordinates'");
                }
                gtype = dim * 1000 + GeoJsonParser.parseOrdinates(jp, type, dim, elemInfo, ordinates);
                gtypeSet = true;
                continue;
            }
            if ("geometries".equalsIgnoreCase(fieldName)) {
                int colGtype = 2000;
                while (jp.nextToken() != JsonToken.END_ARRAY) {
                    colGtype = GeoJsonParser.parseJSONGeometry(jp, elemInfo, ordinates);
                }
                int colDim = colGtype / 1000;
                gtype = colDim * 1000 + 4;
                gtypeSet = true;
                continue;
            }
            jp.skipChildren();
        }
        if (gtypeSet) {
            return gtype;
        }
        throw new Exception("Invalid geometry, missing coordinates");
    }

    private static JsonParser initParser(String data) throws Exception {
        JsonParser jp = null;
        JsonFactory f = new JsonFactory();
        jp = f.createJsonParser(data);
        if (jp.nextToken() != JsonToken.START_OBJECT) {
            throw new Exception("Malformed JSON: Invalid start of data");
        }
        return jp;
    }

    public static JGeometry GeoJson2JGeometry(String json, int srid) throws Exception {
        return GeoJsonParser.GeoJson2JGeometry(GeoJsonParser.initParser(json), srid);
    }

    public static JGeometry GeoJson2JGeometry(JsonParser jp, int srid) throws Exception {
        int i;
        ArrayList<Integer> elemInfo = new ArrayList<Integer>();
        ArrayList<Double> ordinates = new ArrayList<Double>();
        int gtype = GeoJsonParser.parseJSONGeometry(jp, elemInfo, ordinates);
        int[] elemInfoArray = new int[elemInfo.size()];
        double[] ordinateArray = new double[ordinates.size()];
        int min = elemInfo.size();
        boolean elemInfoIsMin = true;
        if (ordinates.size() < min) {
            min = ordinates.size();
            elemInfoIsMin = false;
        }
        for (i = 0; i < min; ++i) {
            elemInfoArray[i] = elemInfo.get(i);
            ordinateArray[i] = ordinates.get(i);
        }
        if (elemInfoIsMin) {
            for (i = elemInfo.size(); i < ordinates.size(); ++i) {
                ordinateArray[i] = ordinates.get(i);
            }
        } else {
            for (i = ordinates.size(); i < elemInfo.size(); ++i) {
                elemInfoArray[i] = elemInfo.get(i);
            }
        }
        return new JGeometry(gtype, srid, elemInfoArray, ordinateArray);
    }

    public static TextAttributesType GeoJson2TextAttributes(JsonParser jp) throws Exception {
        if (jp == null || jp.isClosed() || !jp.hasCurrentToken()) {
            throw new Exception("The JsonParser is not ready");
        }
        if (jp.getCurrentToken() != JsonToken.START_OBJECT) {
            throw new Exception("Malformed JSON: Invalid start of geometry data");
        }
        TextAttributesType attrs = new TextAttributesType();
        TextStyle style = new TextStyle();
        Textlayout layout = new Textlayout();
        attrs.setTextStyle(style);
        attrs.setTextlayout(layout);
        boolean fontSizeFound = false;
        while (jp.nextToken() != JsonToken.END_OBJECT) {
            String fieldName = jp.getCurrentName();
            jp.nextToken();
            if ("fontFamily".equalsIgnoreCase(fieldName)) {
                style.setFontFamily(jp.getText());
                continue;
            }
            if ("fontSize".equalsIgnoreCase(fieldName)) {
                style.setFontSize(jp.getFloatValue());
                fontSizeFound = true;
                continue;
            }
            if ("fontWeight".equalsIgnoreCase(fieldName)) {
                style.setFontWeight(jp.getText());
                continue;
            }
            if ("fontStyle".equalsIgnoreCase(fieldName)) {
                style.setFontStyle(FontStyle.fromValue((String)jp.getText()));
                continue;
            }
            if ("textDecoration".equalsIgnoreCase(fieldName)) {
                style.setTextDecoration(TextDecoration.fromValue((String)jp.getText()));
                continue;
            }
            if ("letterSpacing".equalsIgnoreCase(fieldName)) {
                style.setLetterSpacing(jp.getText());
                continue;
            }
            if ("wordSpacing".equalsIgnoreCase(fieldName)) {
                style.setWordSpacing(jp.getText());
                continue;
            }
            if ("fill".equalsIgnoreCase(fieldName)) {
                style.setFill(jp.getText());
                continue;
            }
            if ("fill-opacity".equalsIgnoreCase(fieldName)) {
                style.setFillOpacity(Float.valueOf(jp.getFloatValue()));
                continue;
            }
            if ("stroke".equalsIgnoreCase(fieldName)) {
                style.setStroke(jp.getText());
                continue;
            }
            if ("strokeWidth".equalsIgnoreCase(fieldName)) {
                style.setStrokeWidth(Float.valueOf(jp.getFloatValue()));
                continue;
            }
            if ("stroke-opacity".equalsIgnoreCase(fieldName)) {
                style.setStrokeOpacity(Float.valueOf(jp.getFloatValue()));
                continue;
            }
            if ("horizontalAlignment".equalsIgnoreCase(fieldName)) {
                layout.setHorizontalAlignment(jp.getText());
                continue;
            }
            if ("verticalAlignment".equalsIgnoreCase(fieldName)) {
                layout.setVerticalAlignment(jp.getText());
                continue;
            }
            if ("multilineJustification".equalsIgnoreCase(fieldName)) {
                layout.setMultilineJustification(jp.getText());
                continue;
            }
            if ("multilineSpacing".equalsIgnoreCase(fieldName)) {
                layout.setMultilineSpacing(Float.valueOf(jp.getFloatValue()));
                continue;
            }
            jp.skipChildren();
        }
        if (style.getFontFamily() == null) {
            throw new Exception("fontFamily is not defined");
        }
        if (!fontSizeFound) {
            throw new Exception("fontSize is not defined");
        }
        return attrs;
    }

    public static AnnotationTextElement GeoJson2AnnotationTextElement(JsonParser jp, int srid) throws Exception {
        if (jp == null || jp.isClosed() || !jp.hasCurrentToken()) {
            throw new Exception("The JsonParser is not ready");
        }
        if (jp.getCurrentToken() != JsonToken.START_OBJECT) {
            throw new Exception("Malformed JSON: Invalid start of geometry data");
        }
        AnnotationTextElement element = new AnnotationTextElement();
        while (jp.nextToken() != JsonToken.END_OBJECT) {
            String fieldName = jp.getCurrentName();
            jp.nextToken();
            if ("location".equalsIgnoreCase(fieldName)) {
                JGeometry loc = GeoJsonParser.GeoJson2JGeometry(jp, srid);
                element.setLocation(loc);
                continue;
            }
            if ("textValue".equalsIgnoreCase(fieldName)) {
                element.setValue(jp.getText());
                continue;
            }
            if ("leaderLine".equalsIgnoreCase(fieldName)) {
                JGeometry line = GeoJsonParser.GeoJson2JGeometry(jp, srid);
                element.setLeaderLine(line);
                continue;
            }
            if ("textAttributes".equalsIgnoreCase(fieldName)) {
                element.setAttributes(GeoJsonParser.GeoJson2TextAttributes(jp));
                continue;
            }
            jp.skipChildren();
        }
        return element;
    }

    public static Object GeoJson2TopoPrimitive(JsonParser jp, int srid) throws Exception {
        if (jp == null || jp.isClosed() || !jp.hasCurrentToken()) {
            throw new Exception("The JsonParser is not ready");
        }
        if (jp.getCurrentToken() != JsonToken.START_OBJECT) {
            throw new Exception("Malformed JSON: Invalid start of feature data");
        }
        String type = null;
        TopologyNode node = null;
        TopologyEdge edge = null;
        TopologyFace face = null;
        while (jp.nextToken() != JsonToken.END_OBJECT) {
            String fieldName = jp.getCurrentName();
            jp.nextToken();
            if ("type".equalsIgnoreCase(fieldName)) {
                type = jp.getText();
                if (type.equalsIgnoreCase("Node")) {
                    node = new TopologyNode();
                    continue;
                }
                if (type.equalsIgnoreCase("Edge")) {
                    edge = new TopologyEdge();
                    continue;
                }
                if (!type.equalsIgnoreCase("Face")) continue;
                face = new TopologyFace();
                continue;
            }
            if ("geometry".equalsIgnoreCase(fieldName) || "mbr_geometry".equalsIgnoreCase(fieldName)) {
                JGeometry geom = GeoJsonParser.GeoJson2JGeometry(jp, srid);
                if (type.equalsIgnoreCase("Node")) {
                    node.setGeometry(geom);
                    continue;
                }
                if (type.equalsIgnoreCase("Edge")) {
                    edge.setGeometry(geom);
                    continue;
                }
                if (!type.equalsIgnoreCase("Face")) continue;
                face.setMBRGeometry(geom);
                continue;
            }
            if ("properties".equalsIgnoreCase(fieldName)) {
                while (jp.nextToken() != JsonToken.END_OBJECT) {
                    int i;
                    ArrayList<String> list;
                    String propValue;
                    String propField = jp.getCurrentName();
                    jp.nextToken();
                    if (type.equalsIgnoreCase("Node")) {
                        propValue = jp.getText();
                        int val = Integer.parseInt(propValue);
                        if ("NODE_ID".equalsIgnoreCase(propField)) {
                            node.setId(val);
                            continue;
                        }
                        if ("EDGE_ID".equalsIgnoreCase(propField)) {
                            node.setStartEdge(val);
                            continue;
                        }
                        if (!"FACE_ID".equalsIgnoreCase(propField)) continue;
                        node.setContainFace(val);
                        continue;
                    }
                    if (type.equalsIgnoreCase("Edge")) {
                        propValue = jp.getText();
                        int val = Integer.parseInt(propValue);
                        if ("EDGE_ID".equalsIgnoreCase(propField)) {
                            edge.setId(val);
                            continue;
                        }
                        if ("START_NODE_ID".equalsIgnoreCase(propField)) {
                            edge.setOriginNode(val);
                            continue;
                        }
                        if ("END_NODE_ID".equalsIgnoreCase(propField)) {
                            edge.setEndNode(val);
                            continue;
                        }
                        if ("NEXT_LEFT_EDGE_ID".equalsIgnoreCase(propField)) {
                            edge.setNextEdgeL(val);
                            continue;
                        }
                        if ("PREV_LEFT_EDGE_ID".equalsIgnoreCase(propField)) {
                            edge.setPrevEdgeL(val);
                            continue;
                        }
                        if ("NEXT_RIGHT_EDGE_ID".equalsIgnoreCase(propField)) {
                            edge.setNextEdgeR(val);
                            continue;
                        }
                        if ("PREV_RIGHT_EDGE_ID".equalsIgnoreCase(propField)) {
                            edge.setPrevEdgeR(val);
                            continue;
                        }
                        if ("LEFT_FACE_ID".equalsIgnoreCase(propField)) {
                            edge.setBoundedFaceL(val);
                            continue;
                        }
                        if (!"RIGHT_FACE_ID".equalsIgnoreCase(propField)) continue;
                        edge.setBoundedFaceR(val);
                        continue;
                    }
                    if (!type.equalsIgnoreCase("Face")) continue;
                    if ("FACE_ID".equalsIgnoreCase(propField)) {
                        propValue = jp.getText();
                        face.setId(Integer.parseInt(propValue));
                        continue;
                    }
                    if ("BOUNDARY_EDGE_ID".equalsIgnoreCase(propField)) {
                        propValue = jp.getText();
                        face.setBoundaryEdge(Integer.parseInt(propValue));
                        continue;
                    }
                    if ("ISLAND_EDGE_ID_LIST".equalsIgnoreCase(propField)) {
                        list = new ArrayList<String>();
                        while (jp.nextToken() != JsonToken.END_ARRAY) {
                            list.add(jp.getText());
                        }
                        int[] int_arr = new int[list.size()];
                        for (i = 0; i < list.size(); ++i) {
                            int_arr[i] = Integer.parseInt((String)list.get(i));
                        }
                        face.setIslandEdges(int_arr);
                        continue;
                    }
                    if (!"ISLAND_NODE_ID_LIST".equalsIgnoreCase(propField)) continue;
                    list = new ArrayList();
                    while (jp.nextToken() != JsonToken.END_ARRAY) {
                        list.add(jp.getText());
                    }
                    int[] int_arr = new int[list.size()];
                    for (i = 0; i < list.size(); ++i) {
                        int_arr[i] = Integer.parseInt((String)list.get(i));
                    }
                    face.setIslandNodes(int_arr);
                }
                continue;
            }
            jp.skipChildren();
        }
        if (type.equalsIgnoreCase("Node")) {
            return node;
        }
        if (type.equalsIgnoreCase("Edge")) {
            return edge;
        }
        if (type.equalsIgnoreCase("Face")) {
            return face;
        }
        return null;
    }

    private static void addTopoPrimitiveDescriptor(JsonParser jp, TopologyGeometry geom) throws Exception {
        int id = -1;
        int type = -1;
        while (jp.nextToken() != JsonToken.END_OBJECT) {
            String fieldName = jp.getCurrentName();
            jp.nextToken();
            if ("topo_id".equalsIgnoreCase(fieldName)) {
                id = jp.getIntValue();
                continue;
            }
            if (!"topo_type".equalsIgnoreCase(fieldName)) continue;
            type = jp.getIntValue();
        }
        geom.addTopoPrimitive(id, type);
    }

    private static void addTopoChildFeatureDescriptor(JsonParser jp, TopologyGeometry geom) throws Exception {
        int layerId = -1;
        int featureId = -1;
        while (jp.nextToken() != JsonToken.END_OBJECT) {
            String fieldName = jp.getCurrentName();
            jp.nextToken();
            if ("layer_id".equalsIgnoreCase(fieldName)) {
                layerId = jp.getIntValue();
                continue;
            }
            if (!"feature_id".equalsIgnoreCase(fieldName)) continue;
            featureId = jp.getIntValue();
        }
        geom.addChildFeature(layerId, featureId);
    }

    public static AbstractFeature GeoJson2Feature(JsonParser jp, int srid, Hashtable<String, String> attrtypes) throws Exception {
        if (jp == null || jp.isClosed() || !jp.hasCurrentToken()) {
            throw new Exception("The JsonParser is not ready");
        }
        if (jp.getCurrentToken() != JsonToken.START_OBJECT) {
            throw new Exception("Malformed JSON: Invalid start of feature data");
        }
        AbstractFeature feature = null;
        AnnotationText annotext = null;
        TopologyGeometry topoGeom = null;
        while (jp.nextToken() != JsonToken.END_OBJECT) {
            String fieldName = jp.getCurrentName();
            jp.nextToken();
            if ("type".equalsIgnoreCase(fieldName)) {
                String type = jp.getText();
                if (type.equalsIgnoreCase("feature")) {
                    feature = new GeometryFeature();
                    continue;
                }
                if (type.equalsIgnoreCase("annotext")) {
                    feature = new AnnotationTextFeature();
                    annotext = new AnnotationText();
                    feature.setSpatialAttribute(annotext);
                    continue;
                }
                if (!type.equalsIgnoreCase("topology")) continue;
                feature = new TopologyFeature();
                topoGeom = new TopologyGeometry();
                feature.setSpatialAttribute(topoGeom);
                continue;
            }
            if ("geometry".equalsIgnoreCase(fieldName)) {
                JGeometry geom = GeoJsonParser.GeoJson2JGeometry(jp, srid);
                feature.setSpatialAttribute(geom);
                continue;
            }
            if ("envelope".equalsIgnoreCase(fieldName)) {
                JGeometry env = GeoJsonParser.GeoJson2JGeometry(jp, srid);
                annotext.setEnvelope(env);
                continue;
            }
            if ("elements".equalsIgnoreCase(fieldName)) {
                while (jp.nextToken() != JsonToken.END_ARRAY) {
                    annotext.addElement(GeoJsonParser.GeoJson2AnnotationTextElement(jp, srid));
                }
                continue;
            }
            if ("tg_id".equalsIgnoreCase(fieldName)) {
                topoGeom.setId(jp.getIntValue());
                continue;
            }
            if ("primitives".equalsIgnoreCase(fieldName)) {
                while (jp.nextToken() != JsonToken.END_ARRAY) {
                    GeoJsonParser.addTopoPrimitiveDescriptor(jp, topoGeom);
                }
                continue;
            }
            if ("child_features".equalsIgnoreCase(fieldName)) {
                while (jp.nextToken() != JsonToken.END_ARRAY) {
                    GeoJsonParser.addTopoChildFeatureDescriptor(jp, topoGeom);
                }
                continue;
            }
            if ("properties".equalsIgnoreCase(fieldName)) {
                while (jp.nextToken() != JsonToken.END_OBJECT) {
                    String t;
                    String propField = jp.getCurrentName();
                    jp.nextToken();
                    String propValue = jp.getText();
                    String attrType = "string";
                    if (attrtypes != null && (t = attrtypes.get(propField)) != null) {
                        attrType = t;
                    }
                    if (propValue.isEmpty() || propValue.equalsIgnoreCase("null")) {
                        propValue = null;
                    }
                    feature.setAttribute(propField, Field.createField((String)propValue, (String)attrType));
                }
                continue;
            }
            jp.skipChildren();
        }
        return feature;
    }
}

