/*
 * Decompiled with CFR 0.152.
 */
package oracle.maps.util;

import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.List;
import java.util.TreeSet;

public class TransformUtils {
    public static double getWCTolerance(Point2D wcCenter, int pixelTolerance, AffineTransform xfm) {
        try {
            Point2D.Double xy = new Point2D.Double();
            xfm.transform(wcCenter, xy);
            Point2D.Double UL = new Point2D.Double();
            xfm.inverseTransform(new Point2D.Double(((Point2D)xy).getX() - (double)pixelTolerance, ((Point2D)xy).getY() - (double)pixelTolerance), UL);
            double dx = wcCenter.getX() - ((Point2D)UL).getX();
            double dy = ((Point2D)UL).getY() - wcCenter.getY();
            double wcTolerance = Math.sqrt(dx * dx + dy * dy);
            return wcTolerance;
        }
        catch (Exception ex) {
            return 0.0;
        }
    }

    public static double transformMagnitude(double mag, AffineTransform xfm) {
        Point2D.Double o = new Point2D.Double(0.0, 0.0);
        xfm.transform(o, o);
        double c = Math.sqrt(mag * mag / 2.0);
        Point2D.Double p = new Point2D.Double(c, c);
        xfm.transform(p, p);
        return p.distance(o);
    }

    public static List<Rectangle2D> areaToRectangles(Area area) {
        TreeSet<Double> xCoords = new TreeSet<Double>();
        TreeSet<Double> yCoords = new TreeSet<Double>();
        if (area != null && !area.isEmpty()) {
            PathIterator pi = area.getPathIterator(null);
            double[] coords = new double[6];
            while (!pi.isDone()) {
                pi.currentSegment(coords);
                xCoords.add(coords[0]);
                yCoords.add(coords[1]);
                pi.next();
            }
        }
        int numX = xCoords.size();
        int numY = yCoords.size();
        ArrayList<Rectangle2D> rectangles = new ArrayList<Rectangle2D>((numX - 1) * (numY - 1));
        if (numX >= 2 && numY >= 2) {
            Double[] xs = xCoords.toArray(new Double[numX]);
            Double[] ys = yCoords.toArray(new Double[numY]);
            Rectangle2D[][] recs = new Rectangle2D[numX - 1][numY - 1];
            for (int i = 0; i < numX - 1; ++i) {
                for (int j = 0; j < numY - 1; ++j) {
                    Rectangle2D.Double rectangle = new Rectangle2D.Double(xs[i], ys[j], xs[i + 1] - xs[i], ys[j + 1] - ys[j]);
                    if (!area.contains(rectangle.getCenterX(), rectangle.getCenterY())) continue;
                    recs[i][j] = rectangle;
                    rectangles.add(rectangle);
                }
            }
        }
        return rectangles;
    }
}

