/*
 * Decompiled with CFR 0.152.
 */
package oracle.mdeditor.thread;

import java.util.Vector;
import oracle.mapviewer.share.MVThemeMetadata;
import oracle.mapviewer.share.MVTileLayerMetadata;
import oracle.mapviewer.share.Sequence;
import oracle.mapviewer.share.SpatialTableMetadata;
import oracle.mdeditor.ui.ProgressDialog;
import oracle.mdeditor.ui.resources.MessagesBundle;
import oracle.spatial.edit.model.AbstractDataAccessObject;
import oracle.spatial.edit.model.AbstractDataSource;
import oracle.spatial.edit.model.MDSException;
import oracle.spatial.edit.util.DataSourceMetadata;

public class LoadConnectionThread
extends Thread {
    private AbstractDataSource dataSourceConn = null;
    private DataSourceMetadata dataSourceMeta = null;
    private ProgressDialog pgrdlg = null;
    private boolean success = false;

    public LoadConnectionThread(AbstractDataSource datasourceConnection, DataSourceMetadata dsrcMetadata, ProgressDialog dlg) {
        this.dataSourceConn = datasourceConnection;
        this.dataSourceMeta = dsrcMetadata;
        this.pgrdlg = dlg;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        this.success = false;
        if (this.dataSourceConn == null) {
            return;
        }
        if (this.dataSourceMeta == null) {
            return;
        }
        AbstractDataAccessObject dataAccess = null;
        Object sessionNames = null;
        Vector<SpatialTableMetadata> sptMeta = null;
        Vector<MVThemeMetadata> mvPredThemes = null;
        Vector<MVTileLayerMetadata> mvTileLayers = null;
        Vector<String> mvBaseMaps = null;
        Vector<Sequence> dbSequences = null;
        Vector<String> topologyNames = null;
        try {
            this.pgrdlg.setTitle(MessagesBundle.getMessage("Loading_mapviewer_data"));
            this.pgrdlg.setTaskMessage(MessagesBundle.getMessage("Task_opening_connection"));
            dataAccess = this.dataSourceConn.getDataAccessObject();
            dataAccess.openConnection();
            this.pgrdlg.setTaskMessage(MessagesBundle.getMessage("Task_get_spatial_tables"));
            sptMeta = dataAccess.getSpatialTablesMetadata();
            this.pgrdlg.setTaskMessage(MessagesBundle.getMessage("Task_get_predefined_themes"));
            mvPredThemes = dataAccess.getMapViewerThemesMetadata();
            this.pgrdlg.setTaskMessage(MessagesBundle.getMessage("Task_get_base_maps"));
            mvBaseMaps = dataAccess.getMapViewerBaseMaps();
            this.pgrdlg.setTaskMessage(MessagesBundle.getMessage("Task_get_tile_layers"));
            mvTileLayers = dataAccess.getMapViewerTileLayersMetadata();
            this.pgrdlg.setTaskMessage(MessagesBundle.getMessage("Task_get_topo_models"));
            String[] topologies = dataAccess.getTopologyNames();
            if (topologies != null && topologies.length > 0) {
                topologyNames = new Vector<String>();
                for (int i = 0; i < topologies.length; ++i) {
                    topologyNames.add(topologies[i]);
                }
            }
            this.pgrdlg.setTaskMessage(MessagesBundle.getMessage("Task_get_sequences"));
            dbSequences = dataAccess.getSequences();
            this.dataSourceMeta.clear();
            if (sessionNames != null && (sessionNames).length > 0) {
                Vector<String> sns = new Vector<String>();
                for (int i = 0; i < (sessionNames).length; ++i) {
                    sns.add(sessionNames[i].trim());
                }
                this.dataSourceMeta.setEditSessionNames(sns);
            }
            this.dataSourceMeta.setSpatialTableMetadata(sptMeta);
            this.dataSourceMeta.setMVPredefinedThemeMetadata(mvPredThemes);
            this.dataSourceMeta.setMVBaseMaps(mvBaseMaps);
            this.dataSourceMeta.setMVTileLayerMetadata(mvTileLayers);
            this.dataSourceMeta.setSequences(dbSequences);
            this.success = true;
        }
        catch (MDSException ex) {
            System.out.println("Exception: " + ex.getMessage());
            ex.printStackTrace();
        }
        catch (Exception ex) {
            System.out.println("Exception: " + ex.getMessage());
            ex.printStackTrace();
        }
        finally {
            if (dataAccess != null) {
                try {
                    dataAccess.closeConnection();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        this.pgrdlg.setVisible(false);
    }

    public boolean success() {
        return this.success;
    }
}

