/*
 * Decompiled with CFR 0.152.
 */
package oracle.mdeditor.ui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import oracle.bali.ewt.border.TitledPane;
import oracle.mapviewer.share.style.StyleModel;
import oracle.mdeditor.ui.LabelingStylePicker;
import oracle.mdeditor.ui.MainAppPanel;
import oracle.mdeditor.ui.RenderingStylePicker;
import oracle.mdeditor.ui.resources.MessagesBundle;

public class RenderLabelPanel
extends JPanel {
    private TitledPane renderPanel = new TitledPane();
    private JCheckBox renderBox = new JCheckBox();
    private RenderingStylePicker renderStyle = null;
    private TitledPane labelPanel = new TitledPane();
    private JCheckBox labelBox = new JCheckBox();
    private LabelingStylePicker labelStyle = null;

    public RenderLabelPanel(MainAppPanel mainApp) {
        this.renderStyle = new RenderingStylePicker(null);
        this.labelStyle = new LabelingStylePicker(null);
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        this.setLayout(new GridBagLayout());
        this.renderBox.setText(MessagesBundle.getMessage("Checkbox_render"));
        this.labelBox.setText(MessagesBundle.getMessage("Checkbox_label"));
        this.renderStyle.setApplyButtonVisible(false);
        this.labelStyle.setApplyButtonVisible(false);
        this.renderPanel.setTitle((Component)this.renderBox);
        this.renderPanel.setContent((Component)this.renderStyle);
        this.labelPanel.setTitle((Component)this.labelBox);
        this.labelPanel.setContent((Component)this.labelStyle);
        JPanel spacer = new JPanel();
        spacer.setPreferredSize(new Dimension(0, 0));
        this.add((Component)this.renderPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(5, 5, 0, 5), 0, 0));
        this.add((Component)this.labelPanel, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 10, 1, new Insets(5, 5, 0, 5), 0, 0));
        this.add((Component)spacer, new GridBagConstraints(0, 2, 2, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
    }

    public boolean isRenderSelected() {
        return this.renderBox.isSelected();
    }

    public void setRenderSelected(boolean selected) {
        this.renderBox.setSelected(selected);
    }

    public StyleModel getRenderStyleModel() {
        return this.renderStyle.getStyleModel();
    }

    public void setRenderStyle(String style) {
        this.renderStyle.setStyleParameters(style);
    }

    public boolean isLabelSelected() {
        return this.labelBox.isSelected();
    }

    public void setLabelSelected(boolean selected) {
        this.labelBox.setSelected(selected);
    }

    public StyleModel getLabelStyleModel() {
        return this.labelStyle.getStyleModel();
    }

    public void setLabelStyle(String style) {
        this.labelStyle.setStyleParameters(style);
    }

    public void setRenderColorTabEnabled(boolean enabled) {
        this.renderStyle.setColorTabEnabled(enabled);
    }

    public void setRenderLineTabEnabled(boolean enabled) {
        this.renderStyle.setLineTabEnabled(enabled);
    }

    public void setRenderMarkerTabEnabled(boolean enabled) {
        this.renderStyle.setMarkerTabEnabled(enabled);
    }
}

