/*
 * Decompiled with CFR 0.152.
 */
package oracle.mdeditor.ui.actiongroup;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.Point2D;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JToggleButton;
import oracle.maps.core.GeoObject;
import oracle.maps.core.Layer;
import oracle.maps.core.LayerManager;
import oracle.maps.core.MapCanvas;
import oracle.maps.tools.PenTool;
import oracle.mdeditor.resources.icons.Icons;
import oracle.mdeditor.session.EditSession;
import oracle.mdeditor.ui.AnnotationTextElementPanel;
import oracle.mdeditor.ui.EditSessionPanel;
import oracle.mdeditor.ui.ErrorDialog;
import oracle.mdeditor.ui.MainAppPanel;
import oracle.mdeditor.ui.OlafDialog;
import oracle.mdeditor.ui.actiongroup.BasicToolsPane;
import oracle.mdeditor.ui.resources.MessagesBundle;
import oracle.sdovis.edit.util.JGeometryUtil;
import oracle.sdovis.text.AnnotationText;
import oracle.spatial.edit.layer.AnnotationTextSetLayer;
import oracle.spatial.edit.model.annotationtext.AnnotationTextFeature;
import oracle.spatial.geometry.JGeometry;

public class AnnotationTextToolsPane
extends BasicToolsPane {
    private JToggleButton addatextelem = new JToggleButton(Icons.getIcon("addannotext.png"));
    private JButton removeatextelem = new JButton(Icons.getIcon("remannotext.png"));
    private JToggleButton addleaderline = new JToggleButton(Icons.getIcon("addleaderline.png"));
    private JButton removeleaderline = new JButton(Icons.getIcon("remleaderline.png"));
    private JButton editatextelem = new JButton(Icons.getIcon("editannotext.png"));
    private JButton atextelemorientation = new JButton(Icons.getIcon("rotateannotext.png"));

    public AnnotationTextToolsPane(MainAppPanel mainApp) {
        super(mainApp);
        this.buttons = new AbstractButton[]{this.addatextelem, this.removeatextelem, this.editatextelem, this.addleaderline, this.removeleaderline, this.atextelemorientation};
        this.setName(MessagesBundle.getMessage("Annotation_text"));
        ButtonGroup bg = mainApp.getButtonGroup("toolsBG");
        bg.add(this.addatextelem);
        bg.add(this.addleaderline);
        this.addatextelem.setToolTipText(MessagesBundle.getMessage("Tooltip_add_annotation_element"));
        this.addatextelem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MapCanvas canvas = AnnotationTextToolsPane.this.getMapCanvas();
                if (canvas != null) {
                    PenTool penTool = new PenTool(canvas);
                    penTool.setModifier("penpoint");
                    penTool.setMainApp(AnnotationTextToolsPane.this.getMainApp());
                    AnnotationTextToolsPane.this.getMainApp().setTool(penTool);
                }
            }
        });
        this.removeatextelem.setToolTipText(MessagesBundle.getMessage("Tooltip_remove_annotation_element"));
        this.removeatextelem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MapCanvas canvas = AnnotationTextToolsPane.this.getMapCanvas();
                if (canvas == null) {
                    return;
                }
                try {
                    AnnotationTextSetLayer layer = (AnnotationTextSetLayer)canvas.getLayerManager().getLayerByTag("targetLayer");
                    AnnotationTextFeature selected = (AnnotationTextFeature)layer.getSelection().get(0);
                    int elemIndex = selected.getElement();
                    if (elemIndex > -1) {
                        layer.removeTextElement(selected.getKey().toString(), elemIndex);
                        layer.clearSelection();
                    }
                }
                catch (Exception ex) {
                    ErrorDialog.showErrorDialog(ex, canvas.getFrameForDialog(), "could not remove text element", "Error", 0);
                }
            }
        });
        this.addleaderline.setToolTipText(MessagesBundle.getMessage("Tooltip_add_leader_line"));
        this.addleaderline.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MapCanvas canvas = AnnotationTextToolsPane.this.getMapCanvas();
                if (canvas != null) {
                    PenTool penTool = new PenTool(canvas);
                    penTool.setAsClosedPath(false);
                    penTool.setModifier("penline");
                    penTool.setMainApp(AnnotationTextToolsPane.this.getMainApp());
                    AnnotationTextToolsPane.this.getMainApp().setTool(penTool);
                }
            }
        });
        this.removeleaderline.setToolTipText(MessagesBundle.getMessage("Tooltip_remove_leader_line"));
        this.removeleaderline.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MapCanvas canvas = AnnotationTextToolsPane.this.getMapCanvas();
                if (canvas == null) {
                    return;
                }
                try {
                    AnnotationTextSetLayer layer = (AnnotationTextSetLayer)canvas.getLayerManager().getLayerByTag("targetLayer");
                    AnnotationTextFeature selected = (AnnotationTextFeature)layer.getSelection().get(0);
                    int elemIndex = selected.getElement();
                    if (elemIndex > -1) {
                        layer.removeTextElementLeaderLine(selected.getKey().toString(), elemIndex);
                    }
                }
                catch (Exception ex) {
                    ErrorDialog.showErrorDialog(ex, canvas.getFrameForDialog(), "could not remove leader line", "Error", 0);
                }
            }
        });
        this.editatextelem.setToolTipText(MessagesBundle.getMessage("Tooltip_edit_annotation_element"));
        this.editatextelem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MapCanvas canvas = AnnotationTextToolsPane.this.getMapCanvas();
                if (canvas == null) {
                    return;
                }
                try {
                    AnnotationTextSetLayer layer = (AnnotationTextSetLayer)canvas.getLayerManager().getLayerByTag("targetLayer");
                    AnnotationTextFeature selected = (AnnotationTextFeature)layer.getSelection().get(0);
                    int elemIndex = selected.getElement();
                    if (elemIndex > -1) {
                        AnnotationTextElementPanel atextPanel = new AnnotationTextElementPanel(layer, selected, elemIndex);
                        atextPanel.resetUndoSteps();
                        atextPanel.setDrawPanel(canvas);
                        OlafDialog txtDlg = new OlafDialog(canvas.getFrameForDialog(), "Annotation Text Element", atextPanel, 0.9f);
                        txtDlg.setAsCloseSelection(true);
                        txtDlg.setSize(340, 490);
                        txtDlg.setVisible(true);
                        txtDlg.dispose();
                    }
                }
                catch (Exception ex) {
                    ErrorDialog.showErrorDialog(ex, canvas.getFrameForDialog(), "could not edit text element", "Error", 0);
                }
            }
        });
        this.atextelemorientation.setToolTipText(MessagesBundle.getMessage("Tooltip_change_annotation_element_orientation"));
        this.atextelemorientation.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MapCanvas canvas = AnnotationTextToolsPane.this.getMapCanvas();
                if (canvas == null) {
                    return;
                }
                try {
                    AnnotationTextSetLayer layer = (AnnotationTextSetLayer)canvas.getLayerManager().getLayerByTag("targetLayer");
                    AnnotationTextFeature selected = (AnnotationTextFeature)layer.getSelection().get(0);
                    int elemIndex = selected.getElement();
                    if (elemIndex > -1) {
                        String tooltip;
                        Point2D pt;
                        JGeometry loc = selected.getSpatialAttribute().getElementLocation(elemIndex);
                        if (loc == null || loc.getType() != 1) {
                            throw new Exception("Annotation element location is not a point.");
                        }
                        double x = 0.0;
                        double y = 0.0;
                        int dim = loc.getDimensions();
                        if (loc.isOrientedPoint()) {
                            double[] oords = loc.getOrdinatesArray();
                            if (oords == null) {
                                throw new Exception("ordinates array is null.");
                            }
                            x = oords[dim];
                            y = oords[dim + 1];
                        }
                        if ((pt = EditSessionPanel.getXYOperationValues("Oriented vector values", "X axis:", tooltip = "Value range [-1,1]", x, "Y axis:", tooltip, y, canvas.getFrameForDialog())) == null) {
                            throw new Exception("Null values.");
                        }
                        double orientX = pt.getX();
                        double orientY = pt.getY();
                        if (Double.isNaN(orientX) || Double.isNaN(orientY)) {
                            throw new Exception("Invalid oriented vector values (must be numeric).");
                        }
                        double[] orientData = new double[dim];
                        for (int i = 0; i < dim; ++i) {
                            orientData[i] = 0.0;
                        }
                        orientData[0] = orientX;
                        orientData[1] = orientY;
                        JGeometry change = JGeometryUtil.changePointOrientation((JGeometry)loc, (int)elemIndex, (double[])orientData);
                        if (change == null) {
                            throw new Exception("Unable to change text element orientation.");
                        }
                        layer.updateTextElementLocation(selected.getKey().toString(), elemIndex, change);
                    }
                }
                catch (Exception ex) {
                    ErrorDialog.showErrorDialog(ex, canvas.getFrameForDialog(), "could not update point orientation", "Error", 0);
                }
            }
        });
        for (AbstractButton btn : this.buttons) {
            this.add(btn);
        }
    }

    @Override
    public void updateButtonsStatus() {
        AnnotationText geom;
        EditSession editSession = this.mainApp.getEditSessionPanel().getEditSession();
        if (editSession == null) {
            return;
        }
        MapCanvas canvas = this.getMapCanvas();
        if (canvas == null) {
            return;
        }
        LayerManager lm = canvas.getLayerManager();
        Layer l = lm.getLayerByTag("targetLayer");
        if (!(l instanceof AnnotationTextSetLayer)) {
            return;
        }
        AnnotationTextSetLayer targetLayer = (AnnotationTextSetLayer)l;
        List<GeoObject> targetSelected = targetLayer.getSelection();
        if (targetSelected.size() > 1) {
            return;
        }
        this.addatextelem.setEnabled(true);
        if (targetSelected.size() == 1 && (geom = ((AnnotationTextFeature)targetSelected.get(0)).getSpatialAttribute()) != null) {
            boolean lineSelected;
            this.atextelemorientation.setEnabled(true);
            this.editatextelem.setEnabled(true);
            if (geom.getNumberOfElements() > 1) {
                this.removeatextelem.setEnabled(true);
            }
            boolean bl = lineSelected = ((AnnotationTextFeature)targetSelected.get(0)).getComponent() == AnnotationTextFeature.COMP_LEADERLINE;
            if (!lineSelected) {
                this.addleaderline.setEnabled(true);
            } else {
                this.removeleaderline.setEnabled(true);
            }
        }
    }
}

