/*
 * Decompiled with CFR 0.152.
 */
package oracle.spatial.edit.util;

import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Properties;
import java.util.logging.Logger;
import oracle.maps.core.MVImageLayerProvider;
import oracle.mapviewer.share.SpatialTableMetadata;
import oracle.mapviewer.share.util.LogFactory;
import oracle.mdeditor.EditorAppletInfo;
import oracle.mdeditor.session.EditSession;
import oracle.mdeditor.session.layer.LayerProvider;
import oracle.mdeditor.ui.MainAppPanel;
import oracle.mdeditor.ui.resources.MessagesBundle;
import oracle.sdovis.util.HttpConnection;
import oracle.spatial.edit.layer.MVVectorLayerProvider;
import oracle.spatial.edit.model.AbstractDataAccessObject;
import oracle.spatial.edit.model.AbstractDataSource;
import oracle.spatial.edit.model.MDSException;
import oracle.spatial.edit.model.XMLDataSource;
import oracle.spatial.edit.session.MDSEditSession;

public class MVConnection {
    private static final Logger log = LogFactory.getLogger((LogFactory.LoggerEnum)LogFactory.LoggerEnum.MAPEDITOR);
    private MainAppPanel mainApp = null;
    private String serverURL = null;
    private String editor = null;
    private String jSessionID = null;
    private ArrayList<DataSource> dataSources = null;

    public MVConnection(String serverURL, String editor, MainAppPanel mainApp, String jSessionID) {
        this.serverURL = serverURL;
        this.editor = editor;
        this.mainApp = mainApp;
        this.jSessionID = jSessionID;
    }

    public ArrayList<DataSource> getDataSources() throws Exception {
        if (this.dataSources == null) {
            this.fillDataSources();
        }
        return this.dataSources;
    }

    public void clearDataSources() {
        this.dataSources = null;
    }

    private void fillDataSources() throws Exception {
        String dsrcReq = "<?xml version=\"1.0\" standalone=\"yes\"?>\n <non_map_request>\n   <list_editable_data_sources />\n </non_map_request> ";
        String mvURL = this.serverURL;
        if (mvURL == null) {
            return;
        }
        mvURL = mvURL + "/omserver";
        log.info("Issuing list editable data sources request ...");
        HttpConnection httpConn = new HttpConnection();
        if (!httpConn.connect(mvURL)) {
            log.warning(MessagesBundle.getFormattedMessage("Unable_toconnect_with_server", mvURL));
            return;
        }
        String response = null;
        try {
            httpConn.setContentTypeProperty("application/x-www-form-urlencoded");
            httpConn.sendXMLRequest("xml_request", dsrcReq);
            response = httpConn.getXMLResponse();
        }
        catch (Exception ex) {
            throw ex;
        }
        finally {
            if (httpConn != null) {
                httpConn.disConnect();
            }
        }
        log.info("Done with list editable data sources request.");
        if (response == null) {
            log.warning("Null response for list editable data sources request");
            return;
        }
        this.dataSources = new ArrayList(1);
        int idx = response.indexOf("<map_data_source name=\"");
        while (idx > 0) {
            int idx2 = response.indexOf("\"", idx + 24);
            String dsrc = response.substring(idx + 23, idx2);
            if (dsrc != null) {
                this.dataSources.add(new DataSource(this.serverURL, dsrc, this.editor, this.mainApp, this.jSessionID));
            }
            response = response.substring(idx2 + 1);
            idx = response.indexOf("<map_data_source name=\"");
        }
    }

    public String getServerURL() {
        return this.serverURL;
    }

    public String getEditor() {
        return this.editor;
    }

    public String getJSessionID() {
        return this.jSessionID;
    }

    public static class DataSource {
        public static final MDSEditSession NULLSESSIONMARKER = new MDSEditSession(null, null, null);
        private AbstractDataSource dataSource = null;
        private Hashtable<String, MDSEditSession> editSessions = null;
        private Hashtable<String, LayerProvider> layerProviders = new Hashtable(4);
        private MainAppPanel mainApp = null;

        public DataSource(String serverURL, String dataSourceName, String editor, MainAppPanel mainApp, String javaSessionID) {
            if (serverURL == null || dataSourceName == null || editor == null) {
                throw new NullPointerException();
            }
            this.mainApp = mainApp;
            Properties props = new Properties();
            props.setProperty("serverURL", serverURL);
            props.setProperty("dataSource", dataSourceName);
            props.setProperty("editor", editor);
            if (javaSessionID == null) {
                String jsessionid;
                String appletBaseURL;
                EditorAppletInfo appletInfo = mainApp.getContextBean();
                if (appletInfo != null && (serverURL.equalsIgnoreCase(appletBaseURL = appletInfo.getMapViewerBaseUrl()) || this.areSameLocalHosts(serverURL, appletBaseURL)) && (jsessionid = appletInfo.getApplet().getParameter("session_id")) != null && !jsessionid.trim().isEmpty()) {
                    props.setProperty("jsessionID", jsessionid);
                    log.info("Session ID set for data source [" + dataSourceName + "].");
                }
            } else {
                props.setProperty("jsessionID", javaSessionID);
                log.info("Session ID set for data source [" + dataSourceName + "].");
            }
            this.dataSource = new XMLDataSource(dataSourceName);
            this.dataSource.init(props);
            this.layerProviders.put("Geometry layers", new MVVectorLayerProvider(SpatialTableMetadata.GEOMETRY_TYPE, mainApp, this.dataSource));
            this.layerProviders.put("Predefined Themes", new MVImageLayerProvider(0, mainApp, this.dataSource));
            this.layerProviders.put("Base Maps", new MVImageLayerProvider(1, mainApp, this.dataSource));
            this.layerProviders.put("Tile Cache", new MVImageLayerProvider(2, mainApp, this.dataSource));
            log.info("Data source created [" + dataSourceName + "].");
        }

        public String getName() {
            String name = null;
            if (this.dataSource != null) {
                name = this.dataSource.getName();
            }
            return name;
        }

        public Hashtable<String, MDSEditSession> getEditSessions() throws Exception {
            if (this.editSessions == null) {
                this.fetchEditSessions();
            }
            return this.editSessions;
        }

        private void fetchEditSessions() throws Exception {
            if (this.dataSource == null) {
                return;
            }
            String[] names = null;
            AbstractDataAccessObject dao = this.dataSource.getDataAccessObject();
            Object exception = null;
            log.info("Loading edit sessions for editor [" + this.dataSource.getConnectionProperties().getProperty("editor") + "] and data source [" + this.getName() + "] ...");
            try {
                dao.openConnection();
                names = dao.getEditorSessions();
            }
            catch (MDSException ex) {
                throw new Exception(ex);
            }
            catch (Exception ex) {
                throw ex;
            }
            finally {
                if (dao != null) {
                    try {
                        dao.closeConnection();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
            log.info("End with loading of edit sessions for [" + this.dataSource.getConnectionProperties().getProperty("editor") + "] and data source [" + this.getName() + "].");
            if (names != null) {
                this.editSessions = new Hashtable();
                for (String name : names) {
                    this.editSessions.put(name, NULLSESSIONMARKER);
                }
            }
        }

        public AbstractDataSource getDataSource() {
            return this.dataSource;
        }

        public Hashtable<String, LayerProvider> getLayerProviders() {
            return this.layerProviders;
        }

        public void setAsNullSession(String sessionName) {
            if (sessionName == null || this.editSessions == null || this.editSessions.get(sessionName) == null) {
                return;
            }
            this.editSessions.put(sessionName, NULLSESSIONMARKER);
        }

        public EditSession getEditSession(String sessionName) {
            if (sessionName == null || this.editSessions == null) {
                return null;
            }
            return this.editSessions.get(sessionName);
        }

        public static MDSEditSession getNullSessionMarker() {
            return NULLSESSIONMARKER;
        }

        private boolean areSameLocalHosts(String serverURL, String mvconnServerURL) {
            if (serverURL == null || mvconnServerURL == null) {
                return false;
            }
            String tempServerURL = serverURL.toLowerCase();
            String tempMVconnURL = mvconnServerURL.toLowerCase();
            try {
                InetAddress ownIP = InetAddress.getLocalHost();
                String ip = ownIP.getHostAddress();
                boolean svIsLocalHost = false;
                if (serverURL.toLowerCase().indexOf("localhost:") > -1) {
                    svIsLocalHost = true;
                } else if (serverURL.toLowerCase().indexOf("127.0.0.1:") > -1) {
                    svIsLocalHost = true;
                    tempServerURL = tempServerURL.replaceFirst("127.0.0.1:", "localhost:");
                } else if (serverURL.toLowerCase().indexOf(ip + ":") > -1) {
                    svIsLocalHost = true;
                    tempServerURL = tempServerURL.replaceFirst(ip + ":", "localhost:");
                }
                boolean mvconnIsLocalHost = false;
                if (mvconnServerURL.toLowerCase().indexOf("localhost:") > -1) {
                    mvconnIsLocalHost = true;
                } else if (mvconnServerURL.toLowerCase().indexOf("127.0.0.1:") > -1) {
                    mvconnIsLocalHost = true;
                    tempMVconnURL = tempMVconnURL.replaceFirst("127.0.0.1:", "localhost:");
                } else if (mvconnServerURL.toLowerCase().indexOf(ip + ":") > -1) {
                    mvconnIsLocalHost = true;
                    tempMVconnURL = tempMVconnURL.replaceFirst(ip + ":", "localhost:");
                }
                if (svIsLocalHost && mvconnIsLocalHost && tempServerURL.equalsIgnoreCase(tempMVconnURL)) {
                    return true;
                }
            }
            catch (Exception ex) {
                // empty catch block
            }
            return false;
        }
    }
}

