/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.vcs.changeset;

import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseListener;
import java.net.URL;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.event.ChangeListener;
import oracle.bali.share.nls.StringUtils;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.controller.Command;
import oracle.ide.controller.CommandProcessor;
import oracle.ide.controller.ContextMenu;
import oracle.ide.controller.ContextMenuListener;
import oracle.ide.controller.IdeAction;
import oracle.ide.controls.ToggleAction;
import oracle.ide.controls.Toolbar;
import oracle.ide.feedback.FeedbackManager;
import oracle.ide.model.Displayable;
import oracle.ide.model.Element;
import oracle.ide.util.MnemonicSolver;
import oracle.javatools.icons.OracleIcons;
import oracle.jdeveloper.resource.VCSArb;
import oracle.jdeveloper.vcs.changelist.ChangeList;
import oracle.jdeveloper.vcs.changelist.ChangeListCategorizer;
import oracle.jdeveloper.vcs.changelist.ChangeListContextMenuListener;
import oracle.jdeveloper.vcs.changelist.ChangeListWindow;
import oracle.jdeveloper.vcs.changeset.ChangeSetAdapter;
import oracle.jdeveloper.vcs.changeset.ChangeSetController;
import oracle.jdeveloper.vcs.changeset.ChangeSetEvent;
import oracle.jdeveloper.vcs.changeset.ChangeSetException;
import oracle.jdeveloper.vcs.changeset.ChangeSetListener;
import oracle.jdeveloper.vcs.changeset.ChangeSetRegistry;
import oracle.jdeveloper.vcs.changeset.cmd.ExistingChangeSetCommand;
import oracle.jdeveloper.vcs.spi.VCSHashURL;
import oracle.jdeveloper.vcs.spi.VCSOptionsCustomizer;
import oracle.jdeveloper.vcs.util.VCSMenuUtils;
import oracle.jdeveloper.vcs.util.VCSModelUtils;
import oracle.jdeveloper.vcs.vop.BaseVersionOperationPanel;
import oracle.jdeveloper.vcs.vop.MutableVersionOperationModel;
import oracle.jdeveloper.vcs.vop.VersionOperationTreePanel;
import oracle.jdevimpl.vcs.changeset.ChangeSetService;

public class ChangeSetChangeList
extends ChangeList {
    public static final String TOGGLE_CHANGE_SETS_COMMAND = "oracle.jdeveloper.vcs.changeset.cmd.ToggleChangeSetsCommand";
    public static final int TOGGLE_CHANGE_SETS_COMMAND_ID = Ide.findOrCreateCmdID((String)"oracle.jdeveloper.vcs.changeset.cmd.ToggleChangeSetsCommand");
    public static final String EDIT_CHANGE_SET_COMMAND = "oracle.jdeveloper.vcs.changeset.cmd.EditChangeSetCommand";
    public static final int EDIT_CHANGE_SET_COMMAND_ID = Ide.findOrCreateCmdID((String)"oracle.jdeveloper.vcs.changeset.cmd.EditChangeSetCommand");
    public static final String MAKE_DEFAULT_CHANGE_SET_COMMAND = "oracle.jdeveloper.vcs.changeset.cmd.MakeDefaultChangeSetCommand";
    public static final int MAKE_DEFAULT_CHANGE_SET_COMMAND_ID = Ide.findOrCreateCmdID((String)"oracle.jdeveloper.vcs.changeset.cmd.MakeDefaultChangeSetCommand");
    public static final String UNSET_DEFAULT_CHANGE_SET_COMMAND = "oracle.jdeveloper.vcs.changeset.cmd.UnsetDefaultChangeSetCommand";
    public static final int UNSET_DEFAULT_CHANGE_SET_COMMAND_ID = Ide.findOrCreateCmdID((String)"oracle.jdeveloper.vcs.changeset.cmd.UnsetDefaultChangeSetCommand");
    public static final String NEW_CHANGE_SET_COMMAND = "oracle.jdeveloper.vcs.changeset.cmd.NewChangeSetCommand";
    public static final int NEW_CHANGE_SET_COMMAND_ID = Ide.findOrCreateCmdID((String)"oracle.jdeveloper.vcs.changeset.cmd.NewChangeSetCommand");
    public static final String REMOVE_CHANGE_SET_COMMAND = "oracle.jdeveloper.vcs.changeset.cmd.RemoveChangeSetCommand";
    public static final int REMOVE_CHANGE_SET_COMMAND_ID = Ide.findOrCreateCmdID((String)"oracle.jdeveloper.vcs.changeset.cmd.RemoveChangeSetCommand");
    public static final String REMOVE_FROM_CHANGE_SET_COMMAND = "oracle.jdeveloper.vcs.changeset.cmd.RemoveFromChangeSetCommand";
    public static final int REMOVE_FROM_CHANGE_SET_COMMAND_ID = Ide.findOrCreateCmdID((String)"oracle.jdeveloper.vcs.changeset.cmd.RemoveFromChangeSetCommand");
    public static final String COMMIT_CHANGE_SET_COMMAND = "oracle.jdeveloper.vcs.changeset.cmd.CommitChangeSetCommand";
    public static final int COMMIT_CHANGE_SET_COMMAND_ID = Ide.findOrCreateCmdID((String)"oracle.jdeveloper.vcs.changeset.cmd.CommitChangeSetCommand");
    private static final String GUI_VOP = "vop";
    private static final String GUI_TREE = "tree";
    private final String _systemId;
    private CardLayout _layout;
    private VersionOperationTreePanel _tree;
    private IdeAction _toggleChangeSetsAction;
    private ContextMenuListener _changeSetContextMenuListener;
    private boolean _changeSetsVisible;
    private String _changeSetsVisDTCacheKey;

    public ChangeSetChangeList() {
        this(null, null);
    }

    public ChangeSetChangeList(Object modeId, String systemId) {
        super(modeId);
        this._systemId = systemId;
        this._layout = new CardLayout();
        this.setLayout(this._layout);
        this.add((Component)this.getVersionOperationPanel(), GUI_VOP);
        final ChangeSetAdapter adapter = this.getChangeSetAdapter();
        if (adapter == null) {
            return;
        }
        this._tree = new VersionOperationTreePanel();
        this.initializeVersionOperationPanel(this._tree);
        this.add((Component)this._tree, GUI_TREE);
        adapter.addChangeSetListener(new ChangeSetListener(){

            @Override
            public final void changeSetsChanged(ChangeSetEvent cse) {
                ChangeSetChangeList.this.updateCategoryCache();
            }

            @Override
            public final void defaultChangeSetChanged(ChangeSetEvent cse) {
                try {
                    String name = adapter.getDefaultChangeSet();
                    ChangeSetChangeList.this.getVersionOperationPanel().setDefaultCategory(name);
                    ChangeSetChangeList.this._tree.setDefaultCategory(name);
                }
                catch (ChangeSetException csex) {
                    FeedbackManager.reportException((Throwable)csex);
                }
            }
        });
        if (this.readChangeSetsVisibilityFromDTCache()) {
            this._setChangeSetsVisible(true);
        }
    }

    private final boolean readChangeSetsVisibilityFromDTCache() {
        return this._systemId != null && this.getModeId() != null && Ide.getDTCache().getBoolean(this.getChangeSetsVisibilityCacheKey(), false);
    }

    private final void writeChangeSetsVisibilityToDTCache(boolean visible) {
        if (this._systemId != null && this.getModeId() != null) {
            Ide.getDTCache().putBoolean(this.getChangeSetsVisibilityCacheKey(), visible);
        }
    }

    private final String getChangeSetsVisibilityCacheKey() {
        if (this._changeSetsVisDTCacheKey == null) {
            this._changeSetsVisDTCacheKey = this._systemId + "." + this.getModeId().toString() + ".ChangeSetsVisible";
        }
        return this._changeSetsVisDTCacheKey;
    }

    @Override
    protected ChangeListCategorizer createCategorizer() {
        if (this.getChangeSetAdapter() == null) {
            return null;
        }
        return new ChangeListCategorizer(){

            @Override
            public final Object getRequeryMutex() {
                return ChangeSetService.getQueueMutex();
            }

            @Override
            public final boolean canRequery() {
                return !ChangeSetService.isQueueBusy();
            }

            @Override
            public final Map<VCSHashURL, String> mapURLsToCategory(Collection<URL> urls) {
                ChangeSetAdapter adapter = ChangeSetChangeList.this.getChangeSetAdapter();
                try {
                    Collection<VCSHashURL> hashUrls = VCSHashURL.convertFromURLs(urls);
                    Map<String, Collection<VCSHashURL>> changesets = adapter.getChangeSets(urls.toArray(new URL[0]));
                    HashMap<VCSHashURL, String> urlsToCategory = new HashMap<VCSHashURL, String>();
                    for (Map.Entry<String, Collection<VCSHashURL>> entry : changesets.entrySet()) {
                        hashUrls.removeAll(entry.getValue());
                        for (VCSHashURL url : entry.getValue()) {
                            urlsToCategory.put(url, entry.getKey());
                        }
                    }
                    for (VCSHashURL url : hashUrls) {
                        urlsToCategory.put(url, null);
                    }
                    return urlsToCategory;
                }
                catch (ChangeSetException cse) {
                    FeedbackManager.reportException((Throwable)cse);
                    return Collections.emptyMap();
                }
            }
        };
    }

    @Override
    protected void setCategoryCacheImpl(Map<VCSHashURL, String> categoryCache) {
        super.setCategoryCacheImpl(categoryCache);
        if (this._tree != null) {
            this._tree.setCategoryCache(categoryCache);
        }
    }

    @Override
    protected ChangeListWindow.ScopeFilter createCategoryScopeFilter(String category) {
        ChangeSetAdapter adapter = this.getChangeSetAdapter();
        if (adapter == null) {
            return null;
        }
        return new CategoryScopeFilter(adapter, category);
    }

    @Override
    protected final void layoutPanel(BaseVersionOperationPanel vop) {
    }

    @Override
    public final void addMouseListener(MouseListener ml) {
        super.addMouseListener(ml);
        if (this._tree != null) {
            this._tree.addMouseListener(ml);
        }
    }

    @Override
    public final void removeMouseListener(MouseListener ml) {
        super.removeMouseListener(ml);
        if (this._tree != null) {
            this._tree.removeMouseListener(ml);
        }
    }

    @Override
    public final void addSelectionListener(ChangeListener listener) {
        super.addSelectionListener(listener);
        if (this._tree != null) {
            this._tree.addSelectionListener(listener);
        }
    }

    @Override
    public final void removeSelectionListener(ChangeListener listener) {
        super.removeSelectionListener(listener);
        if (this._tree != null) {
            this._tree.removeSelectionListener(listener);
        }
    }

    @Override
    public final void selectAll() {
        super.selectAll();
        if (this._tree != null) {
            this._tree.selectAll();
        }
    }

    @Override
    protected final void setBorderLook(int vopLookConstant) {
        super.setBorderLook(vopLookConstant);
        if (this._tree != null) {
            this._tree.setBorderLook(vopLookConstant);
        }
    }

    @Override
    public final void setOptionsCustomizer(VCSOptionsCustomizer c) {
        super.setOptionsCustomizer(c);
        if (this._tree != null) {
            this._tree.setOptionsComponent(c.getComponent());
        }
    }

    @Override
    public final void setOptionsVisible(boolean isVisible) {
        this.getActiveVOP().setOptionsVisible(isVisible);
    }

    @Override
    public final boolean isOptionsVisible() {
        return this.getActiveVOP().isOptionsVisible();
    }

    @Override
    public final boolean isItemAtPosition(Point p) {
        return this.getActiveVOP().isItemAtPosition(p);
    }

    @Override
    public Element[] getSelection() {
        return this.getActiveVOP().getSelection();
    }

    private final BaseVersionOperationPanel getActiveVOP() {
        return this._tree != null && this._changeSetsVisible ? this._tree : this.getVersionOperationPanel();
    }

    @Override
    protected void addToolbarActions(ChangeListWindow window, Toolbar toolbar) {
        super.addToolbarActions(window, toolbar);
        if (this.getChangeSetAdapter() == null) {
            return;
        }
        toolbar.addSeparator();
        toolbar.addToggleButton((ToggleAction)this.getToggleChangeSetsAction(window));
    }

    public final IdeAction getToggleChangeSetsAction(ChangeListWindow window) {
        if (this._toggleChangeSetsAction == null) {
            this._toggleChangeSetsAction = window.createLocalAction(TOGGLE_CHANGE_SETS_COMMAND_ID);
            this._toggleChangeSetsAction.setState(this._changeSetsVisible);
        }
        return this._toggleChangeSetsAction;
    }

    public final void setChangeSetsVisible(boolean changeSetsVisible) {
        if (this._tree == null) {
            return;
        }
        this._setChangeSetsVisible(changeSetsVisible);
        this.writeChangeSetsVisibilityToDTCache(changeSetsVisible);
        this.invalidate();
        this.repaint();
    }

    private final void _setChangeSetsVisible(boolean changeSetsVisible) {
        int i;
        BaseVersionOperationPanel vop = this.getActiveVOP();
        boolean optionsVisible = vop.isOptionsVisible();
        if (optionsVisible) {
            vop.setOptionsVisible(false);
        }
        if (changeSetsVisible) {
            this._layout.show(this, GUI_TREE);
        } else {
            this._layout.show(this, GUI_VOP);
        }
        this._changeSetsVisible = changeSetsVisible;
        BaseVersionOperationPanel newVop = this.getActiveVOP();
        if (optionsVisible) {
            newVop.setOptionsVisible(true);
        }
        if ((i = vop.getOptionsDividerLocation()) >= 0) {
            newVop.setOptionsDividerLocation(i);
        }
    }

    @Override
    protected void installModel(MutableVersionOperationModel model) {
        super.installModel(model);
        if (this._tree != null) {
            this._tree.installModel(model);
            try {
                this._tree.setDefaultCategory(this.getChangeSetAdapter().getDefaultChangeSet());
            }
            catch (ChangeSetException cse) {
                FeedbackManager.reportException((Throwable)cse);
            }
        }
    }

    protected ChangeSetAdapter getChangeSetAdapter() {
        return this._systemId != null ? ChangeSetRegistry.lookup(this._systemId) : null;
    }

    @Override
    protected void addContextMenuListeners(ContextMenu contextMenu) {
        if (this.getChangeSetAdapter() == null) {
            super.addContextMenuListeners(contextMenu);
            return;
        }
        this._changeSetContextMenuListener = new ChangeSetContextMenuListener(this);
        contextMenu.addContextMenuListener(this._changeSetContextMenuListener);
    }

    @Override
    protected void removeContextMenuListeners(ContextMenu contextMenu) {
        if (this.getChangeSetAdapter() == null) {
            super.removeContextMenuListeners(contextMenu);
            return;
        }
        contextMenu.removeContextMenuListener(this._changeSetContextMenuListener);
        this._changeSetContextMenuListener = null;
    }

    public final URL[] getChangeSetURLs(String name) {
        Collection<VCSHashURL> urls = this._getChangeSetURLs(name);
        return VCSHashURL.convertToURLs(urls).toArray(new URL[urls.size()]);
    }

    private final Collection<VCSHashURL> _getChangeSetURLs(String name) {
        Collection<VCSHashURL> urls = this.getCachedURLsForCategory(name);
        ArrayList<VCSHashURL> modelUrls = new ArrayList<VCSHashURL>();
        for (Displayable item : this.getVersionOperationPanel().getModel().getItems()) {
            VCSHashURL hashUrl;
            URL url = VCSModelUtils.getLocatableURL(item);
            if (url == null || !urls.contains(hashUrl = new VCSHashURL(url))) continue;
            modelUrls.add(hashUrl);
        }
        return modelUrls;
    }

    private final Collection<VCSHashURL> getCachedURLsForCategory(String name) {
        ArrayList<VCSHashURL> urls = new ArrayList<VCSHashURL>();
        for (Map.Entry<VCSHashURL, String> entry : this.getCategoryCache().entrySet()) {
            if (entry.getValue() == null || !entry.getValue().equals(name)) continue;
            urls.add(entry.getKey());
        }
        return urls;
    }

    public static class ChangeSetContextMenuListener
    extends ChangeListContextMenuListener {
        public ChangeSetContextMenuListener(ChangeSetChangeList changeList) {
            super(changeList);
        }

        @Override
        protected void addCategoryMenuItems(ContextMenu popup) {
            ChangeSetAdapter adapter = ((ChangeSetChangeList)this.getChangeList()).getChangeSetAdapter();
            if (adapter == null) {
                return;
            }
            if (popup.getContext().getView() instanceof ChangeListWindow) {
                popup.add((Component)popup.createMenuItem((ToggleAction)((ChangeSetChangeList)this.getChangeList()).getToggleChangeSetsAction((ChangeListWindow)popup.getContext().getView()), 0.0f), 5.1f);
            }
            IdeAction commitChangeSetAction = IdeAction.find((int)COMMIT_CHANGE_SET_COMMAND_ID);
            this.updateEllipsisVisible(commitChangeSetAction, adapter.getCommitAction());
            VCSMenuUtils.addDynamicMenuItem(popup, COMMIT_CHANGE_SET_COMMAND_ID, 2.0f);
            VCSMenuUtils.addDynamicMenuItem(popup, EDIT_CHANGE_SET_COMMAND_ID, 2.05f);
            VCSMenuUtils.addDynamicMenuItem(popup, REMOVE_CHANGE_SET_COMMAND_ID, 2.05f);
            VCSMenuUtils.addDynamicMenuItem(popup, MAKE_DEFAULT_CHANGE_SET_COMMAND_ID, 2.05f);
            VCSMenuUtils.addDynamicMenuItem(popup, UNSET_DEFAULT_CHANGE_SET_COMMAND_ID, 2.05f);
            JMenu addToMenu = popup.createMenu(StringUtils.stripMnemonic((String)VCSArb.get("CHANGE_SETS_ADD_TO")), (float)StringUtils.getMnemonicKeyCode((String)VCSArb.get("CHANGE_SETS_ADD_TO")));
            final Context context = popup.getContext();
            VCSMenuUtils.addLazyDynamicMenuItem(addToMenu, NEW_CHANGE_SET_COMMAND_ID, 0.0f, context);
            IdeAction newChangeSetAction = IdeAction.find((int)NEW_CHANGE_SET_COMMAND_ID);
            newChangeSetAction.updateAction(context);
            if (newChangeSetAction.isEnabled()) {
                HashSet<String> categoriesSet = new HashSet<String>(this.getChangeList().getCategoryCache().values());
                categoriesSet.remove(null);
                URL[] urls = ChangeSetController.getContextURLs(context);
                if (urls.length <= 10) {
                    try {
                        Collection<VCSHashURL> hashUrls = VCSHashURL.convertFromURLs(Arrays.asList(urls));
                        Map<String, Collection<VCSHashURL>> changesets = adapter.getChangeSets(urls);
                        for (Map.Entry<String, Collection<VCSHashURL>> entry : changesets.entrySet()) {
                            hashUrls.removeAll(entry.getValue());
                        }
                        if (hashUrls.isEmpty() && changesets.size() == 1) {
                            categoriesSet.remove(changesets.keySet().iterator().next());
                        }
                    }
                    catch (ChangeSetException cse) {
                        FeedbackManager.reportException((Throwable)cse);
                    }
                }
                String[] categories = categoriesSet.toArray(new String[categoriesSet.size()]);
                Arrays.sort(categories, Collator.getInstance());
                MnemonicSolver solver = new MnemonicSolver();
                for (final String category : categories) {
                    JMenuItem menuItem = new JMenuItem(category);
                    menuItem.addActionListener(new ActionListener(){

                        @Override
                        public final void actionPerformed(ActionEvent ae) {
                            try {
                                ExistingChangeSetCommand cmd = new ExistingChangeSetCommand(){

                                    @Override
                                    protected final String getExistingChangeSetName() {
                                        return category;
                                    }
                                };
                                cmd.setContext(context);
                                CommandProcessor.getInstance().invoke((Command)cmd);
                            }
                            catch (Exception e) {
                                FeedbackManager.reportException((Throwable)e);
                            }
                        }
                    });
                    VCSMenuUtils.addRawMenuItemNoAction(addToMenu, menuItem, 0.1f, context);
                    solver.addMenuLabel(menuItem);
                }
                solver.solve();
            }
            if (addToMenu.getItemCount() > 0) {
                popup.add((Component)addToMenu, 5.1f);
            }
            VCSMenuUtils.addDynamicMenuItem(popup, REMOVE_FROM_CHANGE_SET_COMMAND_ID, 5.1f);
        }

        private final void updateEllipsisVisible(IdeAction localAction, IdeAction commitAction) {
            String text = (String)commitAction.getValue("Name");
            boolean visible = text.endsWith("...");
            text = (String)localAction.getValue("Name");
            boolean hasEllipsis = text.endsWith("...");
            if (hasEllipsis && !visible) {
                localAction.putValueDirectly("Name", (Object)text.substring(0, text.length() - 3));
            } else if (!hasEllipsis && visible) {
                localAction.putValueDirectly("Name", (Object)(text + "..."));
            }
        }
    }

    private static class CategoryScopeFilter
    extends ChangeListWindow.ScopeFilter {
        private final ChangeSetAdapter _adapter;
        private final String _category;

        CategoryScopeFilter(ChangeSetAdapter adapter, String category) {
            this._adapter = adapter;
            this._category = category;
        }

        @Override
        public String getShortLabel() {
            return VCSArb.format("CHANGE_SET_SCOPE_PREFIX", this._category != null ? this._category : VCSArb.get("CHANGE_SET_DEFAULT_CATEGORY"));
        }

        @Override
        public Icon getIcon() {
            return OracleIcons.getIcon((String)"group.png");
        }

        @Override
        public boolean accept(URL url) {
            try {
                Map<String, Collection<VCSHashURL>> changesets = this._adapter.getChangeSets(new URL[]{url});
                if (this._category == null) {
                    return changesets.isEmpty();
                }
                return !changesets.isEmpty() && changesets.keySet().iterator().next().equals(this._category);
            }
            catch (ChangeSetException cse) {
                FeedbackManager.reportException((Throwable)cse);
                return false;
            }
        }

        @Override
        public String toExternalForm() {
            return this._category != null ? "CATEGORY=" + this._category : "DEFAULT_CATEGORY";
        }
    }
}

