/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.vcs.historygraph;

import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.net.URL;
import java.text.DateFormat;
import java.util.Collection;
import java.util.Date;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SwingWorker;
import oracle.ide.ExtensionRegistry;
import oracle.ide.hover.HoverFlavor;
import oracle.javatools.ui.infotip.InfoTipHover;
import oracle.javatools.ui.infotip.InfoTipStyles;
import oracle.javatools.ui.infotip.templates.BasicTemplate;
import oracle.javatools.ui.infotip.templates.Template;
import oracle.jdeveloper.vcs.historygraph.GraphNode;
import oracle.jdeveloper.vcs.historygraph.VCSHistoryGraphExtension;
import oracle.jdeveloper.vcs.spi.VCSExtendHover;
import oracle.jdeveloper.vcs.spi.VCSHistoryGraphProvider;
import oracle.jdeveloper.vcs.tracking.VCSBugTrackingHook;

public class HistoryGraphHover
extends InfoTipHover {
    private static DateFormat format = DateFormat.getDateTimeInstance();

    static HistoryGraphHover get(final VCSHistoryGraphProvider provider, final URL root, final GraphNode gNode, JComponent parent, Rectangle r, final InfoTipStyles style) {
        String description;
        JPanel panel = new JPanel();
        panel.setLayout(new GridBagLayout());
        Insets insets = style.getBorderInsets();
        panel.setBorder(BorderFactory.createEmptyBorder(insets.top, insets.left, insets.bottom, insets.right));
        panel.setOpaque(false);
        String revision = gNode.getRevId();
        JTextField revisionField = new JTextField(revision);
        revisionField.setBorder(BorderFactory.createEmptyBorder());
        revisionField.setOpaque(false);
        revisionField.setEditable(false);
        revisionField.setFont(style.getItemTitleFont());
        GridBagConstraints gbc = new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 17, 2, style.getItemTitleInsets(), 0, 0);
        panel.add((Component)revisionField, gbc);
        int preferredWidth = Math.max(300, revisionField.getPreferredSize().width);
        if (gNode.getCommitTime() != null) {
            JTextField commitField = new JTextField(format.format(new Date(gNode.getCommitTime())));
            commitField.setBorder(BorderFactory.createEmptyBorder());
            commitField.setOpaque(false);
            commitField.setEditable(false);
            gbc.insets = new Insets(0, 0, 0, 0);
            panel.add((Component)commitField, gbc);
            preferredWidth = Math.max(preferredWidth, commitField.getPreferredSize().width);
        }
        if (gNode.getAuthor() != null) {
            JTextField authorField = new JTextField(gNode.getAuthor());
            authorField.setBorder(BorderFactory.createEmptyBorder());
            authorField.setOpaque(false);
            authorField.setEditable(false);
            gbc.insets = new Insets(0, 0, 0, 0);
            panel.add((Component)authorField, gbc);
            preferredWidth = Math.max(preferredWidth, authorField.getPreferredSize().width);
        }
        if ((description = gNode.getDescription()) != null && !description.isEmpty()) {
            JTextArea text = new JTextArea(description.trim());
            text.setBackground(Color.WHITE);
            text.setEditable(false);
            text.setColumns(50);
            text.setLineWrap(true);
            text.setWrapStyleWord(true);
            text.setRows(10);
            text.setForeground(style.getContentTextColor());
            JScrollPane pane = new JScrollPane(text);
            pane.setBorder(BorderFactory.createLineBorder(style.getInternalBorderColor()));
            pane.setHorizontalScrollBarPolicy(31);
            gbc.fill = 1;
            gbc.weightx = 1.0;
            gbc.weighty = 1.0;
            gbc.insets = new Insets(3, 0, 0, 0);
            panel.add((Component)pane, gbc);
            int pW = preferredWidth = Math.max(preferredWidth, pane.getPreferredSize().width);
            for (final VCSHistoryGraphExtension graph : HistoryGraphHover.getHistoryGraphExtensions()) {
                Collection<String> issues = graph.getIssues(description);
                issues.stream().filter(e -> !e.isEmpty()).forEach(e -> VCSExtendHover.addExtendedProperties(style, panel, graph.getLabel(), gbc, pW, graph.isEnabled(), issues, new MouseAdapter(){

                    @Override
                    public void mouseEntered(MouseEvent e) {
                        if (graph.isEnabled()) {
                            e.getComponent().setForeground(style.getHyperLinkTextColor(true));
                        }
                    }

                    @Override
                    public void mouseExited(MouseEvent e) {
                        if (graph.isEnabled()) {
                            e.getComponent().setForeground(style.getHyperLinkTextColor(false));
                        }
                    }
                }, new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        final Object obj = e.getSource();
                        if (obj instanceof AbstractButton) {
                            SwingWorker worker = new SwingWorker(){

                                protected URL doInBackground() throws Exception {
                                    URL[] urls = provider.getURLs(root, gNode.getRevId());
                                    return urls[0];
                                }

                                @Override
                                protected void done() {
                                    try {
                                        URL url = (URL)this.get();
                                        graph.openIssue(url, ((AbstractButton)obj).getText());
                                    }
                                    catch (Exception f) {
                                        f.printStackTrace();
                                    }
                                }
                            };
                            worker.execute();
                        }
                    }
                }));
            }
        }
        return new HistoryGraphHover((Template)new BasicTemplate((JComponent)panel), InfoTipStyles.DEFAULT, parent, r);
    }

    private HistoryGraphHover(Template template, InfoTipStyles style, JComponent parent, Rectangle location) {
        super(template, style, parent, location, HoverFlavor.getFlavor((String)"info"));
    }

    private static Collection<VCSHistoryGraphExtension> getHistoryGraphExtensions() {
        VCSBugTrackingHook hook = (VCSBugTrackingHook)ExtensionRegistry.getExtensionRegistry().getHook(VCSBugTrackingHook.HOOK);
        return hook.getCommitGraph();
    }
}

