/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.vcs.spi;

import java.awt.EventQueue;
import java.net.URL;
import java.util.Collections;
import oracle.ide.Ide;
import oracle.ide.controller.Command;
import oracle.ide.model.Node;
import oracle.ide.net.URLFileSystem;
import oracle.ide.util.Assert;
import oracle.ide.vcs.VCSManager;
import oracle.jdeveloper.vcs.spi.VCSExtension;
import oracle.jdeveloper.vcs.spi.VCSProgress;
import oracle.jdeveloper.vcs.util.VCSExtensionUtils;
import oracle.jdeveloper.vcs.util.VCSFileSystemUtils;
import oracle.jdevimpl.vcs.VCSManagerImpl;

public class VCSCheckOutNodeCmd
extends Command {
    public VCSCheckOutNodeCmd() {
        this(1);
    }

    public VCSCheckOutNodeCmd(int type) {
        this(type, null);
    }

    public VCSCheckOutNodeCmd(int type, String name) {
        super(Ide.findOrCreateCmdID((String)VCSCheckOutNodeCmd.class.getName()), type, name);
    }

    public int doit() throws Exception {
        Node node;
        if (!EventQueue.isDispatchThread() && Ide.getIdeArgs().getCreateUI()) {
            Assert.printStackTrace((Throwable)new IllegalStateException("doit() called from non-event thread"));
        }
        if ((node = this.getContext().getNode()) == null) {
            return 1;
        }
        URL url = node.getURL();
        if (url == null || !URLFileSystem.isReadOnly((URL)url)) {
            return 1;
        }
        if (!VCSManager.getVCSManager().isVersioned(url)) {
            return 1;
        }
        if (!this.isOperable(url)) {
            return 1;
        }
        if (VCSFileSystemUtils.isNonEditable(url)) {
            return 1;
        }
        if (!VCSManagerImpl.isAutoCheckoutsSet(url) && !this.canCheckOutUI(url)) {
            return 1;
        }
        if (!this.doCheckOut(url)) {
            return 1;
        }
        node.isReadOnly();
        return 0;
    }

    public int undo() throws Exception {
        Node node = this.getContext().getNode();
        if (node == null) {
            return 1;
        }
        URL url = node.getURL();
        if (url == null || URLFileSystem.isReadOnly((URL)url)) {
            return 1;
        }
        if (!this.isOperable(url)) {
            return 1;
        }
        if (!this.undoCheckOut(url)) {
            return 1;
        }
        node.isReadOnly();
        node.markDirty(false);
        return 0;
    }

    protected boolean isOperable(URL url) {
        return true;
    }

    protected boolean canCheckOutUI(URL url) {
        return VCSManagerImpl.confirmCheckOutUI(Collections.singleton(url));
    }

    protected boolean doCheckOut(URL url) throws Exception {
        VCSExtension extension = VCSExtensionUtils.getActiveExtension(url);
        return extension != null && extension.setReadWrite(new URL[]{url}, VCSProgress.createNullInstance());
    }

    protected boolean undoCheckOut(URL url) throws Exception {
        return false;
    }
}

