/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.vcs.spi;

import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.time.LocalDate;
import java.time.temporal.ChronoUnit;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import oracle.ide.Ide;
import oracle.ide.config.DTCache;
import oracle.ide.controller.ContextMenuListener;
import oracle.jdeveloper.vcs.generic.HistoryGraphEntryProducer;
import oracle.jdeveloper.vcs.generic.VCSProfile;
import oracle.jdeveloper.vcs.historygraph.GraphNode;
import oracle.jdeveloper.vcs.historygraph.HighLightListener;
import oracle.jdeveloper.vcs.spi.VCSException;
import oracle.jdevimpl.vcs.ClassUtil;
import oracle.jdevimpl.vcs.generic.profile.HistoryGraphProviderInfo;

public class VCSHistoryGraphProvider {
    private static final String DURATION_PATH = "graph_duration";
    private static final String USER_DATE = "graph_userdate";
    private VCSProfile _profile;
    private HistoryGraphProviderInfo _providerInfo;
    private HistoryGraphEntryProducer _producer;
    private Map<String, LocalDate> _startDate = new HashMap<String, LocalDate>();

    public VCSHistoryGraphProvider(VCSProfile profile, HistoryGraphProviderInfo providerInfo) {
        this._profile = profile;
        this._providerInfo = providerInfo;
    }

    public GraphNode[] getEntries(URL url) throws VCSException {
        HistoryGraphEntryProducer producer = this.getEntryProducer();
        if (producer != null) {
            return producer.produceEntries(url, this.getStartDate(url));
        }
        return new GraphNode[0];
    }

    public int getDateDuration(URL url) {
        return this.getDuration(url);
    }

    public LocalDate getUserEnteredDate(URL url) {
        LocalDate uDate = this.getUserDate(url);
        if (uDate == null) {
            return LocalDate.now().minusDays(45L);
        }
        return uDate;
    }

    public LocalDate getStartDate(URL url) {
        if (!this._startDate.containsKey(url.getPath())) {
            Integer duration = this.getDuration(url);
            LocalDate startDate = LocalDate.now().minusDays(duration.intValue());
            this._startDate.put(url.getPath(), startDate);
        }
        return this._startDate.get(url.getPath());
    }

    public void setStartDate(URL url, LocalDate localDate, boolean userEntered) {
        LocalDate startDate;
        if (userEntered) {
            this.persistUserDate(url, localDate);
        }
        if ((startDate = this._startDate.get(url.getPath())) != null && localDate.equals(this._startDate)) {
            return;
        }
        this._startDate.put(url.getPath(), localDate);
        if (this._providerInfo.getPersistDuration().booleanValue()) {
            this.persistDuration(url, localDate);
        }
    }

    public URL[] getURLs(URL root, String revision) throws VCSException {
        return this.getEntryProducer().getURLs(root, revision);
    }

    public String getBranchLabelFor(URL root, GraphNode node) throws VCSException {
        return this.getEntryProducer().getBranchLabelFor(root, node);
    }

    public String getCommitLabel(URL root) throws VCSException {
        return this.getEntryProducer().getCommitLabel(root);
    }

    public ContextMenuListener getContextMenuListener() {
        return this.getEntryProducer().getContextMenuListener();
    }

    public HighLightListener getHighLightListener() {
        return this.getEntryProducer().getHighLightListener();
    }

    private HistoryGraphEntryProducer getEntryProducer() {
        if (this._producer == null) {
            try {
                Class<HistoryGraphEntryProducer> theClass = this._providerInfo.getEntryProducerClass();
                this._producer = ClassUtil.newInstance(theClass);
            }
            catch (ClassNotFoundException cnfe) {
                this._profile.getLogger().warning("unable to load history graph entry producer class: " + cnfe.getMessage());
            }
            catch (Exception e) {
                this._profile.getLogger().log(Level.WARNING, "unable to instantiate history graph entry producer", e instanceof InvocationTargetException ? ((InvocationTargetException)e).getTargetException() : e);
            }
        }
        return this._producer;
    }

    private Integer getDuration(URL url) {
        Integer duration = Ide.getDTCache().getInteger(DURATION_PATH.concat(url.getPath()), this._providerInfo.getCommitDuration().intValue());
        if (duration == null) {
            return this._providerInfo.getCommitDuration();
        }
        return duration;
    }

    private void persistDuration(URL url, LocalDate startDate) {
        DTCache cache = Ide.getDTCache();
        if (cache != null) {
            int duration = (int)ChronoUnit.DAYS.between(startDate, LocalDate.now());
            cache.putInteger(DURATION_PATH.concat(url.getPath()), duration);
        }
    }

    private void persistUserDate(URL url, LocalDate userDate) {
        DTCache cache = Ide.getDTCache();
        if (cache != null) {
            cache.putString(USER_DATE.concat(url.getPath()), Long.toString(userDate.toEpochDay()));
        }
    }

    private LocalDate getUserDate(URL url) {
        String epoch;
        DTCache cache = Ide.getDTCache();
        if (cache != null && (epoch = cache.getString(USER_DATE.concat(url.getPath()))) != null && !epoch.isEmpty()) {
            return LocalDate.ofEpochDay(Long.parseLong(epoch));
        }
        return null;
    }
}

