/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.vcs.util;

import java.net.URL;
import java.util.Collection;
import java.util.Iterator;
import oracle.ide.Context;
import oracle.ide.editor.EditorManager;
import oracle.ide.model.ContentLevelFolder;
import oracle.ide.model.Element;
import oracle.ide.model.Locatable;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLFilter;
import oracle.ide.net.URLPath;
import oracle.ideimpl.vcs.VCSContextUtil;
import oracle.jdeveloper.vcs.generic.VCSProfile;
import oracle.jdeveloper.vcs.spi.VCSProtocolRegistry;
import oracle.jdeveloper.vcs.util.VCSURLFilters;

public final class VCSContextUtils {
    private static URLFilter _protocolFilter = null;

    private VCSContextUtils() {
    }

    public static final URLFilter createLocalProtocolFilter() {
        return VCSURLFilters.createChainedANDFilter(new URLFilter[]{new URLFilter(){

            public boolean accept(URL url) {
                return URLFileSystem.isLocal((URL)url);
            }
        }, new URLFilter(){

            public boolean accept(URL url) {
                for (String protocol : VCSProtocolRegistry.protocols()) {
                    if (!url.getProtocol().equals(protocol)) continue;
                    return true;
                }
                return false;
            }
        }});
    }

    public static final Locatable[] getContextLocatables(Context context, URLFilter filter) {
        return VCSContextUtil.getContextLocatables((Context)context, (URLFilter)filter);
    }

    public static final Locatable[] getContextLocatables(Context context) {
        if (_protocolFilter == null) {
            _protocolFilter = VCSContextUtils.createLocalProtocolFilter();
        }
        return VCSContextUtil.getContextLocatables((Context)context, (URLFilter)_protocolFilter);
    }

    public static final Locatable[] getExpandedLocatables(Element[] elements, URLFilter filter) {
        return VCSContextUtil.getExpandedLocatables((Element[])elements, (URLFilter)filter);
    }

    public static final Locatable[] getExpandedLocatables(Context context, Element[] elements, URLFilter filter) {
        return VCSContextUtil.getExpandedLocatables((Context)context, (Element[])elements, (URLFilter)filter);
    }

    public static final String getContextViewType(Context context) {
        return VCSContextUtil.getContextViewType((Context)context);
    }

    public static final URL getURL(Context context) {
        if (context.getNode() != null) {
            return context.getNode().getURL();
        }
        Element elm = context.getElement();
        if (elm == null) {
            return null;
        }
        if (elm != null && elm instanceof Locatable) {
            return ((Locatable)elm).getURL();
        }
        if (elm.mayHaveChildren() && elm instanceof ContentLevelFolder) {
            URLPath uPath = ((ContentLevelFolder)elm).getRootDirectories();
            return URLFactory.newDirURL((URL)uPath.getFirstEntry(), (String)((ContentLevelFolder)elm).getRelativePath());
        }
        return null;
    }

    public static URL[] getVersionEditorUrls(VCSProfile profile) {
        URLFilter filter = profile.getURLFilter("oracle.jdeveloper.vcs.filters.url.CONTROL");
        Collection urls = EditorManager.getEditorManager().getAllUrlEditors();
        Iterator it = urls.iterator();
        while (it.hasNext()) {
            URL url = (URL)it.next();
            if (filter.accept(url)) continue;
            it.remove();
        }
        return urls.toArray(new URL[0]);
    }
}

