/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs;

import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.Observer;
import oracle.ide.Ide;
import oracle.ide.config.GlobalIgnoreList;
import oracle.ide.file.ContentSetRoot;
import oracle.ide.model.ContentLevel;
import oracle.ide.model.ContentSet;
import oracle.ide.model.Element;
import oracle.ide.model.Project;
import oracle.ide.model.ProjectContent;
import oracle.ide.model.UpdateMessage;
import oracle.ide.model.Workspace;
import oracle.ide.net.JarUtil;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLFilter;
import oracle.ide.net.URLPath;
import oracle.ide.net.VirtualFileSystemHelper;
import oracle.ide.util.IntersectedFilters;
import oracle.ide.vcs.VCSManager;
import oracle.javatools.data.PropertyStorage;
import oracle.javatools.util.CompositeIterator;
import oracle.javatools.util.Maps;
import oracle.jdeveloper.library.JLibrary;
import oracle.jdeveloper.library.Library;
import oracle.jdeveloper.model.JProjectLibraries;
import oracle.jdeveloper.vcs.spi.VCSApplicationSystem;
import oracle.jdeveloper.vcs.spi.VCSHashURL;
import oracle.jdeveloper.vcs.util.VCSModelUtils;
import oracle.jdevimpl.vcs.VCSManagerImpl;
import oracle.jdevimpl.vcs.util.IdeObserver;

public class ApplicationSystemImpl
extends VCSApplicationSystem {
    private static final int CACHE_SIZE = 1000;
    private static ApplicationSystemImpl _instance;
    private Map<VCSHashURL, Boolean> _cache;
    private Collection<Workspace> _workspaces;
    private Collection<Project> _projects;
    private boolean _initialized;
    private boolean _attached;

    public static final ApplicationSystemImpl getInstance() {
        if (_instance == null) {
            _instance = new ApplicationSystemImpl();
        }
        return _instance;
    }

    @Override
    public final void addObserver(Observer o) {
        this.lazyInitialize();
        super.addObserver(o);
    }

    private final synchronized void lazyInitialize() {
        if (this._initialized) {
            return;
        }
        this._cache = Collections.synchronizedMap(new Maps.CacheMap(1000, Maps.CacheMap.NOT_CANONICAL));
        this._workspaces = new ArrayList<Workspace>();
        this._projects = new ArrayList<Project>();
        this.lazyAttach();
        this.updateApplicationSystems();
        this._initialized = true;
    }

    private final synchronized void lazyAttach() {
        if (this._attached) {
            return;
        }
        IdeObserver ideObserver = new IdeObserver(){

            @Override
            protected void updateImpl(Object source, UpdateMessage updateMessage) {
                if (!ApplicationSystemImpl.this.isInitialized()) {
                    return;
                }
                int msgId = updateMessage.getMessageID();
                if (!(source != Ide.getWorkspaces() && !(source instanceof Workspace) || msgId != UpdateMessage.CHILD_ADDED && msgId != UpdateMessage.CHILD_REMOVED)) {
                    ApplicationSystemImpl.this.updateApplicationSystems();
                }
                if (msgId == UpdateMessage.OBJECT_OPENED && source instanceof Project) {
                    ApplicationSystemImpl.this.invalidateCache();
                }
                if (msgId == UpdateMessage.PROPERTY_SET && updateMessage.containsProperty("contentProvidersPath")) {
                    ApplicationSystemImpl.this.invalidateCache();
                }
            }

            @Override
            protected boolean canAttach(Element e) {
                return e == Ide.getWorkspaces() || e instanceof Workspace || e instanceof Project;
            }
        };
        ideObserver.startObserving();
        this._attached = true;
    }

    private final synchronized boolean isInitialized() {
        return this._initialized;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void updateApplicationSystems() {
        Collection<Workspace> collection = this._workspaces;
        synchronized (collection) {
            this._workspaces.clear();
            this._workspaces.addAll(Ide.getWorkspaces().workspaces());
            Collection<Project> collection2 = this._projects;
            synchronized (collection2) {
                this._projects.clear();
                for (Workspace workspace : this._workspaces) {
                    this._projects.addAll(workspace.projects());
                }
            }
        }
        this.invalidateCache();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final boolean isControlledDirectory(URL dirUrl) {
        VCSHashURL hashUrl;
        Boolean cachedValue;
        this.lazyInitialize();
        if (!URLFileSystem.isDirectoryPath((URL)dirUrl)) {
            throw new IllegalArgumentException("URL is not a directory path: " + dirUrl);
        }
        if (JarUtil.isJarURL((URL)dirUrl)) {
            dirUrl = URLFileSystem.getParent((URL)JarUtil.getJarFileURL((URL)dirUrl));
        }
        if ((cachedValue = this._cache.get(hashUrl = new VCSHashURL(dirUrl))) != null) {
            return cachedValue;
        }
        Collection contentSetRoots = ContentSetRoot.getContentSetRootsContaining((URL)dirUrl);
        if (contentSetRoots != null && !contentSetRoots.isEmpty()) {
            return this.cacheAndGet(hashUrl, true);
        }
        if (GlobalIgnoreList.isGloballyIgnored((URL)dirUrl)) {
            return this.cacheAndGet(hashUrl, false);
        }
        Collection<Project> collection = this._projects;
        synchronized (collection) {
            for (Project project : this._projects) {
                JLibrary[] libraries;
                if (URLFileSystem.equals((URL)URLFileSystem.getParent((URL)project.getURL()), (URL)dirUrl)) {
                    return this.cacheAndGet(hashUrl, true);
                }
                if (!project.isOpen()) continue;
                JProjectLibraries projectLibraries = JProjectLibraries.getInstance((PropertyStorage)project);
                if (this.isWithinLibraryPath((Library)projectLibraries.getJDK(), dirUrl)) {
                    return this.cacheAndGet(hashUrl, true);
                }
                for (JLibrary library : libraries = projectLibraries.getLibraries()) {
                    if (!this.isWithinLibraryPath((Library)library, dirUrl)) continue;
                    return this.cacheAndGet(hashUrl, true);
                }
            }
        }
        collection = this._workspaces;
        synchronized (collection) {
            for (Workspace workspace : this._workspaces) {
                if (URLFileSystem.equals((URL)URLFileSystem.getParent((URL)workspace.getURL()), (URL)dirUrl)) {
                    return this.cacheAndGet(hashUrl, true);
                }
                for (String path : this.getWorkspaceArtifactPaths()) {
                    URL artifactUrl = URLFactory.newURL((URL)URLFileSystem.getParent((URL)workspace.getURL()), (String)path);
                    if (!URLFileSystem.isDirectoryPath((URL)artifactUrl) || !URLFileSystem.isBaseURLFor((URL)artifactUrl, (URL)dirUrl)) continue;
                    return this.cacheAndGet(hashUrl, true);
                }
            }
        }
        return this.cacheAndGet(hashUrl, false);
    }

    private final boolean isWithinLibraryPath(Library library, URL dirUrl) {
        if (library == null) {
            return false;
        }
        if (this.isWithinLibraryPath(library.getClassPath(), dirUrl)) {
            return true;
        }
        if (this.isWithinLibraryPath(library.getSourcePath(), dirUrl)) {
            return true;
        }
        return this.isWithinLibraryPath(library.getDocPath(), dirUrl);
    }

    private final boolean isWithinLibraryPath(URLPath path, URL dirUrl) {
        if (path == null) {
            return false;
        }
        for (URL entry : path.asList()) {
            if (JarUtil.isJarURL((URL)entry)) {
                try {
                    entry = JarUtil.getJarFileURL((URL)entry);
                }
                catch (IllegalArgumentException iae) {
                    return false;
                }
            }
            if (!URLFileSystem.isDirectoryPath((URL)entry)) {
                entry = URLFileSystem.getParent((URL)entry);
            }
            if (!URLFileSystem.isBaseURLFor((URL)entry, (URL)dirUrl)) continue;
            return true;
        }
        return false;
    }

    private final boolean cacheAndGet(VCSHashURL hashUrl, boolean result) {
        this._cache.put(hashUrl, result);
        return result;
    }

    final void invalidateCache() {
        if (this._cache != null) {
            this._cache.clear();
        }
        this.setChanged();
        this.notifyObservers();
    }

    @Override
    public boolean canProjectHaveMember(Project project, VCSApplicationSystem.ContentSetProxy proxy, URL url) {
        if (!project.isOpen()) {
            return false;
        }
        if ((proxy != null ? proxy.getContentSet(project) : ProjectContent.getInstance((PropertyStorage)project).getAllContents()).canHaveMember(url)) {
            return true;
        }
        if (URLFileSystem.equals((URL)URLFileSystem.getParent((URL)url), (URL)URLFileSystem.getParent((URL)project.getURL()))) {
            return !GlobalIgnoreList.isGloballyIgnored((URL)url) && !URLFileSystem.isDirectoryPath((URL)url);
        }
        return false;
    }

    @Override
    public boolean canWorkspaceHaveMember(Workspace workspace, VCSApplicationSystem.ContentSetProxy proxy, URL url) {
        if (!workspace.isOpen()) {
            return false;
        }
        Iterator itr = workspace.getChildren();
        while (itr.hasNext()) {
            Object o = itr.next();
            if (o instanceof Project && this.canProjectHaveMember((Project)o, proxy, url)) {
                return true;
            }
            URL url2 = VCSModelUtils.getLocatableURL(o);
            if (url2 == null || !URLFileSystem.equals((URL)url, (URL)url2)) continue;
            return !GlobalIgnoreList.isGloballyIgnored((URL)url);
        }
        if (GlobalIgnoreList.isGloballyIgnored((URL)url)) {
            return false;
        }
        if (URLFileSystem.equals((URL)workspace.getURL(), (URL)url)) {
            return true;
        }
        URL workspaceDirUrl = URLFileSystem.getParent((URL)workspace.getURL());
        for (String path : this.getWorkspaceArtifactPaths()) {
            if (!URLFileSystem.isBaseURLFor((URL)URLFactory.newURL((URL)workspaceDirUrl, (String)path), (URL)url)) continue;
            return true;
        }
        return URLFileSystem.equals((URL)workspaceDirUrl, (URL)URLFileSystem.getParent((URL)url)) && !URLFileSystem.isDirectoryPath((URL)url);
    }

    private final Collection<String> getWorkspaceArtifactPaths() {
        return ((VCSManagerImpl)VCSManager.getVCSManager()).getMgrWorkspaceArtifacts();
    }

    @Override
    public Iterator<URL> createProjectIterator(Project project, VCSApplicationSystem.ListMode mode) {
        if (!project.isOpen()) {
            return Collections.emptySet().iterator();
        }
        return new CompositeIterator(new Iterator[]{this.createContentSetURLIterator(ProjectContent.getInstance((PropertyStorage)project).getAllContents(), mode), this.listProjectDirectoryURLs(project, mode).iterator()});
    }

    private final Iterator<URL> createContentSetURLIterator(ContentSet contentSet, final VCSApplicationSystem.ListMode mode) {
        String relPath = null;
        IntersectedFilters additionalFilters = null;
        URLFilter urlFilter = null;
        ContentLevel contentLevel = ContentLevel.newInstance((ContentSet)contentSet, additionalFilters);
        if (relPath != null && !relPath.equals("")) {
            throw new IllegalStateException();
        }
        ContentLevel initialLevel = contentLevel;
        ContentSet contentSet2 = contentSet;
        contentSet2.getClass();
        return new ContentSet.URLIterator(contentSet2, initialLevel, urlFilter){
            {
                ContentSet contentSet = x0;
                contentSet.getClass();
                super(contentSet, x1, x2);
            }

            protected Collection<URL> getLevelFiles(ContentLevel curLevel) {
                ArrayList<URL> files = new ArrayList<URL>();
                if (mode == VCSApplicationSystem.ListMode.FILES_AND_DIRECTORIES || mode == VCSApplicationSystem.ListMode.DIRECTORIES_ONLY) {
                    if (curLevel.getLevel() == 0) {
                        files.addAll(curLevel.getDirectoryURLPath().asList());
                    }
                    files.addAll(curLevel.getDirectoriesAsURLs());
                }
                if (mode == VCSApplicationSystem.ListMode.FILES_AND_DIRECTORIES || mode == VCSApplicationSystem.ListMode.FILES_ONLY) {
                    files.addAll(curLevel.getFiles());
                }
                return files;
            }
        };
    }

    private final Collection<URL> listProjectDirectoryURLs(Project project, VCSApplicationSystem.ListMode mode) {
        URL parentUrl = URLFileSystem.getParent((URL)project.getURL());
        URL[] urls = URLFileSystem.list((URL)URLFileSystem.canonicalize((URL)parentUrl));
        if (urls == null) {
            return Collections.emptySet();
        }
        ArrayList<URL> urls0 = new ArrayList<URL>();
        if (mode == VCSApplicationSystem.ListMode.DIRECTORIES_ONLY) {
            return urls0;
        }
        urls0.addAll(Arrays.asList(urls));
        Iterator itr = urls0.iterator();
        while (itr.hasNext()) {
            URL url = (URL)itr.next();
            if (URLFileSystem.isDirectoryPath((URL)url)) {
                itr.remove();
                continue;
            }
            if (!GlobalIgnoreList.isGloballyIgnored((URL)url)) continue;
            itr.remove();
        }
        return urls0;
    }

    @Override
    public Iterator<URL> createWorkspaceOnlyIterator(Workspace workspace, VCSApplicationSystem.ListMode mode) {
        ArrayList<URL> urls = new ArrayList<URL>();
        if (mode == VCSApplicationSystem.ListMode.FILES_AND_DIRECTORIES || mode == VCSApplicationSystem.ListMode.FILES_ONLY) {
            urls.add(workspace.getURL());
        }
        if (!workspace.isOpen()) {
            return urls.iterator();
        }
        urls.addAll(this.listWorkspaceArtifactURLs(workspace, mode));
        Iterator itr = workspace.getChildren();
        while (itr.hasNext()) {
            Object child = itr.next();
            URL url = VCSModelUtils.getLocatableURL(child);
            if (url == null || mode != VCSApplicationSystem.ListMode.FILES_AND_DIRECTORIES && !(mode == VCSApplicationSystem.ListMode.FILES_ONLY ^ URLFileSystem.isDirectoryPath((URL)url))) continue;
            urls.add(url);
        }
        return urls.iterator();
    }

    private final Collection<URL> listWorkspaceArtifactURLs(Workspace workspace, VCSApplicationSystem.ListMode mode) {
        ArrayList<URL> urls = new ArrayList<URL>();
        for (String path : this.getWorkspaceArtifactPaths()) {
            this.collectWorkspaceArtifactURLs(URLFactory.newURL((URL)URLFileSystem.getParent((URL)workspace.getURL()), (String)path), urls, mode);
        }
        this.collectWorkspaceDirectoryURLs(workspace, urls, mode);
        return urls;
    }

    private final void collectWorkspaceArtifactURLs(URL baseUrl, Collection urls, VCSApplicationSystem.ListMode mode) {
        if (!URLFileSystem.exists((URL)baseUrl)) {
            return;
        }
        if (mode == VCSApplicationSystem.ListMode.FILES_AND_DIRECTORIES || mode == VCSApplicationSystem.ListMode.FILES_ONLY ^ URLFileSystem.isDirectoryPath((URL)baseUrl)) {
            urls.add(baseUrl);
        }
        if (!URLFileSystem.isDirectoryPath((URL)baseUrl)) {
            return;
        }
        URL[] contentsUrls = URLFileSystem.list((URL)baseUrl);
        if (contentsUrls == null) {
            return;
        }
        for (int i = 0; i < contentsUrls.length; ++i) {
            this.collectWorkspaceArtifactURLs(contentsUrls[i], urls, mode);
        }
    }

    private final void collectWorkspaceDirectoryURLs(Workspace workspace, Collection urls, VCSApplicationSystem.ListMode mode) {
        if (mode == VCSApplicationSystem.ListMode.DIRECTORIES_ONLY) {
            return;
        }
        URL workspaceDirUrl = URLFileSystem.getParent((URL)workspace.getURL());
        VirtualFileSystemHelper.invalidateDirectory((URL)workspaceDirUrl);
        URL[] contentsUrls = URLFileSystem.list((URL)workspaceDirUrl);
        for (int i = 0; i < contentsUrls.length; ++i) {
            if (URLFileSystem.isDirectoryPath((URL)contentsUrls[i]) || URLFileSystem.getSuffix((URL)contentsUrls[i]).equals(".jws")) continue;
            urls.add(contentsUrls[i]);
        }
    }
}

