/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs;

import java.awt.Component;
import java.awt.EventQueue;
import java.net.URL;
import java.util.Map;
import java.util.ResourceBundle;
import javax.ide.extension.ExtensionRegistry;
import javax.ide.util.MetaClass;
import javax.swing.JMenuItem;
import javax.swing.SwingUtilities;
import oracle.ide.Addin;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.Version;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.controller.IdeActions;
import oracle.ide.model.ContentSet;
import oracle.ide.model.Element;
import oracle.ide.model.Node;
import oracle.ide.model.NodeEvent;
import oracle.ide.model.NodeFactory;
import oracle.ide.model.NodeListener;
import oracle.ide.model.Project;
import oracle.ide.model.ProjectContent;
import oracle.ide.model.Subject;
import oracle.ide.model.TextNode;
import oracle.ide.model.UpdateMessage;
import oracle.ide.model.Workspace;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLFilter;
import oracle.ide.vcs.VCSEvent;
import oracle.ide.vcs.VCSListener;
import oracle.ide.vcs.VCSManager;
import oracle.ideri.util.Product;
import oracle.javatools.data.PropertyStorage;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.util.Log;
import oracle.jdeveloper.resource.VCSArb;
import oracle.jdeveloper.vcs.properties.PropertiesCommand;
import oracle.jdeveloper.vcs.properties.PropertiesController;
import oracle.jdeveloper.vcs.properties.PropertiesPanel;
import oracle.jdeveloper.vcs.properties.PropertiesPanelRegistry;
import oracle.jdeveloper.vcs.properties.VersionPropertiesPanelProvider;
import oracle.jdeveloper.vcs.res.Bundle;
import oracle.jdeveloper.vcs.share.ShareApplicationCommand;
import oracle.jdeveloper.vcs.share.ShareProjectCommand;
import oracle.jdeveloper.vcs.spi.VCSContextMenuListener;
import oracle.jdeveloper.vcs.spi.VCSControlCache;
import oracle.jdeveloper.vcs.spi.VCSEventBus;
import oracle.jdeveloper.vcs.spi.VCSFileEventSender;
import oracle.jdeveloper.vcs.spi.VCSMenuConstants;
import oracle.jdeveloper.vcs.spi.VCSNodeUpdate;
import oracle.jdeveloper.vcs.util.VCSKeyboardUtils;
import oracle.jdeveloper.vcs.util.VCSMenuUtils;
import oracle.jdeveloper.vcs.util.VCSModelUtils;
import oracle.jdevimpl.vcs.VCSManagerImpl;
import oracle.jdevimpl.vcs.changeset.ChangeSetEBComponent;
import oracle.jdevimpl.vcs.util.GeneralPropertiesPanel;

final class VersioningAddin
implements Addin {
    private static final Log LOG = new Log("vcs");
    private static final String ACCELERATOR_FILE = "oracle/jdevimpl/vcs/accelerators.xml";

    VersioningAddin() {
    }

    public final void initialize() {
        VCSFileEventSender.setFileEventSender(new VCSFileEventSender(){

            @Override
            protected void fireVCSEvent(URL[] urls, int eventType) {
                VersioningAddin.this._fireVCSEvent(urls, eventType);
            }
        });
        if (Ide.getIdeArgs().getCreateUI()) {
            this.registerPropertiesHandlers();
        }
        Node.addNodeListenerForTypeHierarchy(Node.class, (NodeListener)new NodeListener(){

            public void nodeSaved(final NodeEvent ne) {
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public final void run() {
                        VersioningAddin.this.fireNodeSaved(ne.getNode());
                    }
                });
            }

            public void nodeReverted(final NodeEvent ne) {
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public final void run() {
                        VersioningAddin.this.fireNodeReloaded(ne.getNode());
                    }
                });
            }

            public void nodeRenamed(final NodeEvent ne, final URL oldURL, URL newURL) {
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public final void run() {
                        VersioningAddin.this.fireNodeRenamed(ne.getNode(), oldURL);
                    }
                });
            }
        });
        if (Ide.getIdeArgs().getCreateUI()) {
            VCSKeyboardUtils.addAcceleratorDefinitionFile(this.getClass().getClassLoader(), ACCELERATOR_FILE);
            EventQueue.invokeLater(new Runnable(){

                @Override
                public final void run() {
                    IdeActions.getFileSaveAction().addController(new Controller(){

                        public boolean handleEvent(IdeAction action, Context context) {
                            if (this.canSave(context)) {
                                return false;
                            }
                            MessageDialog.information((Component)Ide.getMainWindow(), (Object)Bundle.get("FILE_SAVE_CONFLICT"), (String)Bundle.get("FILE_SAVE_CONFLICT_TITLE"), null);
                            return true;
                        }

                        private boolean canSave(Context context) {
                            URL url = VCSModelUtils.getLocatableURL(context.getNode());
                            return url == null || context.getNode() instanceof TextNode || !VCSManager.getVCSManager().containsConflicts(url);
                        }

                        public boolean update(IdeAction action, Context context) {
                            return false;
                        }
                    });
                }
            });
        }
        Node.addNodeListenerForTypeHierarchy(Project.class, (NodeListener)new NodeListener(){

            public void nodeOpened(NodeEvent ne) {
                Project project = (Project)ne.getNode();
                VCSListenerImpl l = new VCSListenerImpl(project);
                project.getTransientProperties().put("VCSListener", l);
                VCSManager.getVCSManager().addVCSListener((VCSListener)l, null);
            }

            public void nodeClosed(NodeEvent ne) {
                Project project = (Project)ne.getNode();
                VCSListener l = (VCSListener)project.getTransientProperties().remove("VCSListener");
                if (l != null) {
                    VCSManager.getVCSManager().removeVCSListener(l);
                }
            }
        });
        if (Ide.getIdeArgs().getCreateUI()) {
            IdeAction.find((int)51).addController(new Controller(){

                public boolean handleEvent(IdeAction action, Context context) {
                    if (action.getCommandId() == 51) {
                        VCSControlCache.getInstance().fireControlStateChanged(null);
                    }
                    return false;
                }

                public boolean update(IdeAction action, Context context) {
                    return false;
                }
            });
            VCSMenuUtils.installContextMenuListener(new VCSContextMenuListener(null){

                @Override
                protected Component[] getContextMenuItems(Context context) {
                    if (Product.isRaptor()) {
                        return null;
                    }
                    if (context.getNode() instanceof Workspace) {
                        Component[] componentArray;
                        IdeAction action = ShareApplicationCommand.getShareApplicationAction();
                        action.updateAction(context);
                        if (action.isEnabled()) {
                            Component[] componentArray2 = new Component[1];
                            componentArray = componentArray2;
                            componentArray2[0] = VCSMenuUtils.createMenuItem(action.getCommandId(), 1000.0f);
                        } else {
                            componentArray = null;
                        }
                        return componentArray;
                    }
                    if (context.getNode() instanceof Project) {
                        IdeAction action = ShareProjectCommand.getShareProjectAction();
                        action.updateAction(context);
                        if (!action.isEnabled()) {
                            return null;
                        }
                        JMenuItem menuItem = VCSMenuUtils.createMenuItem(action.getCommandId(), 1000.0f);
                        return new Component[]{menuItem};
                    }
                    return null;
                }

                @Override
                protected float getSection() {
                    return 1.0f;
                }
            });
            Ide.getVersionInfo().addComponent(VCSArb.get("VCS_ABOUT_TITLE"), Version.VER_FULL);
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    VersioningAddin.this.installVersionsMenuWindow();
                }
            });
        }
        VCSEventBus.addToBus(new ChangeSetEBComponent());
    }

    private final void installVersionsMenuWindow() {
        Integer id = Ide.findOrCreateCmdID((String)"VCS.VersioningNavigator");
        VCSMenuUtils.addMenuItemToTeamMenu(id, null, 99.0f);
    }

    private void fireNodeReloaded(Node node) {
        VCSNodeUpdate nodeUpdate = new VCSNodeUpdate(node, VCSNodeUpdate.RELOADED);
        VCSEventBus.send(nodeUpdate);
    }

    private void fireNodeRenamed(Node node, URL oldUrl) {
        VCSNodeUpdate nodeUpdate = new VCSNodeUpdate(node, VCSNodeUpdate.RENAMED);
        nodeUpdate.setOldURL(oldUrl);
        VCSEventBus.send(nodeUpdate);
    }

    private void fireNodeSaved(Node node) {
        VCSNodeUpdate nodeUpdate = new VCSNodeUpdate(node, VCSNodeUpdate.SAVED);
        VCSEventBus.send(nodeUpdate);
    }

    private void _fireVCSEvent(URL[] urls, int eventType) {
        Map<VCSListener, URLFilter> vcsListeners = ((VCSManagerImpl)VCSManager.getVCSManager()).getMgrVCSListeners();
        VCSEvent vcse = new VCSEvent((Object)this, urls, eventType);
        VCSListener[] l = vcsListeners.keySet().toArray(new VCSListener[0]);
        block0: for (int i = l.length - 1; i >= 0; --i) {
            URLFilter filter = vcsListeners.get(l[i]);
            if (filter == null) {
                if (eventType == 3) continue;
                l[i].notifyEvent(vcse);
                continue;
            }
            for (int j = 0; j < urls.length; ++j) {
                if (!filter.accept(urls[j])) continue;
                l[i].notifyEvent(vcse);
                continue block0;
            }
        }
    }

    private void registerPropertiesHandlers() {
        IdeAction propertiesAction = IdeAction.findOrCreate((int)PropertiesCommand.PROPERTIES_CMD_ID, (MetaClass)new MetaClass(ExtensionRegistry.getExtensionRegistry().getClassLoader("oracle.jdeveloper.vcs"), PropertiesCommand.PROPERTIES_CMD), (String)VCSArb.get("PROPERTIES"), (String)VCSArb.get("VERSIONING_CATEGORY"), null, (ResourceBundle)VCSArb.getBundle(), null, null, (boolean)false);
        propertiesAction.putValue("Category", (Object)VCSMenuConstants.ACTION_CATEGORY_VERSIONING);
        propertiesAction.putValue("NoCtxName", (Object)VCSArb.get("PROPERTIES_CONTEXT_INDEPENDENT_NAME"));
        VCSKeyboardUtils.addKeyStrokeContext(new IdeAction[]{propertiesAction}, "Versioning-Properties");
        propertiesAction.addController((Controller)new PropertiesController());
        PropertiesPanelRegistry.registerPanelProvider(new VersionPropertiesPanelProvider(){

            @Override
            public String getTabName() {
                return VCSArb.get("PROPERTIES_GENERAL");
            }

            @Override
            public float getTabWeight() {
                return Float.MAX_VALUE;
            }

            @Override
            public boolean isDefaultTab() {
                return false;
            }

            @Override
            public boolean isHandled(Context context) {
                if (!super.isHandled(context)) {
                    return false;
                }
                URL url = this.getContextURL(context);
                return url != null && VCSManager.getVCSManager().isVersioned(url);
            }

            @Override
            public PropertiesPanel createPanel(Context context) {
                return new GeneralPropertiesPanel(this.getContextElement(context), this.getContextURL(context));
            }
        });
    }

    private class VCSListenerImpl
    implements VCSListener {
        private final Project _project;

        VCSListenerImpl(Project project) {
            this._project = project;
        }

        public void notifyEvent(VCSEvent event) {
            int eventType = event.getEventType();
            switch (eventType) {
                case 1: {
                    LOG.trace("VCSManager: VCSEvent.FILE_CREATED");
                    ContentSet contents = ProjectContent.getInstance((PropertyStorage)this._project).getAllContents();
                    URL[] addedURLs = event.getURLs();
                    for (int i = 0; i < addedURLs.length; ++i) {
                        if (!contents.canHaveMember(addedURLs[i])) continue;
                        try {
                            Node node = NodeFactory.findOrCreate((URL)addedURLs[i]);
                            this.fireAddedEvent(node);
                            continue;
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                    break;
                }
                case 2: {
                    LOG.trace("VCSManager: VCSEvent.FILE_DELETED");
                    ContentSet contents = ProjectContent.getInstance((PropertyStorage)this._project).getAllContents();
                    URL[] removedURLs = event.getURLs();
                    for (int i = 0; i < removedURLs.length; ++i) {
                        Node removedNode;
                        if (!contents.canHaveMember(removedURLs[i]) || (removedNode = NodeFactory.find((URL)removedURLs[i])) == null) continue;
                        this.fireRemovedEvent(removedNode);
                    }
                    break;
                }
                case 4: {
                    LOG.trace("VCSManager: VCSEvent.FILE_STRUCTURE_CHANGED");
                    ContentSet contents = ProjectContent.getInstance((PropertyStorage)this._project).getAllContents();
                    URL[] structureChangeURLs = event.getURLs();
                    URL projectDir = URLFileSystem.getParent((URL)this._project.getURL());
                    for (int i = 0; i < structureChangeURLs.length; ++i) {
                        if (contents.canHaveMember(structureChangeURLs[i])) {
                            this.fireStructureChangedEvent();
                            continue;
                        }
                        if (!URLFileSystem.equals((URL)structureChangeURLs[i], (URL)projectDir)) continue;
                        this.fireStructureChangedEvent();
                    }
                    break;
                }
            }
        }

        private void fireAddedEvent(Node addedNode) {
            UpdateMessage.fireChildAdded((Subject)this._project, (Element)addedNode);
        }

        private void fireRemovedEvent(Node removedNode) {
            UpdateMessage updateMessage = new UpdateMessage(UpdateMessage.CHILD_REMOVED, (Object)this);
            updateMessage.getRemoveObjects().add(removedNode);
            this._project.notifyObservers((Object)this._project, updateMessage);
        }

        private void fireStructureChangedEvent() {
            UpdateMessage.fireStructureChanged((Subject)this._project);
        }
    }
}

