/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.palette2;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.io.File;
import java.net.URL;
import java.util.Collection;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.ide.Ide;
import oracle.ide.ceditor.keymap.EditorFactory;
import oracle.ide.dialogs.DialogUtil;
import oracle.ide.help.HelpSystem;
import oracle.ide.net.DefaultURLFilter;
import oracle.ide.net.URLChooser;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFilter;
import oracle.ide.net.URLTextField;
import oracle.ide.palette2.PaletteItem;
import oracle.ide.palette2.PaletteSection;
import oracle.ide.palette2.res.Bundle;
import oracle.ide.resource.IdeIcons;
import oracle.ide.util.GraphicsUtils;
import oracle.ide.util.ResourceUtils;
import oracle.ideimpl.palette2.MyComponentsCodeSnippetItem;
import oracle.ideimpl.palette2.MyComponentsGroup;
import oracle.ideimpl.palette2.PaletteArb;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.editor.BasicEditorPane;

public class MyComponentsCodeSnippetDialog
implements VetoableChangeListener {
    private JEWTDialog _dlg;
    private CodeSnippetPanel _panel = null;
    private MyComponentsGroup paletteGroup;
    private MyComponentsCodeSnippetItem paletteItem;
    private String sectionName;

    public boolean invoke(MyComponentsGroup group, String sectionName, MyComponentsCodeSnippetItem item, String snippetText) {
        String caption;
        this.paletteGroup = group;
        this.paletteItem = item;
        this.sectionName = sectionName;
        this._panel = new CodeSnippetPanel();
        if (this.paletteItem == null) {
            caption = PaletteArb.getString(19);
            this._panel.setIconUrl(null);
            if (snippetText != null) {
                this._panel.setSnippet(snippetText);
            }
        } else {
            caption = PaletteArb.getString(20);
            this._panel.setName(this.paletteItem.getName());
            this._panel.setIconUrl(this.paletteItem.getIconURL());
            this._panel.setSnippet((String)this.paletteItem.getData("codeSnippet"));
        }
        this._dlg = new JEWTDialog((Frame)Ide.getMainWindow(), caption, 7);
        this._dlg.setContent((Component)this._panel);
        this._dlg.setPreferredSize(new Dimension(500, 300));
        this._dlg.addVetoableChangeListener((VetoableChangeListener)this);
        HelpSystem.getHelpSystem().registerTopic((JComponent)this._dlg.getContent(), "f1_idededitsnippet_html");
        boolean result = this._dlg.runDialog();
        this._dlg.removeVetoableChangeListener((VetoableChangeListener)this);
        this._dlg.dispose();
        return result;
    }

    @Override
    public void vetoableChange(PropertyChangeEvent evt) throws PropertyVetoException {
        if (JEWTDialog.isDialogClosingEvent((PropertyChangeEvent)evt) && (this.paletteItem == null ? !this.addSnippet() : !this.updateSnippet())) {
            throw new PropertyVetoException("no", evt);
        }
    }

    private boolean addSnippet() {
        boolean canContinue = true;
        String message = "";
        if (this._panel.getName().trim().length() == 0) {
            message = PaletteArb.getString(26);
            canContinue = false;
            this._panel.getNameFld().requestFocus();
        } else if (this._panel.getSnippet().trim().length() == 0) {
            message = PaletteArb.getString(27);
            canContinue = false;
            this._panel.getSnippetFld().requestFocus();
        } else if (this.snippetNameInUse(this._panel.getName())) {
            message = PaletteArb.format(28, this._panel.getName());
            canContinue = false;
            this._panel.getNameFld().requestFocus();
        }
        if (!canContinue) {
            MessageDialog.error((Component)this._dlg, (Object)message, (String)Bundle.get("COMPONENT_PALETTE"), null);
            return false;
        }
        MyComponentsCodeSnippetItem item = new MyComponentsCodeSnippetItem(this._panel.getName(), this._panel.getIconUrl(), this._panel.getSnippet());
        this.paletteGroup.getMyComponentsPages().appendCodeSnippet(item, this.sectionName, true);
        return true;
    }

    private boolean updateSnippet() {
        boolean canContinue = true;
        String message = "";
        if (this._panel.getName().trim().length() == 0) {
            message = PaletteArb.getString(26);
            canContinue = false;
            this._panel.getNameFld().requestFocus();
        } else if (this._panel.getSnippet().trim().length() == 0) {
            message = PaletteArb.getString(27);
            canContinue = false;
            this._panel.getSnippetFld().requestFocus();
        } else {
            String panelName = this._panel.getName();
            if (!this.paletteItem.getName().equalsIgnoreCase(panelName) && this.snippetNameInUse(this._panel.getName())) {
                message = PaletteArb.getString(28);
                canContinue = false;
                this._panel.getNameFld().requestFocus();
            }
        }
        if (!canContinue) {
            MessageDialog.error((Component)this._dlg, (Object)message, (String)Bundle.get("COMPONENT_PALETTE"), null);
            return false;
        }
        if (!this.paletteItem.getName().equalsIgnoreCase(this._panel.getName())) {
            this.paletteGroup.getMyComponentsPages().removeItem(11, this.paletteItem, this.sectionName);
            MyComponentsCodeSnippetItem item = new MyComponentsCodeSnippetItem(this._panel.getName(), this._panel.getIconUrl(), this._panel.getSnippet());
            this.paletteGroup.getMyComponentsPages().appendCodeSnippet(item, this.sectionName, true);
        } else {
            this.paletteGroup.getMyComponentsPages().updateCodeSnippet(this._panel.getName(), this._panel.getIconUrl(), this._panel.getSnippet());
        }
        return true;
    }

    private boolean snippetNameInUse(String name) {
        if (this.paletteGroup != null) {
            Collection<PaletteSection> paletteSections = this.paletteGroup.getSections();
            for (PaletteSection section : paletteSections) {
                Collection<PaletteItem> paletteItems = section.getItems();
                for (PaletteItem paletteItem : paletteItems) {
                    if (!paletteItem.getName().equalsIgnoreCase(name)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    private class CodeSnippetPanel
    extends JPanel
    implements ActionListener {
        JLabel _nameLbl = new JLabel();
        JTextField _nameFld = new JTextField();
        GridBagLayout gridBagLayout1 = new GridBagLayout();
        JLabel _snippetLbl = new JLabel();
        JScrollPane jScrollPane1 = new JScrollPane();
        final BasicEditorPane _snippetFld = EditorFactory.createStandaloneEditorPane();
        private JLabel _itemImageLbl = new JLabel();
        private JLabel _imageViewLbl = new JLabel();
        private URLTextField _imageFld = new URLTextField();
        private JButton _browseBtn = new JButton();

        public CodeSnippetPanel() {
            try {
                this.jbInit();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        private void jbInit() throws Exception {
            this.setLayout(this.gridBagLayout1);
            this._snippetFld.setLanguageSupport("temp.jsp");
            ResourceUtils.resLabel((JLabel)this._nameLbl, (Component)this._nameFld, (String)PaletteArb.getString(21));
            ResourceUtils.resLabel((JLabel)this._itemImageLbl, (Component)this._imageFld, (String)PaletteArb.getString(23));
            ResourceUtils.resLabel((JLabel)this._snippetLbl, (Component)this._snippetFld, (String)PaletteArb.getString(22));
            ResourceUtils.resButton((AbstractButton)this._browseBtn, (String)PaletteArb.getString(24));
            Insets labelInsets = new Insets(0, 0, 5, 0);
            Insets insets = new Insets(0, 5, 5, 0);
            this.add((Component)this._nameLbl, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, labelInsets, 0, 0));
            this.add((Component)this._nameFld, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 10, 2, insets, 0, 0));
            this.add((Component)this._itemImageLbl, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 0, labelInsets, 0, 0));
            this.add((Component)this._imageFld, new GridBagConstraints(1, 2, 2, 1, 0.0, 0.0, 10, 2, insets, 0, 0));
            this.add((Component)this._browseBtn, new GridBagConstraints(3, 2, 1, 1, 0.0, 0.0, 13, 0, insets, 0, 0));
            this.add((Component)this._imageViewLbl, new GridBagConstraints(4, 2, 1, 1, 0.0, 0.0, 10, 1, insets, 0, 0));
            this.add((Component)this._snippetLbl, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 11, 2, labelInsets, 0, 0));
            this.jScrollPane1.getViewport().add((Component)this._snippetFld, null);
            this.add((Component)this.jScrollPane1, new GridBagConstraints(1, 3, 4, 6, 1.0, 1.0, 10, 1, insets, 0, 0));
            this._browseBtn.addActionListener(this);
            this._imageViewLbl.setText("");
        }

        @Override
        public String getName() {
            return this._nameFld.getText();
        }

        @Override
        public void setName(String name) {
            this._nameFld.setText(name);
        }

        public void setSnippet(String s) {
            this._snippetFld.setText(s);
        }

        public String getSnippet() {
            return this._snippetFld.getText();
        }

        public JTextField getNameFld() {
            return this._nameFld;
        }

        public BasicEditorPane getSnippetFld() {
            return this._snippetFld;
        }

        public void setIconUrl(String imageURL) {
            if (imageURL == null || imageURL.length() == 0) {
                imageURL = IdeIcons.getString((int)28);
            }
            this._imageFld.setText(imageURL);
            this._imageViewLbl.setIcon(this.getIconImage(imageURL));
        }

        public String getIconUrl() {
            return this._imageFld.getText();
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            URL url;
            if (e.getSource() == this._browseBtn && (url = this.showImageDialog()) != null) {
                this._imageFld.setURL(url);
                Toolkit toolkit = Toolkit.getDefaultToolkit();
                Image image = toolkit.getImage(url);
                if (image != null) {
                    this._imageViewLbl.setText("");
                    ImageIcon i = new ImageIcon(image);
                    this._imageViewLbl.setIcon(i);
                } else {
                    this._imageViewLbl.setText(PaletteArb.getString(25));
                }
                this.invalidate();
                this.repaint();
            }
        }

        private URL showImageDialog() {
            String[] imageFiles = GraphicsUtils.getImageExtensions();
            URLChooser _imageChooser = DialogUtil.newURLChooser((URL)URLFactory.newURL(null));
            _imageChooser.setURLFilter((URLFilter)new DefaultURLFilter("Image Files", imageFiles));
            _imageChooser.setSelectionScope(0);
            int approve = _imageChooser.showOpenDialog((Component)Ide.getMainWindow(), PaletteArb.getString(29));
            if (approve == 0) {
                return _imageChooser.getSelectedURL();
            }
            return null;
        }

        private Icon getIconImage(String iconParm) {
            ImageIcon icon = null;
            if (iconParm == null) {
                return null;
            }
            try {
                Toolkit toolkit;
                Image image;
                File file;
                URL url = null;
                int index = iconParm.indexOf("!");
                url = index != -1 ? ((iconParm = iconParm.replace('\\', '/')).indexOf("file:") == -1 ? new URL("jar:file:/" + iconParm) : new URL("jar:" + iconParm)) : this.getClass().getResource(iconParm);
                if (url == null && (file = new File(iconParm)).exists()) {
                    url = file.toURL();
                }
                if (url != null && (image = (toolkit = Toolkit.getDefaultToolkit()).getImage(url)) != null) {
                    icon = new ImageIcon(image);
                }
            }
            catch (Exception ex) {
                icon = null;
            }
            return icon;
        }
    }
}

