/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.palette2;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DragSourceEvent;
import java.awt.dnd.DragSourceListener;
import java.awt.dnd.InvalidDnDOperationException;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.InputEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleIcon;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import javax.swing.text.html.HTMLDocument;
import oracle.ide.Context;
import oracle.ide.ExtensionRegistry;
import oracle.ide.adapters.AdapterManager;
import oracle.ide.editor.EditorManager;
import oracle.ide.feedback.FeedbackManager;
import oracle.ide.hover.Hover;
import oracle.ide.hover.HoverFlavor;
import oracle.ide.hover.Hoverable;
import oracle.ide.hover.HoverableRegistry;
import oracle.ide.model.ColorProvider;
import oracle.ide.palette2.DefaultPaletteItem;
import oracle.ide.palette2.PaletteItem;
import oracle.ide.palette2.PalettePages;
import oracle.ide.palette2.PaletteTransferable;
import oracle.ide.util.Assert;
import oracle.ideimpl.palette2.MyComponentsCodeSnippetItem;
import oracle.ideimpl.palette2.MyComponentsPages;
import oracle.ideimpl.palette2.Palette1Provider;
import oracle.ideimpl.palette2.PaletteArb;
import oracle.ideimpl.palette2.PaletteControllerUI;
import oracle.ideimpl.palette2.PaletteGroupUI;
import oracle.ideimpl.palette2.PaletteSectionUI;
import oracle.ideimpl.palette2.PaletteWindowImpl;
import oracle.ideimpl.palette2.PaletteWindowUI;
import oracle.javatools.datatransfer.AugmentableTransferable;
import oracle.javatools.datatransfer.TransferDataInfo;
import oracle.javatools.datatransfer.TransferUtils;
import oracle.javatools.dnd.DndUtils;
import oracle.javatools.ui.SuperLabel;
import oracle.javatools.ui.infotip.InfoTipHover;
import oracle.javatools.ui.infotip.InfoTipStyles;
import oracle.javatools.ui.infotip.templates.ActionTemplate;
import oracle.javatools.ui.infotip.templates.Template;
import oracle.javatools.util.Disposable;
import oracle.javatools.util.ModelUtil;

public class PaletteItemUI
extends JPanel
implements Disposable {
    private static final HoverFlavor HOVER_FLAVOR = HoverFlavor.getFlavor((String)"info");
    private transient PaletteItem paletteItem;
    private transient PaletteSectionUI paletteSectionUI;
    private ItemUI itemUI;
    private String pageName;
    private String groupName;
    private boolean _hasFocus;
    static final Logger _logger = Logger.getLogger(PaletteItemUI.class.getName());
    private transient ColorProvider<PaletteItemUI> colorProvider;
    private boolean useLargeIcon = true;

    public PaletteItemUI(PaletteItem item, PaletteSectionUI sectionUI, String viewState, String pageName, String groupName) {
        this.paletteItem = item;
        this.paletteSectionUI = sectionUI;
        this.pageName = pageName;
        this.groupName = groupName;
        this.useLargeIcon = this.paletteSectionUI.getUseLargeIcons();
        this.colorProvider = (ColorProvider)AdapterManager.Factory.getAdapterManager().adapt((Object)this, ColorProvider.class);
        try {
            this.jbInit();
        }
        catch (Exception e) {
            FeedbackManager.reportException((Throwable)e);
        }
    }

    private void jbInit() {
        this.setLayout(new BorderLayout());
        this.setBackground(this.colorProvider.backgroundFor((Object)this, "enabled"));
        this.itemUI = new ItemUI(this);
        this.add((Component)this.itemUI, "Center");
        this.addKeyListener(this.paletteSectionUI.getPaletteGroupUI());
        PaletteItem item = this.getPaletteItem();
        if (null == item) {
            return;
        }
        Icon icon = this.useLargeIcon ? item.getLargeIcon() : item.getIcon();
        this.itemUI.setIcon(icon);
    }

    public PaletteItem getPaletteItem() {
        return this.paletteItem;
    }

    public PaletteSectionUI getPaletteSectionUI() {
        return this.paletteSectionUI;
    }

    public void showAsUnselected() {
        if (null != this.itemUI) {
            this.itemUI.setAndShowAsUnselected();
        }
    }

    public void showAsSelected() {
        if (null != this.itemUI) {
            this.itemUI.setAndShowAsSelected();
        }
    }

    public void markRecentUsage() {
        if (null != this.itemUI) {
            this.itemUI.markRecentUsage();
        }
    }

    public void setShowState(String viewState) {
    }

    public String getPageName() {
        return this.pageName;
    }

    public String getGroupName() {
        return this.groupName;
    }

    @Override
    public boolean hasFocus() {
        return this._hasFocus;
    }

    void addFocusListenerWithoutPropagationToParent(FocusListener l) {
        if (l == null) {
            return;
        }
        super.addFocusListener(l);
        if (this.itemUI != null) {
            this.itemUI.addFocusListener(l);
        }
    }

    @Override
    public synchronized void addFocusListener(FocusListener l) {
        this.addFocusListenerWithoutPropagationToParent(l);
        this.propagateFocusListenerToParent(l);
    }

    private void propagateFocusListenerToParent(FocusListener l) {
        Container parent = this.getParent();
        if (!(parent instanceof PaletteGroupUI.CenterPanel)) {
            return;
        }
        PaletteGroupUI.CenterPanel centerPanel = (PaletteGroupUI.CenterPanel)parent;
        centerPanel.addFocusListener(l, this);
    }

    public JLabel getGUI() {
        return this.itemUI;
    }

    public String getItemName() {
        PaletteItem item = this.getPaletteItem();
        return null != item ? item.getName() : "";
    }

    public Icon getLargeIcon() {
        PaletteItem item = this.getPaletteItem();
        return null != item ? item.getLargeIcon() : null;
    }

    public void setUseLargeIcon(boolean useLargeIcon) {
        Icon icon;
        if (useLargeIcon == this.useLargeIcon) {
            return;
        }
        this.useLargeIcon = useLargeIcon;
        PaletteItem item = this.getPaletteItem();
        if (null == item) {
            return;
        }
        Icon icon2 = icon = this.useLargeIcon ? item.getLargeIcon() : item.getIcon();
        if (null != this.itemUI) {
            this.itemUI.setIcon(icon);
        }
    }

    @Override
    public void requestFocus() {
        super.requestFocus();
        if (null != this.itemUI) {
            this.itemUI.requestFocus();
        }
    }

    @Override
    public synchronized void addKeyListener(KeyListener l) {
        super.addKeyListener(l);
        if (null != this.itemUI) {
            this.itemUI.addKeyListener(l);
        }
    }

    @Override
    public synchronized void removeKeyListener(KeyListener l) {
        super.removeKeyListener(l);
        if (null != this.itemUI) {
            this.itemUI.removeKeyListener(l);
        }
    }

    @Override
    public String getName() {
        return this.getItemName();
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + "@" + Integer.toHexString(this.hashCode()) + ": " + (null != this.paletteItem ? this.paletteItem.getName() : "<null>");
    }

    public void dispose() {
        if (null != this.itemUI) {
            this.itemUI.dispose();
            this.itemUI = null;
        }
    }

    private static class ItemUI
    extends JLabel
    implements MouseListener,
    DragSourceListener,
    DragGestureListener,
    Hoverable,
    AncestorListener,
    Disposable {
        private static final String HOVER_TIP_FMT = "<html><b>{0}</b></html>";
        private static final String HTML = "<html>";
        private static final Pattern NAKED_HTML = Pattern.compile("<.*>.*</.*>", 32);
        private static final Pattern HTML_REGEX = Pattern.compile("^\\s?<\\s?[hH][tT][Mm][Ll]\\s?>.*");
        private Border defaultBorder;
        private DragSource _dragSource;
        private boolean _tryPopupInMousePressed = false;
        private boolean _selected = false;
        private PaletteControllerUI paletteController = PaletteControllerUI.getInstance();
        private PaletteItemUI paletteItemUI;
        private ColorProvider<PaletteItemUI> colorProvider;
        private boolean dragEventWasCancelled = false;

        public ItemUI(PaletteItemUI paletteItemUI) {
            this.paletteItemUI = paletteItemUI;
            this.paletteItemUI.addAncestorListener(this);
            this.colorProvider = (ColorProvider)AdapterManager.Factory.getAdapterManager().adapt((Object)paletteItemUI, ColorProvider.class);
            this.decorate();
            String name = this.paletteItemUI.getName();
            this.setName("PaletteItem " + name);
            AccessibleContext accessibleCtx = this.getAccessibleContext();
            AccessibleIcon[] accessibleIcon = accessibleCtx.getAccessibleIcon();
            if (accessibleIcon != null && name != null) {
                accessibleIcon[0].setAccessibleIconDescription(name);
                accessibleCtx.setAccessibleName(name);
                accessibleCtx.setAccessibleDescription(name);
            }
            this.resetHighlight();
            this.defaultBorder = BorderFactory.createEmptyBorder(2, 3, 2, 3);
            this.setBorder(this.defaultBorder);
            this.setRequestFocusEnabled(false);
            this.setFocusable(true);
            this.addFocusListener();
            this._dragSource = new DragSource();
            this._dragSource.createDefaultDragGestureRecognizer(this, 1, this);
        }

        @Override
        protected void processComponentKeyEvent(KeyEvent e) {
            if (e.getID() != 401) {
                return;
            }
            if (e.getKeyCode() == 9) {
                Container cont = this.paletteItemUI.getParent();
                Component[] children = cont.getComponents();
                if (children == null || children.length == 0) {
                    return;
                }
                if (e.isShiftDown()) {
                    children[0].transferFocusBackward();
                } else {
                    Component c = children[children.length - 1];
                    if (c instanceof PaletteItemUI) {
                        ((PaletteItemUI)c).itemUI.transferFocus();
                    } else {
                        children[children.length - 1].transferFocus();
                    }
                }
            }
        }

        private void addFocusListener() {
            this.addFocusListener(new FocusListener(){

                @Override
                public void focusGained(FocusEvent e) {
                    paletteItemUI._hasFocus = true;
                    if (this.isSelected()) {
                        this.resetHighlight();
                    } else {
                        this.highlight();
                    }
                    ItemUI source = this;
                    Rectangle sourceBounds = source.getBounds();
                    JViewport viewport = this.viewPortInHierarchy(source);
                    if (viewport == null) {
                        return;
                    }
                    Component view = viewport.getView();
                    if (null != view) {
                        view.setVisible(true);
                    }
                    Rectangle convertedSourceBounds = SwingUtilities.convertRectangle(source, sourceBounds, viewport);
                    viewport.scrollRectToVisible(convertedSourceBounds);
                }

                @Override
                public void focusLost(FocusEvent e) {
                    paletteItemUI._hasFocus = false;
                    if (paletteController.getStickyMode() && paletteController.getSelectedItemUI() == paletteItemUI) {
                        return;
                    }
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            this.setAndShowAsUnselected();
                        }
                    });
                }
            });
        }

        private JViewport viewPortInHierarchy(Component start) {
            for (Component c = start; c != null; c = c.getParent()) {
                if (!(c instanceof JViewport)) continue;
                return (JViewport)c;
            }
            return null;
        }

        private final void decorate() {
            this.setOpaque(true);
            this.addMouseListener(this);
            this.addKeyListener(this.paletteItemUI.getPaletteSectionUI().getPaletteGroupUI());
        }

        @Override
        public Point getToolTipLocation(MouseEvent event) {
            int x = (int)this.getAlignmentX();
            int y = (int)this.getAlignmentY();
            return new Point(x, y + 50);
        }

        private String _getToolText() {
            String toolTip = this.paletteItemUI.getPaletteItem().getDescription();
            toolTip = false == ModelUtil.hasLength((String)toolTip) ? this.paletteItemUI.getPaletteItem().getName() : this.maybeConvertToHtml(toolTip);
            return toolTip;
        }

        private String maybeConvertToHtml(String toolTip) {
            if (HTML_REGEX.matcher(toolTip).matches()) {
                return toolTip;
            }
            toolTip = toolTip.replace("\n", " ");
            toolTip = toolTip.replace("\r", " ");
            if (NAKED_HTML.matcher(toolTip = toolTip.replaceAll("\\s{2,}", " ")).matches()) {
                toolTip = toolTip.replace("&amp;", "&");
                return "<html><body>" + toolTip + "</body></html>";
            }
            return toolTip;
        }

        @Override
        public void mouseEntered(MouseEvent e) {
            if (e.getModifiers() == 16) {
                return;
            }
            if (!this.isSelected() && e.getClickCount() == 0) {
                this.highlight();
            }
        }

        private void highlight() {
            if (this.isSelected()) {
                return;
            }
            this.setBackground(this.colorProvider.backgroundFor((Object)this.paletteItemUI, "mouseover"));
            this.setForeground(this.colorProvider.foregroundFor((Object)this.paletteItemUI, "mouseover"));
        }

        public void markRecentUsage() {
            this.getMyComponentsPages().addToRecentlyUsed(this.paletteItemUI.getPaletteItem(), this.paletteItemUI.getPageName(), this.paletteItemUI.getGroupName(), true);
        }

        @Override
        public void mousePressed(MouseEvent e) {
            PaletteSectionUI section;
            this.dragEventWasCancelled = false;
            PaletteItemUI item = this.paletteController.getSelectedItemUI();
            if (item != null && item != this.paletteItemUI) {
                item.showAsUnselected();
                this.paletteController.setSelectedWindowUI((PaletteItemUI)null);
            }
            if ((section = this.paletteController.getSelectedSectionUI()) != null) {
                section.showAsUnselected();
                this.paletteController.setSelectedWindowUI((PaletteSectionUI)null);
            }
            this._tryPopupInMousePressed = e.isPopupTrigger();
            if (this._tryPopupInMousePressed) {
                this.paletteController.setSelectedWindowUI(this.paletteItemUI, "PALETTE2_BUTTON2_PRESSED");
                this.tryPopup(e);
            }
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            if (this.dragEventWasCancelled) {
                this.dragEventWasCancelled = false;
                return;
            }
            if (e.isShiftDown() || e.getClickCount() == 2) {
                this.setAndShowAsSelected();
                this.paletteController.setSelectedWindowUI(this.paletteItemUI);
                this.paletteController.setStickyMode(true);
                return;
            }
            if (!this._tryPopupInMousePressed) {
                if (e.isPopupTrigger()) {
                    this.paletteController.setSelectedWindowUI(this.paletteItemUI, "PALETTE2_BUTTON2_RELEASED");
                    this.tryPopup(e);
                } else {
                    if (this.paletteController.getStickyMode()) {
                        this.paletteController.setStickyMode(false);
                    }
                    if (e.isControlDown()) {
                        if (this.paletteItemUI == this.paletteController.getSelectedItemUI()) {
                            this.setAndShowAsUnselected();
                            this.paletteController.setSelectedWindowUI((PaletteItemUI)null);
                        } else {
                            this.setAndShowAsSelected();
                            this.paletteController.setSelectedWindowUI(this.paletteItemUI);
                        }
                    } else {
                        this.setAndShowAsSelected();
                        this.paletteController.setSelectedWindowUI(this.paletteItemUI);
                    }
                }
            }
        }

        @Override
        public void mouseClicked(MouseEvent e) {
        }

        @Override
        public void mouseExited(MouseEvent e) {
            if (e.getModifiers() == 16) {
                return;
            }
            this.resetHighlight();
        }

        private void tryPopup(MouseEvent e) {
            if (e.isPopupTrigger()) {
                this.paletteController.tryPopup(e);
            }
        }

        @Override
        public void dragEnter(DragSourceDragEvent dsde) {
        }

        @Override
        public void dragOver(DragSourceDragEvent dsde) {
        }

        @Override
        public void dropActionChanged(DragSourceDragEvent dsde) {
        }

        @Override
        public void dragExit(DragSourceEvent dse) {
        }

        @Override
        public void dragDropEnd(DragSourceDropEvent event) {
            if (event.getDropSuccess()) {
                this.markRecentUsage();
                EditorManager.getEditorManager().activateCurrentEditorFrame();
            } else {
                this.dragEventWasCancelled = true;
            }
            this.setAndShowAsUnselected();
            this.paletteController.setSelectedWindowUI(null, "PALETTE2_ITEM_DRAG_DROPPED");
        }

        protected void setAndShowAsUnselected() {
            this.setSelected(false);
            this.resetHighlight();
        }

        protected void setAndShowAsSelected() {
            List<PaletteItemUI> paletteItems = this.paletteItemUI.getPaletteSectionUI().getPaletteGroupUI().getAllPaletteItemUIs();
            for (PaletteItemUI item : paletteItems) {
                if (item.itemUI == null || !item.itemUI.isSelected()) continue;
                item.itemUI.setAndShowAsUnselected();
            }
            this.setSelected(true);
            this.resetHighlight();
        }

        private void resetHighlight() {
            String key = "disabled";
            if (this.isSelected()) {
                key = "selected";
            } else if (this.isEnabled()) {
                key = "enabled";
            }
            this.setBackground(this.colorProvider.backgroundFor((Object)this.paletteItemUI, key));
            this.setForeground(this.colorProvider.foregroundFor((Object)this.paletteItemUI, key));
        }

        @Override
        public void dragGestureRecognized(DragGestureEvent dge) {
            Transferable trans;
            PaletteItem item = this.paletteItemUI.getPaletteItem();
            if (null == item) {
                return;
            }
            this.paletteController.setSelectedWindowUI(this.paletteItemUI, "PALETTE2_ITEM_DRAG_SELECTED");
            if (item.getProviderId().equalsIgnoreCase(PaletteArb.getString(2))) {
                PalettePages palette1Pages = ((PaletteWindowImpl)PaletteWindowImpl.getInstance()).getPalette1ProviderPages();
                if (palette1Pages != null) {
                    Palette1Provider prov = (Palette1Provider)((Object)palette1Pages);
                    prov.dragGestureRecognized(this._dragSource, dge);
                }
                return;
            }
            boolean rightClick = false;
            InputEvent triggerEvent = dge.getTriggerEvent();
            if (4 == triggerEvent.getModifiers() || 8 == triggerEvent.getModifiers()) {
                rightClick = true;
            }
            if ((trans = this.getTrans(rightClick, triggerEvent)) != null) {
                this._dragSource.startDrag(dge, null, trans, this);
            } else {
                Object data;
                AugmentableTransferable transferable = TransferUtils.createTransferable();
                if (dge != null) {
                    DndUtils.addTriggerEvent((AugmentableTransferable)transferable, (InputEvent)dge.getTriggerEvent());
                }
                transferable.augment(PaletteItem.PALETTE_ITEM_FLAVOR, (Object)item, 0.5f, null);
                if (item instanceof DefaultPaletteItem && (data = item.getData("DnDTransferData")) instanceof TransferDataInfo[]) {
                    for (TransferDataInfo d : (TransferDataInfo[])data) {
                        transferable.augment(d);
                    }
                }
                if (item instanceof MyComponentsCodeSnippetItem) {
                    transferable.augment(DataFlavor.stringFlavor, item.getData("codeSnippet"), 0.5f, null);
                }
                try {
                    this._dragSource.startDrag(dge, null, (Transferable)transferable, this);
                }
                catch (InvalidDnDOperationException idndoe) {
                    Assert.printStackTrace((Throwable)idndoe);
                    _logger.log(Level.WARNING, "Workaround for exception reported as 6434909 ( reproducible rarely under Linux )", idndoe);
                }
            }
        }

        private Transferable getTrans(boolean rightClick, InputEvent triggerEvent) {
            PaletteItem item = this.paletteItemUI.getPaletteItem();
            if (null == item) {
                return null;
            }
            String editor = (String)item.getData("editor");
            if (editor == null) {
                return null;
            }
            String extension = (String)item.getData("extension");
            if (extension == null) {
                return null;
            }
            try {
                ExtensionRegistry registry = ExtensionRegistry.getExtensionRegistry();
                ClassLoader loader = registry.getClassLoader(extension);
                Object o = Class.forName(editor, true, loader).newInstance();
                if (o instanceof PaletteTransferable) {
                    PaletteTransferable pT = (PaletteTransferable)o;
                    Context context = new Context();
                    context.setProperty("paletteItem", (Object)item);
                    pT.setContext(context);
                    return (Transferable)o;
                }
            }
            catch (Exception ex) {
                FeedbackManager.reportException((Throwable)ex);
            }
            return null;
        }

        public void setSelected(boolean s) {
            this._selected = s;
        }

        public boolean isSelected() {
            return this._selected;
        }

        public Hover hover(Point p, List<HoverFlavor> flavors) {
            if (!flavors.contains(HOVER_FLAVOR)) {
                return null;
            }
            PaletteItem item = this.paletteItemUI.getPaletteItem();
            if (null == item) {
                return null;
            }
            Icon icon = item.getIcon();
            String title = item.getName();
            Object info = null;
            String tipText = this._getToolText();
            if (ModelUtil.hasLength((String)tipText)) {
                if (tipText.toLowerCase().startsWith(HTML)) {
                    JTextPane textPane = new JTextPane();
                    textPane.setEditable(false);
                    textPane.setContentType("text/html");
                    textPane.setText(tipText);
                    textPane.setCaretPosition(0);
                    JLabel dummy = new JLabel();
                    Font font = dummy.getFont();
                    String bodyRule = "body { font-family: " + font.getFamily() + "; font-size: " + font.getSize() + "pt }";
                    String pRule = "p { margin: 3pt }";
                    String codeRule = "code { font-size: " + font.getSize() + "pt }";
                    HTMLDocument htmlDoc = (HTMLDocument)textPane.getDocument();
                    htmlDoc.getStyleSheet().addRule(bodyRule);
                    htmlDoc.getStyleSheet().addRule("p { margin: 3pt }");
                    htmlDoc.getStyleSheet().addRule(codeRule);
                    info = new JScrollPane(textPane);
                    ((JComponent)info).setPreferredSize(new Dimension(350, 100));
                } else {
                    info = new SuperLabel();
                    info.setPreferredWrapWidth(350);
                    info.setText(tipText);
                    ((JComponent)info).setOpaque(false);
                }
            }
            Action action = null;
            ActionTemplate template = new ActionTemplate(icon, title, (JComponent)info, action);
            InfoTipHover hover = new InfoTipHover((Template)template, InfoTipStyles.DEFAULT, (JComponent)this, this.getBounds(), HOVER_FLAVOR);
            hover.showHover();
            return hover;
        }

        @Override
        public void ancestorAdded(AncestorEvent event) {
            HoverableRegistry.registerComponent((Component)this, (Hoverable)this);
        }

        @Override
        public void ancestorRemoved(AncestorEvent event) {
            HoverableRegistry.unregisterComponent((Component)this, (Hoverable)this);
        }

        @Override
        public void ancestorMoved(AncestorEvent event) {
        }

        private MyComponentsPages getMyComponentsPages() {
            PaletteWindowUI paletteWindow = (PaletteWindowUI)AdapterManager.Factory.getAdapterManager().adapt((Object)PaletteWindowImpl.getInstance(), PaletteWindowUI.class);
            if (null == paletteWindow) {
                return null;
            }
            for (PalettePages pages : paletteWindow.getProviderPages()) {
                if (!(pages instanceof MyComponentsPages)) continue;
                return (MyComponentsPages)pages;
            }
            return null;
        }

        public void dispose() {
            this.ancestorRemoved(null);
            this.paletteItemUI.removeAncestorListener(this);
        }
    }
}

