/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.palette2.layouts;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.text.MessageFormat;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import net.miginfocom.swing.MigLayout;
import oracle.ide.palette2.layouts.PaletteLayout;
import oracle.ideimpl.palette2.PaletteGroupUI;
import oracle.ideimpl.palette2.PaletteItemUI;
import oracle.ideimpl.palette2.PaletteSectionUI;
import oracle.javatools.util.ModelUtil;

public class IconLayout
extends PaletteLayout<MigLayout> {
    private static final int HGAP = 5;
    private static final String LAYOUT_CONSTRAINTS = "fillx, wrap {0}";
    private static final String SEPARATOR_CONSTRAINTS = "{0,choice,0#|0<newline, }span, growx, height 18!";
    private static final String ITEM_CONSTRAINTS = "align leading top, growy, width {0}!";
    private static final String COL_NUM = "col_num";

    public IconLayout() {
        super(new MigLayout());
    }

    @Override
    protected void configurePaletteItemUI(PaletteItemUI itemUI) {
        JLabel label = itemUI.getGUI();
        label.setHorizontalAlignment(0);
        label.setVerticalAlignment(0);
        label.setHorizontalTextPosition(11);
        label.setVerticalTextPosition(0);
        label.setPreferredSize(null);
        label.setText(null);
    }

    @Override
    protected void configurePaletteSectionUI(PaletteSectionUI sectionUI) {
    }

    @Override
    public void layoutContainer(Container parent) {
        if (!(parent instanceof JComponent)) {
            return;
        }
        PaletteGroupUI groupUI = this.getGroupUI((JComponent)parent);
        Insets groupUIInsets = groupUI.getInsets();
        Component gui = groupUI.getGUI();
        Dimension groupUISize = groupUI.getSize();
        if (gui instanceof JScrollPane) {
            groupUISize = ((JScrollPane)gui).getViewport().getExtentSize();
        }
        groupUISize.width -= groupUIInsets.left + groupUIInsets.right + 10;
        if (groupUISize.width <= 0) {
            return;
        }
        List<PaletteSectionUI> sectionUIs = groupUI.getAllPaletteSectionUIs();
        for (int i = 0; i < sectionUIs.size(); ++i) {
            PaletteSectionUI sectionUI = sectionUIs.get(i);
            Component separator = sectionUI.getSeparator();
            if (null != separator) {
                String separatorConstraints = MessageFormat.format(SEPARATOR_CONSTRAINTS, i);
                ((MigLayout)this.impl).setComponentConstraints(separator, (Object)separatorConstraints);
            }
            int cols = 1;
            List<PaletteItemUI> itemUIs = sectionUI.getPaletteItems();
            for (int j = 0; j < itemUIs.size(); ++j) {
                PaletteItemUI itemUI = itemUIs.get(j);
                Dimension itemSize = itemUI.getPreferredSize();
                if (0 == j) {
                    cols = Math.max(1, groupUISize.width / (itemSize.width + 5));
                    String layoutConstraints = MessageFormat.format(LAYOUT_CONSTRAINTS, cols);
                    ((MigLayout)this.impl).setLayoutConstraints((Object)layoutConstraints);
                }
                itemUI.putClientProperty(COL_NUM, j % cols);
                String itemConstraints = MessageFormat.format(ITEM_CONSTRAINTS, itemSize.width);
                ((MigLayout)this.impl).setComponentConstraints((Component)itemUI, (Object)itemConstraints);
            }
        }
        super.layoutContainer(parent);
    }

    @Override
    protected PaletteItemUI getItemAbove(PaletteItemUI current) {
        if (null == current) {
            return null;
        }
        int index = this.indexOf(current);
        Container parent = current.getParent();
        for (int i = index - 1; i >= 0; --i) {
            Object col2;
            Component comp = parent.getComponent(i);
            if (!(comp instanceof PaletteItemUI)) continue;
            PaletteItemUI above = (PaletteItemUI)comp;
            Object col1 = current.getClientProperty(COL_NUM);
            if (!ModelUtil.areEqual((Object)col1, (Object)(col2 = above.getClientProperty(COL_NUM)))) continue;
            return above;
        }
        return current;
    }

    @Override
    protected PaletteItemUI getItemBelow(PaletteItemUI current) {
        if (null == current) {
            return null;
        }
        int index = this.indexOf(current);
        Container parent = current.getParent();
        int count = parent.getComponentCount();
        for (int i = index + 1; i < count; ++i) {
            Object col2;
            Component comp = parent.getComponent(i);
            if (!(comp instanceof PaletteItemUI)) continue;
            PaletteItemUI above = (PaletteItemUI)comp;
            Object col1 = current.getClientProperty(COL_NUM);
            if (!ModelUtil.areEqual((Object)col1, (Object)(col2 = above.getClientProperty(COL_NUM)))) continue;
            return above;
        }
        return current;
    }
}

