/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.git;

import java.util.ArrayList;
import java.util.List;
import oracle.jdevimpl.vcs.git.GITUser;
import oracle.jdevimpl.vcs.git.GITUserProperties;

public class GITRemUsers {
    private static List<GITUser> _authors = null;
    private static List<GITUser> _commiters = null;

    public static List<GITUser> getAuthors() {
        if (_authors == null) {
            GITRemUsers.loadUsers();
        }
        return _authors;
    }

    public static List<GITUser> getCommiters() {
        if (_commiters == null) {
            GITRemUsers.loadUsers();
        }
        return _commiters;
    }

    public static void addAuthor(GITUser author) {
        if (author != null && !_authors.contains(author)) {
            _authors.add(0, author);
            GITRemUsers.storeUsers();
        }
    }

    public static void addCommiter(GITUser commiter) {
        if (commiter != null && !_commiters.contains(commiter)) {
            _commiters.add(0, commiter);
            GITRemUsers.storeUsers();
        }
    }

    private static void storeUsers() {
        GITUserProperties prop = new GITUserProperties();
        prop.storeUsers(_authors, _commiters);
    }

    private static void loadUsers() {
        GITUserProperties prop = new GITUserProperties();
        _authors = new ArrayList<GITUser>();
        _commiters = new ArrayList<GITUser>();
        prop.loadUsers(_authors, _commiters);
    }
}

