/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.git;

import java.io.File;
import java.util.Collection;
import javax.swing.Icon;
import javax.swing.tree.DefaultMutableTreeNode;
import oracle.ide.Context;
import oracle.ide.controller.ContextMenu;
import oracle.ide.controller.ContextMenuListener;
import oracle.ide.model.Node;
import oracle.javatools.icons.OracleIcons;
import oracle.jdeveloper.vcs.spi.VCSExplorer;
import oracle.jdevimpl.vcs.git.GITRevision;
import oracle.jdevimpl.vcs.git.res.Resource;

public class GITStashExplorer
extends VCSExplorer {
    protected DefaultMutableTreeNode createTreeNodes() {
        DefaultMutableTreeNode root = new DefaultMutableTreeNode();
        GITRevision revision = (GITRevision)this.getNode().getData();
        root.add(new DefaultMutableTreeNode(Resource.format("EXPLORER_STASH_MESSAGE", revision.getMessage())));
        root.add(new DefaultMutableTreeNode(Resource.format("EXPLORER_STASH_ID", revision.getRevision())));
        Collection<File> files = revision.getFiles();
        if (files == null) {
            root.add(new DefaultMutableTreeNode(Resource.get("STASH_UNTRACKED_FILE")));
        } else if (!files.isEmpty()) {
            DefaultMutableTreeNode fileNode = new DefaultMutableTreeNode(Resource.get("EXPLORER_STASH_FILE"));
            root.add(fileNode);
            files.stream().forEach(item -> fileNode.add(new DefaultMutableTreeNode(item)));
        }
        return root;
    }

    protected Icon getExplorerIcon(DefaultMutableTreeNode node) {
        if (node.getUserObject() instanceof File) {
            return OracleIcons.getIcon((String)"file.png");
        }
        return this.getExplorerIcon();
    }

    private class GitStashMenuListener
    implements ContextMenuListener {
        private GitStashMenuListener() {
        }

        public void menuWillShow(ContextMenu contextMenu) {
            Node node = contextMenu.getContext().getNode();
        }

        public void menuWillHide(ContextMenu contextMenu) {
        }

        public boolean handleDefaultAction(Context context) {
            return false;
        }
    }
}

