/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.git.cmd;

import java.awt.Component;
import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.composite.CompositeFileElementRegistry;
import oracle.ide.config.Preferences;
import oracle.ide.model.Element;
import oracle.ide.model.Locatable;
import oracle.ide.model.Node;
import oracle.ide.model.NodeFactory;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.javatools.data.PropertyStorage;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.dialogs.progress.IndeterminateProgressMonitor;
import oracle.jdeveloper.vcs.generic.CommandState;
import oracle.jdeveloper.vcs.generic.VCSProfile;
import oracle.jdeveloper.vcs.spi.VCSCancellable;
import oracle.jdeveloper.vcs.spi.VCSCommentsCustomizer;
import oracle.jdeveloper.vcs.spi.VCSDirectoryInvokableState;
import oracle.jdeveloper.vcs.spi.VCSException;
import oracle.jdeveloper.vcs.spi.VCSHashURL;
import oracle.jdeveloper.vcs.spi.VCSOptionsCustomizer;
import oracle.jdeveloper.vcs.spi.VCSPreferences;
import oracle.jdeveloper.vcs.spi.VCSRecentCommentsModel;
import oracle.jdeveloper.vcs.spi.VCSStatus;
import oracle.jdeveloper.vcs.spi.VCSStatusFilter;
import oracle.jdeveloper.vcs.tracking.VCSBugTrackingContext;
import oracle.jdeveloper.vcs.util.VCSComponents;
import oracle.jdeveloper.vcs.util.VCSFileSystemUtils;
import oracle.jdeveloper.vcs.util.VCSModelUtils;
import oracle.jdeveloper.vcs.util.VCSNavigableUtils;
import oracle.jdeveloper.vcs.util.VCSWindowUtils;
import oracle.jdevimpl.vcs.git.GITClientAdaptor;
import oracle.jdevimpl.vcs.git.GITCommandProgressMonitor;
import oracle.jdevimpl.vcs.git.GITProcessException;
import oracle.jdevimpl.vcs.git.GITProfile;
import oracle.jdevimpl.vcs.git.GITRemUsers;
import oracle.jdevimpl.vcs.git.GITStatusResolver;
import oracle.jdevimpl.vcs.git.GITUser;
import oracle.jdevimpl.vcs.git.GITUtil;
import oracle.jdevimpl.vcs.git.cmd.GITExtendedNodeAbstractOperation;
import oracle.jdevimpl.vcs.git.cmd.GITOperationAdd;
import oracle.jdevimpl.vcs.git.cmd.GITStatusFilter;
import oracle.jdevimpl.vcs.git.cmd.GITStatusNotCommited;
import oracle.jdevimpl.vcs.git.cmd.custom.GITCommitCustomizer;
import oracle.jdevimpl.vcs.git.res.Resource;
import oracle.jdevimpl.vcs.xspi.VCSBugCommandState;
import oracle.jdevimpl.vcs.xspi.VCSBugComponents;
import oracle.jdevimpl.vcs.xspi.VCSBugTrackingManager;
import org.netbeans.libs.git.GitBranch;
import org.netbeans.libs.git.GitClient;
import org.netbeans.libs.git.GitException;
import org.netbeans.libs.git.GitRepositoryState;
import org.netbeans.libs.git.GitRevisionInfo;
import org.netbeans.libs.git.GitStatus;
import org.netbeans.libs.git.GitUser;
import org.netbeans.libs.git.progress.ProgressMonitor;

public class GITOperationCommit
extends GITExtendedNodeAbstractOperation {
    public static final String COMMAND_ID = "oracle.jdeveloper.git.commit";
    private static VCSRecentCommentsModel _recentCommentsModel;
    protected static final GITStatusFilter _filter;
    private Boolean _commitConflict;

    public GITOperationCommit() {
        super(COMMAND_ID);
    }

    protected GITOperationCommit(String id) {
        super(id);
    }

    public static final VCSRecentCommentsModel getRecentCommentsModel() {
        if (_recentCommentsModel == null) {
            _recentCommentsModel = new VCSRecentCommentsModel();
        }
        return _recentCommentsModel;
    }

    protected CommandState createCommandState() {
        return new VCSBugCommandState();
    }

    protected void configureCommandState(CommandState commandState, VCSDirectoryInvokableState invokableState, Map timestamps, Locatable[] locatables) {
        super.configureCommandState(commandState, invokableState, timestamps, locatables);
        VCSBugTrackingContext context = new VCSBugTrackingContext("Git");
        context.setURL(this.getURLfromLocatable(locatables));
        ((VCSBugCommandState)commandState).setBugContext(context);
    }

    protected boolean locatablesValid(VCSProfile profile) {
        Element elm = this.getContext().getElement();
        if (elm != null && elm.mayHaveChildren()) {
            return true;
        }
        Node node = this.getContext().getNode();
        if (node != null && GITUtil.isReposRoot(node.getURL())) {
            return true;
        }
        return super.locatablesValid(profile);
    }

    protected Locatable[] getOperands(VCSProfile profile) throws Exception {
        Locatable[] fileLocs;
        if (this.isCommitConflict()) {
            return this.getRootOperand(profile);
        }
        Collection<Locatable> flds = this.findFolders(profile);
        if (flds.isEmpty()) {
            return super.getOperands(profile);
        }
        ArrayList<Locatable> locs = new ArrayList<Locatable>();
        this.getFilteredCollectionWithProgress(locs, flds, _filter, Resource.get("COMMIT_ALL_PROGRESS_TITLE"), Resource.get("COMMIT_ALL_PROGRESS"));
        for (Locatable loc : fileLocs = super.getOperands(profile)) {
            if (URLFileSystem.isDirectoryPath((URL)loc.getURL())) continue;
            locs.add(loc);
        }
        return locs.toArray(new Locatable[0]);
    }

    protected CommandState getCommandState(VCSProfile profile, Locatable[] locatables) throws Exception {
        CommandState state = super.getCommandState(profile, locatables);
        if (state == null) {
            MessageDialog.information((Component)Ide.getMainWindow(), (Object)Resource.get("INFO_NO_COMMITALL"), (String)Resource.get("INFO_NO_COMMITALL_TITLE"), null);
        }
        return state;
    }

    protected String getDialogHint() {
        if (this.isCommitConflict()) {
            return Resource.get("COMMIT_RESOLVE_CONFLICTS");
        }
        return super.getDialogHint();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean invokeCommandImpl(VCSProfile profile, CommandState commandState, Component parentUi, Map options) throws Exception {
        IndeterminateProgressMonitor progress = new IndeterminateProgressMonitor(parentUi, Resource.get("OPERATION_COMMIT_PROGRESS_TITLE"));
        progress.setMillisToPopup(0);
        progress.setCloseOnFinish(true);
        progress.setCancellable(false);
        progress.start();
        try {
            boolean bl = this.invokeCommit(profile, commandState, options, progress);
            return bl;
        }
        finally {
            if (!progress.isCancelled()) {
                progress.finish();
            }
        }
    }

    @Override
    protected boolean invokeCommandSilentlyImpl(VCSProfile profile, CommandState commandState, Map options) throws Exception {
        return this.invokeCommit(profile, commandState, options, null);
    }

    protected int doitImpl(VCSProfile profile) throws Exception {
        int stat;
        Collection<Locatable> flds = this.findFolders(profile);
        if (!flds.isEmpty() && (stat = this.saveNodesIfDirty(flds.toArray(new Locatable[0]))) != 0) {
            return stat;
        }
        Locatable[] locatables = this.getOperands(profile);
        int stat2 = this.saveNodesIfDirty(locatables);
        if (stat2 != 0) {
            return stat2;
        }
        Collection<Locatable> renamed = this.getRenamedLocatables(profile, locatables);
        if (!renamed.isEmpty()) {
            for (Locatable loc : locatables) {
                renamed.add(loc);
            }
            locatables = renamed.toArray(new Locatable[0]);
        }
        if (!this.commitToDetachedHead(locatables)) {
            return 1;
        }
        return this.doitImplInvoke(profile, locatables);
    }

    protected void setCommandSpecificCustomizerOptions(VCSProfile profile, VCSOptionsCustomizer customizer) {
        String id = profile.getID();
        String key = id + ".pending_changes_comment";
        String comment = (String)profile.getObject(key);
        if (comment != null) {
            HashMap<String, String> m = new HashMap<String, String>();
            m.put("setting_comments", comment);
            customizer.setOptions(m);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Collection<Locatable> getRenamedLocatables(VCSProfile profile, Locatable[] locatables) throws Exception {
        ArrayList<Locatable> renamedLoc = new ArrayList<Locatable>();
        ArrayList<File> files = new ArrayList<File>();
        VCSStatusFilter filter = profile.getStatusFilter("filters.status.renamed");
        for (Locatable loc : locatables) {
            if (!filter.accept((VCSStatus)profile.getPolicyStatusCache().get(loc.getURL()))) continue;
            files.add(new File(loc.getURL().getPath()));
        }
        if (!files.isEmpty()) {
            GitClient client = null;
            try {
                client = GITClientAdaptor.getClient(locatables[0].getURL());
                GITCommandProgressMonitor monitor = new GITCommandProgressMonitor("status");
                Map status = client.getStatus(files.toArray(new File[0]), (ProgressMonitor)monitor);
                for (File key : status.keySet()) {
                    GitStatus gStatus = (GitStatus)status.get(key);
                    if (!gStatus.isRenamed()) continue;
                    Node node = NodeFactory.findOrCreate((URL)URLFactory.newFileURL((File)gStatus.getOldPath()));
                    renamedLoc.add((Locatable)node);
                }
            }
            finally {
                if (client != null) {
                    client.release();
                }
            }
        }
        return renamedLoc;
    }

    @Override
    protected JEWTDialog createOperationDialogImpl(Collection nodes, VCSOptionsCustomizer customizer, CommandState commandState) {
        this.setGITVersionOperationPanel(VCSComponents.createSelectFileListerComponent((Collection)nodes));
        JEWTDialog dialog = VCSBugComponents.createCommitOperationDialog((Component)VCSWindowUtils.getCurrentWindow(), (String)this.getDialogTitle(), (String)this.getDialogHint(), (Component)this.getGITVersionOperationPanel(), (VCSOptionsCustomizer)customizer, (String)this.getHelpTopicId(), (VCSBugTrackingContext)((VCSBugCommandState)commandState).getBugContext());
        return dialog;
    }

    private boolean invokeCommit(VCSProfile profile, CommandState commandState, Map options, IndeterminateProgressMonitor progress) throws Exception {
        Boolean commitNonStaged = (Boolean)options.get("commit-not-staged") == null ? Boolean.FALSE : (Boolean)options.get("commit-not-staged");
        GITUser author = (GITUser)options.get("commit-author");
        GITUser commiter = (GITUser)options.get("commit-commiter");
        GitClient client = null;
        if (author != null && commiter != null) {
            this.rememberUser(author, commiter);
        }
        GITCommandProgressMonitor monitor = new GITCommandProgressMonitor("Commit");
        Locatable[] locs = this.getGITVersionOperationPanel() == null ? commandState.getLocatables() : this.getGITVersionOperationPanel().getSelectedLocatables();
        monitor.setLog(true);
        String comment = this.getCommitComment(commandState, options);
        Map<VCSHashURL, Collection<URL>> wtUrls = this.sortByWorkTree(locs);
        Iterator<VCSHashURL> it = wtUrls.keySet().iterator();
        while (it.hasNext()) {
            try {
                VCSHashURL root = it.next();
                Collection<URL> urls = wtUrls.get(root);
                client = GITClientAdaptor.getClient(root.getURL());
                Collection<URL> processed = this.getProcessedUrlsNotifier(commandState);
                CommitInfo info = this.commit(urls.toArray(new URL[0]), monitor, client, comment, commitNonStaged, author, commiter, progress);
                processed.addAll(info._urls);
                if (commandState.getProperty("git.structure-changed") == null) {
                    commandState.setProperty("git.structure-changed", processed);
                } else {
                    Collection total = (Collection)commandState.getProperty("git.structure-changed");
                    total.addAll(processed);
                }
                VCSBugTrackingManager.getInstance().updateOnCommit(((VCSBugCommandState)commandState).getBugContext(), info._urls, (String)options.get("setting_comments"), info._commitId, info._author, info._time);
            }
            catch (GitException ge) {
                GITProfile.getQualifiedLogger(GITOperationCommit.class.getName()).warning(ge.getMessage());
                throw new GITProcessException(Resource.get("PROCESS_EXCEPTION_COMMIT_ERROR"), (Exception)((Object)ge));
            }
            catch (GITProcessException gitpe) {
                GITProfile.getQualifiedLogger(GITOperationCommit.class.getName()).warning(gitpe.getMessage());
                throw new GITProcessException(Resource.get("PROCESS_EXCEPTION_COMMIT_ERROR"), (Exception)((Object)gitpe));
            }
            finally {
                if (client == null) continue;
                client.release();
            }
        }
        return true;
    }

    private String getCommitComment(CommandState commandState, Map options) {
        String comment = (String)options.get("setting_comments");
        VCSBugTrackingContext tracking = ((VCSBugCommandState)commandState).getBugContext();
        if (tracking != null && tracking.getMessage() != null) {
            comment = tracking.isMessageBelow() ? (String)options.get("setting_comments") + "\n" + tracking.getMessage() : tracking.getMessage() + "\n" + (String)options.get("setting_comments");
        }
        return comment;
    }

    private void rememberUser(GITUser author, GITUser commiter) {
        URL rootR = GITUtil.getClientRoot();
        List<GITUser> users = GITUtil.getUserList(rootR);
        if (!users.contains(author)) {
            GITRemUsers.addAuthor(author);
        }
        if (!users.contains(commiter)) {
            GITRemUsers.addCommiter(commiter);
        }
    }

    protected VCSOptionsCustomizer createOptionsCustomizer(Collection<Locatable> nodes) {
        URL root;
        URL[] urls = VCSFileSystemUtils.coalesceURLs((URL[])VCSModelUtils.convertNodesToURLs(nodes));
        VCSCommentsCustomizer customizer = new VCSCommentsCustomizer("oracle.jdeveloper.git", (VCSOptionsCustomizer)new GITCommitCustomizer(!this.isCommitConflict()));
        customizer.setShowReuseCommentsOption(false);
        customizer.setRecentCommentsModel(GITOperationCommit.getRecentCommentsModel());
        customizer.setShowTemplatesAndCommentsCombo(true);
        customizer.setTemplatesSettingsPath(VCSNavigableUtils.getSystemNavigablePath((String)Resource.get("VCS_SHORT_NAME"), (String[])new String[]{VCSCommentsCustomizer.COMMENT_TEMPLATES_NAVIGABLE_LABEL}));
        customizer.setContextURLs(urls);
        HashMap<String, Object> options = new HashMap<String, Object>();
        if (this.isAutoAddFiles()) {
            options.put("commit-not-staged", Boolean.TRUE);
        }
        if ((root = GITUtil.getClientRoot()) != null) {
            List<GITUser> authorList = GITUtil.getUserList(root);
            options.put("user-details", authorList);
        }
        options.put("remember-authors", GITRemUsers.getAuthors());
        options.put("remember-commiters", GITRemUsers.getCommiters());
        customizer.setOptions(options);
        return customizer;
    }

    @Override
    protected void postInvoke(VCSProfile profile, CommandState commandState) throws Exception {
        Collection eventUrls = (Collection)commandState.getProperty("git.structure-changed");
        if (eventUrls == null) {
            return;
        }
        if (eventUrls.isEmpty() && !this._commitConflict.booleanValue()) {
            MessageDialog.information((Component)Ide.getMainWindow(), (Object)Resource.get("INFO_COMMIT_NO_FILES"), (String)Resource.get("INFO_COMMIT_NO_FILES_TITLE"), null);
            return;
        }
        super.postInvoke(profile, commandState);
    }

    private CommitInfo commit(URL[] urls, GITCommandProgressMonitor monitor, GitClient client, String comment, Boolean commitNonStaged, GITUser author, GITUser commiter, final IndeterminateProgressMonitor progress) throws Exception, Exception {
        Collection<File> cmFiles;
        CommitInfo cInfo = new CommitInfo();
        Collection<File> files = GITUtil.convertURLToFile(urls);
        cInfo._urls = Collections.emptyList();
        if (commitNonStaged.booleanValue()) {
            VCSCancellable cancellable = new VCSCancellable(){

                public boolean isCancelled() {
                    return progress.isCanceled();
                }
            };
            monitor.setOperation("add");
            Collection<Locatable> toAdd = this.getFilteredCollection(urls, new GITOperationAdd.GitStatusUnadded(), cancellable);
            if (!toAdd.isEmpty()) {
                Collection<File> addFiles = GITUtil.convertLocatableToFile(toAdd.toArray(new Locatable[0]));
                this.updateProgress(progress, Resource.get("COMMIT_PROGRESS_ADD"));
                client.add(addFiles.toArray(new File[0]), (ProgressMonitor)monitor);
            }
        }
        if (!(cmFiles = this.isCommitConflict() ? files : this.getCommitFiles(client, files)).isEmpty()) {
            monitor.setOperation(Resource.get("COMMIT_OPERATION"));
            if (monitor.getError() != null) {
                throw new GITProcessException(Resource.get("PROCESS_EXCEPTION_COMMIT_ERROR"), monitor.getError());
            }
            this.updateProgress(progress, Resource.get("COMMIT_PROGRESS_COMMIT"));
            GitUser gAuthor = author != null ? new GitUser(author.getName(), author.getEmail()) : client.getUser();
            GitUser gCommiter = commiter != null ? new GitUser(commiter.getName(), commiter.getEmail()) : client.getUser();
            GitRevisionInfo info = client.commit(cmFiles.toArray(new File[0]), comment, gAuthor, gCommiter, (ProgressMonitor)monitor);
            if (monitor.getError() != null) {
                throw new GITProcessException(Resource.get("PROCESS_EXCEPTION_COMMIT_ERROR"), monitor.getError());
            }
            Map modified = info.getModifiedFiles();
            cInfo._time = info.getCommitTime();
            cInfo._author = info.getCommitter().toString();
            cInfo._commitId = info.getRevision();
            if (modified != null) {
                ArrayList<URL> mdurls = new ArrayList<URL>();
                Iterator it = modified.keySet().iterator();
                while (it.hasNext()) {
                    mdurls.add(URLFactory.newFileURL((File)((File)it.next())));
                }
                cInfo._urls = mdurls;
            }
        } else {
            GITProfile.getQualifiedLogger(GITOperationCommit.class.getName()).warning(Resource.get("INFO_COMMIT_NO_FILES"));
            throw new VCSException(Resource.get("INFO_COMMIT_NO_FILES_TITLE"), Resource.get("INFO_COMMIT_NO_FILES"));
        }
        return cInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean isCommitConflict() {
        if (this._commitConflict != null) {
            return this._commitConflict;
        }
        this._commitConflict = new Boolean(false);
        Context context = this.getContext();
        GitClient client = null;
        try {
            URL url = this.getUrlFromContext(context);
            if (url != null) {
                client = GITClientAdaptor.getClient(url);
                if (client == null) {
                    boolean bl = false;
                    return bl;
                }
                GITCommandProgressMonitor monitor = new GITCommandProgressMonitor("getRepositoryState");
                GitRepositoryState state = client.getRepositoryState((ProgressMonitor)monitor);
                if (state == GitRepositoryState.MERGING_RESOLVED || state == GitRepositoryState.REBASING || state == GitRepositoryState.CHERRY_PICKING_RESOLVED) {
                    this._commitConflict = Boolean.TRUE;
                }
            }
        }
        catch (GitException e) {
            GITProfile.getQualifiedLogger(GITOperationCommit.class.getName()).warning("cannot determine repository state " + e.getLocalizedMessage());
        }
        finally {
            if (client != null) {
                client.release();
            }
        }
        return this._commitConflict;
    }

    private URL getUrlFromContext(Context context) {
        Node node = context.getNode();
        if (node != null) {
            return node.getURL();
        }
        Element elm = context.getElement();
        if (elm != null && elm instanceof Locatable) {
            return ((Locatable)elm).getURL();
        }
        URL[] compositeFileUrls = CompositeFileElementRegistry.getCompositeFileURLs((Element)elm);
        if (compositeFileUrls != null && compositeFileUrls.length > 0) {
            return compositeFileUrls[0];
        }
        return null;
    }

    private Collection<File> getCommitFiles(GitClient client, Collection<File> files) throws GitException {
        ArrayList<File> clFile = new ArrayList<File>();
        GITCommandProgressMonitor monitor = new GITCommandProgressMonitor("status");
        Map status = client.getStatus(files.toArray(new File[0]), (ProgressMonitor)monitor);
        for (File file : status.keySet()) {
            GitStatus stat = (GitStatus)status.get(file);
            if (stat.isRenamed()) {
                clFile.add(file);
                continue;
            }
            if (GITStatusResolver.isDeleted(stat)) {
                clFile.add(file);
                continue;
            }
            if (GITStatusResolver.isAddedModified(stat)) {
                clFile.add(file);
                continue;
            }
            if (stat.getStatusIndexWC().equals((Object)GitStatus.Status.STATUS_NORMAL) && (stat.getStatusHeadWC().equals((Object)GitStatus.Status.STATUS_MODIFIED) || stat.getStatusHeadWC().equals((Object)GitStatus.Status.STATUS_ADDED))) {
                clFile.add(file);
                continue;
            }
            if (!stat.getStatusIndexWC().equals((Object)GitStatus.Status.STATUS_MODIFIED) || !stat.getStatusHeadWC().equals((Object)GitStatus.Status.STATUS_MODIFIED) || !stat.getStatusHeadIndex().equals((Object)GitStatus.Status.STATUS_MODIFIED)) continue;
            clFile.add(file);
        }
        return clFile;
    }

    protected boolean isAutoAddFiles() {
        return VCSPreferences.getInstance((PropertyStorage)Preferences.getPreferences(), (String)"oracle.jdeveloper.git").getAutoAddFiles();
    }

    private boolean filesOnStageIndex(Locatable[] locs) {
        return false;
    }

    protected boolean commitToDetachedHead(Locatable[] locatables) {
        if (locatables.length == 0) {
            return true;
        }
        URL root = GITUtil.getRootContaining(locatables[0].getURL());
        Map<String, GitBranch> branches = GITUtil.getBranches(root, false);
        GitBranch active = GITUtil.getActiveBranch(branches);
        if (active != null && active.getName().equals("(no branch)")) {
            return MessageDialog.confirm((Component)VCSWindowUtils.getCurrentWindow(), (Object)Resource.get("COMMIT_HEAD_MSG"), (String)Resource.get("COMMIT_HEAD_TITLE"), null);
        }
        return true;
    }

    static {
        _filter = new GITStatusNotCommited();
    }

    private class CommitInfo {
        Collection<URL> _urls;
        long _time;
        String _author;
        String _commitId;

        private CommitInfo() {
        }
    }
}

