/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.git.cmd;

import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.net.URL;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import oracle.bali.ewt.dialog.DialogHeader;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.ide.Ide;
import oracle.ide.dialogs.OnePageWizardDialogFactory;
import oracle.ide.help.HelpSystem;
import oracle.ide.model.Node;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.dialogs.progress.DeterminateProgressMonitor;
import oracle.jdeveloper.vcs.generic.VCSProfile;
import oracle.jdeveloper.vcs.spi.VCSCommandStyle;
import oracle.jdevimpl.vcs.git.GITClientAdaptor;
import oracle.jdevimpl.vcs.git.GITCommandProgressMonitor;
import oracle.jdevimpl.vcs.git.GITNavURLFileSystemHelper;
import oracle.jdevimpl.vcs.git.GITProcessException;
import oracle.jdevimpl.vcs.git.GITProfile;
import oracle.jdevimpl.vcs.git.GITUtil;
import oracle.jdevimpl.vcs.git.cmd.GITAbstractOperation;
import oracle.jdevimpl.vcs.git.nav.GITBranchNode;
import oracle.jdevimpl.vcs.git.nav.GITRepositoryNavigator;
import oracle.jdevimpl.vcs.git.res.Resource;
import oracle.jdevimpl.vcs.git.ui.GITCreateTagPanel;
import org.netbeans.libs.git.GitClient;
import org.netbeans.libs.git.GitException;
import org.netbeans.libs.git.GitTag;
import org.netbeans.libs.git.progress.ProgressMonitor;

public class GITOperationCreateTag
extends GITAbstractOperation {
    public static final String COMMAND_ID = "oracle.jdeveloper.git.createtag";

    public GITOperationCreateTag() {
        super(COMMAND_ID, VCSCommandStyle.NORMAL);
    }

    public GITOperationCreateTag(String commandId) {
        super(commandId);
    }

    @Override
    protected DeterminateProgressMonitor createProgressMonitor(Component parent) {
        return new DeterminateProgressMonitor(parent, this.getProgressTitle(), (Object)this.getProgressMessage(), "", 0, -1);
    }

    protected String getProgressTitle() {
        return Resource.get("OPERATION_TAG_PROGRESS_TITLE");
    }

    protected String getProgressMessage() {
        return Resource.get("OPERATION_TAG_PROGRESS_MESSAGE");
    }

    protected String getDialogTitle() {
        return Resource.get("CREATETAG_DLG_TITLE");
    }

    protected String getHelpTopicId() {
        return "f1_git_create_tag_html";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int doitImpl(VCSProfile profile) throws Exception {
        Node node = this.getContext().getNode();
        final GITCreateTagPanel panel = new GITCreateTagPanel();
        URL r = null;
        if (node instanceof GITBranchNode) {
            r = GITUtil.getRootContaining(GITNavURLFileSystemHelper.fromNavigatorURL(node.getURL()));
            panel.setRevisionBranch(((GITBranchNode)node).getBranch().getName());
        } else {
            r = this.getGitClientRoot(profile);
            panel.setRevisionBranch(this.getCurrentBranch(r));
            panel.setRevision(this.getGitRevision());
        }
        final URL root = r;
        panel.setRoot(root);
        JEWTDialog dialog = OnePageWizardDialogFactory.createJEWTDialog((Component)Ide.getMainWindow(), (Component)panel, (Component)panel.getDefaultComp(), (String)this.getDialogTitle(), (int)7);
        dialog.setMinimumSize(550, 200);
        DialogHeader header = new DialogHeader();
        header.setHeaderDescription(Resource.get("CREATETAG_DIALOG_HINT"));
        dialog.setDialogHeader((Component)header);
        dialog.addVetoableChangeListener(new VetoableChangeListener(){

            @Override
            public void vetoableChange(PropertyChangeEvent evt) throws PropertyVetoException {
                if (!JEWTDialog.isDialogClosingEvent((PropertyChangeEvent)evt)) {
                    return;
                }
                try {
                    GITOperationCreateTag.this.validateDialog(evt, panel, root);
                    GITOperationCreateTag.this.createTag(root, panel);
                }
                catch (GITProcessException ex) {
                    GITOperationCreateTag.this.getExceptionHandler().handleException((Exception)((Object)ex));
                    throw new PropertyVetoException(ex.getMessage(), evt);
                }
            }
        });
        HelpSystem.getHelpSystem().registerTopic((JComponent)panel, this.getHelpTopicId());
        try {
            if (dialog.runDialog()) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        GITRepositoryNavigator.getInstance().updateNavigator(root, false);
                    }
                });
                int n = 0;
                return n;
            }
        }
        finally {
            dialog.dispose();
        }
        return 1;
    }

    private void validateDialog(PropertyChangeEvent pce, GITCreateTagPanel panel, URL url) throws PropertyVetoException {
        if (panel.getTagName() == null || panel.getTagName().isEmpty()) {
            MessageDialog.error((Component)panel, (Object)Resource.format("TAG_NAME_EMPTY", panel.getTagName()), (String)Resource.get("TAGERROR_TITLE"), null);
            throw new PropertyVetoException(Resource.format("TAG_NAME_EMPTY", panel.getName()), pce);
        }
        Map<String, GitTag> tags = GITUtil.getTags(url);
        if (tags.containsKey(panel.getTagName())) {
            MessageDialog.error((Component)panel, (Object)Resource.format("TAG_EXIST_NAME", panel.getTagName()), (String)Resource.get("TAGERROR_TITLE"), null);
            throw new PropertyVetoException(Resource.format("TAG_EXIST_NAME", panel.getName()), pce);
        }
        String useTag = panel.getRevisionTag();
        if (useTag != null && !useTag.isEmpty() && !tags.containsKey(useTag)) {
            MessageDialog.error((Component)panel, (Object)Resource.format("ERROR_TAG_NOT_EXIST", useTag), (String)Resource.get("TAGERROR_TITLE"), null);
            throw new PropertyVetoException(Resource.format("ERROR_TAG_NOT_EXIST", panel.getName()), pce);
        }
        String branch = panel.getRevisionBranch();
        if (branch != null && !GITUtil.getBranches(url).containsKey(branch)) {
            MessageDialog.error((Component)panel, (Object)Resource.format("ERROR_BRANCH_NOT_EXIST", branch), (String)Resource.get("TAGERROR_TITLE"), null);
            throw new PropertyVetoException(Resource.format("ERROR_BRANCH_NOT_EXIST", branch), pce);
        }
    }

    private void createTag(URL root, GITCreateTagPanel panel) throws GITProcessException {
        GITCommandProgressMonitor monitor = new GITCommandProgressMonitor(Resource.get("CREATE_TAG_OPERATION"));
        GitClient client = null;
        monitor.setLog(true);
        try {
            client = GITClientAdaptor.getClient(root);
            GitTag gTag = client.createTag(panel.getTagName(), panel.getRevision(), panel.getComment(), false, panel.forceUpdate(), (ProgressMonitor)monitor);
            if (monitor.getError() != null) {
                throw new GITProcessException(Resource.format("TAG_CREATE_TAG_FAILED", panel.getTagName()), monitor.getError());
            }
        }
        catch (GitException e) {
            GITProfile.getQualifiedLogger(GITOperationCreateTag.class.getName()).warning(e.getMessage());
            throw new GITProcessException(Resource.format("TAG_CREATE_TAG_FAILED", panel.getTagName()), e.getCause().getMessage());
        }
        finally {
            monitor.logCompleted();
            if (client != null) {
                client.release();
            }
        }
    }

    protected String getGitRevision() {
        return null;
    }
}

