/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.git.cmd;

import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.VetoableChangeListener;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JDialog;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.ide.Ide;
import oracle.ide.model.Locatable;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.dialogs.progress.DeterminateProgressMonitor;
import oracle.jdeveloper.vcs.generic.CommandState;
import oracle.jdeveloper.vcs.generic.VCSProfile;
import oracle.jdeveloper.vcs.spi.VCSCommandStyle;
import oracle.jdeveloper.vcs.spi.VCSDialogCommitter;
import oracle.jdeveloper.vcs.spi.VCSDirectoryInvokableState;
import oracle.jdeveloper.vcs.spi.VCSOptionsCustomizer;
import oracle.jdeveloper.vcs.tracking.VCSBugTrackingContext;
import oracle.jdeveloper.vcs.util.VCSComponents;
import oracle.jdeveloper.vcs.util.VCSDialogRunner;
import oracle.jdeveloper.vcs.util.VCSWindowUtils;
import oracle.jdevimpl.vcs.git.GITClientAdaptor;
import oracle.jdevimpl.vcs.git.GITCommandProgressMonitor;
import oracle.jdevimpl.vcs.git.GITProcessException;
import oracle.jdevimpl.vcs.git.GITProfile;
import oracle.jdevimpl.vcs.git.GITUtil;
import oracle.jdevimpl.vcs.git.cmd.GITExtendedNodeAbstractOperation;
import oracle.jdevimpl.vcs.git.cmd.GITStatusFilter;
import oracle.jdevimpl.vcs.git.cmd.GITStatusNotCommited;
import oracle.jdevimpl.vcs.git.res.Resource;
import oracle.jdevimpl.vcs.git.ui.GITExportUncommitted;
import oracle.jdevimpl.vcs.xspi.VCSBugCommandState;
import oracle.jdevimpl.vcs.xspi.VCSBugComponents;
import oracle.jdevimpl.vcs.xspi.VCSBugTrackingManager;
import org.netbeans.libs.git.GitClient;
import org.netbeans.libs.git.GitException;
import org.netbeans.libs.git.progress.ProgressMonitor;

public class GITOperationExportUncommitted
extends GITExtendedNodeAbstractOperation {
    private static final String EXPORTFILE = "ExportChanges";
    protected static final GITStatusFilter _filter = new GITStatusNotCommited();

    public GITOperationExportUncommitted() {
        super("oracle.jdeveloper.git.export-uncommitted", VCSCommandStyle.NORMAL);
    }

    protected VCSOptionsCustomizer createOptionsCustomizer(CommandState commandState) {
        GITExportUncommitted customizer = new GITExportUncommitted(commandState);
        HashMap<String, String> options = new HashMap<String, String>();
        options.put("export.file", URLFileSystem.getPlatformPathName((URL)this.getExportFileSuggestion(EXPORTFILE)));
        customizer.setOptions(options);
        return customizer;
    }

    protected CommandState createCommandState() {
        return new VCSBugCommandState();
    }

    @Override
    protected JEWTDialog createOperationDialogImpl(Collection nodes, final VCSOptionsCustomizer customizer, CommandState commandState) {
        this.setGITVersionOperationPanel(VCSComponents.createSelectFileListerComponent((Collection)nodes));
        ((VCSBugCommandState)commandState).getBugContext().addPropertyListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (evt.getPropertyName().equals("patch-attach-task")) {
                    Map options = customizer.getOptions();
                    options.put("PatchLocation", (Boolean)evt.getNewValue() == false);
                    customizer.setOptions(options);
                }
            }
        });
        return VCSBugComponents.createPatchOperationDialog((Component)VCSWindowUtils.getCurrentWindow(), (String)this.getDialogTitle(), (String)this.getDialogHint(), (Component)this.getGITVersionOperationPanel(), (VCSOptionsCustomizer)customizer, (String)this.getHelpTopicId(), (VCSBugTrackingContext)((VCSBugCommandState)commandState).getBugContext());
    }

    protected void configureCommandState(CommandState commandState, VCSDirectoryInvokableState invokableState, Map timestamps, Locatable[] locatables) {
        super.configureCommandState(commandState, invokableState, timestamps, locatables);
        VCSBugTrackingContext context = new VCSBugTrackingContext("Git");
        context.setURL(this.getURLfromLocatable(locatables));
        ((VCSBugCommandState)commandState).setBugContext(context);
    }

    protected Locatable[] getOperands(VCSProfile profile) throws Exception {
        Locatable[] locs = this.getRootOperand(profile);
        if (locs.length == 0) {
            return super.getOperands(profile);
        }
        ArrayList<Locatable> exports = new ArrayList<Locatable>();
        this.getFilteredCollectionWithProgress(exports, new URL[]{locs[0].getURL()}, _filter, Resource.get("EXPORT_PROGRESS_TITLE"), Resource.get("EXPORT_PROGRESS"));
        if (exports.isEmpty()) {
            MessageDialog.information((Component)Ide.getMainWindow(), (Object)Resource.get("INFO_NO_EXPORT_COMM"), (String)Resource.get("INFO_NO_EXPORT_COMM_TITLE"), null);
        }
        return exports.toArray(new Locatable[0]);
    }

    @Override
    protected DeterminateProgressMonitor createProgressMonitor(Component parent) {
        return new DeterminateProgressMonitor(parent, Resource.get("OPERATION_EXPORT_UNCOM_PROGRESS_TITLE"), (Object)Resource.get("OPERATION_EXPORT_UNCOM_PROGRESS_MESSAGE"), "", 0, -1);
    }

    @Override
    protected boolean invokeCommand(final VCSProfile profile, final CommandState commandState) throws Exception {
        List<Locatable> nodes = Arrays.asList(commandState.getLocatables());
        VCSOptionsCustomizer customizer = this.createOptionsCustomizer(commandState);
        this.setCommandSpecificCustomizerOptions(profile, customizer);
        final JEWTDialog dialog = this.createOperationDialog(nodes, customizer, commandState);
        dialog.addVetoableChangeListener((VetoableChangeListener)new VCSDialogCommitter(customizer){

            protected boolean doCommitOperation(Map options) throws Exception {
                return GITOperationExportUncommitted.this.invokeCommandImpl(profile, commandState, (Component)dialog, options);
            }
        });
        return VCSDialogRunner.runDialog((JDialog)dialog);
    }

    @Override
    protected boolean invokeCommandImpl(VCSProfile profile, CommandState commandState, Component parentUi, Map options) throws Exception {
        Locatable[] locatables = this.getGITVersionOperationPanel().getSelectedLocatables();
        GITCommandProgressMonitor monitor = new GITCommandProgressMonitor(Resource.get("EXPORT_UNCOMMITTED_OPERATION"));
        if (locatables.length == 0) {
            return false;
        }
        URL exportURL = null;
        boolean saveUrl = true;
        if ((String)options.get("export.file") != null) {
            exportURL = URLFactory.newURL((String)((String)options.get("export.file")));
        } else {
            exportURL = URLFileSystem.createTempFile((String)"diff", (String)".patch", (URL)URLFactory.newDirURL((String)System.getProperty("java.io.tmpdir")));
            saveUrl = false;
        }
        GitClient client = null;
        OutputStream os = null;
        try {
            client = GITClientAdaptor.getClient(locatables[0].getURL());
            os = this.getOutputStream(exportURL);
            client.exportDiff(GITUtil.convertLocatableToFile(locatables).toArray(new File[0]), GitClient.DiffMode.HEAD_VS_WORKINGTREE, os, (ProgressMonitor)monitor);
            if (monitor.getError() != null) {
                throw new GITProcessException(Resource.get("EXPORT_UNCOMMITTED_ERROR"), monitor.getError());
            }
            if (saveUrl) {
                this.saveExportLocation(exportURL);
            }
            this.openEditor(exportURL);
            VCSBugTrackingManager.getInstance().attachPatch(((VCSBugCommandState)commandState).getBugContext(), exportURL);
        }
        catch (IOException io) {
            GITProfile.getQualifiedLogger(GITOperationExportUncommitted.class.getName()).warning(io.getMessage());
            throw new GITProcessException(Resource.get("EXPORT_UNCOMMITTED_ERROR"), io);
        }
        catch (GitException ge) {
            GITProfile.getQualifiedLogger(GITOperationExportUncommitted.class.getName()).warning(ge.getMessage());
            throw new GITProcessException(Resource.get("EXPORT_UNCOMMITTED_ERROR"), (Exception)((Object)ge));
        }
        finally {
            try {
                if (os != null) {
                    os.close();
                }
            }
            catch (IOException iOException) {}
            monitor.logCompleted();
            if (client != null) {
                client.release();
            }
        }
        return true;
    }

    protected int doitImpl(VCSProfile profile) throws Exception {
        int stat;
        Locatable[] root = this.getRootOperand(profile);
        if (root.length > 0 && (stat = this.saveNodesIfDirty(root)) != 0) {
            return stat;
        }
        Locatable[] locatables = this.getOperands(profile);
        return this.doitImplInvoke(profile, locatables);
    }
}

