/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.git.cmd;

import java.awt.Component;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.SwingUtilities;
import javax.swing.table.TableCellRenderer;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.ide.editor.EditorManager;
import oracle.ide.model.Locatable;
import oracle.ide.model.Node;
import oracle.ide.net.URLFileSystem;
import oracle.ide.util.IdeUtil;
import oracle.javatools.dialogs.ExceptionDialog;
import oracle.javatools.dialogs.progress.IndeterminateProgressMonitor;
import oracle.jdeveloper.vcs.generic.CommandState;
import oracle.jdeveloper.vcs.generic.VCSProfile;
import oracle.jdeveloper.vcs.generic.VCSProfileRegistry;
import oracle.jdeveloper.vcs.spi.VCSCancellable;
import oracle.jdeveloper.vcs.spi.VCSCommentsCustomizer;
import oracle.jdeveloper.vcs.spi.VCSOptionsCustomizer;
import oracle.jdeveloper.vcs.util.VCSCommandUtils;
import oracle.jdeveloper.vcs.util.VCSComponents;
import oracle.jdeveloper.vcs.util.VCSContextUtils;
import oracle.jdeveloper.vcs.util.VCSWindowUtils;
import oracle.jdeveloper.vcs.vop.MutableVersionOperationModel;
import oracle.jdeveloper.vcs.vop.VersionOperationModel;
import oracle.jdeveloper.vcs.vop.VersionOperationPanel;
import oracle.jdevimpl.vcs.git.GITClientAdaptor;
import oracle.jdevimpl.vcs.git.GITCommandProgressMonitor;
import oracle.jdevimpl.vcs.git.GITProcessException;
import oracle.jdevimpl.vcs.git.GITProfile;
import oracle.jdevimpl.vcs.git.GITStatusResolver;
import oracle.jdevimpl.vcs.git.GITUtil;
import oracle.jdevimpl.vcs.git.cmd.GITExtendedAbstractOperation;
import oracle.jdevimpl.vcs.git.cmd.GITStatusFilter;
import oracle.jdevimpl.vcs.git.nav.GITRepositoryNavigator;
import oracle.jdevimpl.vcs.git.res.Resource;
import oracle.jdevimpl.vcs.git.ui.GITStashCommitCustomizer;
import oracle.jdevimpl.vcs.git.ui.GITUntrackedListener;
import org.netbeans.libs.git.GitBranch;
import org.netbeans.libs.git.GitClient;
import org.netbeans.libs.git.GitException;
import org.netbeans.libs.git.GitRevisionInfo;
import org.netbeans.libs.git.GitStatus;
import org.netbeans.libs.git.progress.ProgressMonitor;

public class GITStashCreateCommand
extends GITExtendedAbstractOperation
implements GITUntrackedListener {
    private static final String COMMAND_ID = "oracle.jdeveloper.git.stash-create";
    private GITStatusFilter _filter;
    private URL _root;
    private GITStatusFilter _unversionedFilter;
    private Collection<Locatable> _versioned;
    private Collection<Locatable> _unversioned;
    private VersionOperationPanel _panel;

    public GITStashCreateCommand() {
        super(COMMAND_ID);
    }

    protected Locatable[] getOperands(VCSProfile profile) throws Exception {
        Locatable[] root = this.getRootOperand(profile);
        if (root.length == 0) {
            return super.getOperands(profile);
        }
        URL[] urls = new URL[]{root[0].getURL()};
        this._root = root[0].getURL();
        this._versioned = new ArrayList<Locatable>();
        this.getFilteredCollectionWithProgress(this._versioned, urls, this.getFilter(), Resource.get("STASH_PROGRESS_TITLE"), Resource.get("STASH_PROGRESS"));
        if (this._versioned.isEmpty()) {
            this._unversioned = new ArrayList<Locatable>();
            this.getFilteredCollectionWithProgress(this._unversioned, urls, (GITStatusFilter)new UnversionFilter(), Resource.get("STASH_PROGRESS_TITLE"), Resource.get("STASH_PROGRESS"));
            return this._unversioned.toArray(new Locatable[0]);
        }
        return this._versioned.toArray(new Locatable[0]);
    }

    protected VCSOptionsCustomizer createOptionsCustomizer() {
        GITStashCommitCustomizer stashCustomizer = new GITStashCommitCustomizer();
        VCSCommentsCustomizer customizer = new VCSCommentsCustomizer("oracle.jdeveloper.git", (VCSOptionsCustomizer)stashCustomizer);
        if (this._unversioned != null) {
            HashMap<String, Boolean> opts = new HashMap<String, Boolean>();
            opts.put("stashed_untracked", Boolean.TRUE);
            stashCustomizer.setOptions(opts);
        }
        stashCustomizer.addUntrackedListemner(this);
        return customizer;
    }

    protected int doitImpl(VCSProfile profile) throws Exception {
        try {
            if (!this.saveDirtyNodes(null)) {
                return 1;
            }
            Locatable[] locatables = this.getOperands(profile);
            return this.doitImplInvoke(profile, locatables);
        }
        catch (IOException ioe) {
            ExceptionDialog.showExceptionDialog((Component)VCSWindowUtils.getCurrentWindow(), (Throwable)ioe, (String)IdeUtil.getProgramName(), (String)ioe.getMessage(), null);
            return -1;
        }
    }

    protected boolean saveDirtyNodes(Locatable[] contextLocatables) throws Exception {
        URL[] urls = VCSContextUtils.getVersionEditorUrls((VCSProfile)VCSProfileRegistry.getInstance().getProfile("oracle.jdeveloper.git"));
        Node[] nodes = this.getNodes(urls);
        return VCSCommandUtils.saveDirtyNodes((Locatable[])nodes);
    }

    @Override
    protected JEWTDialog createOperationDialogImpl(Collection nodes, VCSOptionsCustomizer customizer, CommandState commandState) {
        this._panel = VCSComponents.createFileListerComponent((Collection)nodes, (TableCellRenderer)this.createFileListerRenderer());
        JEWTDialog dialog = VCSComponents.createOperationDialog((Component)VCSWindowUtils.getCurrentWindow(), (String)this.getDialogTitle(), null, (Component)this._panel, (Component)(customizer != null ? customizer.getComponent() : null), (String)this.getHelpTopicId(), (Component)(customizer != null ? customizer.getInitialFocusComponent() : null));
        return dialog;
    }

    @Override
    protected boolean invokeCommandImpl(VCSProfile profile, CommandState commandState, Component parentUi, Map options) throws Exception {
        Locatable[] loc = commandState.getLocatables();
        Boolean untrack = (Boolean)options.get("stashed_untracked");
        String msg = (String)options.get("setting_comments");
        URL root = GITUtil.getRootContaining(loc[0].getURL());
        GITCommandProgressMonitor monitor = new GITCommandProgressMonitor(Resource.get("STASH_OPERATION"));
        final IndeterminateProgressMonitor progress = new IndeterminateProgressMonitor((Component)IdeUtil.getMainWindow(), Resource.get("STASH_PROGRESS_TITLE"), (Object)Resource.get("STASH_PROGRESS"), null);
        VCSCancellable cancellable = new VCSCancellable(){

            public boolean isCancelled() {
                return progress.isCanceled();
            }
        };
        progress.start();
        GitClient client = null;
        try {
            monitor.setLog(true);
            monitor.setCancellable(cancellable);
            client = GITClientAdaptor.getClient(loc[0].getURL());
            Collection<URL> stashed = this.getModifiedFiles(monitor, client, root);
            GitRevisionInfo info = client.stashSave(!msg.isEmpty() ? msg : this.getDefaultStashName(client, monitor), untrack.booleanValue(), (ProgressMonitor)monitor);
            this.updateFiles(commandState, stashed);
            if (monitor.getError() != null) {
                GITProfile.getQualifiedLogger(GITStashCreateCommand.class.getName()).warning(monitor.getError());
                throw new GITProcessException(Resource.get("STASH_COMMMIT_ERROR"), monitor.getError());
            }
        }
        catch (GitException ex) {
            GITProfile.getQualifiedLogger(GITStashCreateCommand.class.getName()).warning(ex.getMessage());
            throw new GITProcessException(Resource.get("STASH_COMMMIT_ERROR"), ex.getMessage());
        }
        finally {
            if (client != null) {
                client.release();
            }
            monitor.logCompleted();
            progress.finish();
        }
        this.updateNavigator(root);
        return true;
    }

    private void updateNavigator(final URL url) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                GITRepositoryNavigator.getInstance().updateNavigator(url, true);
            }
        });
    }

    private void updateFiles(CommandState commandState, Collection<URL> urls) {
        this.setProcessedUrls(commandState, urls.toArray(new URL[0]));
        commandState.setProperty("git.structure-changed", urls);
    }

    private String getDefaultStashName(GitClient client, GITCommandProgressMonitor monitor) throws GitException {
        Map branches = client.getBranches(false, (ProgressMonitor)monitor);
        for (String branch : branches.keySet()) {
            if (!((GitBranch)branches.get(branch)).isActive()) continue;
            return Resource.format("STASH_DEFAULT_NAME", branch);
        }
        return "";
    }

    private GITStatusFilter getFilter() {
        if (this._filter == null) {
            this._filter = new ModifiedFilter();
        }
        return this._filter;
    }

    @Override
    public void includeUntracked(boolean untracked) {
        URL[] urls = new URL[]{this._root};
        try {
            if (this._unversioned == null) {
                this._unversioned = new ArrayList<Locatable>();
                this.getFilteredCollectionWithProgress(this._unversioned, urls, (GITStatusFilter)new UnversionFilter(), Resource.get("STASH_PROGRESS_TITLE"), Resource.get("STASH_PROGRESS"));
            }
            ArrayList<Locatable> nodes = new ArrayList<Locatable>();
            nodes.addAll(this._versioned);
            if (untracked) {
                nodes.addAll(this._unversioned);
            }
            MutableVersionOperationModel opModel = VCSComponents.createFileListerModel(nodes, null);
            this._panel.installModel((VersionOperationModel)opModel);
        }
        catch (Exception ex) {
            GITProfile.getQualifiedLogger(GITStashCreateCommand.class.getName()).warning(ex.getMessage());
            this.getExceptionHandler().handleException(ex, (Component)VCSWindowUtils.getCurrentWindow());
        }
    }

    @Override
    protected void postInvoke(VCSProfile profile, CommandState commandState) throws Exception {
        super.postInvoke(profile, commandState);
        if (commandState == null) {
            return;
        }
        Collection<URL> processed = this.getProcessedUrlsNotifier(commandState);
        this.fireSomeFilesDeleted(processed.toArray(new URL[0]));
        List edts = EditorManager.getEditorManager().getAllEditors();
        final ArrayList editorsToClose = new ArrayList();
        edts.stream().filter(item -> !URLFileSystem.exists((URL)item.getContext().getNode().getURL())).forEach(item -> editorsToClose.add(item));
        if (!editorsToClose.isEmpty()) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    EditorManager.getEditorManager().closeEditors(editorsToClose);
                }
            });
        }
    }

    private class ModifiedFilter
    implements GITStatusFilter {
        private ModifiedFilter() {
        }

        @Override
        public boolean accept(GitStatus status) {
            if (GITStatusResolver.isModified(status)) {
                return true;
            }
            if (GITStatusResolver.isAdded(status)) {
                return true;
            }
            if (GITStatusResolver.isPending(status)) {
                return true;
            }
            return GITStatusResolver.isPendingModified(status);
        }
    }

    private class UnversionFilter
    implements GITStatusFilter {
        private UnversionFilter() {
        }

        @Override
        public boolean accept(GitStatus status) {
            return GITStatusResolver.isUnversioned(status);
        }

        @Override
        public boolean useGlobalIgnore() {
            return false;
        }
    }
}

