/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.git.wiz;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import oracle.ide.panels.TraversableContext;
import oracle.jdevimpl.vcs.git.res.Resource;
import oracle.jdevimpl.vcs.git.wiz.GITWizardSummary;

public class GITCloneSummaryPanel
extends GITWizardSummary {
    private static final String F1_HELP_ID = "f1_git_clone_wizard_5_html";

    public GITCloneSummaryPanel() {
        this.setHelpID(F1_HELP_ID);
    }

    @Override
    protected void initRes() {
        this.getHeaderLabel().setText(Resource.get("WZ_CLONE_SUMMARY_HEAD"));
        this.getHintText().setText(Resource.get("WZ_CLONE_SUMMARY_HINT"));
    }

    @Override
    protected DefaultTreeModel buildTree(TraversableContext tc) {
        DefaultMutableTreeNode root = new DefaultMutableTreeNode("ROOT");
        DefaultTreeModel model = new DefaultTreeModel(root);
        model.setRoot(root);
        DefaultMutableTreeNode node = this.newNode(Resource.get("WZ_CLONE_SUM_REPOS"));
        String reposUrl = (String)tc.get("git.remote-uri");
        node.add(this.newNode(reposUrl));
        root.add(node);
        String username = (String)tc.get("git.username");
        if (username != null && !username.isEmpty()) {
            node = this.newNode(Resource.get("WZ_CLONE_SUMMARY_USER"));
            node.add(this.newNode(username));
            root.add(node);
        }
        Collection branches = (Collection)tc.get("git.use-branches");
        ArrayList sBranch = new ArrayList();
        sBranch.addAll(branches);
        Collections.sort(sBranch);
        node = this.newNode(Resource.get("WZ_CLONE_SUM_REMOTE_BRANCH"));
        for (String branch : sBranch) {
            node.add(this.newNode(branch));
        }
        root.add(node);
        node = this.newNode(Resource.get("WZ_CLONE_SUM_DEST"));
        String destDir = (String)tc.get("git.clone-destination-dir");
        node.add(this.newNode(destDir));
        root.add(node);
        node = this.newNode(Resource.get("WZ_CLONE_SUM_NAME"));
        String clName = (String)tc.get("git.clone-clone-name");
        node.add(this.newNode(clName));
        root.add(node);
        node = this.newNode(Resource.get("WZ_CLONE_SUM_BRANCH"));
        String branch = (String)tc.get("git.clone-checkout-branch");
        if (branch == null) {
            branch = Resource.get("CHECKOUT_NO_BRANCH");
        }
        node.add(this.newNode(branch));
        root.add(node);
        return model;
    }
}

