/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.git.wiz;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.swing.JScrollPane;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableModel;
import oracle.ide.Ide;
import oracle.ide.controls.JMultiLineLabel;
import oracle.ide.panels.DefaultTraversablePanel;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.ui.table.GenericTable;
import oracle.javatools.ui.table.GenericTableModel;
import oracle.javatools.ui.table.GenericTablePersistentSettings;
import oracle.jdevimpl.vcs.git.GITClientAdaptor;
import oracle.jdevimpl.vcs.git.GITCommandProgressMonitor;
import oracle.jdevimpl.vcs.git.GITProfile;
import oracle.jdevimpl.vcs.git.GITUtil;
import oracle.jdevimpl.vcs.git.res.Resource;
import oracle.jdevimpl.vcs.git.wiz.GITBranchTag;
import org.netbeans.libs.git.GitBranch;
import org.netbeans.libs.git.GitClient;
import org.netbeans.libs.git.GitException;
import org.netbeans.libs.git.GitTag;
import org.netbeans.libs.git.progress.ProgressMonitor;

class GITPushBranchPanel
extends DefaultTraversablePanel {
    private static final String BRANCH_KEY = "git-push-branch-table";
    private static final String F1_HELP_ID = "f1_git_push_wizard_3_html";
    private JMultiLineLabel _hintText = new JMultiLineLabel();
    private GenericTable _table = new GenericTable((TableModel)new BranchTagTableModel());

    public GITPushBranchPanel() {
        this.init();
        this.setHelpID(F1_HELP_ID);
    }

    private void init() {
        Insets ins = new Insets(5, 5, 5, 5);
        this._hintText.setText(Resource.get("WZ_PUSH_BRANCH_HINT"));
        this.setLayout(new GridBagLayout());
        this.add((Component)this._hintText, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 2, ins, 0, 0));
        this.add(new JScrollPane((Component)this._table), new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 17, 1, ins, 0, 0));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onEntry(TraversableContext dataContext) {
        if (dataContext.getDirection() == 1) {
            Map remoteBranches = (Map)dataContext.get("git.remote-branches");
            GitClient client = null;
            try {
                URL localRootUrl = (URL)dataContext.get("git.local-url");
                client = GITClientAdaptor.getClient(localRootUrl);
                GITCommandProgressMonitor monitor = new GITCommandProgressMonitor("branches");
                Map localBranches = client.getBranches(false, (ProgressMonitor)monitor);
                Collection<GITBranchTag> branches = this.getBranches(localBranches, remoteBranches);
                ((BranchTagTableModel)this._table.getModel()).addData(branches);
                Collection<GITBranchTag> tags = this.getTagsToPush(localRootUrl, (Map)dataContext.get("git.tags"));
                ((BranchTagTableModel)this._table.getModel()).addData(tags);
                GitBranch active = GITUtil.getActiveBranch(localBranches);
                if (active != null) {
                    ((BranchTagTableModel)this._table.getModel()).setBranchSelect(active.getName());
                }
                this._table.setSortColumn(1, true);
                Map settings = (Map)Ide.getDTCache().getData(BRANCH_KEY);
                if (settings != null) {
                    this._table.setPersistentSettings(new GenericTablePersistentSettings(settings));
                }
            }
            catch (GitException e) {
                MessageDialog.error((Component)((Object)this), (Object)Resource.get("WZ_PUSH_NO_LOCAL_BRANCH"), (String)Resource.get("WZ_PUSH_ERROR_TITLE"), null);
                GITProfile.getQualifiedLogger(GITPushBranchPanel.class.getName()).warning("Push " + e.getMessage());
            }
            finally {
                if (client != null) {
                    client.release();
                }
            }
        }
    }

    public void onExit(TraversableContext dataContext) throws TraversalException {
        if (dataContext.getDirection() == 1) {
            Collection branches = ((BranchTagTableModel)this._table.getModel()).getIncludeBranches();
            if (branches.isEmpty()) {
                throw new TraversalException(Resource.get("WZ_PUSH_NO_BRANCH"), Resource.get("WZ_PUSH_NO_BRANCH_TITLE"));
            }
            dataContext.put("git.use-branches", (Object)branches);
            GenericTablePersistentSettings settings = this._table.getPersistentSettings();
            Ide.getDTCache().putData(BRANCH_KEY, settings.toMap());
        }
    }

    private Collection<GITBranchTag> getTagsToPush(URL localRootUrl, Map<String, String> remotes) {
        Map<String, GitTag> tags = GITUtil.getTags(localRootUrl);
        ArrayList<GITBranchTag> tagNotRemote = new ArrayList<GITBranchTag>();
        for (String tagName : tags.keySet()) {
            if (remotes.containsKey(tagName)) {
                GitTag tag = tags.get(tagName);
                String tagId = remotes.get(tagName);
                if (tag.getTagId().equals(tagId)) continue;
            }
            tagNotRemote.add(new GITBranchTag(tagName, tagName, true));
        }
        return tagNotRemote;
    }

    private Collection<GITBranchTag> getBranches(Map<String, GitBranch> localBranch, Map<String, GitBranch> remoteBranch) {
        ArrayList<GITBranchTag> branches = new ArrayList<GITBranchTag>();
        for (String local : localBranch.keySet()) {
            String remote = remoteBranch.containsKey(local) ? local : "";
            GITBranchTag branch = new GITBranchTag(local, remote, false);
            branches.add(branch);
        }
        return branches;
    }

    private static class BranchTagTableModel
    extends DefaultTableModel
    implements GenericTableModel {
        private String[] _columns = new String[]{Resource.get("WZ_PUSH_BRANCH_COLUMN1"), Resource.get("WZ_PUSH_BRANCH_COLUMN2"), Resource.get("WZ_PUSH_BRANCH_COLUMN3"), Resource.get("WZ_PUSH_BRANCH_COLUMN4")};
        private List<GITBranchTag> _branches = new ArrayList<GITBranchTag>();
        private Boolean[] _include;

        private BranchTagTableModel() {
        }

        @Override
        public int getColumnCount() {
            return this._columns.length;
        }

        @Override
        public String getColumnName(int col) {
            return this._columns[col];
        }

        public Class getColumnClass(int col) {
            if (col == 0) {
                return Boolean.class;
            }
            return String.class;
        }

        @Override
        public void setValueAt(Object value, int row, int col) {
            if (col == 0) {
                this._include[row] = (Boolean)value;
            }
        }

        @Override
        public boolean isCellEditable(int row, int column) {
            return column == 0;
        }

        @Override
        public Object getValueAt(int row, int col) {
            if (col == 0) {
                return this._include[row];
            }
            if (col == 1) {
                GITBranchTag bt = this._branches.get(row);
                if (bt.isTag()) {
                    return this.getTagDescription(bt.getLocal());
                }
                return this._branches.get(row).getLocal();
            }
            if (col == 2) {
                GITBranchTag bt = this._branches.get(row);
                if (bt.isTag()) {
                    return bt.getRemote().isEmpty() ? this.getTagDescription(bt.getLocal()) : this.getTagDescription(bt.getRemote());
                }
                return this._branches.get(row).getRemote().isEmpty() ? this._branches.get(row).getLocal() : this._branches.get(row).getRemote();
            }
            if (col == 3) {
                return this._branches.get(row).isUpdate() ? Resource.get("WZ_PUSH_BRANCH_UPD") : Resource.get("WZ_PUSH_BRANCH_CRE");
            }
            return new Object();
        }

        private Object getTagDescription(String name) {
            StringBuilder sb = new StringBuilder(Resource.get("PUSH_TAG_DESC"));
            sb.append('/');
            sb.append(name);
            return sb.toString();
        }

        @Override
        public int getRowCount() {
            if (this._branches == null) {
                return 0;
            }
            return this._branches.size();
        }

        private void addData(Collection<GITBranchTag> branches) {
            this._branches.addAll(branches);
            this._include = new Boolean[this._branches.size()];
            for (int b = 0; b < this._include.length; ++b) {
                this._include[b] = Boolean.FALSE;
            }
        }

        private Collection<GITBranchTag> getIncludeBranches() {
            ArrayList<GITBranchTag> branches = new ArrayList<GITBranchTag>();
            for (int b = 0; b < this._include.length; ++b) {
                if (!this._include[b].booleanValue()) continue;
                branches.add(this._branches.get(b));
            }
            return branches;
        }

        private void setBranchSelect(String branch) {
            for (int b = 0; b < this._branches.size(); ++b) {
                if (!this._branches.get(b).getLocal().equals(branch)) continue;
                this._include[b] = Boolean.TRUE;
            }
        }

        public int getColumnAlignment(int column) {
            if (column == 0) {
                return 0;
            }
            return 2;
        }

        public boolean canHide(int column) {
            return column != 0 && column != 1;
        }
    }
}

