/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.model;

import java.awt.Component;
import javax.swing.JMenuItem;
import oracle.ide.Context;
import oracle.ide.controller.ContextMenu;
import oracle.ide.controller.ContextMenuListener;
import oracle.ide.controller.IdeAction;
import oracle.ide.controller.IdeActions;
import oracle.ide.controller.MenuConstants;
import oracle.ide.controls.ToggleAction;
import oracle.ide.model.Element;
import oracle.ide.model.ElementAttributes;
import oracle.ide.model.Locatable;
import oracle.ide.model.Project;
import oracle.ide.model.RelativeDirectoryContextFolder;
import oracle.ide.model.Workspace;
import oracle.ide.navigator.ProjectNavigatorWindow;
import oracle.ide.resource.IdeArb;
import oracle.ide.view.View;
import oracle.jdeveloper.library.Library;
import oracle.jdeveloper.model.JProjectStructureController;

final class JProjectMenuListener
implements ContextMenuListener {
    JProjectMenuListener() {
    }

    public boolean handleDefaultAction(Context context) {
        boolean handled = false;
        if (context.getNode() instanceof Project) {
            try {
                IdeAction.find((int)35).performAction(context);
                handled = true;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return handled;
    }

    public void menuWillShow(ContextMenu popup) {
        if (popup == null || popup.getContext() == null) {
            return;
        }
        Context context = popup.getContext();
        this.handleProjectPopup(popup, context);
        this.handleElementPopup(popup, context);
    }

    private void handleProjectPopup(ContextMenu popup, Context context) {
        if (context.getNode() instanceof Project) {
            IdeAction action = IdeAction.find((int)JProjectStructureController.ADD_TO_PROJECT_CMD_ID);
            JMenuItem addToProjectContextItem = popup.createMenuItem((ToggleAction)action, MenuConstants.WEIGHT_FILE_ADD_TO_PROJECT);
            popup.add((Component)addToProjectContextItem, 1.0f);
            JMenuItem editConfigurationsDlgItem = popup.createMenuItem((ToggleAction)IdeAction.find((int)35), MenuConstants.WEIGHT_TOOLS_PROJECT_PROPERTIES);
            popup.add((Component)editConfigurationsDlgItem, MenuConstants.SECTION_EDIT_PROPERTIES_CTXT_MENU);
        }
    }

    private void handleElementPopup(ContextMenu popup, Context context) {
        Element element;
        View view = context.getView();
        if (view != null && view instanceof ProjectNavigatorWindow && (element = context.getElement()) != null && !(element instanceof Library)) {
            if (!(element instanceof Workspace)) {
                JMenuItem eraseMenuItem = popup.createMenuItem((ToggleAction)IdeActions.getFileRemoveFromDiskAction(), MenuConstants.WEIGHT_FILE_ERASE);
                eraseMenuItem.setIcon(IdeArb.getIcon((int)103));
                popup.add((Component)eraseMenuItem, 1.0f);
            }
            if (element.getAttributes().isSet(ElementAttributes.ERASEABLE) || element.getAttributes().isSet(ElementAttributes.DELETEABLE)) {
                Object data = element.getData();
                if (!(element instanceof Project) && data != null && (data instanceof Locatable || data instanceof RelativeDirectoryContextFolder)) {
                    JMenuItem deleteMenuItem = popup.createMenuItem((ToggleAction)IdeActions.getFileRemoveFromIDEAction(), MenuConstants.WEIGHT_FILE_ERASE);
                    deleteMenuItem.setIcon(null);
                    popup.add((Component)deleteMenuItem, 1.0f);
                }
            }
        }
    }

    public void menuWillHide(ContextMenu popup) {
    }
}

