/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.xml;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import oracle.ide.util.Assert;
import oracle.ide.util.IdeUtil;
import oracle.javatools.util.SwingClosure;
import oracle.javatools.xml.bind.DOMBindingRuntime;
import oracle.javatools.xml.bind.XMLBinding;
import oracle.jdeveloper.xml.DomIO;
import oracle.jdeveloper.xml.StreamDomIO;
import oracle.jdeveloper.xml.URLDomIO;
import oracle.jdevimpl.xml.ElementDescriptor;
import oracle.xml.parser.v2.XMLDocument;
import oracle.xml.parser.v2.XMLElement;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.events.Event;
import org.w3c.dom.events.EventListener;

public abstract class BindingIO {
    public static final String XMLNS_URI = "http://www.w3.org/2000/xmlns/";
    public static final String XSI_URI = "http://www.w3.org/2001/XMLSchema-instance";
    public static final String XMLNS_XSI = "xmlns:xsi";
    public static final String XSI_SLOC = "xsi:schemaLocation";
    private XMLDocument _document;
    private Object _rootProxy;
    private EventListener _eventListener;
    private boolean _dirty;

    public void load(URL url) throws IOException {
        this.load(new URLDomIO(url));
    }

    public void load(InputStream in) throws IOException {
        this.load(new StreamDomIO(in, null));
    }

    public void load(DomIO io) throws IOException {
        String standalone;
        this.checkLoad();
        this._document = (XMLDocument)io.load();
        this.enableDirtyDetection();
        if (this._document != null && this.isStandalone() && !"yes".equals(standalone = this._document.getStandalone())) {
            this._document.setStandalone("yes");
        }
    }

    public void save(URL url) throws IOException {
        this.save(new URLDomIO(url), false);
    }

    public void write(URL url) throws IOException {
        this.save(new URLDomIO(url), true);
    }

    public void save(OutputStream out) throws IOException {
        this.save(new StreamDomIO(null, out), false);
    }

    public void write(OutputStream out) throws IOException {
        this.save(new StreamDomIO(null, out), true);
    }

    public boolean isDirty() {
        return this._dirty;
    }

    public void save(DomIO io) throws IOException {
        this.save(io, false);
    }

    public void save(DomIO io, boolean isPreview) throws IOException {
        if (this._dirty || isPreview) {
            this.checkSave();
            io.save((Document)this._document);
            if (!isPreview) {
                this.resetDirty();
            }
        }
    }

    public void saveAsynchronously(final DomIO io, final boolean isPreview) throws IOException {
        DomIO.runSwingClosure(new SwingClosure(true){

            protected void runImpl() throws IOException {
                BindingIO.this.save(io, isPreview);
            }
        });
    }

    public ElementDescriptor getElementDescriptor(Object proxyObj) {
        Element element = DOMBindingRuntime.getBoundElement((Object)proxyObj);
        if (element instanceof XMLElement) {
            XMLElement xmlElem = (XMLElement)element;
            return new ElementDescriptor(xmlElem.getLineNumber(), xmlElem.getColumnNumber());
        }
        return new ElementDescriptor(0, 0);
    }

    public Object getRootProxy() {
        if (this._rootProxy == null) {
            XMLBinding binding = this.getXMLBinding((Document)this._document);
            DOMBindingRuntime rt = new DOMBindingRuntime((Document)this._document, binding);
            Object disableWSHandling = this._document.getUserData("disable-whitespace-handling");
            if (Boolean.TRUE.equals(disableWSHandling)) {
                rt.setEnableWhitespace(false);
            }
            this._rootProxy = rt.getProxy();
        }
        return this._rootProxy;
    }

    public Object create() {
        return this.create(null);
    }

    public Object create(String descriptorVersion) {
        return this.create(descriptorVersion, new XMLDocument(), false);
    }

    public Object create(String descriptorVersion, DomIO domIO) throws IOException {
        return this.create(descriptorVersion, (XMLDocument)domIO.create(), false);
    }

    public Object create(String descriptorVersion, DomIO domIO, boolean utf8Only) throws IOException {
        return this.create(descriptorVersion, (XMLDocument)domIO.create(), utf8Only);
    }

    private Object create(String descriptorVersion, XMLDocument document, boolean utf8Only) {
        this._document = document;
        this.enableDirtyDetection();
        this._document.setVersion("1.0");
        if (utf8Only) {
            this._document.setEncoding("UTF-8");
        } else {
            this._document.setEncoding(BindingIO.getEncoding());
        }
        if (this.isStandalone()) {
            this._document.setStandalone("yes");
        }
        DoctypeInfo info = this.ensureDoctype(descriptorVersion);
        Element rootElem = this._document.createElementNS(info.uri, info.qname);
        this._document.appendChild((Node)rootElem);
        this.initDocument((Document)this._document, descriptorVersion);
        return this.getRootProxy();
    }

    protected void initDocument(Document document, String descriptorVersion) {
    }

    protected boolean isStandalone() {
        return false;
    }

    protected final void warnVersionNotRecognized(String descriptorVersion, String descriptorName) {
        Assert.println((String)("**** WARNING: Descriptor version '" + descriptorVersion + "' in " + descriptorName + " was not recognized.  Defaulting to the latest version."));
        Assert.printStackTrace();
    }

    protected abstract XMLBinding getXMLBinding(Document var1);

    protected abstract DoctypeInfo getDoctypeInfo(String var1);

    protected String getMinimumRequiredVersion() {
        return null;
    }

    protected int mapVersionToInt(String versionStr) {
        return 0;
    }

    protected int compareVersions(String versionStr1, String versionStr2) {
        int id1 = this.mapVersionToInt(versionStr1);
        int id2 = this.mapVersionToInt(versionStr2);
        return id1 - id2;
    }

    private void enableDirtyDetection() {
        this._eventListener = new EventListener(){

            @Override
            public void handleEvent(Event event) {
                BindingIO.this._dirty = true;
            }
        };
        this._document.addEventListener("DOMSubtreeModified", this._eventListener, false);
        this.resetDirty();
    }

    private void checkLoad() {
        this._document = null;
        this._rootProxy = null;
        this._eventListener = null;
        this.resetDirty();
    }

    private void checkSave() {
        if (this._document == null) {
            throw new IllegalStateException("No document loaded.");
        }
        this.ensureDoctype(null);
    }

    private void resetDirty() {
        this._dirty = false;
    }

    private DoctypeInfo ensureDoctype(String defaultDescriptorVersion) {
        DoctypeInfo info = this.getDoctypeInfo(defaultDescriptorVersion);
        DocumentType doctype = this._document.getDoctype();
        if (doctype == null) {
            if (info.publicID != null || info.systemID != null) {
                this._document.setDoctype(info.qname, info.systemID, info.publicID);
            }
        } else {
            this.maybeUpdateDoctype(doctype.getSystemId());
        }
        return info;
    }

    private void maybeUpdateDoctype(String curSystemId) {
        String minReqVer = this.getMinimumRequiredVersion();
        if (this.compareVersions(minReqVer, curSystemId) > 0) {
            DoctypeInfo info = this.getDoctypeInfo(minReqVer);
            this._document.setDoctype(info.qname, info.systemID, info.publicID);
        }
    }

    private static String getEncoding() {
        return IdeUtil.getIdeIanaEncoding();
    }

    protected static final class DoctypeInfo {
        public final String uri;
        public final String qname;
        public final String systemID;
        public final String publicID;

        public DoctypeInfo(String rootName, String systemID, String publicID) {
            this(null, rootName, systemID, publicID);
        }

        public DoctypeInfo(String uri, String qname, String systemID, String publicID) {
            this.uri = uri;
            this.qname = qname;
            this.systemID = systemID;
            this.publicID = publicID;
        }
    }
}

