/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.xml;

import java.awt.Component;
import java.util.Arrays;
import oracle.ide.panels.TDialogLauncher;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.ide.util.Namespace;
import oracle.javatools.util.Copyable;
import oracle.javatools.xml.bind.ElementList;
import oracle.javatools.xml.bind.ElementListListener;
import oracle.jdevimpl.xml.DetailPanel;
import oracle.jdevimpl.xml.TwoColumnPanel;

abstract class ElementListPanel
extends TwoColumnPanel {
    private transient ElementList _elementList;
    private transient TraversableContext _tc;

    public ElementListPanel() {
    }

    protected ElementListPanel(boolean trackEnableComponents) {
        super(trackEnableComponents);
    }

    protected ElementListPanel(int topPadding) {
        super(topPadding);
    }

    protected ElementListPanel(int topPadding, boolean trackEnableComponents) {
        super(topPadding, trackEnableComponents);
    }

    public void onEntry(TraversableContext tc) {
        this._tc = tc;
    }

    public void onExit(TraversableContext tc) throws TraversalException {
    }

    protected abstract ElementListListener newElementListListener();

    protected abstract int[] getSelectedIndexes();

    protected abstract void setSelectedIndexes(int[] var1);

    protected abstract String getElementListItemKey();

    protected abstract DetailPanel newCreatePanel();

    public Object create(TraversableContext tc) {
        DetailPanel createPanel = this.newCreatePanel();
        if (createPanel != null) {
            return this.createImpl(createPanel, tc);
        }
        return null;
    }

    public Object[] delete(TraversableContext tc) {
        int[] indexes = this.getSelectedIndexes();
        Arrays.sort(indexes);
        int n = indexes.length;
        Object[] deleted = new Object[n];
        ElementList elementList = this.getElementList();
        int index = 0;
        for (int i = n - 1; i >= 0; --i) {
            index = indexes[i];
            deleted[i] = elementList.remove(index);
        }
        this.postDelete(deleted, tc);
        this.setSelectedIndexes(new int[]{index});
        return deleted;
    }

    protected void postDelete(Object[] deleted, TraversableContext tc) {
    }

    public void moveUp(TraversableContext tc) {
        int index = this.getAndAssertMoveIndex("moveUp()");
        if (index <= 0) {
            throw new IllegalStateException("moveUp() called when element can't move up");
        }
        ElementList elementList = this.getElementList();
        Object element = elementList.remove(index);
        elementList.add(index - 1, element);
    }

    public void moveDown(TraversableContext tc) {
        ElementList elementList;
        int index = this.getAndAssertMoveIndex("moveDown()");
        if (index >= (elementList = this.getElementList()).size()) {
            throw new IllegalStateException("moveDown() called when element can't move down");
        }
        Object element = elementList.remove(index);
        elementList.add(index + 1, element);
    }

    protected final TraversableContext getTraversableContext() {
        return this._tc;
    }

    protected final ElementList getElementList() {
        return this._elementList;
    }

    protected void setElementList(ElementList elementList) {
        this._elementList = elementList;
        ElementListListener listener = this.newElementListListener();
        if (this._elementList != null) {
            this._elementList.addElementListListener(listener);
        }
    }

    protected TraversableContext newTraversableContext(TraversableContext parent, Object data) {
        Namespace namespace = new Namespace((Namespace)parent);
        String listItemKey = this.getElementListItemKey();
        namespace.put(listItemKey, data);
        TraversableContext tc = new TraversableContext(namespace, 0);
        tc.putDesignTimeObject("DetailPanel.detail-data", (Object)listItemKey);
        return tc;
    }

    protected boolean shouldSortData() {
        return true;
    }

    protected boolean prependNewItems() {
        return false;
    }

    private Object createImpl(DetailPanel createPanel, TraversableContext tc) {
        ElementList elementList = this.getElementList();
        Class elementType = elementList.elementType();
        Object newProxy = elementType != null && (elementType.isInterface() || Copyable.class.isAssignableFrom(elementType)) ? elementList.createElement() : "";
        TraversableContext newTC = this.newTraversableContext(tc, newProxy);
        TDialogLauncher launcher = createPanel.getTDialogLauncher((Component)((Object)this), (Namespace)newTC);
        boolean result = launcher.showDialog();
        if (result) {
            Object newData = newTC.find(this.getElementListItemKey());
            if (this.prependNewItems()) {
                elementList.add(0, newData);
            } else {
                elementList.add(newData);
            }
            return newData;
        }
        return null;
    }

    private int getAndAssertMoveIndex(String methodName) {
        int[] indexes = this.getSelectedIndexes();
        int n = indexes.length;
        if (n == 0) {
            throw new IllegalStateException(methodName + " called when no element selected");
        }
        if (n > 1) {
            throw new IllegalStateException(methodName + " called when there are multiple selections");
        }
        return indexes[0];
    }
}

